/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.google.gson.JsonSyntaxException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.FieldRangeCollection;
import com.kingdee.shr.base.syssetting.FieldRangeFactory;
import com.kingdee.shr.base.syssetting.FieldRangeInfo;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.ListFilterSolutionCollection;
import com.kingdee.shr.base.syssetting.ListFilterSolutionInfo;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.ListQuerySolutionCollection;
import com.kingdee.shr.base.syssetting.ListQuerySolutionInfo;
import com.kingdee.shr.base.syssetting.ListSetSolutionCollection;
import com.kingdee.shr.base.syssetting.ListSetSolutionInfo;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.AbstractListQuerySolutionControllerBean;
import com.kingdee.shr.base.syssetting.app.upgrade.ListQuerySolutionUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SHRUserUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ListQuerySolutionControllerBean
extends AbstractListQuerySolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.ListQuerySolutionControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ListQuerySolutionInfo info = (ListQuerySolutionInfo)model;
        this.checkConfig(ctx, info);
        if (null != info) {
            if (ListQuerySchemeTypeEnum.USER.equals((Object)info.getType())) {
                if (info.getOwner() == null) {
                    info.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx));
                }
                if (info.isIsDefault()) {
                    this.clearSolutionIsDefault(ctx, info);
                }
                if (!StateEnum.ENABLE.equals((Object)info.getState())) {
                    info.setState(StateEnum.ENABLE);
                }
                if (null == info.getId()) {
                    info.setInner(Boolean.FALSE);
                }
            }
            if (info.getState() == null) {
                info.setState(StateEnum.ENABLE);
            }
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _updateDefaultScheme(Context ctx, String id) throws BOSException, EASBizException {
        ListQuerySolutionInfo info = this.getListQuerySolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (ListQuerySchemeTypeEnum.SYSTEM.equals((Object)info.getType()) && !SHRUserUtils.isAdministrator(ctx)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{SHRSysSettingResourceUtil.getResource("sys_not_default", ctx)});
        }
        boolean flag = true;
        if (info.isIsDefault()) {
            flag = false;
        }
        this.clearSolutionIsDefault(ctx, info);
        if (StateEnum.ENABLE.equals((Object)info.getState())) {
            this.setIsDefault(ctx, BOSUuid.read((String)id), flag);
        }
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.setState(ctx, id, StateEnum.ENABLE);
        this.checkStateData(ctx, id);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.setState(ctx, id, StateEnum.DISABLE);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ListQuerySolutionInfo info = this.getListQuerySolutionInfo(ctx, pk);
        this.checkCanDelete(info);
        super._delete(ctx, pk);
    }

    private void checkCanDelete(ListQuerySolutionInfo info) throws EASBizException {
        if (ListQuerySchemeTypeEnum.SYSTEM.equals((Object)info.getType()) && StateEnum.ENABLE.equals((Object)info.getState())) {
            throw new SyssettinException(SyssettinException.FORBID_BEFORE_DELETE);
        }
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        ListQuerySolutionCollection collection = this.getListQuerySolutionCollection(ctx, viewInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            UIViewInfo uiview = collection.get(i).getUiview();
            String uiviewID = uiview.getId().toString();
            IUIView localInstance = UIViewFactory.getLocalInstance(ctx);
            uiview = localInstance.getUIViewInfo((IObjectPK)new ObjectStringPK(uiviewID));
            if (uiview.getType().equals((Object)UIType.list)) continue;
            this.checkCanDelete(collection.get(i));
        }
        IObjectPK[] pks = super._delete(ctx, filter);
        return pks;
    }

    @Override
    protected IObjectPK _copy(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ListQuerySolutionInfo info = this.getListQuerySolutionInfo(ctx, (IObjectPK)pk);
        info.setId(null);
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        Double nonce = null;
        if (null != random) {
            nonce = random.nextDouble();
        }
        info.setName(info.getName() + "_" + SHRSysSettingResourceUtil.getResource("copy", ctx) + (int)(nonce * 100.0));
        info.setIsDefault(false);
        info.setInner(false);
        info.setState(StateEnum.DISABLE);
        info.setCreateTime(null);
        info.setCreator(null);
        this._checkStatusValid(ctx, (IObjectValue)info);
        return this.save(ctx, (CoreBaseInfo)info);
    }

    private void clearSolutionIsDefault(Context ctx, ListQuerySolutionInfo info) throws BOSException {
        String category;
        if (ListQuerySchemeTypeEnum.SYSTEM.equals((Object)info.getType())) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        String tableName = this.getBOSEntity(ctx, (CoreBaseInfo)info).getTable().getName();
        sb.append(" update ").append(tableName).append(" ");
        sb.append(" set FIsDefault = 0 where FUIViewID = ? and FType = ? ");
        if (ListQuerySchemeTypeEnum.USER.equals((Object)info.getType())) {
            sb.append(" and FOwnerID = ");
            sb.append("'");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            sb.append(userInfo.getId().toString());
            sb.append("'");
        }
        if (!StringUtils.isEmpty((String)(category = info.getCategory()))) {
            sb.append(" and FCategory = ");
            sb.append("'");
            sb.append(category);
            sb.append("'");
        }
        Object[] params = new Object[]{info.getUiview().getId().toString(), info.getType().getValue()};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    public void checkNameDup(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException, EASBizException {
        ListQuerySolutionInfo info = (ListQuerySolutionInfo)coreBaseInfo;
        if (this.exists(ctx, ListQuerySolutionUtil.getDumpListQuerySolutionFilterInfo(ctx, info))) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getName()});
        }
    }

    public void checkConfig(Context ctx, ListQuerySolutionInfo info) throws EASBizException {
        String config = info.getConfig();
        if (!StringUtils.isEmpty((String)config)) {
            try {
                JSONUtils.convertJsonToObject(ctx, config);
            }
            catch (JsonSyntaxException e) {
                throw new SyssettinException(SyssettinException.JSON_FORMAT_ERROR);
            }
        }
    }

    private void changeDefault(Context ctx, BOSUuid uiViewId, ListQuerySchemeTypeEnum type) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)uiViewId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)type.getValue()));
        viewInfo.setFilter(filterInfo);
        ListQuerySolutionCollection collection = this.getListQuerySolutionCollection(ctx, viewInfo);
        if (null != collection && collection.size() > 0) {
            int total = collection.size();
            for (int i = 0; i < total; ++i) {
                this.setIsDefault(ctx, collection.get(i).getId(), false);
            }
        }
    }

    private void setIsDefault(Context ctx, BOSUuid id, boolean isDefault) throws EASBizException, BOSException {
        ListQuerySolutionInfo info = new ListQuerySolutionInfo();
        info.setId(id);
        info.setIsDefault(isDefault);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDefault"));
        this._updatePartial(ctx, (IObjectValue)info, sic);
    }

    private void setState(Context ctx, String id, StateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        this.addEnabledAndDisabled(ctx, id, state);
        ListQuerySolutionInfo info = this.createNewModel();
        info.setId(BOSUuid.read((String)id));
        info.setState(state);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        this._updatePartial(ctx, (IObjectValue)info, sic);
    }

    private void addEnabledAndDisabled(Context ctx, String id, StateEnum state) throws EASBizException, BOSException, UuidException {
        ListQuerySolutionInfo oldModel = this.getListQuerySolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (StateEnum.DISABLE.equals((Object)state)) {
            if (StateEnum.ENABLE.equals((Object)oldModel.getState()) && oldModel.isIsDefault()) {
                throw new SyssettinException(SyssettinException.NOT_REDIRECT_FORBID);
            }
        } else if (StateEnum.ENABLE.equals((Object)state) && StateEnum.DISABLE.equals((Object)oldModel.getState()) && oldModel.isIsDefault()) {
            this.changeDefault(ctx, oldModel.getUiview().getId(), oldModel.getType());
        }
    }

    private void checkStateData(Context ctx, String id) throws BOSException, EASBizException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("uiview.id"));
        ListQuerySolutionInfo info = this.getListQuerySolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        this.checkStateData(ctx, info);
    }

    private void checkStateData(Context ctx, ListQuerySolutionInfo info) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)info.getUiview().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isDefault"));
        viewInfo.setSelector(selector);
        ListQuerySolutionCollection collection = this.getListQuerySolutionCollection(ctx, viewInfo);
        int defaultCount = 0;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            if (!collection.get(i).isIsDefault()) continue;
            ++defaultCount;
        }
        if (defaultCount == 0) {
            throw new SyssettinException(SyssettinException.MUST_ENABLE_CASE);
        }
        if (defaultCount > 1) {
            throw new SyssettinException(SyssettinException.ONLY_ENABLE_CASE);
        }
    }

    @Override
    public ListQuerySolutionInfo getListQuerySolutionInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected ListQuerySolutionInfo createNewModel() {
        return null;
    }

    protected ListSetSolutionCollection getListSetSolutionCollection0(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        return null;
    }

    protected ListFilterSolutionCollection getListFilterSolutionCollection0(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setisDefault(Context ctx, String id) throws BOSException, EASBizException {
        ListQuerySolutionInfo info = this.getListQuerySolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (StateEnum.ENABLE.equals((Object)info.getState())) {
            this.changeDefault(ctx, info.getUiview().getId(), info.getType());
        }
        this.setIsDefault(ctx, BOSUuid.read((String)id), true);
    }

    @Override
    protected Map _updateBatchByStructureChange(Context ctx, List changeContent) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList data = null;
        if (null != changeContent && changeContent.size() > 0) {
            data = new ArrayList();
            int total = changeContent.size();
            for (int i = 0; i < total; ++i) {
                Map changContentMap = (Map)changeContent.get(i);
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                resultData.putAll(changContentMap);
                try {
                    this.updateByStructureChange(ctx, changContentMap);
                    resultData.put("success", true);
                    resultData.put("message", "");
                }
                catch (BOSException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                catch (EASBizException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                data.add(resultData);
            }
            result.put("success", true);
            result.put("message", "");
            result.put("data", data);
        } else {
            result.put("success", true);
            result.put("message", SHRSysSettingResourceUtil.getResource("no_data_need_update", ctx));
            result.put("data", changeContent);
        }
        return result;
    }

    @Override
    protected void _updateByStructureChange(Context ctx, Map changeContent) throws BOSException, EASBizException {
        if (null == changeContent || changeContent.size() <= 0) {
            throw new SyssettinException(SyssettinException.MODIFIED_INFO_NOT_NULL);
        }
        String number = (String)changeContent.get("number");
        String sourceField = (String)changeContent.get("sourceField");
        String targetField = (String)changeContent.get("targetField");
        StringBuffer errorMessage = new StringBuffer();
        if (StringUtils.isEmpty((String)number)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("struc_config_number_null", ctx, "number"));
        }
        if (StringUtils.isEmpty((String)sourceField)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("source_field_not_null", ctx, "sourceField"));
        }
        if (StringUtils.isEmpty((String)targetField)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("target_field_not_null", ctx, "targetField"));
        }
        if (!StringUtils.isEmpty((String)errorMessage.toString())) {
            throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{errorMessage.toString()});
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uiview.model", (Object)number, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ListSetSolutionCollection listSetSolutionCollection = this.getListSetSolutionCollection0(ctx, view);
        this.dealUpdateListSetByStructureChange(ctx, listSetSolutionCollection, sourceField, targetField, number);
        ListFilterSolutionCollection listFilterSolutionCollection = this.getListFilterSolutionCollection0(ctx, view);
        this.dealUpdateListFilterByStructureChange(ctx, listFilterSolutionCollection, sourceField, targetField, number);
        String sql = "SELECT fuipk FROM S_BS_UIView where fmodel = '" + number + "'";
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)sql, CompareType.INNER));
        EntityViewInfo view1 = new EntityViewInfo();
        view1.setFilter(filter1);
        FieldRangeCollection coll1 = FieldRangeFactory.getLocalInstance(ctx).getFieldRangeCollection(view1);
        this.dealUpdateByStructureChange(ctx, coll1, sourceField, targetField, number);
    }

    private void dealUpdateListSetByStructureChange(Context ctx, ListSetSolutionCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        ListSetSolutionCollection updateColl = new ListSetSolutionCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                ListSetSolutionInfo info = coll.get(i);
                if (StringUtils.isEmpty((String)info.getConfig()) || info.getConfig().indexOf(sourceField) <= 0) continue;
                info.setConfig(info.getConfig().replaceAll(sourceField, targetField));
                updateColl.add(info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                this._updateBatchData(ctx, (IObjectCollection)updateColl);
            }
        }
    }

    private void dealUpdateListFilterByStructureChange(Context ctx, ListFilterSolutionCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        ListFilterSolutionCollection updateColl = new ListFilterSolutionCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                ListFilterSolutionInfo info = coll.get(i);
                if (StringUtils.isEmpty((String)info.getConfig()) || info.getConfig().indexOf(sourceField) <= 0) continue;
                info.setConfig(info.getConfig().replaceAll(sourceField, targetField));
                updateColl.add(info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                this._updateBatchData(ctx, (IObjectCollection)updateColl);
            }
        }
    }

    private void dealUpdateByStructureChange(Context ctx, AbstractObjectCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
    }

    private void dealUpdateByStructureChange(Context ctx, FieldRangeCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        CoreBaseCollection updateColl = new CoreBaseCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                FieldRangeInfo info = coll.get(i);
                if (StringUtils.isEmpty((String)info.getConfig()) || info.getConfig().indexOf(sourceField) <= 0) continue;
                info.setConfig(info.getConfig().replaceAll(sourceField, targetField));
                updateColl.add((CoreBaseInfo)info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                FieldRangeFactory.getLocalInstance(ctx).updateBatchData(updateColl);
            }
        }
    }

    @Override
    protected void _setNotDefaultBatchByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String tableName = "T_BD_ListSetSolution";
        sb.append(" update ").append(tableName).append(" ");
        sb.append(" set FIsDefault = 0 where FUIViewID = ? and FType = 2 ");
        Object[] params = new Object[]{uipk};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }
}

