/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermItemURLCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class PermItemURLCache {
    private static final String CACHE_PERM_ITEM_URL = "shr.permItemURL";
    private static CustomCacheService permURLCache = new CustomCacheService("shr.permItemURL");
    private static Logger logger = Logger.getLogger(PermItemURLCache.class);

    public static void initCache(Context ctx) {
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)PermItemURLCache.assembleQueryPermItemUrlAllQuerySql());
            HashMap<String, PermItemInfo> permItemMap = new HashMap<String, PermItemInfo>();
            PermItemInfo permItemInfo = null;
            String url = "";
            String id = "";
            permURLCache.put("hasInitFlag", (Object)"true");
            while (rowSet.next()) {
                url = rowSet.getString("FURL");
                id = rowSet.getString("FID");
                if (StringUtils.isEmpty((String)url)) continue;
                if (permItemMap.containsKey(id)) {
                    permItemInfo = (PermItemInfo)permItemMap.get(id);
                } else {
                    permItemInfo = PermItemURLCache.assemblePermItemInfoByRowSet(rowSet);
                    permItemMap.put(id, permItemInfo);
                }
                permURLCache.put(url, (Object)permItemInfo);
            }
        }
        catch (Exception e) {
            permURLCache.remove("hasInitFlag");
            logger.error((Object)"[ PermItemURLCache  initCache error ]");
            e.printStackTrace();
        }
    }

    public static void addPermItemToCache(PermItemInfo permItemInfo) {
        if (null == permItemInfo || null == permItemInfo.getUrls() || permItemInfo.getUrls().isEmpty()) {
            return;
        }
        PermItemInfo newPermItemInfo = PermItemURLCache.getPermItemInfoByPermItemInfo(permItemInfo);
        int total = permItemInfo.getUrls().size();
        for (int i = 0; i < total; ++i) {
            if (StringUtils.isEmpty((String)permItemInfo.getUrls().get(i).getUrl())) continue;
            permURLCache.put(permItemInfo.getUrls().get(i).getUrl(), (Object)newPermItemInfo);
        }
    }

    public static void removePermItemToCache(PermItemInfo permItemInfo) {
        if (null == permItemInfo) {
            return;
        }
        PermItemURLCache.removePermItemURLCollectionToCache(permItemInfo.getUrls());
    }

    private static void removePermItemURLCollectionToCache(PermItemURLCollection urls) {
        if (null == urls || urls.isEmpty()) {
            return;
        }
        int total = urls.size();
        for (int i = 0; i < total; ++i) {
            if (StringUtils.isEmpty((String)urls.get(i).getUrl())) continue;
            permURLCache.remove(urls.get(i).getUrl());
        }
    }

    public static void updatePermItemToCache(PermItemInfo permItemInfo, PermItemURLCollection oldUrls) {
        PermItemURLCache.removePermItemURLCollectionToCache(oldUrls);
        PermItemURLCache.addPermItemToCache(permItemInfo);
    }

    public static void updateCache(PermItemInfo permItemInfo) {
    }

    public static PermItemInfo getPermItemInfoByURL(Context ctx, String url) {
        if (!permURLCache.contains("hasInitFlag")) {
            PermItemURLCache.initCache(ctx);
        }
        PermItemInfo permItemInfo = null;
        Object permItemObj = permURLCache.get(url);
        if (permItemObj instanceof PermItemInfo) {
            return (PermItemInfo)permURLCache.get(url);
        }
        if (permItemObj instanceof String) {
            return permItemInfo;
        }
        try {
            String permItemUrlByUrlQuerySql = PermItemURLCache.assembleQueryPermItemUrlByUrlQuerySql();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)permItemUrlByUrlQuerySql, (Object[])new Object[]{url});
            if (rowSet.next()) {
                permItemInfo = PermItemURLCache.assemblePermItemInfoByRowSet(rowSet);
                permURLCache.put(url, (Object)permItemInfo);
            } else {
                permURLCache.put(url, (Object)"");
                logger.info((Object)MessageFormat.format("getPermItemInfoByURL not found permItemInfo ,url is : ", url));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return permItemInfo;
    }

    private static String assembleQueryPermItemUrlAllQuerySql() {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT pm.FID, pm.FName,pm.Fnumber,pm.FType,");
        sql.append(" pm.FOrgRelation,u.FURL ");
        sql.append(" FROM T_PM_PermItem pm ");
        sql.append(" inner join T_PM_PermItemURL u on u.FParentID = pm.fid and pm.FIsLeaf =1");
        return sql.toString();
    }

    private static String assembleQueryPermItemUrlByUrlQuerySql() {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT pm.FID, pm.FName,pm.Fnumber,pm.FType,");
        sql.append(" pm.FOrgRelation,u.FURL ");
        sql.append(" FROM T_PM_PermItem pm ");
        sql.append(" inner join T_PM_PermItemURL u on u.FParentID = pm.fid ");
        sql.append(" where pm.FIsLeaf =1 and u.FURL = ? ");
        return sql.toString();
    }

    private static String assembleQueryHrPermItemUrlByUrlQuerySql() {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT FURL");
        sql.append(" FROM T_PM_PermItemURL ");
        sql.append(" where FURL = ? ");
        return sql.toString();
    }

    private static PermItemInfo assemblePermItemInfoByRowSet(IRowSet rowSet) throws Exception {
        PermItemInfo permItemInfo = new PermItemInfo();
        permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
        permItemInfo.setName(rowSet.getString("FName"));
        permItemInfo.setNumber(rowSet.getString("FNumber"));
        permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
        permItemInfo.setType(PermItemType.getEnum((int)rowSet.getInt("FType")));
        return permItemInfo;
    }

    private static PermItemInfo getPermItemInfoByPermItemInfo(PermItemInfo permItemInfo) {
        PermItemInfo newPermItemInfo = new PermItemInfo();
        newPermItemInfo.setId(permItemInfo.getId());
        newPermItemInfo.setName(permItemInfo.getName());
        newPermItemInfo.setNumber(permItemInfo.getNumber());
        newPermItemInfo.setOrgRelation(permItemInfo.getOrgRelation());
        newPermItemInfo.setType(permItemInfo.getType());
        return newPermItemInfo;
    }
}

