/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.IHRRefresh;
import com.kingdee.shr.base.syssetting.app.osf.IOSFCacheSyn;
import com.kingdee.shr.osf.OSFCacheHelper;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OSFCacheSyn
extends ORMObject
implements IOSFCacheSyn {
    private static Logger logger = Logger.getLogger((String)OSFCacheSyn.class.getName());

    @Override
    public void disable(Context ctx, String configID) throws BOSException, EASBizException {
    }

    @Override
    public void enable(Context ctx, String configID) throws BOSException, EASBizException {
    }

    @Override
    public void restartService(Context ctx) throws BOSException, EASBizException {
        MsfClassLoaderFactory.reloadLibs();
        this.refreshCache(ctx);
        OSFCacheHelper.removeAll();
    }

    @Override
    public void stopService(Context ctx) throws BOSException, EASBizException {
        MsfClassLoaderFactory.removeLibs();
        this.refreshCache(ctx);
    }

    private void refreshCache(Context ctx) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("shr refreshCache localAddress" + System.getProperty("EAS_INSTANCE_HOME")));
        }
        HashSet<String> refreshSet = new HashSet<String>();
        refreshSet.add("com.kingdee.eas.hr.base.app.filter.StructureConfigConvertFactory");
        refreshSet.add("com.kingdee.shr.base.syssetting.app.view.UIViewRefresh");
        refreshSet.add("com.kingdee.shr.base.syssetting.app.cache.PermItemURLRefresh");
        refreshSet.add("com.kingdee.shr.base.syssetting.app.cache.BasicItemCache");
        refreshSet.add("com.kingdee.shr.base.permission.cache.SensitiveCache");
        for (String refreshClassName : refreshSet) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("start refresh  " + refreshClassName));
                }
                IHRRefresh refresh = (IHRRefresh)MsfClassLoaderFactory.forName(refreshClassName).newInstance();
                refresh.hrRrefresh(ctx);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("end refresh  " + refreshClassName));
            }
            catch (Exception e) {
                logger.error((Object)e.getCause());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("end refresh cache " + System.getProperty("EAS_INSTANCE_HOME")));
        }
    }
}

