/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud.logic;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.base.syssetting.cloud.http.ResultVo;
import com.kingdee.shr.base.syssetting.cloud.http.SHRClient;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class CloudHubMessageLogic {
    private String CLOUD_XT_MESSAGE_SERVER_URL;
    private static final String MESSAGE_FORMAT_TEXT = "text";
    private static final String MESSAGE_FORMAT_TEXTLINK = "textLink";
    private static final String MESSAGE_FORMAT_TEXT_TYPESET = "textTypeset";
    private static final String MESSAGE_FORMAT_TEXT_TYPESET_WITHPIC = "textTypesetWithPic";
    private static final String RECEIVER_ROLE_TOUSER = "toUser";
    private static final String RECEIVER_ROLE_TOSUBSCRIBER = "toSubscriber";

    public CloudHubMessageLogic(Context ctx) {
        this.CLOUD_XT_MESSAGE_SERVER_URL = CloudHubUtil.getXTMsgServerURL(ctx);
    }

    public HttpResultVo pushTextMessage(Context ctx, String pubaccName, IObjectCollection users, String text, boolean isPrivate) throws BOSException, EASBizException {
        Properties pubConfig;
        HttpResultVo resultVo = null;
        String eid = CloudHubUtil.getIntegrationEid(ctx);
        String messageFormat = MESSAGE_FORMAT_TEXT;
        String receiverRole = RECEIVER_ROLE_TOUSER;
        if (users == null) {
            receiverRole = RECEIVER_ROLE_TOSUBSCRIBER;
        }
        if (!((Boolean)(pubConfig = CloudHubUtil.getPubAccConfig(ctx, eid, pubaccName)).get("enable")).booleanValue()) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("public_not_enable", ctx));
        }
        String serverUrl = CloudHubUtil.getXunTongServerUrl(ctx, isPrivate);
        List<String> usersArray = CloudHubUtil.generateReceiverSequence(ctx, users);
        Map<String, Object> msg = this.generateTextMessageEntity(text);
        String paramJson = this.assembleCloudParamsInfo(ctx, eid, pubConfig, serverUrl, messageFormat, receiverRole, msg, usersArray);
        resultVo = this.pushMessage(ctx, this.CLOUD_XT_MESSAGE_SERVER_URL, paramJson);
        return resultVo;
    }

    public HttpResultVo pushTextLinkMessage(Context ctx, String pubaccName, IObjectCollection users, String text, String appid, String url, boolean isPrivate) throws EASBizException, BOSException {
        Properties pubConfig;
        HttpResultVo resultVo = null;
        String eid = CloudHubUtil.getIntegrationEid(ctx);
        String messageFormat = MESSAGE_FORMAT_TEXTLINK;
        String receiverRole = RECEIVER_ROLE_TOUSER;
        if (users == null) {
            receiverRole = RECEIVER_ROLE_TOSUBSCRIBER;
        }
        if (!((Boolean)(pubConfig = CloudHubUtil.getPubAccConfig(ctx, eid, pubaccName)).get("enable")).booleanValue()) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("public_not_enable", ctx));
        }
        String serverUrl = CloudHubUtil.getXunTongServerUrl(ctx, isPrivate);
        List<String> usersArray = CloudHubUtil.generateReceiverSequence(ctx, users);
        Map<String, Object> msg = this.generateTextLinkMessageEntity(text, appid, url);
        String paramJson = this.assembleCloudParamsInfo(ctx, eid, pubConfig, serverUrl, messageFormat, receiverRole, msg, usersArray);
        resultVo = this.pushMessage(ctx, this.CLOUD_XT_MESSAGE_SERVER_URL, paramJson);
        return resultVo;
    }

    public HttpResultVo pushTextTypeSetMessage(Context ctx, String pubaccName, IObjectCollection users, String text, String title, String appid, String url, String date, boolean isPrivate) throws BOSException, EASBizException {
        Properties pubConfig;
        HttpResultVo resultVo = null;
        String eid = CloudHubUtil.getIntegrationEid(ctx);
        String messageFormat = MESSAGE_FORMAT_TEXT_TYPESET;
        String receiverRole = RECEIVER_ROLE_TOUSER;
        if (users == null) {
            receiverRole = RECEIVER_ROLE_TOSUBSCRIBER;
        }
        if (!((Boolean)(pubConfig = CloudHubUtil.getPubAccConfig(ctx, eid, pubaccName)).get("enable")).booleanValue()) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("public_not_enable", ctx));
        }
        String serverUrl = CloudHubUtil.getXunTongServerUrl(ctx, isPrivate);
        List<String> usersArray = CloudHubUtil.generateReceiverSequence(ctx, users);
        Map<String, Object> msg = this.generateTextTypeSetMessageEntity(text, title, appid, url, date);
        String paramJson = this.assembleCloudParamsInfo(ctx, eid, pubConfig, serverUrl, messageFormat, receiverRole, msg, usersArray);
        resultVo = this.pushMessage(ctx, this.CLOUD_XT_MESSAGE_SERVER_URL, paramJson);
        return resultVo;
    }

    public HttpResultVo pushTextTypeSetWithPicMessage(Context ctx, String pubaccName, IObjectCollection users, String text, String title, String appid, String url, String date, File picFile, boolean isPrivate) throws BOSException, EASBizException {
        Properties pubConfig;
        HttpResultVo resultVo = null;
        String eid = CloudHubUtil.getIntegrationEid(ctx);
        String messageFormat = MESSAGE_FORMAT_TEXT_TYPESET_WITHPIC;
        String receiverRole = RECEIVER_ROLE_TOUSER;
        if (users == null) {
            receiverRole = RECEIVER_ROLE_TOSUBSCRIBER;
        }
        if (!((Boolean)(pubConfig = CloudHubUtil.getPubAccConfig(ctx, eid, pubaccName)).get("enable")).booleanValue()) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("public_not_enable", ctx));
        }
        String serverUrl = CloudHubUtil.getXunTongServerUrl(ctx, isPrivate);
        List<String> usersArray = CloudHubUtil.generateReceiverSequence(ctx, users);
        Map<String, Object> msg = this.generateTextTypeSetWithPicMessageEntity(text, title, appid, url, date, picFile);
        String paramJson = this.assembleCloudParamsInfo(ctx, eid, pubConfig, serverUrl, messageFormat, receiverRole, msg, usersArray);
        resultVo = this.pushMessage(ctx, this.CLOUD_XT_MESSAGE_SERVER_URL, paramJson);
        return resultVo;
    }

    private String assembleCloudParamsInfo(Context ctx, String eid, Properties pubConfig, String serverUrl, String messageFormat, String receiverRole, Map<String, Object> msg, List<String> usersArray) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eid", eid);
        params.put("pubCode", pubConfig.get("pubCode").toString());
        params.put("pubKey", pubConfig.get("pubKey").toString());
        params.put("serverUrl", serverUrl);
        params.put("messageFormat", messageFormat);
        params.put("receiverRole", receiverRole);
        params.put("msg", msg);
        if (usersArray != null) {
            params.put("user", usersArray);
        }
        return JSONUtils.convertObjectToJson(ctx, params);
    }

    private HttpResultVo pushMessage(Context ctx, String serverUrl, String paramJson) throws BOSException {
        HttpResultVo resultVo = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("params", paramJson);
        ResultVo result = SHRClient.doPost(serverUrl, params);
        if ("0".equals(result.getErrorCode())) {
            String data = result.getData().toString();
            HashMap dataMap = JSONUtils.convertJsonToObject(ctx, data);
            int status = ((Double)dataMap.get("status")).intValue();
            resultVo = 200 == status ? new HttpResultVo(status, SHRSysSettingResourceUtil.getResource("message_push_success", ctx)) : new HttpResultVo(status, dataMap.get("data"));
        } else {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("message_push_fail", ctx));
        }
        return resultVo;
    }

    private Map<String, Object> generateTextMessageEntity(String text) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put(MESSAGE_FORMAT_TEXT, text);
        return msg;
    }

    private Map<String, Object> generateTextLinkMessageEntity(String text, String appid, String url) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put(MESSAGE_FORMAT_TEXT, text);
        msg.put("appid", appid);
        msg.put("url", url);
        msg.put("todo", 0);
        return msg;
    }

    private Map<String, Object> generateTextTypeSetMessageEntity(String text, String title, String appid, String url, String date) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        ArrayList modelList = new ArrayList();
        HashMap<String, String> model = new HashMap<String, String>();
        model.put(MESSAGE_FORMAT_TEXT, text);
        model.put("title", title);
        model.put("appid", appid);
        model.put("url", url);
        model.put("date", date);
        model.put("zip", "");
        modelList.add(model);
        msg.put("list", modelList);
        msg.put("model", 1);
        msg.put("todo", 0);
        return msg;
    }

    private Map<String, Object> generateTextTypeSetWithPicMessageEntity(String text, String title, String appid, String url, String date, File picFile) throws BOSException {
        HashMap<String, Object> msg = null;
        FileInputStream fis = null;
        try {
            msg = new HashMap<String, Object>();
            fis = new FileInputStream(picFile);
            ArrayList modelList = new ArrayList();
            HashMap<String, String> model = new HashMap<String, String>();
            model.put(MESSAGE_FORMAT_TEXT, text);
            model.put("title", title);
            model.put("appid", appid);
            model.put("url", url);
            model.put("date", date);
            model.put("zip", "");
            model.put("name", picFile.getName());
            model.put("pic", CloudHubMessageLogic.base64Encode(this.getBytes(fis)));
            modelList.add(model);
            msg.put("list", modelList);
            msg.put("model", 2);
            msg.put("todo", 0);
        }
        catch (FileNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        return msg;
    }

    public static String base64Encode(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    private byte[] getBytes(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                out.write(b, 0, b.length);
            }
            out.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] s = out.toByteArray();
        return s;
    }
}

