/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.shr.common.util.XssFilterUtil;
import com.microsoft.sqlserver.jdbc.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class FileVaildUtils {
    private static Logger logger = Logger.getLogger(FileVaildUtils.class);
    private static String CSV = ".*(cmd|HYPERLIN|\\+1\\[1\\]|1\\+\\[1\\]|\\[1\\]!z).*";
    private static Pattern pattern = Pattern.compile(CSV);
    private static final long MAX_SIZE = 524288000L;

    private FileVaildUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean readExcel(InputStream is, String fileType) {
        Workbook workbook = FileVaildUtils.getWorkbook(is, fileType);
        if (null == workbook) {
            return false;
        }
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.clearAllCachedResultValues();
        return FileVaildUtils.readWorkbook(workbook);
    }

    public static boolean readWorkbook(Workbook wb) {
        int sheetCount = wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = wb.getSheetAt(i);
            int rowCount = sheet.getLastRowNum();
            for (int j = 0; j <= rowCount; ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                int cellCount = row.getLastCellNum();
                for (int k = 0; k < cellCount; ++k) {
                    Cell cell = row.getCell(k);
                    if (!FileVaildUtils.getCellFormatValue(cell)) continue;
                    logger.error((Object)MessageFormat.format("Excel CSV Location : row = {0}, col = {1}", j + 1, k + 1));
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbook(InputStream is, String fileType) {
        if (null == is || fileType == null || fileType.equals("")) {
            return null;
        }
        try {
            if ("xls".equals(fileType) || "xlsx".equals(fileType)) {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                return workbook;
            }
            Workbook workbook = null;
            return workbook;
        }
        catch (POIXMLException e) {
            logger.error((Object)"Content type part [M1.13]");
            Workbook workbook = null;
            return workbook;
        }
        catch (Exception e) {
            logger.error((Object)"Create workbook error");
            Workbook workbook = null;
            return workbook;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)"FileStream Close Error", (Throwable)e);
            }
        }
    }

    public static boolean checkZipBomb(String fileType, InputStream ins) throws IOException {
        if ("zip".equalsIgnoreCase(fileType)) {
            long size = 0L;
            ZipEntry zipEntry = null;
            BufferedInputStream in = new BufferedInputStream(ins);
            ZipInputStream zin = new ZipInputStream((InputStream)in, Charset.forName("GBK"));
            while (null != zin && (zipEntry = zin.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    size += zipEntry.getSize();
                }
                if (size <= 524288000L) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean getCellFormatValue(Cell cell) {
        if (null == cell || StringUtils.isEmpty((CharSequence)cell.toString())) {
            return false;
        }
        if (null != cell.getHyperlink()) {
            return true;
        }
        XssFilterUtil.stripXSS(cell.toString(), "cell");
        if (cell.getCellType() == CellType.FORMULA) {
            return FileVaildUtils.isVaildCSVXSSFOfFormula(cell.toString());
        }
        return FileVaildUtils.isVaildCSVXSSF(cell.toString());
    }

    public static boolean isVaildCSVXSSF(String cellString) {
        String cell = cellString.trim();
        return !(!cell.startsWith("=") && !cell.startsWith("-") && !cell.startsWith("+") && !cell.startsWith("@") || !cell.contains("cmd") && !cell.contains("HYPERLIN") && !cell.contains("calc"));
    }

    public static boolean isVaildCSVXSSFOfFormula(String cellString) {
        if (StringUtils.isEmpty((CharSequence)cellString)) {
            return false;
        }
        Matcher matcher = pattern.matcher(cellString);
        return matcher.find();
    }
}

