/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.shr.base.syssetting.util.custom.SHRDBUtils;
import java.sql.SQLException;

public class SHRSqlBuilder {
    private SHRSqlBuilder() {
    }

    public static String buildTableSql(DataTableInfo table) {
        StringBuffer sb = new StringBuffer();
        if (table != null) {
            sb.append("IF Not Exists(Select * From KSQL_USERTABLES Where KSQL_TABNAME = '" + table.getRealName() + "') \n");
            sb.append(" CREATE Table " + table.getRealName() + " (");
            for (int i = 0; i < table.getColumns().size(); ++i) {
                sb.append(SHRDBUtils.getColSQL(table.getColumns().get(i)) + ",");
            }
            String pkname = SHRSqlBuilder.truncateName(table.getPrimaryKey().getRealName());
            for (int i = 0; i < table.getPrimaryKey().getPKColumns().size(); ++i) {
                ColumnInfo col = table.getPrimaryKey().getPKColumns().get(i).getColumn();
                sb.append(" CONSTRAINT " + pkname + " PRIMARY KEY (" + col.getRealName() + ")");
            }
            String sql = sb.toString().trim();
            if (sql.endsWith(",")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = sql + ");";
            return sql;
        }
        return "";
    }

    public static String buildColumnSql(AbstractTableInfo table, ColumnInfo column) throws SQLException {
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getRealName() + "' AND KSQL_COL_NAME='" + column.getRealName() + "') \n");
            sql.append(" ALTER Table " + table.getRealName());
            sql.append(" ADD " + SHRDBUtils.getColSQL(column));
        }
        return sql.toString();
    }

    public static String buildColumnSqlInMultiLanguage(AbstractTableInfo table, ColumnInfo column, int multilanguage) throws SQLException {
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getRealName() + "' AND KSQL_COL_NAME='" + column.getRealName() + "_l" + multilanguage + "') \n");
            sql.append(" ALTER Table " + table.getRealName());
            sql.append(" ADD " + SHRDBUtils.getColSQLInMultiLanguage(column, multilanguage));
        }
        return sql.toString();
    }

    private static String truncateName(String name) {
        String newName = name;
        if (name.length() > 18) {
            newName = name.substring(0, 18);
        }
        return newName;
    }
}

