/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.AuthCQTypeEnum;
import com.kingdee.shr.base.syssetting.CQEncryptTypeEnum;
import com.kingdee.shr.base.syssetting.CQResultCodeEnum;
import com.kingdee.shr.base.syssetting.InteCQException;
import com.kingdee.shr.base.syssetting.InteSystemEnum;
import com.kingdee.shr.base.syssetting.JWTTypeEnum;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.inte.cq.bean.APIAndCallInfo;
import com.kingdee.shr.inte.cq.bean.CQResponseBean;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InteCQConfigUtil {
    public static final String CQ_INTE_KEY = "6fea70e1e31ee245f94caae3e021b489";
    private static final Pattern URL_PATTERN = Pattern.compile("^(?:http|https)://(?:(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\\.)+(?:[A-Z]{2,6}\\.?|[A-Z0-9-]{2,}\\.?)|localhost|\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|\\[?[A-F0-9]*:[A-F0-9:]+\\]?)(?::\\d+)?(?:/?|[/?]\\S+)$", 2);

    private InteCQConfigUtil() {
    }

    public static String encrypt(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            return AESUtils.cbcEncrypt(content, CQ_INTE_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    public static String decrypt(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            return AESUtils.cbcDecrypt(content, CQ_INTE_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    public static APIAndCallInfo getCallInfo(Context ctx, InteSystemEnum inteSystem, String number) throws BOSException {
        StringBuilder sql = new StringBuilder();
        String l = LocaleUtils.getShortCode(ctx);
        sql.append("SELECT t0.FUrl serviceurl, t0.FIsOpenLog, t0.FDomainID,t0.FAgentUser apiUser,t0.FAuthType apiauthtyp,t0.FStatus,t0.FName_").append(l).append(" apiName,");
        sql.append("t1.FUrl serverurl,t1.FAccountId,t1.FAppId,t1.FAppSecret,t1.FAgentUser,t1.FDigestType,t1.FDigestSecret,t1.FSignType,t1.FSignSecret,t1.FSignUser,t1.FSignKey,t1.FEncryptType,t1.FCertKey,");
        sql.append("t1.FAuthType,t1.FJwtType,t1.FNumber,t1.FName_").append(l).append(" configName,t1.FDatacenter ");
        sql.append("FROM T_SHR_CQAPIConfig t0 ");
        sql.append("LEFT JOIN T_SHR_InteCQConfig t1 ON t0.FInteCQID = t1.FID ");
        sql.append("where t0.FNumber = ? and t1.FStatus = ? and t1.FInteSystem=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number, 1, inteSystem.getValue()});
        APIAndCallInfo info = null;
        try {
            while (rs.next()) {
                info = InteCQConfigUtil.getRowData(rs);
                info.setInteSystem(inteSystem);
                info.setApiConfigNumber(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private static APIAndCallInfo getRowData(IRowSet rs) throws SQLException {
        APIAndCallInfo info = new APIAndCallInfo();
        info.setDatacenter(rs.getString("FDatacenter"));
        info.setInteCQConfigNumber(rs.getString("FNumber"));
        info.setInteCQConfigName(rs.getString("configName"));
        info.setApiConfigName(rs.getString("apiName"));
        info.setServerUrl(rs.getString("serverurl"));
        info.setServiceUrl(rs.getString("serviceurl"));
        info.setAccountId(rs.getString("FAccountId"));
        info.setClientId(rs.getString("FAppId"));
        info.setAppSecret(InteCQConfigUtil.decrypt(rs.getString("FAppSecret")));
        String apiAgentUser = rs.getString("apiUser");
        String domainId = rs.getString("FDomainID");
        UIViewTreeInfo typeinfo = new UIViewTreeInfo();
        typeinfo.setId(BOSUuid.read((String)domainId));
        info.setDomain(typeinfo);
        if (StringUtils.isEmpty((String)apiAgentUser)) {
            info.setAgentUser(rs.getString("FAgentUser"));
        } else {
            info.setAgentUser(apiAgentUser);
        }
        AuthCQTypeEnum authType = AuthCQTypeEnum.getEnum(rs.getInt("FAuthType"));
        if (null == authType) {
            authType = AuthCQTypeEnum.advance;
        }
        info.setAuthType(authType);
        info.setStatus(StateEnum.getEnum(rs.getInt("FStatus")));
        info.setDigestType(rs.getString("FDigestType"));
        info.setDigestSecret(InteCQConfigUtil.decrypt(rs.getString("FDigestSecret")));
        info.setSignType(rs.getString("FSignType"));
        info.setSignSecret(InteCQConfigUtil.decrypt(rs.getString("FSignSecret")));
        info.setSignUser(rs.getString("FSignUser"));
        info.setSignKey(InteCQConfigUtil.decrypt(rs.getString("FSignKey")));
        info.setEncryptType(CQEncryptTypeEnum.getEnum(rs.getInt("FEncryptType")));
        info.setCertKey(InteCQConfigUtil.decrypt(rs.getString("FCertKey")));
        info.setOpenLog(rs.getBoolean("FIsOpenLog"));
        info.setJwtType(JWTTypeEnum.getEnum(rs.getString("FJwtType")));
        return info;
    }

    public static String getErrorMsg(CQResponseBean res) {
        return InteCQConfigUtil.getErrorMsg(res, false);
    }

    public static String getErrorMsg(CQResponseBean res, boolean isTest) {
        if (null == res) {
            return null;
        }
        return InteCQConfigUtil.getErrorMsg(res.getErrorCode(), res.getMessage(), res.getCallInfo(), isTest);
    }

    public static String getErrorMsg(String errorCode, String errorMsg, APIAndCallInfo callInfo, boolean isTest) {
        if (isTest || null == callInfo || StringUtils.isEmpty((String)errorCode)) {
            return errorMsg;
        }
        CQResultCodeEnum newMsg = CQResultCodeEnum.getEnum(errorCode);
        if (null != newMsg) {
            errorMsg = newMsg.getAlias();
        }
        return new InteCQException(InteCQException.CALL_OUTER_ERROR, new Object[]{callInfo.getInteSystem().getAlias(), callInfo.getServerUrl() + callInfo.getServiceUrl(), errorCode, errorMsg}).getMessage();
    }

    public static void handlerErrorMsg(String errorCode, String errorMsg, APIAndCallInfo callInfo) throws EASBizException {
        CQResultCodeEnum newMsg = CQResultCodeEnum.getEnum(errorCode);
        if (null != newMsg) {
            errorMsg = newMsg.getAlias();
        }
        throw new InteCQException(InteCQException.CALL_OUTER_ERROR, new Object[]{callInfo.getInteSystem().getAlias(), callInfo.getServerUrl() + callInfo.getServiceUrl(), errorCode, errorMsg});
    }

    public static void handlerErrorMsg(CQResponseBean res) throws EASBizException {
        InteCQConfigUtil.handlerErrorMsg(res.getErrorCode(), res.getMessage(), res.getCallInfo());
    }

    public static String getErrorMsg(String responseString, APIAndCallInfo callInfo, boolean isTest) {
        CQResponseBean resBean = (CQResponseBean)JSON.parseObject((String)responseString, CQResponseBean.class);
        resBean.setCallInfo(callInfo);
        return InteCQConfigUtil.getErrorMsg(resBean, isTest);
    }

    public static boolean isValidURL(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        Matcher matcher = URL_PATTERN.matcher(url);
        return matcher.matches();
    }
}

