/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.CalculatorManager2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalaryCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.threadpool.CalCalculateThreadPool;
import java.util.Date;

public class ConcurrentCalculatorProxy2
extends SalaryCalculatorProxy2 {
    public ConcurrentCalculatorProxy2(Parameters param, SalaryCalculator2 calculator) throws EASBizException {
        this.calculator = calculator;
        this.setCtx(param.getCtx());
        this.setMainTableName(param.getMainTableName());
        this.setMainTableAlias(param.getMainTableAlias());
        this.setCalCategoryNum(param.getCalCategoryNum());
        this.setSchemeID(param.getSchemeID());
        this.setEndDate(param.getEndDate());
        this.setMainTableRowFilter(param.getMainTableRowFilter());
        this.setCalFormulaColl(param.getFormulaCollection());
        this.setContainsVerification(param.isContainsVerification());
        this.setOuterData(param.getOuterData());
    }

    public static ConcurrentCalculatorProxy2 getInstance(Parameters param, SalaryCalculator2 calculator) throws EASBizException {
        return new ConcurrentCalculatorProxy2(param, calculator);
    }

    public void run() throws EASBizException {
        Future future;
        try {
            future = CalCalculateThreadPool.submit(new CalculaterFutureImpl());
        }
        catch (RejectedExecutionException e) {
            throw new SalaryException(SalaryException.CALBUSY, e);
        }
        CalculatorManager2.addTask(this.calculator, future);
    }

    public static Parameters createParamInstance() {
        return new Parameters();
    }

    public static class Parameters {
        String mainTableName;
        String mainTableAlias;
        String calCategoryNum;
        String schemeID;
        String mainTableRowFilter;
        Context ctx;
        Date endDate;
        BaseFormulaCollection formulaCollection;
        boolean isContainsVerification;
        Object outerData;

        public String getMainTableName() {
            return this.mainTableName;
        }

        public void setMainTableName(String mainTableName) {
            this.mainTableName = mainTableName;
        }

        public String getMainTableAlias() {
            return this.mainTableAlias;
        }

        public void setMainTableAlias(String mainTableAlias) {
            this.mainTableAlias = mainTableAlias;
        }

        public String getCalCategoryNum() {
            return this.calCategoryNum;
        }

        public void setCalCategoryNum(String calCategoryNum) {
            this.calCategoryNum = calCategoryNum;
        }

        public String getSchemeID() {
            return this.schemeID;
        }

        public void setSchemeID(String schemeID) {
            this.schemeID = schemeID;
        }

        public String getMainTableRowFilter() {
            return this.mainTableRowFilter;
        }

        public void setMainTableRowFilter(String mainTableRowFilter) {
            this.mainTableRowFilter = mainTableRowFilter;
        }

        public Context getCtx() {
            return this.ctx;
        }

        public void setCtx(Context ctx) {
            this.ctx = ctx;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public BaseFormulaCollection getFormulaCollection() {
            return this.formulaCollection;
        }

        public void setFormulaCollection(BaseFormulaCollection formulaCollection) {
            this.formulaCollection = formulaCollection;
        }

        public boolean isContainsVerification() {
            return this.isContainsVerification;
        }

        public void setContainsVerification(boolean containsVerification) {
            this.isContainsVerification = containsVerification;
        }

        public Object getOuterData() {
            return this.outerData;
        }

        public void setOuterData(Object outerData) {
            this.outerData = outerData;
        }
    }

    class CalculaterFutureImpl
    implements Callable {
        CalculaterFutureImpl() {
        }

        public Object call() throws Exception {
            ConcurrentCalculatorProxy2.this.calculator.run();
            Sheet calResult = ConcurrentCalculatorProxy2.this.calculator.getCalResult();
            CalculatorManager2.removeTask(ConcurrentCalculatorProxy2.this.calculator.getUID(), "");
            return calResult;
        }
    }
}

