/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.exception.SalarySimulateException;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.data.DataTypes;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalaryCalculator2Simulate
extends SalaryCalculator2 {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.SalaryCalculator2Simulate");
    private String execSubmitBillEntryId;
    private JSONArray calData;
    private JSONArray simulateResult = new JSONArray();
    private Set<String> calItems = new HashSet<String>();

    protected void initParamter(Context ctx, Map<String, Object> param) throws EASBizException {
        this.calData = (JSONArray)param.get("calData");
        this.execSubmitBillEntryId = (String)param.get("execSubmitBillEntryId");
        this.setMainTableName((String)param.get("mainTable"));
        this.setMainTableAlias("CMP_SMT002");
        this.setCalCategoryNum("CMP_SUB_002");
        this.setSchemeID((String)param.get("calSchemeID"));
        this.setCtx(ctx);
        this.setEndDate(new Date());
        this.setMainTableRowFilter((String)param.get("condition"));
        this.setCalFormulas("'" + (String)param.get("formulaId") + "'");
        this.setSimilation(true);
    }

    public JSONArray testExecute(Context ctx, Map<String, Object> param) throws Exception {
        this.initParamter(ctx, param);
        this.run();
        Sheet resutSheet = this.getCalResult();
        if (resutSheet != null && resutSheet.getErrDataList() != null && resutSheet.getErrDataList().size() > 0) {
            throw new Exception(resutSheet.getErrDataList().get(0).getErrMsg());
        }
        return this.simulateResult;
    }

    @Override
    protected SalaryCalFunction2 initCalInstance(Map<String, Object> allCnSnMap, BaseFormulaCollection searchCalFormula) throws SalaryException {
        SalaryCalFunction2 calObj = super.initCalInstance(allCnSnMap, searchCalFormula);
        calObj.setType("test");
        return calObj;
    }

    @Override
    protected DataSet initCalData(Map<String, String> assTable) throws EASBizException {
        DataSet dataSet = super.initCalData(assTable);
        this.reAssembleCalData(dataSet);
        return dataSet;
    }

    private void reAssembleCalData(DataSet dataSet) throws EASBizException {
        DataTable dataTable = dataSet.getTables(this.getMainTableName());
        ColumnAttributes[] allColumns = dataTable.getAllColumns();
        HashMap<String, Integer> cellIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < allColumns.length; ++i) {
            cellIndexMap.put(allColumns[i].getName().toUpperCase(Locale.ENGLISH), i);
        }
        DataRow[] rows = dataTable.getAllRows();
        for (int i = 0; i < rows.length; ++i) {
            DataRow row = rows[i];
            try {
                for (int k = 0; k < this.calData.length(); ++k) {
                    JSONObject data = this.calData.getJSONObject(k);
                    if (data.has("isCal")) {
                        this.calItems.add(data.getString("fieldSn"));
                    }
                    if (!this.reAssembleItem(row, data, cellIndexMap) && !this.reAssembleVar(row, data, dataTable)) continue;
                }
                continue;
            }
            catch (JSONException e) {
                throw new SalarySimulateException(SalarySimulateException.PARAMPARSE, e);
            }
        }
    }

    private boolean reAssembleItem(DataRow row, JSONObject data, Map<String, Integer> cellIndexMap) throws EASBizException, JSONException {
        if (data.has("fieldSn")) {
            String rowKey = this.getMainTableAlias() + "." + data.get("fieldSn");
            Integer rowKeyIndex = cellIndexMap.get(rowKey.toUpperCase(Locale.ENGLISH));
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                row.setValue((int)rowKeyIndex, (Object)data.getString("value"));
            } else {
                row.setValue((int)rowKeyIndex, data.getDouble("value"));
            }
            return true;
        }
        return false;
    }

    private boolean reAssembleVar(DataRow row, JSONObject data, DataTable dataTable) throws EASBizException, JSONException {
        if (data.has("varset")) {
            ColumnAttributes columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(dataTable.columns.size());
            columnAttributes.setName(data.getString("varset"));
            columnAttributes.setVar(true);
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add(data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add(data.getDouble("value"));
            }
            dataTable.columns.add(columnAttributes);
            return true;
        }
        return false;
    }

    @Deprecated
    private boolean reAssembleInfoSet(DataRow row, JSONObject data, DataSet dataSet) throws EASBizException, JSONException {
        if (data.has("infoset")) {
            String infoset = data.getString("infoset");
            String infoSetTableName = infoset.split("\\.")[0];
            DataTable infoSetTable = dataSet.getTables(infoSetTableName);
            ArrayList newRow = new ArrayList();
            if (infoSetTable == null) {
                ArrayList columns;
                infoSetTable = new DataTable();
                infoSetTable.setTableName(infoSetTableName);
                dataSet.addTable(infoSetTable);
                infoSetTable.columns = columns = new ArrayList();
                DataRow dataRow = new DataRow();
                dataRow.columns = columns;
                infoSetTable.addRow(dataRow, this.execSubmitBillEntryId);
                ColumnAttributes columnAttributes = new ColumnAttributes();
                columnAttributes.setIndex(infoSetTable.columns.size());
                columnAttributes.setName("FID");
                columnAttributes.setType(DataTypes.STRING);
                infoSetTable.columns.add(columnAttributes);
                dataRow.add(this.execSubmitBillEntryId);
            }
            ColumnAttributes columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(infoSetTable.columns.size());
            columnAttributes.setName(infoset.split("\\.")[1]);
            columnAttributes.setType(DataTypes.STRING);
            infoSetTable.columns.add(columnAttributes);
            infoSetTable.getDataRow(this.execSubmitBillEntryId).add(data.getString("value"));
            return true;
        }
        return false;
    }

    @Override
    protected void handleCalResult(Map<String, Object> allCnSnMap, Sheet result, Map<String, Object> calResult) throws SalaryException {
        String queryItemSql = "select item.FieldSn, item.FDateType from T_HR_SCalSubmitSchemeItem si left join T_HR_SCalSubmitItem item on si.FCalSubmitItemID = item.FID where si.FCalSubmitSchemeID = '" + this.getSchemeID() + "' and item.FDataType = '2'";
        HashMap<String, Integer> dateTypeMap = new HashMap<String, Integer>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)queryItemSql);
            while (rs.next()) {
                dateTypeMap.put("S" + rs.getString("FieldSn"), rs.getInt("FDateType"));
            }
        }
        catch (Exception e) {
            throw new SalarySimulateException(SalarySimulateException.PARAMPARSE, e);
        }
        for (String calItem : this.calItems) {
            JSONObject node = new JSONObject();
            try {
                node.put("fieldSn", (Object)calItem);
                String key = this.getMainTableName() + "_" + calItem;
                if (dateTypeMap.get(calItem) != null && calResult.get(key.toUpperCase(Locale.ENGLISH)) != null) {
                    int dateType = (Integer)dateTypeMap.get(calItem);
                    SimpleDateFormat sdf = null;
                    sdf = dateType == 20 ? new SimpleDateFormat("yyyy-MM") : new SimpleDateFormat("yyyy-MM-dd");
                    node.put("value", (Object)sdf.format(sdf.parse((String)calResult.get(key.toUpperCase(Locale.ENGLISH)))));
                } else {
                    node.put("value", calResult.get(key.toUpperCase(Locale.ENGLISH)));
                }
            }
            catch (Exception e) {
                throw new SalarySimulateException(SalarySimulateException.PARAMPARSE, e);
            }
            this.simulateResult.put((Object)node);
        }
    }

    @Override
    protected Map<String, Object> initEditedItems() {
        HashMap<String, Object> EditedItems = new HashMap<String, Object>();
        return EditedItems;
    }
}

