/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.base.data;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.validaterule.exception.DataSetException;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.data.DataTypes;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;

public class DataSetGenerator {
    public static ArrayList<ColumnAttributes> generateColumns(ResultSetMetaData rsm) throws Exception {
        ArrayList<ColumnAttributes> result = new ArrayList<ColumnAttributes>();
        try {
            rsm.getColumnCount();
        }
        catch (Exception e) {
            throw new DataSetException(DataSetException.ERRORGETMSG);
        }
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            ColumnAttributes column = new ColumnAttributes();
            column.setIndex(i);
            column.setName(rsm.getColumnName(i + 1));
            column.setSchemaName(rsm.getSchemaName(i + 1));
            column.setDbtype(rsm.getColumnType(i + 1));
            column.setScale(rsm.getScale(i + 1));
            if (column.getDbtype() == 1 || column.getDbtype() == 12) {
                column.setType(DataTypes.STRING);
            } else if (column.getDbtype() == 93 || column.getDbtype() == 91) {
                column.setType(DataTypes.DATE);
            } else if (column.getDbtype() == 2) {
                column.setType(DataTypes.FLOAT);
            } else if (column.getDbtype() == 2004) {
                column.setType(DataTypes.BLOB);
            } else {
                column.setType(DataTypes.INTEGER);
            }
            result.add(column);
        }
        return result;
    }

    protected static Object generateColumnValue(ColumnAttributes column) throws EASBizException {
        int type = column.getType();
        Object defaultvalue = column.getDefaultValue();
        boolean isdefaultvalue = defaultvalue != null;
        try {
            Object result = type == DataTypes.BINARY ? (Object)(isdefaultvalue ? (byte[])defaultvalue : new byte[]{}) : (type == DataTypes.DATE ? (isdefaultvalue ? (Object)((Date)defaultvalue).clone() : (Object)new Date()) : (type == DataTypes.FLOAT ? (isdefaultvalue ? (Object)new Float(((Float)defaultvalue).floatValue()) : (Object)new Float(0.0f)) : (type == DataTypes.INTEGER ? (isdefaultvalue ? (Object)new Integer((Integer)defaultvalue) : (Object)new Integer(0)) : (Object)"")));
            return result;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetException.MISMATCH);
        }
    }

    public static ArrayList generateEmptyRow(ArrayList columns) throws EASBizException {
        if (columns == null || columns.size() == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            result.add(DataSetGenerator.generateColumnValue((ColumnAttributes)columns.get(i)));
        }
        return result;
    }

    public static DataTable generateDatas(ResultSet rs, ArrayList<ColumnAttributes> columns) throws Exception {
        DataTable dt = new DataTable();
        dt = DataSetGenerator.generateDatas(dt, rs, columns);
        return dt;
    }

    public static DataTable generateDatas(DataTable dt, ResultSet rs, ArrayList<ColumnAttributes> columns) throws Exception {
        if (null == dt) {
            dt = new DataTable();
        }
        DataRow dataRow = null;
        String key = null;
        try {
            while (rs.next()) {
                dataRow = new DataRow();
                for (int i = 0; i < columns.size(); ++i) {
                    ColumnAttributes columnAttributes = columns.get(i);
                    if ("fid".equalsIgnoreCase(columnAttributes.getName())) {
                        key = rs.getString("fid");
                    }
                    if (columnAttributes.getDbtype() == DataTypes.DATE) {
                        String s = rs.getString(i + 1);
                        if (s != null && s.endsWith(" 00:00:00.0")) {
                            s = s.replaceAll(" 00:00:00.0", "");
                        }
                        dataRow.add(s);
                        continue;
                    }
                    if (columnAttributes.getDbtype() == 2004) {
                        Blob blob = rs.getBlob(i + 1);
                        if (blob == null) {
                            dataRow.add(null);
                            continue;
                        }
                        long len = blob.length();
                        byte[] data = blob.getBytes(1L, (int)len);
                        dataRow.add(data);
                        continue;
                    }
                    dataRow.add(rs.getObject(i + 1));
                }
                dataRow.columns = columns;
                dt.addRow(dataRow, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataSetException(DataSetException.ERRORGETMSG);
        }
        dt.columns = columns;
        return dt;
    }
}

