/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.eas.toolset.bean.ChangeLog;
import com.kingdee.eas.toolset.bean.Comment;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.client.IToolsetUI;
import com.kingdee.eas.toolset.client.UIHelper;
import com.kingdee.eas.toolset.util.BackgroundPanel;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.eas.toolset.util.FrameUtil;
import com.kingdee.eas.toolset.util.HttpUtil;
import com.kingdee.eas.toolset.util.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DetailInfoUI {
    private static GridBagConstraints gc = new GridBagConstraints();
    private static KDDialog detail;
    private static KDPanel scrComment;
    private static KDTextArea txtDesc;
    private static KDLabel downloadTimes;
    private static KDLabel viewTimes;
    private static KDLabel mail;
    private static KDLabel phone;
    private static KDLabel techSupport;
    private static KDLabel territory;
    private static KDLabel licenseType;
    private static KDLabel updateTime;
    private static KDLabel toolVersion;
    private static KDLabel toolType;
    private static KDLabel toolName;
    private static BackgroundPanel imageLabel;
    private static JTabbedPane descPane;
    private static String tName;
    private static KDTextArea commentArea;
    private static KDPanel commentPanel;
    private static KDPanel doCommontPane;
    private static KDPanel commentListPanel;
    private static KDScrollPane commentListScrollPane;
    private static KDTextPane txtChangeLogs;
    private static JLabel lblViewImage;
    private static String toolId;

    public static void init(IToolsetUI ui, ToolBean tool, int type) {
        String number = tool.getNumber();
        ToolBean tb = ETSUtil.getToolInfo(number);
        if (tb != null) {
            DetailInfoUI.initDialog(tb, type);
            detail.setVisible(true);
        }
    }

    private static JDialog initDialog(ToolBean tb, int type) {
        if (tb == null) {
            return null;
        }
        toolId = tb.getId();
        if (detail == null) {
            detail = new KDDialog();
            detail.setModal(true);
            detail.setDefaultCloseOperation(1);
            detail.setResizable(false);
            detail.setSize(600, 600);
            FrameUtil.onCenter((Component)detail);
            detail.setTitle("\u8be6\u7ec6\u4fe1\u606f");
            detail.setLayout((LayoutManager)new BorderLayout());
            imageLabel = new BackgroundPanel();
            lblViewImage = new JLabel("\u70b9\u51fb\u67e5\u770b\u539f\u56fe");
            lblViewImage.setForeground(Color.blue);
            lblViewImage.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DetailInfoUI.actionViewImage();
                }

                public void mouseEntered(MouseEvent e) {
                    lblViewImage.setForeground(Color.orange);
                }

                public void mouseExited(MouseEvent e) {
                    lblViewImage.setForeground(Color.blue);
                }
            });
            imageLabel.add(lblViewImage);
            imageLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DetailInfoUI.actionViewImage();
                }
            });
            imageLabel.setSize(200, 200);
            imageLabel.setPreferredSize(new Dimension(200, 200));
            detail.add((Component)((Object)imageLabel), (Object)"West");
            KDPanel infoPanel = new KDPanel();
            infoPanel.setPreferredSize(new Dimension(400, 200));
            infoPanel.setLayout((LayoutManager)new GridBagLayout());
            detail.add((Component)infoPanel, (Object)"East");
            Insets ins0 = new Insets(10, 5, 0, 0);
            Insets ins1 = new Insets(10, 15, 0, 0);
            DetailInfoUI.gc.gridx = 0;
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.anchor = 18;
            DetailInfoUI.gc.gridwidth = 10;
            DetailInfoUI.gc.insets = ins0;
            tName = tb.getName();
            toolName = new KDLabel(String.valueOf(tb.getName()) + "(\u7f16\u53f7\uff1a" + tb.getNumber() + ")");
            toolName.setFont(new Font("\u5b8b\u4f53", 1, 12));
            infoPanel.add((Component)toolName, (Object)gc);
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 1;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u5de5\u5177\u7248\u672c\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 1;
            toolVersion = new KDLabel(tb.getToolVersion());
            infoPanel.add((Component)toolVersion, (Object)gc);
            DetailInfoUI.gc.insets = ins1;
            DetailInfoUI.gc.gridx = 2;
            infoPanel.add((Component)new KDLabel("\u66f4\u65b0\u65f6\u95f4\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 3;
            updateTime = new KDLabel(tb.getUpdateTime());
            infoPanel.add((Component)updateTime, (Object)gc);
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 1;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u5de5\u5177\u7c7b\u578b\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 1;
            toolType = new KDLabel(UIHelper.getToolTypeAlias(tb.getToolGroup()));
            infoPanel.add((Component)toolType, (Object)gc);
            DetailInfoUI.gc.insets = ins1;
            DetailInfoUI.gc.gridx = 2;
            infoPanel.add((Component)new KDLabel("\u8bb8\u53ef\u63a7\u5236\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 3;
            licenseType = new KDLabel(UIHelper.getLicenseTypeAlias(tb.getLicenseType()));
            infoPanel.add((Component)licenseType, (Object)gc);
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 2;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u9002\u7528\u9886\u57df\uff1a"), (Object)gc);
            DetailInfoUI.gc.gridx = 1;
            territory = new KDLabel(UIHelper.getTerritoryAlias(tb.getEasTerritorys()));
            infoPanel.add((Component)territory, (Object)gc);
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 2;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u6280\u672f\u652f\u6301\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 1;
            techSupport = new KDLabel(tb.getTechSupport());
            infoPanel.add((Component)techSupport, (Object)gc);
            DetailInfoUI.gc.gridwidth = 2;
            DetailInfoUI.gc.insets = ins1;
            DetailInfoUI.gc.gridx = 2;
            infoPanel.add((Component)new KDLabel("\u652f\u6301\u7535\u8bdd\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 3;
            phone = new KDLabel(tb.getPhone());
            infoPanel.add((Component)phone, (Object)gc);
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 1;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u652f\u6301\u90ae\u7bb1\uff1a"), (Object)gc);
            DetailInfoUI.gc.gridwidth = 3;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 1;
            mail = new KDLabel(tb.getEmail());
            mail.setForeground(Color.blue);
            mail.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DetailInfoUI.actionMail();
                }

                public void mouseEntered(MouseEvent e) {
                    mail.setForeground(Color.orange);
                }

                public void mouseExited(MouseEvent e) {
                    mail.setForeground(Color.blue);
                }
            });
            infoPanel.add((Component)mail, (Object)gc);
            JButton btnMail = new JButton();
            ImageIcon img = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "mail.png");
            if (img != null) {
                btnMail.setIcon(img);
            }
            btnMail.setFocusable(false);
            btnMail.setPreferredSize(new Dimension(20, 20));
            btnMail.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailInfoUI.actionMail();
                }
            });
            DetailInfoUI.gc.anchor = 13;
            infoPanel.add((Component)btnMail, (Object)gc);
            DetailInfoUI.gc.anchor = 17;
            ++DetailInfoUI.gc.gridy;
            DetailInfoUI.gc.gridwidth = 2;
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 0;
            infoPanel.add((Component)new KDLabel("\u6d4f\u89c8\u6b21\u6570\uff1a"), (Object)gc);
            DetailInfoUI.gc.gridx = 1;
            viewTimes = new KDLabel(String.valueOf(tb.getViewTimes()));
            infoPanel.add((Component)viewTimes, (Object)gc);
            DetailInfoUI.gc.gridwidth = 2;
            DetailInfoUI.gc.insets = ins1;
            DetailInfoUI.gc.gridx = 2;
            infoPanel.add((Component)new KDLabel("\u4e0b\u8f7d\u6b21\u6570\uff1a"), (Object)gc);
            DetailInfoUI.gc.insets = ins0;
            DetailInfoUI.gc.gridx = 3;
            downloadTimes = new KDLabel(String.valueOf(tb.getDownloadTimes()));
            infoPanel.add((Component)downloadTimes, (Object)gc);
            descPane = ETSContext.getRunMode() == 0 ? new KDTabbedPane() : new JTabbedPane();
            descPane.setPreferredSize(new Dimension(590, 370));
            detail.add((Component)descPane, (Object)"South");
            txtDesc = new KDTextArea(5, 5);
            txtDesc.setLineWrap(true);
            txtDesc.setEditable(false);
            txtDesc.setText(tb.getDescription());
            txtDesc.setFont(new Font("\u5b8b\u4f53", 0, 12));
            KDScrollPane scrollPane = new KDScrollPane((Component)txtDesc);
            KDScrollPane scrChangeLog = new KDScrollPane();
            scrComment = new KDPanel((LayoutManager)new BorderLayout());
            scrComment.setPreferredSize(new Dimension(580, 360));
            doCommontPane = new KDPanel();
            doCommontPane.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            doCommontPane.setBorder((Border)BorderFactory.createTitledBorder("\u53d1\u8868\u8bc4\u8bba"));
            commentArea = new KDTextArea(3, 20);
            commentArea.setLineWrap(true);
            c.insets = new Insets(5, 0, 5, 5);
            KDScrollPane scroll = new KDScrollPane();
            scroll.setViewportView((Component)commentArea);
            scroll.setPreferredSize(new Dimension(480, 75));
            doCommontPane.add((Component)scroll, (Object)c);
            JButton submitComment = new JButton("\u63d0\u4ea4");
            c.anchor = 15;
            c.insets = new Insets(5, 0, 5, 5);
            doCommontPane.add((Component)submitComment, (Object)c);
            submitComment.setMargin(new Insets(2, 2, 2, 2));
            submitComment.setPreferredSize(new Dimension(40, 25));
            submitComment.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailInfoUI.actionComment();
                }
            });
            scrComment.add((Component)doCommontPane, (Object)"North");
            commentListPanel = new KDPanel();
            commentListScrollPane = new KDScrollPane();
            commentListScrollPane.setPreferredSize(new Dimension(570, 200));
            commentListPanel.add((Component)commentListScrollPane);
            commentPanel = new KDPanel();
            commentPanel.setLayout((LayoutManager)new BoxLayout((Container)commentPanel, 1));
            commentListScrollPane.setViewportView((Component)commentPanel);
            scrComment.add((Component)commentListPanel, (Object)"Center");
            descPane.addTab("\u529f\u80fd\u63cf\u8ff0", (Component)scrollPane);
            descPane.addTab("\u8bc4\u8bba\u53cd\u9988", (Component)scrComment);
            txtChangeLogs = new KDTextPane();
            txtChangeLogs.setEditable(false);
            scrChangeLog.setViewportView((Component)txtChangeLogs);
            descPane.addTab("\u66f4\u65b0\u65e5\u5fd7", (Component)scrChangeLog);
        } else {
            tName = tb.getName();
            toolName.setText(String.valueOf(tb.getName()) + "(\u7f16\u53f7\uff1a" + tb.getNumber() + ")");
            toolVersion.setText(tb.getToolVersion());
            updateTime.setText(tb.getUpdateTime());
            toolType.setText(UIHelper.getToolTypeAlias(tb.getToolGroup()));
            licenseType.setText(UIHelper.getLicenseTypeAlias(tb.getLicenseType()));
            territory.setText(UIHelper.getTerritoryAlias(tb.getEasTerritorys()));
            techSupport.setText(tb.getTechSupport());
            phone.setText(tb.getPhone());
            mail.setText(tb.getEmail());
            mail.setForeground(Color.blue);
            viewTimes.setText(String.valueOf(tb.getViewTimes()));
            downloadTimes.setText(String.valueOf(tb.getDownloadTimes()));
            txtDesc.setText(tb.getDescription());
        }
        ImageIcon imageIcon = null;
        File f = new File(String.valueOf(ETSUtil.getToolPath(tb.getNumber())) + "/image.jpg");
        lblViewImage.setVisible(true);
        if (f.exists()) {
            imageIcon = new ImageIcon(String.valueOf(ETSUtil.getToolPath(tb.getNumber())) + "/image.jpg");
        }
        if (imageIcon == null && tb.getPicture() != null && tb.getPicture().trim().length() > 0) {
            try {
                byte[] data = HttpUtil.getImageBytes(tb.getPicture());
                imageIcon = new ImageIcon(data);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        imageLabel.setName(null);
        if (imageIcon == null) {
            lblViewImage.setVisible(false);
            imageLabel.setName("default");
            imageIcon = ResourceUtil.getImageRes(String.valueOf(ETSContext.getETSHome()) + "/images/", "defaultimage.jpg");
        }
        imageLabel.setImage(imageIcon.getImage());
        if (type == 1) {
            doCommontPane.setVisible(true);
            descPane.setSelectedIndex(1);
            commentListScrollPane.setPreferredSize(new Dimension(570, 200));
        } else if (type == 0) {
            doCommontPane.setVisible(false);
            descPane.setSelectedIndex(0);
            commentListScrollPane.setPreferredSize(new Dimension(570, 300));
        }
        DetailInfoUI.getToolComments();
        DetailInfoUI.getToolChangeLogs();
        return detail;
    }

    protected static void actionViewImage() {
        if (imageLabel.getName() != null) {
            return;
        }
        Image image = imageLabel.getImage();
        if (image == null) {
            return;
        }
        JDialog d = new JDialog();
        BackgroundPanel p = new BackgroundPanel(image);
        d.add((Component)((Object)p));
        d.setTitle("\u5de5\u5177\u622a\u56fe");
        d.setSize(image.getWidth(null) + 30, image.getHeight(null) + 50);
        d.setModal(true);
        FrameUtil.onCenter(d);
        d.setVisible(true);
    }

    private static void getToolChangeLogs() {
        List list = ETSUtil.getToolChangeLogs(toolId);
        txtChangeLogs.setText(null);
        if (list == null || list.size() == 0) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            ChangeLog log = (ChangeLog)list.get(i);
            if (log.getUpdateDescript() != null && log.getUpdateDescript().trim().length() != 0) {
                FrameUtil.appendStyledText(txtChangeLogs, log.getToolVersion(), Color.magenta, 15, true, false, true);
                FrameUtil.appendStyledText(txtChangeLogs, "\t\t\u66f4\u65b0\u4e8e:" + log.getUpdateTime() + "\n", Color.blue, 13, false, true, true);
                FrameUtil.appendStyledText(txtChangeLogs, String.valueOf(log.getUpdateDescript()) + "\n\n", Color.black, 13, false, false, true);
                txtChangeLogs.getCaret().setDot(0);
            }
            ++i;
        }
    }

    private static void getToolComments() {
        TitledBorder countTitle;
        commentPanel.removeAll();
        commentPanel.setVisible(false);
        List list = ETSUtil.getToolComments(toolId);
        if (list != null && list.size() > 0) {
            countTitle = BorderFactory.createTitledBorder("\u5171" + list.size() + "\u6761\u8bc4\u8bba");
            int i = 0;
            while (i < list.size()) {
                Comment c = (Comment)list.get(i);
                KDPanel cp = new KDPanel((LayoutManager)new BorderLayout());
                cp.setMaximumSize(new Dimension(520, 120));
                TitledBorder userTitle = BorderFactory.createTitledBorder(String.valueOf(c.getCreator()) + " - " + c.getCompany());
                cp.setBorder((Border)userTitle);
                KDPanel leftPanel = new KDPanel();
                JLabel name = new JLabel();
                leftPanel.add((Component)name);
                KDTextArea content = new KDTextArea();
                content.setText(c.getContent());
                content.setBorder(null);
                content.setEditable(false);
                content.setForeground(Color.black);
                content.setDisabledTextColor(Color.black);
                content.getCaret().setDot(0);
                KDScrollPane scr = new KDScrollPane();
                scr.setPreferredSize(new Dimension(300, 80));
                scr.setViewportView((Component)content);
                JLabel lbl = new JLabel("\u53d1\u8868\u4e8e\uff1a" + c.getCreateTime());
                lbl.setHorizontalAlignment(4);
                cp.add((Component)leftPanel, (Object)"West");
                cp.add((Component)lbl, (Object)"North");
                cp.add((Component)scr, (Object)"Center");
                commentPanel.add(Box.createVerticalStrut(10));
                commentPanel.add((Component)cp);
                ++i;
            }
        } else {
            countTitle = BorderFactory.createTitledBorder("\u6682\u65e0\u8bc4\u8bba");
        }
        countTitle.setTitleColor(Color.blue);
        JScrollBar scb = commentListScrollPane.getVerticalScrollBar();
        scb.setValue(0);
        commentListPanel.setBorder((Border)countTitle);
        commentPanel.setVisible(true);
    }

    protected static void actionMail() {
        try {
            String m = mail.getText();
            if (m != null && m.trim().length() > 0) {
                StringBuffer content = new StringBuffer("mailto:");
                content.append(m.trim());
                content.append("?subject=\u5173\u4e8eEAS\u670d\u52a1\u5de5\u5177-");
                content.append(tName);
                content.append("&body=");
                content.append("\u53cd\u9988\u4eba:");
                content.append(ETSContext.getCustName());
                content.append("-");
                content.append(ETSContext.getUserName());
                URI url = new URI(content.toString());
                Desktop dtp = Desktop.getDesktop();
                if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                    dtp.browse(url);
                } else {
                    KDOptionPane.showMessageDialog((Component)detail, (Object)"\u65e0\u6cd5\u8c03\u7528\u64cd\u4f5c\u7cfb\u7edf\u90ae\u4ef6\u7ec4\u4ef6");
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected static void actionComment() {
        String userName = ETSContext.getUserName();
        String company = ETSContext.getCustName();
        String text = commentArea.getText();
        if (text == null || text.trim().length() == 0) {
            KDOptionPane.showMessageDialog((Component)detail, (Object)"\u4e0d\u80fd\u63d0\u4ea4\u7a7a\u5185\u5bb9");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("contentOfComment", text);
        params.put("toolId", toolId);
        params.put("userName", userName);
        params.put("company", company);
        boolean b = ETSUtil.comment(params);
        if (b) {
            commentArea.setText("");
            KDOptionPane.showMessageDialog((Component)detail, (Object)"\u53d1\u8868\u8bc4\u8bba\u6210\u529f\uff01");
            DetailInfoUI.getToolComments();
        } else {
            KDOptionPane.showMessageDialog((Component)detail, (Object)"\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\uff01");
        }
    }
}

