/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.IDCRegister;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.toolset.bean.DataCenterBean;
import com.kingdee.eas.toolset.client.EASToolsetUI;
import com.kingdee.eas.toolset.client.LoginHelper;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.FrameUtil;
import com.kingdee.eas.toolset.util.HttpUtil;
import com.kingdee.eas.toolset.util.MapDBUtil;
import com.kingdee.util.IPUtils;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.omg.CORBA.UserException;

public class EASLoginUI
extends JFrame
implements ActionListener {
    KDComboBox dcName;
    JPasswordField password;
    JTextField serverIP;
    JTextField serverPort;
    KDComboBox userName;
    JPanel panel;
    JLabel lblDc;
    JLabel lblUserName;
    JLabel lblPw;
    JLabel lblIP;
    JLabel lblPort;
    JLabel lblMsg;
    JButton btnOk;
    PropertyChangeListener l;
    HashMap dcMap;
    FocusListener dcLoadListener;

    public EASLoginUI() {
        this.jbinit();
        this.onLoad();
    }

    public void onLoad() {
        this.getDefaultLoginParams();
        this.addListeners();
        this.setDefaultCloseOperation(3);
        this.initDcList();
    }

    private void initDcList() {
        ArrayList dcList;
        this.lblMsg.setText(null);
        this.dcName.removeAllItems();
        if (this.dcMap == null) {
            this.dcMap = new HashMap();
        }
        String ip = this.serverIP.getText();
        String port = this.serverPort.getText();
        StringBuffer url = new StringBuffer("tcp://");
        if (ip != null && port != null && !port.isEmpty() && !ip.isEmpty()) {
            url.append(ip);
            url.append(":");
            url.append(port);
            dcList = new ArrayList();
            if (this.dcMap.get(url.toString()) == null) {
                if (HttpUtil.isConnect(String.valueOf(ip) + " " + port)) {
                    try {
                        this.lblMsg.setText("\u6b63\u52a0\u8f7dEAS\u6570\u636e\u4e2d\u5fc3");
                        IDCRegister dcRegister = (IDCRegister)RPCEngineFactory.getEngine((String)url.toString()).createObject("com.kingdee.eas.base.common.DCRegister", IDCRegister.class);
                        dcList = dcRegister.getDCList();
                    }
                    catch (RPCConnectException e) {
                        e.printStackTrace();
                        this.lblMsg.setText("\u672a\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3,\u8bf7\u68c0\u67e5IP\u7aef\u53e3");
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        this.lblMsg.setText("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5f02\u5e38");
                    }
                }
                this.dcMap.put(url.toString(), dcList);
            }
            this.userName.removeAllItems();
            Object[] userNames = MapDBUtil.getLoginUserName(String.valueOf(ip) + ":" + port);
            int i = 0;
            while (i < userNames.length) {
                this.userName.addItem(userNames[i]);
                ++i;
            }
        } else {
            return;
        }
        if (this.dcMap.get(url.toString()) != null) {
            dcList = (ArrayList)this.dcMap.get(url.toString());
            if (dcList.size() > 0) {
                int i = 0;
                while (i < dcList.size()) {
                    DCInfo dcInfo = (DCInfo)dcList.get(i);
                    DataCenterBean dc = new DataCenterBean();
                    dc.setDbType(dcInfo.getDBType());
                    dc.setName(dcInfo.getName("L2"));
                    dc.setNumber(dcInfo.getNumber());
                    dc.setSln(dcInfo.getSolutionName());
                    this.dcName.addItem((Object)dc);
                    ++i;
                }
                this.lblMsg.setText(null);
            } else if (this.dcName.getItemCount() == 0) {
                this.lblMsg.setText("\u672a\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3,\u8bf7\u68c0\u67e5IP\u7aef\u53e3");
            } else {
                this.lblMsg.setText(null);
            }
        }
    }

    private void addListeners() {
        this.btnOk.removeActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnOk.registerKeyboardAction(this, KeyStroke.getKeyStroke(10, 0), 2);
        this.dcLoadListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                EASLoginUI.this.initDcList();
            }

            public void focusGained(FocusEvent e) {
            }
        };
        this.serverIP.addFocusListener(this.dcLoadListener);
        this.serverPort.addFocusListener(this.dcLoadListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (EASLoginUI.this.serverIP.getText() == null || EASLoginUI.this.serverIP.getText().isEmpty()) {
                    EASLoginUI.this.serverIP.requestFocus();
                } else if (EASLoginUI.this.serverPort.getText() == null || EASLoginUI.this.serverPort.getText().isEmpty()) {
                    EASLoginUI.this.serverPort.requestFocus();
                } else if (EASLoginUI.this.userName.getSelectedItem() == null || EASLoginUI.this.userName.getSelectedItem().toString().isEmpty()) {
                    EASLoginUI.this.userName.requestFocus();
                } else {
                    EASLoginUI.this.password.requestFocus();
                }
            }
        });
    }

    private void getDefaultLoginParams() {
        if (ETSContext.getRpcPort() != null) {
            this.serverIP.setText(ETSContext.getIp());
            this.serverPort.setText(ETSContext.getRpcPort());
            return;
        }
        if (this.userName.getItemCount() > 0) {
            this.userName.setSelectedIndex(0);
        }
    }

    private void jbinit() {
        int w = 410;
        int h = 300;
        FrameUtil.onCenter(this, w, h);
        this.setResizable(false);
        this.setTitle("EAS\u7528\u6237\u767b\u9646");
        this.dcName = new KDComboBox();
        this.password = new JPasswordField();
        this.serverIP = new JTextField();
        this.serverPort = new JTextField();
        this.userName = new KDComboBox(MapDBUtil.getLoginUserName(String.valueOf(ETSContext.getIp()) + ":" + ETSContext.getRpcPort()));
        this.userName.setEditable(true);
        this.panel = new JPanel();
        this.lblUserName = new JLabel();
        this.lblDc = new JLabel();
        this.lblPw = new JLabel();
        this.lblIP = new JLabel();
        this.lblPort = new JLabel();
        this.lblMsg = new JLabel();
        this.btnOk = new JButton();
        Container cont = this.getContentPane();
        cont.setLayout(null);
        this.panel.setLayout(null);
        this.panel.setBounds(43, 15, 315, 225);
        cont.add(this.panel);
        this.panel.add(this.lblDc);
        this.panel.add(this.lblUserName);
        this.panel.add((Component)this.userName);
        this.panel.add((Component)this.dcName);
        this.panel.add(this.lblIP);
        this.panel.add(this.serverIP);
        this.panel.add(this.lblPort);
        this.panel.add(this.serverPort);
        this.panel.add(this.lblPw);
        this.panel.add(this.password);
        this.panel.add(this.btnOk);
        this.panel.add(this.lblMsg);
        this.lblMsg.setForeground(Color.red);
        this.panel.setBorder(BorderFactory.createTitledBorder("\u767b\u9646\u4fe1\u606f:"));
        this.lblDc.setText("\u6570\u636e\u4e2d\u5fc3");
        this.lblIP.setText("\u670d\u52a1\u5668IP");
        this.lblPort.setText("\u7aef\u53e3");
        this.lblUserName.setText("\u7528\u6237\u540d");
        this.lblPw.setText("\u5bc6\u7801");
        this.btnOk.setText("\u767b\u9646");
        JButton btnDel = new JButton("\u5220\u9664");
        btnDel.setPreferredSize(new Dimension(20, 20));
        btnDel.setMargin(new Insets(0, 0, 0, 0));
        btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)EASLoginUI.this.userName.getSelectedItem();
                if (item != null) {
                    String ip = EASLoginUI.this.serverIP.getText();
                    String port = EASLoginUI.this.serverPort.getText();
                    MapDBUtil.deleteLoginUserName(String.valueOf(ip) + ":" + port, item);
                    EASLoginUI.this.userName.removeItem((Object)item);
                }
            }
        });
        this.panel.add(btnDel);
        int y = 20;
        int n = 32;
        int height = 24;
        int lblX = 40;
        int compX = 120;
        int lblWidth = 100;
        int compWidth = 150;
        this.lblIP.setBounds(lblX, y, lblWidth, height);
        this.serverIP.setBounds(compX, y, compWidth, height);
        this.lblPort.setBounds(lblX, y += n, lblWidth, height);
        this.serverPort.setBounds(compX, y, compWidth, height);
        this.lblDc.setBounds(lblX, y += n, lblWidth, height);
        this.dcName.setBounds(compX, y, compWidth, height);
        this.lblUserName.setBounds(lblX, y += n, lblWidth, height);
        this.userName.setBounds(compX, y, compWidth, height);
        btnDel.setBounds(compX + 155, y, 30, 25);
        this.lblPw.setBounds(lblX, y += n, lblWidth, height);
        this.password.setBounds(compX, y, compWidth, height);
        this.lblMsg.setBounds(lblX, (y += n) + 5, 180, height);
        this.btnOk.setBounds(compX + 80, y + 5, 58, height);
    }

    private static LoginContext createLoginContext(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern) throws Exception {
        String orgId;
        InetAddress localhost = null;
        String clientIP = null;
        String clientName = null;
        try {
            localhost = IPUtils.getLocleAddress();
            clientIP = localhost.getHostAddress();
            clientName = localhost.getHostName();
            if (clientName == null || clientName.equals("")) {
                clientName = clientIP;
            }
        }
        catch (SocketException e) {
            throw new EASLoginException(EASLoginException.LOCAL_IP_FAILURE, (Throwable)e);
        }
        if (slnName == null) {
            slnName = "eas";
        }
        String[] sln_org = slnName.split(";");
        slnName = sln_org[0];
        String encodePwd = EASLoginUI.encodePassword(userName, password);
        LoginContext ctx = new LoginContext(userName, encodePwd, slnName, dcName, locale, clientIP, clientName);
        if (sln_org.length > 1 && BOSUuid.isValid((String)(orgId = sln_org[1]), (boolean)true)) {
            ctx.put("defOrgID", (Object)orgId);
        }
        ctx.put("dbType", (Object)EASLoginUI.getDbType(dbType));
        String sessionId = "";
        if (authPattern != null && !authPattern.equals("")) {
            String[] authPatternStr = authPattern.split(";");
            ctx.put("UserAuthPattern", (Object)authPatternStr[0]);
            if (authPatternStr.length > 1) {
                sessionId = authPatternStr[1];
            }
        }
        ctx.put("dbTypeCode", (Object)new Integer(dbType));
        ctx.put("Password", (Object)encodePwd);
        if (sessionId != null && !sessionId.equals("")) {
            ctx.setContextID(sessionId);
        }
        return ctx;
    }

    public static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            e.printStackTrace();
        }
        return encodedPassword;
    }

    private static String getDbType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }

    public void actionPerformed(ActionEvent e) {
        String psw = this.password.getText();
        String username = (String)this.userName.getSelectedItem();
        if (this.dcName.getItemCount() == 0) {
            this.lblMsg.setText("\u672a\u52a0\u8f7d\u6570\u636e\u4e2d\u5fc3,\u65e0\u6cd5\u767b\u9646");
            return;
        }
        DataCenterBean dc = (DataCenterBean)this.dcName.getSelectedItem();
        if (dc == null) {
            this.lblMsg.setText("\u672a\u52a0\u8f7d\u6570\u636e\u4e2d\u5fc3,\u65e0\u6cd5\u767b\u9646");
            return;
        }
        if (username == null || username.isEmpty()) {
            this.lblMsg.setText("\u8bf7\u8f93\u5165\u7528\u6237\u540d");
            this.userName.requestFocus();
            return;
        }
        String sln = dc.getSln();
        String dcName = dc.getNumber();
        int dbType = dc.getDbType();
        Locale locale = LocaleUtils.getLocale((String)"L2");
        this.lblMsg.setText(null);
        String ip = this.serverIP.getText();
        String port = this.serverPort.getText();
        StringBuffer url = new StringBuffer("tcp://").append(ip).append(":").append(port);
        String sessionId = null;
        this.setVisible(false);
        try {
            LoginContext loginCtx = EASLoginUI.createLoginContext(username, psw, sln, dcName, locale, dbType, null);
            ETSContext.setLoginContext(loginCtx);
            ETSContext.setIp(ip);
            ETSContext.setEasServerUrl(url.toString());
            ETSContext.setRpcPort(port);
            ETSContext.setEasDCName(dcName);
            ETSContext.setDBType(dbType);
            ETSContext.setUserNumber(username);
            Context userCtx = LoginHelper.submitLogin();
            sessionId = userCtx.getContextID();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            Throwable ee = this.getCause(e1);
            if (ee instanceof UserException || ee.getMessage() != null && ee.getMessage().indexOf("\u7528\u6237\u540d") >= 0) {
                this.lblMsg.setText("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef,\u8bf7\u91cd\u8bd5\u3002");
                this.password.setText(null);
                this.password.requestFocus();
            }
            if (ee instanceof ConnectException) {
                this.serverIP.requestFocus();
                this.serverIP.selectAll();
                this.lblMsg.setText("\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u4fe1\u606f\u3002");
            }
            this.lblMsg.setText("\u767b\u9646\u5931\u8d25\u3002");
        }
        if (sessionId != null) {
            ETSContext.initAfterLogin();
            if (this.dcMap != null) {
                this.dcMap.clear();
                this.dcMap = null;
            }
            MapDBUtil.addLoginUserName(String.valueOf(ip) + ":" + port, username);
            EASToolsetUI ui = null;
            try {
                if (ui == null) {
                    ui = new EASToolsetUI();
                }
                if (!ui.isVisible()) {
                    ui.setVisible(true);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.setVisible(true);
        }
    }

    private Throwable getCause(Throwable e) {
        return e.getCause() == null ? e : this.getCause(e.getCause());
    }
}

