/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.eas.toolset.bean.ChangeLog;
import com.kingdee.eas.toolset.bean.Comment;
import com.kingdee.eas.toolset.bean.Customer;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.bean.ToolFilterBean;
import com.kingdee.eas.toolset.bean.ToolList;
import com.kingdee.eas.toolset.bean.UserBehaviorLog;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.HttpUtil;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ETSCloudUtil {
    public static final String ETS_CLOUD = "http://eassrv.kingdee.com";
    public static final String ETS_CLOUD_URL = "http://eassrv.kingdee.com/EASToolsetCloud/";

    public static List getToolListFromCloud(ToolFilterBean filter) {
        String result;
        ToolList lst;
        block27: {
            lst = null;
            String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!toolList.action";
            StringBuffer params = new StringBuffer();
            if (filter != null) {
                String param = filter.getEasTerritory();
                if (param != null && param.trim().length() > 0 && !"-1".equals(param)) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.easTerritory=");
                    params.append(param);
                }
                if ((param = filter.getPlatVersion()) != null && param.trim().length() > 0) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.platVersion=");
                    params.append(ETSCloudUtil.encode(param.trim()));
                }
                if ((param = filter.getName()) != null && param.trim().length() > 0) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.name=");
                    params.append(ETSCloudUtil.encode(param));
                }
                if ((param = filter.getToolType()) != null && param.trim().length() > 0 && !"-1".equals(param)) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.toolType=");
                    params.append(param);
                }
                if ((param = filter.getLicenseType()) != null && param.trim().length() > 0 && !"-1".equals(param)) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.licenseType=");
                    params.append(param);
                }
                if ((param = filter.getSortType()) != null && param.trim().length() > 0 && !"-1".equals(param)) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.sortType=");
                    params.append(param);
                }
                if ((param = filter.getInstalledNumbers()) != null && param.trim().length() > 0 && !"-1".equals(param)) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("toolFilter.installedNumbers=");
                    params.append(param);
                }
                if ((param = String.valueOf(filter.getCurPage())) != null && param.trim().length() > 0) {
                    if (params.length() > 0) {
                        params.append("&");
                    }
                    params.append("pageInfo.current=");
                    params.append(param);
                }
            }
            result = HttpUtil.doGet(String.valueOf(url) + "?" + params.toString());
            if (result != null && result.trim().length() != 0) break block27;
            return null;
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)result);
            JSONObject data = json.getJSONObject("data");
            JSONArray array = data.getJSONArray("list");
            lst = new ToolList();
            if (data.containsKey((Object)"page")) {
                JSONObject page = data.getJSONObject("page");
                if (page.containsKey((Object)"current")) {
                    int i = page.getInt("current");
                    lst.setCurPage(i);
                }
                if (page.containsKey((Object)"totalPage")) {
                    lst.setTotalPage(page.getInt("totalPage"));
                }
                if (page.containsKey((Object)"pageSize")) {
                    lst.setPageSize(page.getInt("pageSize"));
                }
                if (page.containsKey((Object)"totalCount")) {
                    lst.setTotalCount(page.getInt("totalCount"));
                }
            }
            int i = 0;
            while (i < array.size()) {
                Object str = array.get(i);
                if (str != null) {
                    json = JSONObject.fromObject((Object)str);
                    lst.add((Object)((ToolBean)JSONObject.toBean((JSONObject)json, ToolBean.class)));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lst;
    }

    public static ToolBean getToolInfo(String number) {
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!toolInfo.action?toolNumber=" + number;
        try {
            String result = HttpUtil.doGet(url);
            JSONObject json = JSONObject.fromObject((Object)result);
            String str = json.getString("data");
            if (str.startsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            JSONObject data = JSONObject.fromObject((Object)str);
            return (ToolBean)JSONObject.toBean((JSONObject)data, ToolBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addDownloadTime(String number) {
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!addDownloadTime.action?toolNumber=" + number;
        try {
            HttpUtil.doGet(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadTool(String platVersion, String toolNumber, String destPath) {
        destPath = String.valueOf(destPath) + toolNumber + ".zip";
        int byteread = 0;
        StringBuffer getUrl = new StringBuffer("http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!download.action?platVersion=");
        getUrl.append(platVersion.trim());
        getUrl.append("&toolNumber=");
        getUrl.append(toolNumber);
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            try {
                URL url = new URL(getUrl.toString());
                URLConnection conn = url.openConnection();
                inStream = conn.getInputStream();
                fs = new FileOutputStream(destPath);
                byte[] buffer = new byte[1204];
                while ((byteread = inStream.read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (inStream != null) {
                        inStream.close();
                        inStream = null;
                    }
                    if (fs != null) {
                        fs.close();
                        fs = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
                if (fs != null) {
                    fs.close();
                    fs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map checkToolUpdate(String platVersion, Map toolMap) {
        StringBuffer getUrl = new StringBuffer("http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!checkToolUpdate.action?platVersion=");
        getUrl.append(platVersion.trim());
        getUrl.append("&tools=");
        try {
            String str = toolMap.toString();
            String tools = URLEncoder.encode(str, "utf-8");
            getUrl.append(tools);
            String ret = HttpUtil.doGet(getUrl.toString());
            JSONObject json = JSONObject.fromObject((Object)ret);
            str = json.getString("errCode");
            if ("0".equals(str)) {
                json = json.getJSONObject("data");
                HashMap map = (HashMap)JSONObject.toBean((JSONObject)json, HashMap.class);
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String checkUIUpdate(String etsVersion, String uiVersion) {
        StringBuffer getUrl = new StringBuffer("http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!checkUIUpdate.action?platVersion=");
        try {
            getUrl.append(etsVersion.trim());
            if (uiVersion != null) {
                getUrl.append("&uiVersion=");
                getUrl.append(ETSCloudUtil.encode(uiVersion.trim()));
            }
            String ret = HttpUtil.doGet(getUrl.toString());
            JSONObject json = JSONObject.fromObject((Object)ret);
            System.out.println("json:" + json.toString());
            String str = json.getString("errCode");
            if ("0".equals(str) && json.has("data")) {
                String version = json.getString("data");
                return version;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static void userBehaviorLog(UserBehaviorLog log) {
        String getUrl = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!userBehaviorLog.action";
        StringBuffer params = new StringBuffer();
        if (log.getUserNumber() != null) {
            params.append("ubLog.userNumber=");
            params.append(ETSCloudUtil.encode(log.getUserNumber()));
        }
        if (log.getUserName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.userName=");
            params.append(ETSCloudUtil.encode(log.getUserName()));
        }
        if (log.getCustNumber() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.custNumber=");
            params.append(ETSCloudUtil.encode(log.getCustNumber()));
        }
        if (log.getCustName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.custName=");
            params.append(ETSCloudUtil.encode(log.getCustName()));
        }
        if (log.getClientIp() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.clientIp=");
            params.append(ETSCloudUtil.encode(log.getClientIp()));
        }
        if (log.getClientName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.clientName=");
            params.append(ETSCloudUtil.encode(log.getClientName()));
        }
        if (log.getActionName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.actionName=");
            params.append(ETSCloudUtil.encode(log.getActionName()));
        }
        if (log.getActionDesc() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.actionDesc=");
            params.append(ETSCloudUtil.encode(log.getActionDesc()));
        }
        if (log.getActionParams() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.actionParams=");
            params.append(ETSCloudUtil.encode(log.getActionParams()));
        }
        if (log.getEasDCName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.easDCName=");
            params.append(ETSCloudUtil.encode(log.getEasDCName()));
        }
        if (log.getEasRootOrgName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.easRootOrgName=");
            params.append(ETSCloudUtil.encode(log.getEasRootOrgName()));
        }
        if (log.getToolNumber() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.toolNumber=");
            params.append(ETSCloudUtil.encode(log.getToolNumber()));
        }
        if (log.getToolName() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.toolName=");
            params.append(ETSCloudUtil.encode(log.getToolName()));
        }
        if (log.getProductNumber() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.productNumber=");
            params.append(ETSCloudUtil.encode(log.getProductNumber()));
        }
        if (log.getEasVersion() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.easVersion=");
            params.append(ETSCloudUtil.encode(log.getEasVersion()));
        }
        if (log.getPlatVersion() != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("ubLog.platVersion=");
            params.append(ETSCloudUtil.encode(log.getPlatVersion()));
        }
        try {
            HttpUtil.doGet(String.valueOf(getUrl) + "?" + params.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Customer getCustomerInfo(String productNumber) {
        if (productNumber == null || productNumber.trim().length() == 0) {
            return null;
        }
        Customer cust = null;
        if ("0000000000".equals(productNumber)) {
            cust = new Customer();
            cust.setName("\u4e34\u65f6\u8bb8\u53ef");
            cust.setNumber("TempLicense");
            cust.setOnService(true);
            return cust;
        }
        if (ETSContext.getClientNetworkMode() == 0) {
            return null;
        }
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!loadCustomerInfo.action";
        try {
            String ret = HttpUtil.doGet(String.valueOf(url) + "?productNumber=" + productNumber);
            JSONObject json = JSONObject.fromObject((Object)ret);
            String code = json.getString("errCode");
            if ("0".equals(code)) {
                json = json.getJSONObject("data");
                System.out.println(json);
                cust = (Customer)JSONObject.toBean((JSONObject)json, Customer.class);
            } else {
                System.out.println("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25:" + ret);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
        return cust;
    }

    public static List getToolChangeLogs(String toolId) {
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!getChangeLogs.action?toolId=" + toolId;
        try {
            String result = HttpUtil.doGet(url);
            JSONObject json = JSONObject.fromObject((Object)result);
            Object str = json.get("data");
            JSONArray arr = JSONArray.fromObject((Object)str);
            if (arr != null && arr.size() > 0) {
                ArrayList<Object> lst = new ArrayList<Object>();
                int i = 0;
                while (i < arr.size()) {
                    json = arr.getJSONObject(i);
                    lst.add(JSONObject.toBean((JSONObject)json, ChangeLog.class));
                    ++i;
                }
                return lst;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean comment(Map params) {
        String contentOfComment = (String)params.get("contentOfComment");
        String toolId = (String)params.get("toolId");
        String userName = (String)params.get("userName");
        String company = (String)params.get("company");
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!comment.action?comment.toolId=" + toolId + "&comment.content=" + ETSCloudUtil.encode(contentOfComment) + "&comment.creator=" + ETSCloudUtil.encode(userName) + "&comment.company=" + ETSCloudUtil.encode(company);
        try {
            String result = HttpUtil.doGet(url);
            JSONObject json = JSONObject.fromObject((Object)result);
            String code = json.getString("errCode");
            return "0".equals(code);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List getToolCommentList(String toolId) {
        String url = "http://eassrv.kingdee.com/EASToolsetCloud/etsInterface!getToolComments.action?toolId=" + toolId;
        try {
            String result = HttpUtil.doGet(url);
            JSONObject json = JSONObject.fromObject((Object)result);
            Object str = json.get("data");
            JSONArray arr = JSONArray.fromObject((Object)str);
            if (arr != null && arr.size() > 0) {
                ArrayList<Object> lst = new ArrayList<Object>();
                int i = 0;
                while (i < arr.size()) {
                    json = arr.getJSONObject(i);
                    lst.add(JSONObject.toBean((JSONObject)json, Comment.class));
                    ++i;
                }
                return lst;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean feedback(Map params) {
        StringBuffer url = new StringBuffer(ETS_CLOUD_URL);
        url.append("etsInterface!feedback.action?");
        String value = (String)params.get("name");
        if (value != null) {
            url.append("fb.userName=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = ETSContext.getEasRootOrgName()) != null) {
            url.append("&fb.easRootOrgName=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = ETSContext.getCustNumber()) != null) {
            url.append("&fb.custNumber=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = ETSContext.getCustName()) != null) {
            url.append("&fb.custName=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = ETSContext.getUserNumber()) != null) {
            url.append("&fb.userNumber=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = ETSContext.getProductNumber()) != null) {
            url.append("&fb.productNumber=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = (String)params.get("mail")) != null) {
            url.append("&fb.mail=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = (String)params.get("mobile")) != null) {
            url.append("&fb.mobile=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = (String)params.get("title")) != null) {
            url.append("&fb.title=");
            url.append(ETSCloudUtil.encode(value));
        }
        if ((value = (String)params.get("content")) != null) {
            url.append("&fb.content=");
            url.append(ETSCloudUtil.encode(value));
        }
        try {
            String result = HttpUtil.doGet(url.toString());
            JSONObject json = JSONObject.fromObject((Object)result);
            String code = json.getString("errCode");
            return "0".equals(code);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

