/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BizInvoiceBillReBack {
    private static Logger logger = Logger.getLogger(BizInvoiceBillReBack.class);
    private final String SETTLEMENTBILL_BOSTYPE = "65873F29";
    private final String OTHERBILL_BOSTYPE = "FC910EF3";
    private final String MAKEINVOICE_CANCLE = "cancel";

    public void dispose(Context ctx, String action, String destID) throws EASBizException, BOSException {
        logger.error((Object)"BizInvoiceBillReBack dispose start!");
        if (action != "make" && action != "cancel") {
            return;
        }
        try {
            String sql = "select FSrcBosType, FBizBillID from T_IM_MakeInvoiceRelation where FInvoiceBillID = ?";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{destID});
            String bizBillID = "";
            if (iRowSet.next()) {
                String srcBosType = iRowSet.getString("FSrcBosType");
                if (!"FC910EF3".equals(srcBosType)) {
                    return;
                }
                bizBillID = iRowSet.getString("FBizBillID");
            }
            if (StringUtils.isEmpty((CharSequence)bizBillID)) {
                return;
            }
            String oSql = "select FID, FParentID, FSourceBillId from T_AR_OtherBillentry where FParentID = ?";
            IRowSet otherBillSourceSet = DbUtil.executeQuery((Context)ctx, (String)oSql, (Object[])new Object[]{bizBillID});
            while (otherBillSourceSet.next()) {
                String srcBillId = otherBillSourceSet.getString("FSourceBillId");
                if (StringUtils.isEmpty((CharSequence)srcBillId)) {
                    return;
                }
                String entryId = otherBillSourceSet.getString("FID");
                if (!"65873F29".equals(new ObjectUuidPK(srcBillId).getObjectType().toString())) continue;
                MakeInvoiceInfo invoiceInfo = MakeInvoiceFactory.getLocalInstance((Context)ctx).getMakeInvoiceInfo("select id, number, invoiceNumber, invoiceNo, priceTaxTotal, expressBillNum, mailNumber, mailDate, drawer, invoiceDate, recBillPhone, recBillEmail, recBillAdress, makeInvoiceOrgID, entries.sourceBillEntryId, entries.priceTax  where id = '" + destID + "'");
                if (invoiceInfo.getEntries().size() > 1) {
                    for (int i = 0; i < invoiceInfo.getEntries().size(); ++i) {
                        MakeInvoiceEntryInfo makeInvoiceEntryInfo = invoiceInfo.getEntries().get(i);
                        if (!makeInvoiceEntryInfo.getSourceBillEntryId().equals(entryId)) continue;
                        invoiceInfo.setPriceTaxTotal(makeInvoiceEntryInfo.getPriceTax());
                    }
                }
                invoiceInfo.put("settlementBillId", (Object)srcBillId);
                invoiceInfo.put("otherBillId", (Object)otherBillSourceSet.getString("FParentID"));
                if ("cancel".equals(action)) {
                    invoiceInfo.setPriceTaxTotal(invoiceInfo.getPriceTaxTotal().negate());
                }
                ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseInvoiceAmt((ObjectBaseInfo)invoiceInfo);
                logger.error((Object)("receiveInfo:" + invoiceInfo.toString()));
            }
            logger.error((Object)"BizInvoiceBillReBack dispose end!");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

