/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sscbusiness.contract.ContractCollection;
import com.kingdee.eas.sscbusiness.contract.ContractFactory;
import com.kingdee.eas.sscbusiness.contract.ContractInfo;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceFacadeFactory;
import com.kingdee.eas.sscbusiness.contract.app.AbstractContractDetailControllerBean;
import com.kingdee.eas.sscbusiness.contract.app.ContractDetailEntryCollection;
import com.kingdee.eas.sscbusiness.contract.app.ContractDetailInfo;
import com.kingdee.eas.sscbusiness.contract.tool.PermissionOrgUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ContractDetailControllerBean
extends AbstractContractDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sscbusiness.contract.app.ContractDetailControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractDetailInfo info = (ContractDetailInfo)model;
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getPartAOrg().getId().toString());
        this.setAmount(model);
        this.setContract(ctx, model);
        IObjectPK pk = super._submit(ctx, (IObjectValue)((CoreBaseInfo)model));
        ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseContractAmt(((ContractDetailInfo)model).getContract());
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractDetailInfo info = (ContractDetailInfo)model;
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getPartAOrg().getId().toString());
        info.setContract(null);
        this.setAmount((IObjectValue)info);
        return super._save(ctx, (IObjectValue)info);
    }

    private void setAmount(IObjectValue model) {
        ContractDetailInfo info = (ContractDetailInfo)model;
        ContractDetailEntryCollection entries = info.getEntries();
        BigDecimal fixAmount = new BigDecimal(0);
        BigDecimal computeAmount = new BigDecimal(0);
        for (int i = 0; i < entries.size(); ++i) {
            BigDecimal fixAmountEntry = entries.get(i).getFixAmount() == null ? new BigDecimal(0) : entries.get(i).getFixAmount();
            BigDecimal computeAmountEntry = entries.get(i).getComputeAmount() == null ? new BigDecimal(0) : entries.get(i).getComputeAmount();
            fixAmount = fixAmount.add(fixAmountEntry);
            computeAmount = computeAmount.add(computeAmountEntry);
            int settlementCycle = entries.get(i).getSettlementCycle().getValue();
            BigDecimal settlementCycleAmount = fixAmountEntry.add(computeAmountEntry).divide(new BigDecimal(settlementCycle), 2, RoundingMode.HALF_UP);
            entries.get(i).setSettlementCycleAmount(settlementCycleAmount);
        }
        info.setFixAmount(fixAmount);
        info.setComputeAmount(computeAmount);
        info.setBizDate(new Timestamp(new Date().getTime()));
    }

    private void setContract(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractDetailInfo info = (ContractDetailInfo)model;
        ContractInfo cInfo = info.getContract();
        ContractCollection contracts = ContractFactory.getLocalInstance(ctx).getContractCollection("where number = '" + info.getCtNumber() + "' and scOrg.id = '" + info.getPartAOrg().getId().toString() + "'");
        if (contracts.isEmpty()) {
            cInfo = new ContractInfo();
            cInfo.setNumber(model.getString("ctNumber"));
            cInfo.setFixAmount(info.getFixAmount());
            cInfo.setComputeAmount(info.getComputeAmount());
            cInfo.setStartDate(info.getStartDate());
            cInfo.setEndDate(info.getEndDate());
        } else {
            cInfo = contracts.get(0);
            cInfo.setFixAmount(cInfo.getFixAmount().add(info.getFixAmount()));
            cInfo.setComputeAmount(cInfo.getComputeAmount().add(info.getComputeAmount()));
            if (cInfo.getStartDate().after(info.getStartDate())) {
                cInfo.setStartDate(info.getStartDate());
            }
            if (cInfo.getEndDate().before(info.getEndDate())) {
                cInfo.setEndDate(info.getEndDate());
            }
        }
        cInfo.setScOrg(info.getPartAOrg());
        cInfo.setCompany(info.getCompany());
        ContractFactory.getLocalInstance(ctx).save((CoreBaseInfo)cInfo);
        info.setContract(cInfo);
    }
}

