/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sscbusiness.contract.BillException;
import com.kingdee.eas.sscbusiness.contract.BillType;
import com.kingdee.eas.sscbusiness.contract.ConPerfLevelEnum;
import com.kingdee.eas.sscbusiness.contract.ContractFactory;
import com.kingdee.eas.sscbusiness.contract.ContractInfo;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceFactory;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceInfo;
import com.kingdee.eas.sscbusiness.contract.ReverseLogFactory;
import com.kingdee.eas.sscbusiness.contract.ReverseLogInfo;
import com.kingdee.eas.sscbusiness.contract.SettlementBillFactory;
import com.kingdee.eas.sscbusiness.contract.SettlementBillInfo;
import com.kingdee.eas.sscbusiness.contract.app.AbstractContractPerformanceFacadeControllerBean;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ContractPerformanceFacadeControllerBean
extends AbstractContractPerformanceFacadeControllerBean {
    private static final long serialVersionUID = 4411352445574469663L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sscbusiness.contract.app.ContractPerformanceFacadeControllerBean");

    @Override
    protected IObjectCollection _getChildData(Context ctx, String number, int level) throws BOSException, EASBizException {
        ContractPerformanceInfo contractPerformanceInfo = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("select longNumber where dataKey = '" + number + "'");
        String oql = "where longNumber like '" + contractPerformanceInfo.getLongNumber() + "!%' order by longNumber desc";
        return ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceCollection(oql);
    }

    @Override
    protected void _reverseOtherAmt(Context ctx, IObjectValue otherInfo, int state) throws BOSException, EASBizException {
        this.addReverseLog(ctx, otherInfo);
        this._saveOther(ctx, otherInfo, state);
    }

    @Override
    protected void _reverseReceivingAmt(Context ctx, IObjectValue receivingInfo, int state) throws BOSException, EASBizException {
        this.addReverseLog(ctx, receivingInfo);
        this._saveReceiving(ctx, receivingInfo, state);
    }

    private void addReverseLog(Context ctx, IObjectValue model) throws EASBizException {
        String billId = model.get("id").toString();
        if (StringUtils.isBlank((CharSequence)billId)) {
            throw new BillException(BillException.IDNULL);
        }
        String billNumber = (String)model.get("number");
        if (StringUtils.isBlank((CharSequence)billNumber)) {
            throw new BillException(BillException.NUMBERNULL);
        }
        String srcBillId = model.get("sourceBillId") == null ? null : (String)model.get("sourceBillId");
        try {
            ReverseLogInfo info = new ReverseLogInfo();
            info.setBillId(billId);
            info.setBillNumber(billNumber);
            info.setBillDate((Date)model.get("bizDate"));
            info.setBillAmount((BigDecimal)model.get("amount"));
            info.setSrcBillId(srcBillId);
            ReverseLogFactory.getLocalInstance(ctx).addnew(info);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getGraduallyData(Context ctx, Map params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getSiblingData(Context ctx, Map params) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _saveContract(Context ctx, IObjectValue contractInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        ContractInfo tempInfo = (ContractInfo)contractInfo;
        String dataKey = tempInfo.getId().toString();
        String cNumber = tempInfo.getNumber();
        String oql = "where cNumber = '" + cNumber + "'";
        if (ContractPerformanceFactory.getLocalInstance(ctx).exists(oql)) {
            ContractPerformanceInfo info = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo(oql);
            info.setCFixAmount(tempInfo.getFixAmount());
            info.setCUnpaidAmount(tempInfo.getFixAmount());
            info.setCEstimateAmount(tempInfo.getComputeAmount());
            info.setCUnpaidAmount(tempInfo.getFixAmount().subtract(null == info.getRbAmount() ? new BigDecimal(0) : info.getRbAmount()));
            pk = new ObjectUuidPK(info.getId());
            ContractPerformanceFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
        } else {
            ContractPerformanceInfo info = new ContractPerformanceInfo();
            info.setLevel(ConPerfLevelEnum.Contract);
            info.setDataDate(tempInfo.getStartDate());
            info.setLongNumber(cNumber);
            info.setDataKey(dataKey);
            info.setParentKey(null);
            info.setIsLeaf(true);
            info.setShareCenterId(tempInfo.getScOrg().getId().toString());
            info.setCNumber(cNumber);
            info.setCFixAmount(tempInfo.getFixAmount());
            info.setCEstimateAmount(tempInfo.getComputeAmount());
            info.setCUnpaidAmount(tempInfo.getFixAmount());
            pk = ContractPerformanceFactory.getLocalInstance(ctx).addnew(info);
        }
        return pk;
    }

    @Override
    protected IObjectPK _saveContractDetail(Context ctx, IObjectValue contractDetailInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _saveOther(Context ctx, IObjectValue otherInfo, int state) throws BOSException, EASBizException {
        IObjectPK pk = null;
        OtherBillInfo tempInfo = (OtherBillInfo)otherInfo;
        String parentId = "";
        OtherBillentryCollection colls = tempInfo.getEntry();
        if (null != colls && colls.size() > 0) {
            parentId = colls.get(0).getSourceBillId();
        }
        String dataKey = tempInfo.getId().toString();
        String obNumber = tempInfo.getNumber();
        BigDecimal amount = tempInfo.getAmount();
        String oql = "where obNumber = '" + obNumber + "'";
        if (!ContractPerformanceFactory.getLocalInstance(ctx).exists(oql)) {
            ContractPerformanceInfo parentInfo = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + parentId + "'");
            ContractPerformanceInfo info = new ContractPerformanceInfo();
            info.setLevel(ConPerfLevelEnum.Other);
            info.setDataDate(tempInfo.getBizDate());
            info.setDataKey(dataKey);
            info.setParentKey(parentId);
            info.setIsLeaf(true);
            info.setLongNumber(parentInfo.getLongNumber() + "!" + obNumber);
            info.setShareCenterId(parentInfo.getShareCenterId());
            info.setObState(DisposerActionEnum.getEnum((int)state));
            info.setObNumber(obNumber);
            pk = ContractPerformanceFactory.getLocalInstance(ctx).addnew(info);
        } else {
            ContractPerformanceInfo contractPerformanceInfo = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo(oql);
            contractPerformanceInfo.setObState(DisposerActionEnum.getEnum((int)state));
            ContractPerformanceFactory.getLocalInstance(ctx).save((CoreBaseInfo)contractPerformanceInfo);
        }
        this.recalculatedAmount(ctx, BillType.Other, dataKey, amount);
        return pk;
    }

    @Override
    protected IObjectPK _saveReceiving(Context ctx, IObjectValue receivingInfo, int state) throws BOSException, EASBizException {
        IObjectPK pk = null;
        ReceivingBillInfo tempInfo = (ReceivingBillInfo)receivingInfo;
        String rbNumber = tempInfo.getNumber();
        String parentId = "";
        ReceivingBillEntryCollection colls = tempInfo.getEntries();
        if (null != colls && colls.size() > 0) {
            parentId = colls.get(0).getSourceBillId();
        }
        String dataKey = tempInfo.getId().toString();
        BigDecimal amount = tempInfo.getAmount();
        String oql = "where rbNumber = '" + rbNumber + "'";
        if (!ContractPerformanceFactory.getLocalInstance(ctx).exists(oql)) {
            ContractPerformanceInfo parentInfo = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + parentId + "'");
            ContractPerformanceInfo info = new ContractPerformanceInfo();
            info.setLevel(ConPerfLevelEnum.Receiving);
            info.setDataDate(tempInfo.getBizDate());
            info.setDataKey(dataKey);
            info.setIsLeaf(true);
            info.setParentKey(parentId);
            info.setLongNumber(parentInfo.getLongNumber() + "!" + rbNumber);
            info.setShareCenterId(parentInfo.getShareCenterId());
            info.setRbState(com.kingdee.eas.fi.cas.DisposerActionEnum.getEnum((int)state));
            info.setRbNumber(rbNumber);
            pk = ContractPerformanceFactory.getLocalInstance(ctx).addnew(info);
        } else {
            ContractPerformanceInfo contractPerformanceInfo = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo(oql);
            contractPerformanceInfo.setRbState(com.kingdee.eas.fi.cas.DisposerActionEnum.getEnum((int)state));
            ContractPerformanceFactory.getLocalInstance(ctx).save((CoreBaseInfo)contractPerformanceInfo);
        }
        this.recalculatedAmount(ctx, BillType.Receiving, dataKey, amount);
        return pk;
    }

    @Override
    protected IObjectPK _saveSettlement(Context ctx, IObjectValue settlementInfo) throws BOSException, EASBizException {
        IObjectPK pk = null;
        SettlementBillInfo tempInfo = (SettlementBillInfo)settlementInfo;
        String sbNumber = tempInfo.getNumber();
        String parentId = "";
        String shareCenterId = ((FullOrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString();
        String cNumber = tempInfo.getContractNumber();
        if (null != tempInfo.getContract() && StringUtils.isNotBlank((CharSequence)tempInfo.getContract().getId().toString())) {
            parentId = tempInfo.getContract().getId().toString();
        } else {
            String oql = "where number = '" + cNumber + "' and scOrg.id = '" + shareCenterId + "'";
            if (ContractFactory.getLocalInstance(ctx).exists(oql)) {
                parentId = ContractFactory.getLocalInstance(ctx).getContractInfo(oql).getId().toString();
            }
        }
        String dataKey = tempInfo.getId().toString();
        BigDecimal amount = tempInfo.getTaxCheckedAmount();
        String oql = "where sbNumber = '" + sbNumber + "'";
        if (!ContractPerformanceFactory.getLocalInstance(ctx).exists(oql)) {
            ContractPerformanceInfo info = new ContractPerformanceInfo();
            info.setLevel(ConPerfLevelEnum.Settlement);
            info.setDataDate(tempInfo.getBizDate());
            info.setDataKey(dataKey);
            info.setIsLeaf(true);
            info.setShareCenterId(shareCenterId);
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                info.setParentKey(parentId);
                info.setLongNumber(cNumber + "!" + sbNumber);
            } else {
                info.setParentKey(null);
                info.setLongNumber(sbNumber);
            }
            info.setSbNumber(sbNumber);
            pk = ContractPerformanceFactory.getLocalInstance(ctx).addnew(info);
        }
        this.recalculatedAmount(ctx, BillType.Settlement, dataKey, amount);
        return pk;
    }

    private void recalculatedAmount(Context ctx, BillType billType, String dataKey, BigDecimal amount) {
        try {
            BigDecimal rbAmount = new BigDecimal(0);
            BigDecimal iAmount = new BigDecimal(0);
            switch (billType) {
                case Receiving: {
                    ContractPerformanceInfo contractBill;
                    ContractPerformanceInfo receiving = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + dataKey + "'");
                    rbAmount = receiving.getRbAmount() == null ? amount : receiving.getRbAmount().add(amount);
                    receiving.setRbAmount(rbAmount);
                    this.updateRecordPartial(ctx, receiving, "rbAmount");
                    dataKey = receiving.getParentKey();
                    ContractPerformanceInfo otherBill = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("select parentKey where dataKey='" + receiving.getParentKey() + "'");
                    ContractPerformanceInfo settlementBill = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("select where dataKey='" + otherBill.getParentKey() + "'");
                    settlementBill.setSbUnpaidAmount(settlementBill.getSbUnpaidAmount().subtract(amount));
                    this.updateRecordPartial(ctx, settlementBill, "sbUnpaidAmount");
                    if (StringUtils.isEmpty((CharSequence)settlementBill.getParentKey())) break;
                    contractBill.setIUnpaidAmount((contractBill = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("select where dataKey='" + settlementBill.getParentKey() + "'")).getIUnpaidAmount() == null ? amount.negate() : contractBill.getIUnpaidAmount().subtract(amount));
                    contractBill.setCUnpaidAmount(contractBill.getCUnpaidAmount() == null ? amount.negate() : contractBill.getCUnpaidAmount().subtract(amount));
                    this.updateRecordPartial(ctx, contractBill, "iUnpaidAmount", "cUnpaidAmount");
                    break;
                }
                case Invoke: {
                    if (billType != BillType.Invoke) break;
                    ContractPerformanceInfo otherBill_ = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + dataKey + "'");
                    otherBill_.setObUnpaidAmount(otherBill_.getObAmount().subtract(amount));
                    ContractPerformanceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(otherBill_.getId()), (CoreBaseInfo)otherBill_);
                    ContractPerformanceInfo settlementBill_ = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("select parentKey where dataKey = '" + otherBill_.getParentKey() + "'");
                    String contractDataKey = settlementBill_.getParentKey();
                    if (!StringUtils.isEmpty((CharSequence)settlementBill_.getParentKey())) {
                        ContractPerformanceInfo contractBill_;
                        contractBill_.setCPriceTax((contractBill_ = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + contractDataKey + "'")).getCPriceTax() == null ? amount : contractBill_.getCPriceTax().add(amount));
                        contractBill_.setIUnpaidAmount(contractBill_.getIUnpaidAmount() == null ? amount : contractBill_.getIUnpaidAmount().add(amount));
                        this.updateRecordPartial(ctx, contractBill_, "cPriceTax", "iUnpaidAmount");
                    }
                    break;
                }
                case Other: {
                    ContractPerformanceInfo other = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + dataKey + "'");
                    if ("Other".equals(billType.getName())) {
                        BigDecimal obAmount = other.getObAmount() == null ? amount : other.getObAmount().add(amount);
                        other.setObAmount(obAmount);
                        BigDecimal obUnpaidAmount = other.getObUnpaidAmount() == null ? amount : other.getObUnpaidAmount().add(amount);
                        other.setObUnpaidAmount(obUnpaidAmount);
                    }
                    ContractPerformanceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(other.getId()), (CoreBaseInfo)other);
                    dataKey = other.getParentKey();
                    break;
                }
                case Settlement: {
                    ContractPerformanceInfo settlement = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + dataKey + "'");
                    if ("Settlement".equals(billType.getName())) {
                        BigDecimal sbAmount = settlement.getSbAmount() == null ? amount : settlement.getSbAmount().add(amount);
                        settlement.setSbAmount(sbAmount);
                        BigDecimal sbUnpaidAmount = settlement.getSbUnpaidAmount() == null ? amount : settlement.getSbUnpaidAmount().add(amount);
                        settlement.setSbUnpaidAmount(sbUnpaidAmount);
                    }
                    ContractPerformanceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(settlement.getId()), (CoreBaseInfo)settlement);
                    dataKey = settlement.getParentKey();
                    break;
                }
                case Contract: {
                    ContractPerformanceInfo contract = ContractPerformanceFactory.getLocalInstance(ctx).getContractPerformanceInfo("where dataKey='" + dataKey + "'");
                    if ("Receiving".equals(billType.getName())) {
                        rbAmount = contract.getRbAmount() == null ? amount : contract.getRbAmount().add(amount);
                        contract.setRbAmount(rbAmount);
                        contract.setCUnpaidAmount(contract.getCUnpaidAmount().subtract(amount));
                        contract.setIUnpaidAmount(contract.getIUnpaidAmount().subtract(amount));
                    }
                    if ("Invoke".equals(billType.getName())) {
                        iAmount = contract.getIAmount() == null ? amount : contract.getIAmount().add(amount);
                        contract.setIAmount(iAmount);
                        contract.setIUnpaidAmount(contract.getIUnpaidAmount().add(amount));
                        contract.setIsLeaf(false);
                    }
                    if ("Other".equals(billType.getName())) {
                        BigDecimal obAmount = contract.getObAmount() == null ? amount : contract.getObAmount().add(amount);
                        contract.setObAmount(obAmount);
                    }
                    if ("Settlement".equals(billType.getName())) {
                        BigDecimal sbAmount = contract.getSbAmount() == null ? amount : contract.getSbAmount().add(amount);
                        contract.setSbAmount(sbAmount);
                        contract.setIsLeaf(false);
                    }
                    ContractPerformanceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(contract.getId()), (CoreBaseInfo)contract);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _reverseContractAmt(Context ctx, IObjectValue contractInfo) throws BOSException, EASBizException {
        contractInfo.put("amount", contractInfo.get("fixAmount"));
        this.addReverseLog(ctx, contractInfo);
        this._saveContract(ctx, contractInfo);
    }

    @Override
    protected void _reverseSettlementAmt(Context ctx, IObjectValue settlementInfo) throws BOSException, EASBizException {
        this.addReverseLog(ctx, settlementInfo);
        this._saveSettlement(ctx, settlementInfo);
    }

    @Override
    protected void _reverseContractDetailAmt(Context ctx, IObjectValue contractDetailInfo) throws BOSException, EASBizException {
        contractDetailInfo.put("amount", contractDetailInfo.get("fixAmount"));
        this.addReverseLog(ctx, contractDetailInfo);
        this._saveContractDetail(ctx, contractDetailInfo);
    }

    @Override
    protected void _reverseInvoiceAmt(Context ctx, IObjectValue invoiceInfo) throws BOSException, EASBizException {
        this.addReverseLog(ctx, invoiceInfo);
        this._saveInvoice(ctx, invoiceInfo);
    }

    @Override
    protected IObjectPK _saveInvoice(Context ctx, IObjectValue invoiceInfo) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String parentId = invoiceInfo.get("settlementBillId").toString();
        String dataKey = invoiceInfo.get("id").toString();
        String iNumber = invoiceInfo.get("invoiceNumber").toString();
        BigDecimal amount = new BigDecimal(invoiceInfo.get("priceTaxTotal").toString());
        String oql = "where iNumber = '" + iNumber + "'";
        SettlementBillInfo settlementBillInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo("where id='" + parentId + "'");
        settlementBillInfo.setINumbers(this.getTargetStr(iNumber, settlementBillInfo.getINumbers()));
        settlementBillInfo.setICodes(this.getTargetStr(invoiceInfo.get("invoiceNo").toString(), settlementBillInfo.getICodes()));
        settlementBillInfo.setInvoiceDate((Date)invoiceInfo.get("invoiceDate"));
        settlementBillInfo.setItaker((UserInfo)invoiceInfo.get("drawer"));
        settlementBillInfo.setItakerTel((String)invoiceInfo.get("recBillPhone"));
        settlementBillInfo.setItakerAddr((String)invoiceInfo.get("recBillAdress"));
        settlementBillInfo.setIpostalCode(this.getTargetStr((String)invoiceInfo.get("mailNumber"), settlementBillInfo.getIpostalCode()));
        FullOrgUnitCollection orgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name where id = '" + invoiceInfo.get("makeInvoiceOrgID") + "'");
        if (!orgUnitCollection.isEmpty()) {
            settlementBillInfo.setItakerOrg(orgUnitCollection.get(0).getName());
        }
        settlementBillInfo.setItakerMail((String)invoiceInfo.get("recBillEmail"));
        settlementBillInfo.setICourierNumber(this.getTargetStr((String)invoiceInfo.get("expressBillNum"), settlementBillInfo.getICourierNumber()));
        settlementBillInfo.setIPostDate((Date)invoiceInfo.get("mailDate"));
        BigDecimal iamount = settlementBillInfo.getIAmount() == null ? (BigDecimal)invoiceInfo.get("priceTaxTotal") : settlementBillInfo.getIAmount().add((BigDecimal)invoiceInfo.get("priceTaxTotal"));
        settlementBillInfo.setIAmount(iamount);
        SettlementBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)settlementBillInfo);
        String otherBillId = invoiceInfo.get("otherBillId").toString();
        this.recalculatedAmount(ctx, BillType.Invoke, otherBillId, amount);
        return pk;
    }

    private String getTargetStr(String newStr, String oldStr) {
        String detStr = "";
        if (StringUtils.isEmpty((CharSequence)oldStr)) {
            detStr = newStr;
        } else if (oldStr.contains(newStr)) {
            detStr.replace("," + newStr, "");
            detStr.replace(newStr, "");
        } else {
            detStr = oldStr + "," + newStr;
        }
        return detStr;
    }

    private void updateRecordPartial(Context ctx, ContractPerformanceInfo contractPerformanceInfo, String ... property) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        String lastUpdateTimePro = "lastUpdateTime";
        for (int i = 0; i < property.length; ++i) {
            if (lastUpdateTimePro.equals(property[i])) continue;
            selectorItemCollection.add(property[i]);
        }
        contractPerformanceInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        selectorItemCollection.add(lastUpdateTimePro);
        ContractPerformanceFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)contractPerformanceInfo, selectorItemCollection);
    }
}

