/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sscbusiness.contract.BillException;
import com.kingdee.eas.sscbusiness.contract.BillStateEnum;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceFacadeFactory;
import com.kingdee.eas.sscbusiness.contract.OperateException;
import com.kingdee.eas.sscbusiness.contract.SettlementBillFactory;
import com.kingdee.eas.sscbusiness.contract.SettlementBillInfo;
import com.kingdee.eas.sscbusiness.contract.app.AbstractSettlementBillFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SettlementBillFacadeControllerBean
extends AbstractSettlementBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sscbusiness.contract.app.SettlementBillFacadeControllerBean");

    @Override
    protected void _antiAudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (!this.inWorkflow(ctx, billId.toString())) {
            SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (!(BillStateEnum.APPROVED.equals((Object)info.getState()) || BillStateEnum.PASS.equals((Object)info.getState()) || BillStateEnum.UNPASS.equals((Object)info.getState()))) {
                throw new OperateException(OperateException.NOAUDITSTATEEXCEPTION, new Object[]{info.getNumber()});
            }
        } else {
            throw new OperateException(OperateException.CANTANTIAUDITEXCEPTION, new Object[]{""});
        }
        this.setDraftState(ctx, billId);
    }

    @Override
    protected void _abandon(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setAbandonState(ctx, billId);
        SettlementBillInfo settlementInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        settlementInfo.setTaxCheckedAmount(new BigDecimal(0).multiply(settlementInfo.getTaxCheckedAmount()));
        ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseSettlementAmt(settlementInfo);
    }

    @Override
    protected BOSUuid _genOtherBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.SAVE);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.SUBMIT);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.APPROVING);
        UserInfo user = new UserInfo();
        user.setId(auditorId);
        info.setAuditor(user);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.PASS);
        UserInfo user = new UserInfo();
        user.setId(auditorId);
        info.setAuditor(user);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.UNPASS);
        UserInfo user = new UserInfo();
        user.setId(auditorId);
        info.setAuditor(user);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setAbandonState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.DISCARD);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        info.setState(BillStateEnum.CLOSE);
        SettlementBillFactory.getLocalInstance(ctx).save((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
    }

    @Override
    protected void _batchAntiAudit(Context ctx, String billIds, String auditorId) throws BOSException, EASBizException {
        String[] billIdList;
        if (StringUtils.isBlank((CharSequence)billIds)) {
            throw new BillException(BillException.IDNULL);
        }
        if (!StringUtils.isBlank((CharSequence)auditorId) || null == ctx.getCaller()) {
            throw new BillException(BillException.IDNULL);
        }
        auditorId = ctx.getCaller().toString();
        for (String billId : billIdList = billIds.split(",")) {
            this.antiAudit(ctx, BOSUuid.read((String)billId));
        }
    }

    @Override
    protected void _batchAudit(Context ctx, String billIds, String auditorId) throws BOSException, EASBizException {
        String[] billIdList;
        if (StringUtils.isBlank((CharSequence)billIds)) {
            throw new BillException(BillException.IDNULL);
        }
        if (!StringUtils.isBlank((CharSequence)auditorId) || null == ctx.getCaller()) {
            throw new BillException(BillException.IDNULL);
        }
        auditorId = ctx.getCaller().toString();
        for (String billId : billIdList = billIds.split(",")) {
            this.audit(ctx, billId, auditorId);
        }
    }

    protected void audit(Context ctx, String billId, String auditorId) throws EASBizException, BOSException {
        if (!this.inWorkflow(ctx, billId)) {
            SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (!BillStateEnum.SUBMIT.equals((Object)info.getState())) {
                throw new OperateException(OperateException.NOSUBMITSTATEEXCEPTION, new Object[]{info.getNumber()});
            }
        } else {
            throw new OperateException(OperateException.CANTAUDITEXCEPTION);
        }
        this.setPassState(ctx, BOSUuid.read((String)billId), BOSUuid.read((String)auditorId));
    }

    @Override
    protected void _batchSubmit(Context ctx, String billIds, String auditorId) throws BOSException, EASBizException {
        String[] billIdList;
        if (StringUtils.isBlank((CharSequence)billIds)) {
            throw new BillException(BillException.IDNULL);
        }
        if (!StringUtils.isBlank((CharSequence)auditorId) || null == ctx.getCaller()) {
            throw new BillException(BillException.IDNULL);
        }
        auditorId = ctx.getCaller().toString();
        for (String billId : billIdList = billIds.split(",")) {
            this.submit(ctx, billId, auditorId);
        }
    }

    protected void submit(Context ctx, String billId, String auditorId) throws EASBizException, BOSException {
        SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
        if (!BillStateEnum.SAVE.equals((Object)info.getState())) {
            throw new OperateException(OperateException.NOSAVESTATEEXCEPTION);
        }
        this.setSubmitState(ctx, BOSUuid.read((String)billId));
        ContractPerformanceFacadeFactory.getLocalInstance(ctx).saveSettlement(info);
    }

    private boolean inWorkflow(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "SELECT top 1 FPROCINSTID  FROM t_wfr_procinstref where FREFID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        return rs.size() > 0;
    }
}

