/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.tool;

import com.kingdee.bos.util.BOSUuid;
import org.apache.commons.lang3.StringUtils;

public class ParamCheckUtil {
    public static void checkBOSUuid(String bosid, boolean trim) {
        if (StringUtils.isNotEmpty((CharSequence)bosid) && !BOSUuid.isValid((String)bosid, (boolean)trim)) {
            throw new IllegalArgumentException("id is not valid:" + bosid);
        }
    }

    public static void checkBOSUuid(String bosid) {
        ParamCheckUtil.checkBOSUuid(bosid, false);
    }

    public static void checkBOSUuids(String ... bosids) {
        for (int i = 0; i < bosids.length; ++i) {
            String bosid = bosids[i];
            if (StringUtils.isEmpty((CharSequence)bosid)) continue;
            if (bosid.indexOf(",") > 0) {
                String[] split = bosid.split(",");
                if (split.length <= 0 || !StringUtils.isNotEmpty((CharSequence)split[0])) continue;
                for (int j = 0; j < split.length; ++j) {
                    ParamCheckUtil.checkBOSUuid(split[j], false);
                }
                continue;
            }
            ParamCheckUtil.checkBOSUuid(bosid);
        }
    }

    public static void checkInteger(String integer) {
        if (StringUtils.isNotEmpty((CharSequence)integer)) {
            try {
                Integer.parseInt(integer);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("id is not valid:" + integer);
            }
        }
    }
}

