/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.im.AbstractMakeInvoiceInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.RedMsgTypeEnum;
import com.kingdee.eas.tm.im.basedata.OverLimitAmtSplitTypeEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Enumeration;

public class MakeInvoiceInfo
extends AbstractMakeInvoiceInfo
implements Serializable {
    private BigDecimal limitAmt;
    private OverLimitAmtSplitTypeEnum splitType = OverLimitAmtSplitTypeEnum.PriceExcludingTax;
    private boolean isSplit = false;
    private int limitSplitMethod = 0;
    private int goldenTaxControl = 0;
    private BigDecimal allowDiffMax = null;
    private BigDecimal diffFactor = null;
    private BigDecimal allowTotalDiffMax = null;
    private BigDecimal allowDiffAmtMax = null;
    private BigDecimal allowDiffMaxAvg = null;

    public MakeInvoiceInfo() {
    }

    protected MakeInvoiceInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        String retValue = "";
        if (this.getNumber() != null) {
            retValue = this.getNumber();
        }
        if (this.getRedVoiceNumber() != null) {
            retValue = retValue + "; " + this.getRedVoiceNumber();
        }
        return retValue;
    }

    public String getCurrentAccount() {
        CurrentAccountType currAcctType = this.getCurrentAccountType();
        if ("1".equals(currAcctType.getValue())) {
            return this.getCurrAcctCustomer() == null ? "null" : this.getCurrAcctCustomer().getId().toString();
        }
        if ("2".equals(currAcctType.getValue())) {
            return this.getCurrAcctSupplier() == null ? "null" : this.getCurrAcctSupplier().getId().toString();
        }
        return this.getCurrAcctCompany() == null ? "null" : this.getCurrAcctCompany().getId().toString();
    }

    public static SelectorItemCollection getMakeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("taxNumber"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isRedVoice"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("applicateDate"));
        sic.add(new SelectorItemInfo("applicant.name"));
        sic.add(new SelectorItemInfo("currentAccountType"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        sic.add(new SelectorItemInfo("company.registeredCode"));
        sic.add(new SelectorItemInfo("company.contactPhone"));
        sic.add(new SelectorItemInfo("company.taxAddress"));
        sic.add(new SelectorItemInfo("company.bank.name"));
        sic.add(new SelectorItemInfo("company.bankAccount"));
        sic.add(new SelectorItemInfo("receiveCompany"));
        sic.add(new SelectorItemInfo("address"));
        sic.add(new SelectorItemInfo("tel"));
        sic.add(new SelectorItemInfo("cellphone"));
        sic.add(new SelectorItemInfo("bankName"));
        sic.add(new SelectorItemInfo("bankAccount"));
        sic.add(new SelectorItemInfo("drawer.name"));
        sic.add(new SelectorItemInfo("drawertxt"));
        sic.add(new SelectorItemInfo("payee.name"));
        sic.add(new SelectorItemInfo("payeetxt"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("checker.name"));
        sic.add(new SelectorItemInfo("checker.*"));
        sic.add(new SelectorItemInfo("checktxt"));
        sic.add(new SelectorItemInfo("noTaxAmtTotal"));
        sic.add(new SelectorItemInfo("taxAmtTotal"));
        sic.add(new SelectorItemInfo("priceTaxTotal"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.entryName.taxData.name"));
        sic.add(new SelectorItemInfo("entries.entryName.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.specs"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.noTaxPrice"));
        sic.add(new SelectorItemInfo("entries.NoTaxAmt"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.priceTax"));
        sic.add(new SelectorItemInfo("entries.taxAmt"));
        sic.add(new SelectorItemInfo("entries.entryName.taxClassificationCode.*"));
        sic.add(new SelectorItemInfo("specificInformation.*"));
        sic.add(new SelectorItemInfo("specificInformation.entries.*"));
        return sic;
    }

    public static SelectorItemCollection getPrintSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPrint"));
        sic.add(new SelectorItemInfo("taxNumber"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    @Override
    public BigDecimal getNoTaxAmtTotal() {
        return super.getNoTaxAmtTotal() == null ? new BigDecimal(0) : super.getNoTaxAmtTotal();
    }

    public static MakeInvoiceInfo createMakeInvoiceInfo() {
        BOSUuid id = BOSUuid.create((String)"412A6F98");
        MakeInvoiceInfo makeInvoiceInfo = new MakeInvoiceInfo();
        makeInvoiceInfo.setId(id);
        return makeInvoiceInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id\uff1a" + this.getId()).append("_noTaxAmtTotal:" + this.getNoTaxAmtTotal()).append("_taxAmtTotal:" + this.getTaxAmtTotal()).append("_priceTaxTotal:" + this.getPriceTaxTotal()).append("_entry:" + (Object)((Object)this.getEntries())).append("_creator" + this.getCreator());
        return sb.toString();
    }

    public BigDecimal getLimitAmt() {
        return this.limitAmt;
    }

    public void setLimitAmt(BigDecimal limitAmt) {
        if (limitAmt == null || limitAmt.compareTo(BigDecimal.ZERO) == 0) {
            limitAmt = new BigDecimal("100000");
        }
        this.limitAmt = limitAmt.setScale(2, RoundingMode.DOWN);
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public int getLimitSplitMethod() {
        return this.limitSplitMethod;
    }

    public void setLimitSplitMethod(int limitSplitMethod) {
        this.limitSplitMethod = limitSplitMethod;
    }

    public int getGoldenTaxControl() {
        return this.goldenTaxControl;
    }

    public void setGoldenTaxControl(int goldenTaxControl) {
        this.goldenTaxControl = goldenTaxControl;
    }

    public BigDecimal getDiffFactor() {
        return this.diffFactor;
    }

    public BigDecimal getAllowDiffMax() {
        return this.allowDiffMax;
    }

    public void setAllowDiffMax(BigDecimal allowDiffMax) {
        if (allowDiffMax == null || BigDecimal.ZERO.compareTo(allowDiffMax) == 0) {
            allowDiffMax = new BigDecimal("0.06");
        }
        this.allowDiffMax = allowDiffMax.setScale(2, RoundingMode.DOWN);
    }

    public void setDiffFactor(BigDecimal diffFactor) {
        if (diffFactor == null || BigDecimal.ZERO.compareTo(diffFactor) == 0) {
            diffFactor = new BigDecimal("0.04");
        }
        this.diffFactor = diffFactor.setScale(2, RoundingMode.DOWN);
    }

    public BigDecimal getTotalDiffAmount(MakeInvoiceEntryInfo entry) {
        int goldenTaxControl = this.getGoldenTaxControl();
        BigDecimal priceTax = IMUtils.isNullToZero(entry.getPriceTax());
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal taxAmt = IMUtils.isNullToZero(entry.getTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal totalDiffAmount = noTaxAmt.multiply(taxRate).subtract(taxAmt);
        return totalDiffAmount;
    }

    public BigDecimal getTotalDiffAmount4PriceTax(MakeInvoiceEntryInfo entry) {
        BigDecimal priceTax = IMUtils.isNullToZero(entry.getPriceTax());
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal totalDiffAmount = priceTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).subtract(noTaxAmt);
        return totalDiffAmount;
    }

    public BigDecimal getDiffTotalDiffAmount(MakeInvoiceEntryInfo entry) {
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal deductAmt = IMUtils.isNullToZero(entry.getDeductAmt());
        BigDecimal taxAmt = IMUtils.isNullToZero(entry.getTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal totalDiffAmount = BigDecimal.ZERO;
        totalDiffAmount = this.goldenTaxControl == 0 ? noTaxAmt.subtract(deductAmt).multiply(taxRate).subtract(taxAmt) : noTaxAmt.subtract(deductAmt).multiply(taxRate).setScale(2, RoundingMode.HALF_UP).subtract(taxAmt);
        return totalDiffAmount;
    }

    public BigDecimal getDiffTotalDiffAmount4PriceTax(MakeInvoiceEntryInfo entry) {
        BigDecimal priceTax = IMUtils.isNullToZero(entry.getPriceTax());
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal deductAmt = IMUtils.isNullToZero(entry.getDeductAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal totalDiffAmount = priceTax.subtract(deductAmt).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).add(deductAmt).subtract(noTaxAmt);
        return totalDiffAmount;
    }

    public BigDecimal getDiffAvgAmount() {
        BigDecimal diffAvgAmount = BigDecimal.ZERO;
        if (this.getEntries().size() == 0) {
            return diffAvgAmount;
        }
        BigDecimal diffAmountTotal = BigDecimal.ZERO;
        MakeInvoiceEntryInfo entry = null;
        BigDecimal curDiffAmount = null;
        int size = this.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entry = this.getEntries().get(i);
            curDiffAmount = IMUtils.isNullToZero(entry.getNoTaxAmt()).multiply(IMUtils.isNullToZero(entry.getTaxRate())).subtract(IMUtils.isNullToZero(entry.getTaxAmt()));
            diffAmountTotal = diffAmountTotal.add(curDiffAmount);
        }
        diffAmountTotal = diffAmountTotal.setScale(2, RoundingMode.HALF_UP);
        diffAvgAmount = this.getEntries().size() == 1 ? diffAmountTotal.abs().divide(new BigDecimal(this.getEntries().size()), 2, RoundingMode.HALF_UP) : diffAmountTotal.abs().divide(new BigDecimal(this.getEntries().size()), 10, RoundingMode.HALF_UP);
        return diffAvgAmount;
    }

    public String getBizOrgPropertyName() {
        return "company";
    }

    public Object clone() {
        MakeInvoiceInfo invoice = new MakeInvoiceInfo();
        this.cloneWithProperty(invoice);
        String key = null;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (this.getEntryName().equals(key)) continue;
            invoice.put(key, this.get(key));
        }
        MakeInvoiceEntryCollection newEntries = new MakeInvoiceEntryCollection();
        MakeInvoiceEntryCollection entries = this.getEntries();
        MakeInvoiceEntryInfo entryInfo = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entries.get(i);
            newEntries.add((MakeInvoiceEntryInfo)entryInfo.clone());
        }
        invoice.put(this.getEntryName(), (Object)newEntries);
        return invoice;
    }

    public Object cloneHead() {
        MakeInvoiceInfo invoice = new MakeInvoiceInfo();
        this.cloneWithProperty(invoice);
        String key = null;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (this.getEntryName().equals(key)) continue;
            invoice.put(key, this.get(key));
        }
        invoice.put(this.getEntryName(), (Object)new MakeInvoiceEntryCollection());
        return invoice;
    }

    public void cloneWithProperty(MakeInvoiceInfo invoice) {
        invoice.setAllowDiffAmtMax(this.getAllowDiffAmtMax());
        invoice.setAllowTotalDiffMax(this.getAllowTotalDiffMax());
        invoice.setLimitAmt(this.getLimitAmt());
        invoice.setLimitSplitMethod(this.getLimitSplitMethod());
        invoice.setGoldenTaxControl(this.getGoldenTaxControl());
        invoice.setAllowDiffMax(this.getAllowDiffMax());
        invoice.setDiffFactor(this.getDiffFactor());
        invoice.setSplit(this.isSplit());
        invoice.setSplitType(this.getSplitType());
        invoice.setAllowDiffMaxAvg(this.getAllowDiffMaxAvg());
    }

    public String getEntryName() {
        return "entries";
    }

    @Override
    public void setRedMsgType(RedMsgTypeEnum item) {
        if (item != null) {
            this.setString("redMsgType", item.getValue());
        } else {
            this.setString("redMsgType", null);
        }
    }

    public BigDecimal getAllowTotalDiffMax() {
        return this.allowTotalDiffMax;
    }

    public void setAllowTotalDiffMax(BigDecimal allowTotalDiffMax) {
        this.allowTotalDiffMax = allowTotalDiffMax;
    }

    public BigDecimal getAllowDiffAmtMax() {
        return this.allowDiffAmtMax;
    }

    public void setAllowDiffAmtMax(BigDecimal allowDiffAmtMax) {
        this.allowDiffAmtMax = allowDiffAmtMax;
    }

    public BigDecimal getTotalDiffer() {
        if (this.getEntries().size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal currentDiffer = BigDecimal.ZERO;
        boolean isMultiRate = this.isMultiRate();
        int goldenTaxControl = this.getGoldenTaxControl();
        int size = this.getEntries().size();
        for (int i = 0; i < size; ++i) {
            currentDiffer = currentDiffer.add(this.getEntries().get(i).getEntryDiffer(goldenTaxControl, isMultiRate));
        }
        return currentDiffer.setScale(2, 4);
    }

    public BigDecimal getTotalDiffAmt() {
        if (this.getEntries().size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal currentDiffer = BigDecimal.ZERO;
        int size = this.getEntries().size();
        for (int i = 0; i < size; ++i) {
            currentDiffer = currentDiffer.add(this.getEntries().get(i).getEntryDifferAmt());
        }
        return currentDiffer.setScale(2, 4);
    }

    public boolean isMultiRate() {
        boolean isMultiRate = false;
        if (this.getEntries().size() == 0) {
            return false;
        }
        MakeInvoiceEntryInfo entryInfo = null;
        BigDecimal firstTaxRate = IMUtils.isNullToZero(this.getEntries().get(0).getTaxRate());
        int size = this.getEntries().size();
        for (int i = 1; i < size; ++i) {
            entryInfo = this.getEntries().get(i);
            if (firstTaxRate.compareTo(IMUtils.isNullToZero(entryInfo.getTaxRate())) == 0) continue;
            isMultiRate = true;
        }
        return isMultiRate;
    }

    public void removeLastEntry() {
        if (this.getEntries().size() == 0) {
            return;
        }
        this.getEntries().removeObject(this.getEntries().size() - 1);
    }

    public OverLimitAmtSplitTypeEnum getSplitType() {
        return this.splitType;
    }

    public void setSplitType(OverLimitAmtSplitTypeEnum splitType) {
        this.splitType = splitType;
    }

    public BigDecimal getAllowDiffMaxAvg() {
        return this.allowDiffMaxAvg;
    }

    public void setAllowDiffMaxAvg(BigDecimal allowDiffMaxAvg) {
        if (allowDiffMaxAvg == null || BigDecimal.ZERO.compareTo(allowDiffMaxAvg) == 0) {
            allowDiffMaxAvg = new BigDecimal("0.01");
        }
        this.allowDiffMaxAvg = allowDiffMaxAvg;
    }

    public boolean isEASBizType() {
        return !IMKBizTypeEnum.IERP.equals((Object)this.getBizType());
    }

    public boolean isIERPBizType() {
        return IMKBizTypeEnum.IERP.equals((Object)this.getBizType());
    }

    public String getBOTPEditUI() {
        if (this.isIERPBizType()) {
            return "com.kingdee.eas.tm.imc.client.SIMMakeInvoiceEditUI";
        }
        return "com.kingdee.eas.tm.im.client.MakeInvoiceEditUI";
    }

    public String getBOTPListUI() {
        if (this.isIERPBizType()) {
            return "com.kingdee.eas.tm.imc.client.SIMMakeInvoiceListUI";
        }
        return "com.kingdee.eas.tm.im.client.MakeInvoiceListUI";
    }
}

