/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class NonCompliantInvoiceImport
extends IMBillImportBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.NonCompliantInvoiceImport");
    private NonCompliantInvoiceInfo nonCompliantInvoiceInfo = null;
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return NonCompliantInvoiceFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    protected BigDecimal getValue(Context ctx, String key, Object data) throws TaskExternalException {
        String valStr = data.toString().trim();
        DecimalFormat format = new DecimalFormat();
        try {
            Number val = format.parse(valStr);
            return new BigDecimal(val.toString());
        }
        catch (ParseException e) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
        }
    }

    private BigDecimal getBigDecimalValue(String colName, Object value, int precision, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                if (colName.equals("FTaxRate")) {
                    BigDecimal valueObject = null;
                    valueObject = value.toString().indexOf("%") > 0 ? new BigDecimal(value.toString().substring(0, value.toString().length() - 1)).divide(new BigDecimal(100)).setScale(precision) : new BigDecimal(value.toString());
                    if (valueObject.compareTo(new BigDecimal(1)) > 0 || valueObject.compareTo(new BigDecimal(0)) < 0) {
                        throw new TaskExternalException(IMUtils.getString(resClassName, "TaxRateRangeError", ctx.getLocale()));
                    }
                    return valueObject;
                }
                return new BigDecimal(value.toString()).setScale(precision);
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof TaskExternalException) {
                throw (TaskExternalException)e;
            }
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    private boolean getBooleanValue(String colName, Object value, Context ctx) throws TaskExternalException {
        try {
            if (value != null && !value.equals("")) {
                return value.equals("\u662f") || value.equals("1") || value.equals("true");
            }
            return false;
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "ColumnFormatError", ctx.getLocale(), new Object[]{colName}));
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FCompany_name", (Object)rs.getString("company.name"));
            DataImportTools.putToHashtable(result, (Object)"FBizDate", (Object)rs.getString("bizDate"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceType", (Object)TMInvoiceType.getEnum((String)rs.getString("invoiceType")));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceCode", (Object)rs.getString("invoiceCode"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceNo", (Object)rs.getString("invoiceNo"));
            DataImportTools.putToHashtable(result, (Object)"FElectronicTicketNum", (Object)rs.getString("electronicTicketNum"));
            DataImportTools.putToHashtable(result, (Object)"FPrintNum", (Object)rs.getString("printNum"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceDate", (Object)rs.getString("invoiceDate"));
            DataImportTools.putToHashtable(result, (Object)"FAmount", (Object)rs.getBigDecimal("amount"));
            DataImportTools.putToHashtable(result, (Object)"FTax", (Object)rs.getBigDecimal("tax"));
            DataImportTools.putToHashtable(result, (Object)"FAmountTax", (Object)rs.getBigDecimal("amountTax"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceState", (Object)TMInvoiceStatus.getEnum((String)rs.getString("invoiceState")));
            DataImportTools.putToHashtable(result, (Object)"FSalerName", (Object)rs.getString("salerName"));
            DataImportTools.putToHashtable(result, (Object)"FSalerTaxNo", (Object)rs.getString("salerTaxNo"));
            DataImportTools.putToHashtable(result, (Object)"FBizBillType_name", (Object)rs.getString("bizBillType.name"));
            DataImportTools.putToHashtable(result, (Object)"FBizBillNumber", (Object)rs.getString("bizBillNumber"));
            DataImportTools.putToHashtable(result, (Object)"FEntry$nonCompliantType_name", (Object)rs.getString("nonCompliantType.name"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_nonCompliantState", (Object)NonCompliantStateEnum.getEnum((String)rs.getString("entry.nonCompliantState")));
            DataImportTools.putToHashtable(result, (Object)"FEntry$handler", (Object)rs.getString("handler.name"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_handlingTime", (Object)this.dealDateFormatString(rs.getString("entry.handlingTime")));
            DataImportTools.putToHashtable(result, (Object)"FEntry_handlingSuggest", (Object)rs.getString("entry.handlingSuggest"));
            DataImportTools.putToHashtable(result, (Object)"FEntry_checkTime", (Object)this.dealDateFormatString(rs.getString("entry.checkTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterStr;
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.getContextMap().get("filterItems") != null) {
            filterStr = this.getContextMap().get("filterItems").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return filter;
    }

    private String dealDateFormatString(String timestamp) throws BOSException {
        String dateFormat = "";
        try {
            if (!IMUtils.isEmpty(timestamp)) {
                Timestamp time = Timestamp.valueOf(timestamp);
                Date date = new Date(time.getTime());
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat = format.format(date);
            }
        }
        catch (Exception e) {
            throw new BOSException("date format error!");
        }
        return dateFormat;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.NonCompliantInvoiceQuery";
    }
}

