/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import com.kingdee.eas.tm.im.VehicleInvoiceReqInfo;
import com.kingdee.eas.tm.im.app.IBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginService;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBuildInvoiceReq
implements IBuildInvoiceReq {
    protected MakeInvoiceParam params = null;
    protected Context ctx = null;
    private String[] ids = null;
    private String[] entryIds = null;
    private Map ruleIDs = null;
    private Map<String, IObjectValue> combinBill = new HashMap<String, IObjectValue>();
    private InvoiceReqInfo req = new InvoiceReqInfo();
    protected Map<String, Boolean> isNeedCalMap = new HashMap<String, Boolean>();
    protected Map<String, Boolean> isSplitMap = new HashMap<String, Boolean>();
    private ArrayList orderBiz = new ArrayList();
    protected Map errorMsgMap = new HashMap();
    protected Map errorMsgEntryMap = new HashMap();
    protected int combinePricePrecision = 10;

    @Override
    public InvoiceReqInfo getInvoiceReqInfo() throws BOSException, EASBizException {
        this.initParam();
        this.beforeCheckMakeInvoice();
        this.combinBizBillByRule((String)this.ruleIDs.get("srcRuleID"));
        this.splitBizBillByRule((String)this.ruleIDs.get("srcRuleID"));
        this.removeErrorGroupBill();
        this.removeDiffTaxErrorGroupBill();
        if (this.combinBill.isEmpty()) {
            return null;
        }
        this.doEntryDiscount();
        this.orderBizBills();
        this.beforeSetBills();
        this.overrideSetBills();
        this.afterSetBills();
        return this.req;
    }

    private void orderBizBills() {
        Map billMap = this.getCombinBillMap();
        for (int i = 0; i < this.ids.length; ++i) {
            String id = this.ids[i];
            if (billMap.get(id) == null) continue;
            IObjectValue bill = (IObjectValue)billMap.get(id);
            this.orderBiz.add(billMap.get(id));
            IObjectCollection splitBillColl = (IObjectCollection)bill.get("splitBillColl");
            if (splitBillColl == null || splitBillColl.size() <= 0) continue;
            for (int j = 0; j < splitBillColl.size(); ++j) {
                this.orderBiz.add(splitBillColl.getObject(j));
            }
        }
    }

    private Map getCombinBillMap() {
        HashMap<String, IObjectValue> billMap = new HashMap<String, IObjectValue>();
        Iterator<String> iterator = this.combinBill.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            IObjectValue bill = this.combinBill.get(key);
            billMap.put(bill.get("id").toString(), bill);
        }
        return billMap;
    }

    private void beforeSetBills() throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforeSetBills(this.ctx, this.req, this.combinBill);
    }

    protected void setBills(InvoiceReqInfo req, Map<String, IObjectValue> combinBill) throws EASBizException, BOSException {
    }

    protected BillReqInfo getBillReqInfo(IObjectValue otherBill) throws EASBizException, BOSException {
        return null;
    }

    protected BillEntryReqInfo getBillEntryReqInfo(IObjectValue otherBillEntry) throws EASBizException, BOSException {
        return null;
    }

    private void overrideSetBills() throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetBills(this.ctx, this.req, this.combinBill)) {
            this.setBills(this.req, this.combinBill);
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("saleOrg.*"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.expenseItem.*"));
        sic.add(new SelectorItemInfo("entry.measureUnit.*"));
        return sic;
    }

    private void afterSetBills() throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterSetBills(this.ctx, this.req, this.combinBill);
    }

    protected void doEntryDiscount() throws EASBizException, BOSException {
    }

    protected void doEntryDiscount(IObjectValue obj) throws EASBizException, BOSException {
    }

    public abstract String buildErrorBillMsg() throws BOSException;

    protected ArrayList getFailBills() {
        ArrayList<String> failBills = new ArrayList<String>();
        Iterator iterator = this.errorMsgMap.keySet().iterator();
        while (iterator.hasNext()) {
            String billid = iterator.next().toString();
            failBills.add(billid);
        }
        return failBills;
    }

    protected void initParam() throws BOSException, EASBizException {
        this.req.setInvoiceType(this.params.getInvoiceType());
        this.ids = this.params.getBilBillIds().split(",");
        if (!StringUtils.isEmpty((String)this.params.getBillBillEntryIds())) {
            this.entryIds = this.params.getBillBillEntryIds().split(",");
        }
        this.ruleIDs = this.params.getRuleIDs();
        this.setInvoiceReqHeader();
        String combinePricePrecisionStr = IMFacadeFactory.getLocalInstance(this.ctx).getParamByKey("combinePricePrecision");
        if (!StringUtils.isEmpty((String)combinePricePrecisionStr)) {
            this.combinePricePrecision = Integer.parseInt(combinePricePrecisionStr);
        }
        this.req.setOtherParams(this.params.getOtherParams());
    }

    private void setInvoiceReqHeader() {
        this.req.setSn(BOSUuid.create((String)"88888888").toString());
        this.req.setSrcSystem(this.params.getSrcSystem());
        this.req.setPrint(this.params.isPrint());
        this.req.setReq(this.params.isReq());
        this.req.setBosType(this.params.getSrcBosType());
        this.req.setDestCombinRuleID((String)this.params.getRuleIDs().get("destRuleID"));
        this.req.setSrcCombinRuleID((String)this.params.getRuleIDs().get("srcRuleID"));
        InvoicePluginService pluginService = new InvoicePluginService(this.ctx, this.req);
        this.req.setPluginService(pluginService);
    }

    public void beforeCheckMakeInvoice() throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)this.params.getBilBillIds())) {
            this.errorMsgMap.put("errorMsg", IMUtils.getIMResource(this.ctx, "BILL_IS_NULL", new String[0]));
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < this.ids.length; ++i) {
            idSet.add(this.ids[i]);
        }
        this.checkBillStatus(this.ctx, idSet);
        this.checkHasMakeInvoice(this.ctx, idSet);
    }

    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
    }

    protected void splitBizBillByRule(String ruleID) throws BOSException, EASBizException {
    }

    protected void checkBillStatus(Context ctx, Set<String> idSet) throws BOSException {
    }

    protected void checkHasMakeInvoice(Context ctx, Set<String> idSet) throws BOSException {
        String id;
        if (idSet.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select t1.fbizbillid as fbizbillid,t2.FStatus as FStatus from t_im_makeinvoicerelation t1 ");
        sb.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
        sb.append(" inner join " + this.getSrcTable() + " src on t1.fbizbillid = src.fid");
        sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
        sb.append(" and (");
        sb.append(" src.FInvoicedAmt <> 0");
        sb.append(" or  ");
        sb.append(" t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus in ('1','2','3') ) ");
        sb.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                id = rs.getString("fbizbillid");
                String status = rs.getString("FStatus");
                if ("4".equals(status)) {
                    this.errorMsgMap.put(id, IMUtils.getIMResource(ctx, "SOMEBILL_HAVE_INVOICE", new String[0]));
                    continue;
                }
                this.errorMsgMap.put(id, IMUtils.getIMResource(ctx, "SOMEBILL_HAVE_INVOICENOTMAKE", new String[0]));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        sb.setLength(0);
        sb.append(" select t1.fbizbillid as fbizbillid,sum(t2.fpriceTaxTotal) as fpriceTaxTotal from t_im_makeinvoicerelation t1 ");
        sb.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
        sb.append(" inner join " + this.getSrcTable() + " src on t1.fbizbillid = src.fid");
        sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
        sb.append(" and ");
        sb.append(" t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus  not in ('99')) ");
        sb.append(" group by t1.fbizbillid");
        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                id = rs.getString("fbizbillid");
                BigDecimal fpriceTaxTotal = rs.getBigDecimal("fpriceTaxTotal");
                if (BigDecimal.ZERO.compareTo(fpriceTaxTotal) == 0 || this.errorMsgMap.containsKey(id)) continue;
                this.errorMsgMap.put(id, IMUtils.getIMResource(ctx, "SOMEBILL_HAVE_INVOICENOTMAKE", new String[0]));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected String getSrcTable() {
        return null;
    }

    protected void removeErrorGroupBill() {
        Iterator<String> iterator = this.combinBill.keySet().iterator();
        String errorMsg = null;
        MessageFormat errFormat = new MessageFormat(IMUtils.getIMResource(this.ctx, "GROUP_ERROR_BILL", new String[0]));
        MessageFormat zeroErrFormat = new MessageFormat(IMUtils.getIMResource(this.ctx, "GROUP_ERROR_BILL_ZERO", new String[0]));
        MessageFormat qtyErrFormat = new MessageFormat(IMUtils.getIMResource(this.ctx, "GROUP_ERROR_QTY_ZERO", new String[0]));
        MessageFormat format = null;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> removeKey = new ArrayList<String>();
        boolean isClear = false;
        while (iterator.hasNext()) {
            int i;
            isClear = false;
            idList.clear();
            String key = iterator.next();
            IObjectValue info = this.combinBill.get(key);
            boolean isRedBill = this.isRedBill(info);
            boolean isSplitRedBill = false;
            if (!isRedBill) {
                IObjectCollection splitBillColl = (IObjectCollection)info.get("splitBillColl");
                IObjectValue splitInfo = null;
                if (splitBillColl != null && splitBillColl.size() > 0) {
                    for (int k = 0; k < splitBillColl.size() && !(isSplitRedBill = this.isRedBill(splitInfo = splitBillColl.getObject(k))); ++k) {
                    }
                }
            }
            if (isRedBill || isSplitRedBill) {
                isClear = true;
                format = zeroErrFormat;
            }
            boolean isQtyErrorBill = this.isQtyErrorBill(info);
            boolean isSplitQtyErrorBill = false;
            if (!isQtyErrorBill) {
                IObjectCollection splitBillColl = (IObjectCollection)info.get("splitBillColl");
                IObjectValue splitInfo = null;
                if (splitBillColl != null && splitBillColl.size() > 0) {
                    for (int k = 0; k < splitBillColl.size() && !(isSplitQtyErrorBill = this.isQtyErrorBill(splitInfo = splitBillColl.getObject(k))); ++k) {
                    }
                }
            }
            if (isQtyErrorBill || isSplitQtyErrorBill) {
                isClear = true;
                format = qtyErrFormat;
            }
            StringBuffer tempVal = new StringBuffer(info.getString("description"));
            IObjectCollection splitBillColl = (IObjectCollection)info.get("splitBillColl");
            IObjectValue splitInfo = null;
            if (splitBillColl != null && splitBillColl.size() > 0) {
                for (int k = 0; k < splitBillColl.size(); ++k) {
                    splitInfo = splitBillColl.getObject(k);
                    tempVal.append("_" + splitInfo.getString("description"));
                }
            }
            String[] ids = tempVal.toString().split("_");
            for (i = 0; i < ids.length; ++i) {
                String id = ids[i];
                if (!idList.contains(id)) {
                    idList.add(id);
                }
                if (!this.errorMsgMap.containsKey(id)) continue;
                isClear = true;
                format = errFormat;
            }
            if (!isClear) continue;
            errorMsg = format.format(new Object[0]);
            for (i = 0; i < idList.size(); ++i) {
                if (this.errorMsgMap.containsKey(idList.get(i))) continue;
                this.errorMsgMap.put(idList.get(i), errorMsg);
            }
            removeKey.add(key);
        }
        for (int i = 0; i < removeKey.size(); ++i) {
            this.combinBill.remove(removeKey.get(i));
        }
    }

    protected void removeDiffTaxErrorGroupBill() {
    }

    private boolean isRedBill(IObjectValue info) {
        BigDecimal totoalAmout;
        block3: {
            IObjectCollection colls;
            block2: {
                totoalAmout = BigDecimal.ZERO;
                colls = null;
                if (!(info instanceof OtherBillInfo)) break block2;
                colls = (IObjectCollection)info.get("entry");
                for (int i = 0; i < colls.size(); ++i) {
                    IObjectValue object = colls.getObject(i);
                    totoalAmout = totoalAmout.add(object.getBigDecimal("recievepayamount"));
                }
                break block3;
            }
            if (!(info instanceof TaxSeparationInfo) && !(info instanceof MakeInvoiceReqInfo) && !(info instanceof VehicleInvoiceReqInfo)) break block3;
            colls = (IObjectCollection)info.get("entries");
            for (int i = 0; i < colls.size(); ++i) {
                IObjectValue object = colls.getObject(i);
                totoalAmout = totoalAmout.add(object.getBigDecimal("priceIncludingTax"));
            }
        }
        return totoalAmout.compareTo(BigDecimal.ZERO) < 0;
    }

    private boolean isQtyErrorBill(IObjectValue info) {
        BigDecimal totoalQty;
        block4: {
            IObjectCollection colls;
            block5: {
                block3: {
                    totoalQty = BigDecimal.ZERO;
                    colls = null;
                    if (!(info instanceof OtherBillInfo)) break block3;
                    colls = (IObjectCollection)info.get("entry");
                    for (int i = 0; i < colls.size(); ++i) {
                        IObjectValue object = colls.getObject(i);
                        totoalQty = totoalQty.add(object.getBigDecimal("quantity"));
                    }
                    break block4;
                }
                if (!(info instanceof TaxSeparationInfo)) break block5;
                colls = (IObjectCollection)info.get("entries");
                for (int i = 0; i < colls.size(); ++i) {
                    IObjectValue object = colls.getObject(i);
                    totoalQty = totoalQty.add(object.getBigDecimal("quantity"));
                }
                break block4;
            }
            if (!(info instanceof MakeInvoiceReqInfo)) break block4;
            colls = (IObjectCollection)info.get("entries");
            for (int i = 0; i < colls.size(); ++i) {
                IObjectValue object = colls.getObject(i);
                totoalQty = totoalQty.add(object.getBigDecimal("qty"));
            }
        }
        return totoalQty.compareTo(BigDecimal.ZERO) < 0;
    }

    protected void buildCombinRule(String ruleID, ArrayList<String> headProp, ArrayList<String> entryProp) throws EASBizException, BOSException {
        if (ruleID == null || "".equals(ruleID)) {
            headProp.add("id");
            headProp.add("invoiceType");
            entryProp.add("id");
        } else {
            CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, ruleID);
            if (combinRule == null || combinRule.getCombinFields() == null) {
                headProp.add("id");
                headProp.add("invoiceType");
                entryProp.add("id");
            } else {
                String[] properties = combinRule.getCombinFields().split("_");
                for (int i = 0; i < properties.length; ++i) {
                    String value = properties[i];
                    String[] tempValue = value.split("\\.");
                    if (tempValue.length > 1) {
                        if (entryProp.contains(tempValue[1])) continue;
                        entryProp.add(tempValue[1]);
                        continue;
                    }
                    if (headProp.contains(value)) continue;
                    headProp.add(value);
                }
            }
        }
        if (headProp.isEmpty()) {
            headProp.add("id");
            headProp.add("invoiceType");
        }
        if (!headProp.contains("invoiceType")) {
            headProp.add("invoiceType");
        }
        if (entryProp.isEmpty()) {
            entryProp.add("id");
        }
    }

    protected ArrayList<String> buildSplitRule(String ruleID) throws EASBizException, BOSException {
        ArrayList<String> entryProp = new ArrayList<String>();
        if (ruleID == null || "".equals(ruleID)) {
            return entryProp;
        }
        CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.getCtx(), ruleID);
        if (combinRule.getSplitFields() == null) {
            return entryProp;
        }
        String[] properties = combinRule.getSplitFields().split("_");
        for (int i = 0; i < properties.length; ++i) {
            String value = properties[i];
            String[] tempValue = value.split("\\.");
            if (tempValue.length <= 1 || entryProp.contains(tempValue[1])) continue;
            entryProp.add(tempValue[1]);
        }
        return entryProp;
    }

    protected void clearEntrySrcId(IObjectCollection coll) {
    }

    public Map getErrorMsgMap() {
        return this.errorMsgMap;
    }

    public void setErrorMsgMap(Map errorMsgMap) {
        this.errorMsgMap = errorMsgMap;
    }

    public Map<String, IObjectValue> getCombinBill() {
        return this.combinBill;
    }

    public void setCombinBill(Map<String, IObjectValue> combinBill) {
        this.combinBill = combinBill;
    }

    public MakeInvoiceParam getParams() {
        return this.params;
    }

    public void setParams(MakeInvoiceParam params) {
        this.params = params;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public Map getRuleIDs() {
        return this.ruleIDs;
    }

    public void setRuleIDs(Map ruleIDs) {
        this.ruleIDs = ruleIDs;
    }

    public InvoiceReqInfo getReq() {
        return this.req;
    }

    public void setReq(InvoiceReqInfo req) {
        this.req = req;
    }

    public ArrayList getOrderBiz() {
        return this.orderBiz;
    }

    public void setOrderBiz(ArrayList orderBiz) {
        this.orderBiz = orderBiz;
    }

    public String[] getEntryIds() {
        return this.entryIds;
    }

    public void setEntryIds(String[] entryIds) {
        this.entryIds = entryIds;
    }

    public Map getErrorMsgEntryMap() {
        return this.errorMsgEntryMap;
    }

    public void setErrorMsgEntryMap(Map errorMsgEntryMap) {
        this.errorMsgEntryMap = errorMsgEntryMap;
    }

    public Map<String, Boolean> getIsNeedCalMap() {
        return this.isNeedCalMap;
    }

    public void setIsNeedCalMap(Map<String, Boolean> isNeedCalMap) {
        this.isNeedCalMap = isNeedCalMap;
    }

    public Map<String, Boolean> getIsSplitMap() {
        return this.isSplitMap;
    }

    public void setIsSplitMap(Map<String, Boolean> isSplitMap) {
        this.isSplitMap = isSplitMap;
    }
}

