/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.im.CombinRuleSettingCollection;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.ICombinRuleSetting;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.app.AbstractAutoMakeEleInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.md5.MD5;
import com.kingdee.eas.tm.im.util.EncryptUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoMakeEleInvoiceFacadeControllerBean
extends AbstractAutoMakeEleInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.AutoMakeEleInvoiceFacadeControllerBean");

    @Override
    protected void _makeEleInvoice(Context ctx, String sourceRule, String destRule, String company) throws BOSException, EASBizException {
        Map<String, String> requiredID = this.getRequiredID(ctx, company);
        if (requiredID.size() == 0) {
            return;
        }
        String destRuleId = this.getCombinRuleId(ctx, destRule);
        String sourceRuleId = this.getCombinRuleId(ctx, sourceRule);
        HashMap<String, String> ruleIDs = new HashMap<String, String>();
        ruleIDs.put("destRuleID", destRuleId);
        ruleIDs.put("srcRuleID", sourceRuleId);
        MakeInvoiceParam param = new MakeInvoiceParam();
        param.setInvoiceType("3");
        param.setPrint(false);
        param.setReq(false);
        param.setRuleIDs(ruleIDs);
        param.setSrcBosType("FC910EF3");
        param.setSrcSystem("FI_AR");
        StringBuffer paramID = new StringBuffer();
        for (String id : requiredID.keySet()) {
            paramID.append(id).append(",");
        }
        param.setBilBillIds(paramID.toString());
        Context newCtx = null;
        try {
            newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            newCtx.put((Object)"UserInfo", (Object)userInfo);
            newCtx.setUserName("user");
        }
        catch (CloneNotSupportedException e1) {
            throw new BOSException((Throwable)e1);
        }
        InvoiceRespInfo resp = IMInvoiceFacadeFactory.getLocalInstance(newCtx).makeInvoice(param);
        String errorMsg = resp.getErrorMsg();
        ArrayList mkBillIds = resp.getMkSucessBillIds();
        Map<String, ArrayList> relationMap = resp.getDestBillRelation();
        int failCount = 0;
        StringBuffer invokeErrorMsg = new StringBuffer();
        if (!mkBillIds.isEmpty()) {
            ArrayList list = IMInvoiceFacadeFactory.getLocalInstance(newCtx).buildPwyParam(mkBillIds, PwyServiceType.OPR_INV_RELECT_MAKE, TransSrcSystemEnum.easgui);
            for (int i = 0; i < list.size(); ++i) {
                Map resultMap = (Map)list.get(i);
                MakeInvoiceInfo mkBillInfo = (MakeInvoiceInfo)resultMap.get("info");
                String invoiceID = (String)resultMap.get("billId");
                PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
                IPwyService pwyService = PwyServiceHelper.getPwyService(newCtx, invokeParam);
                pwyService.invoke();
                if (pwyService.getInvokeParam().isSuccess()) continue;
                ++failCount;
                String arNumber = this.getArNumber(requiredID, relationMap.get(invoiceID));
                IMException imex = new IMException(IMException.AR_MAKE_ERROR, new Object[]{arNumber, mkBillInfo.getNumber(), pwyService.getInvokeParam().getDescription()});
                String msg = imex.getMessage();
                invokeErrorMsg.append(msg).append("\r\n");
            }
        }
        StringBuffer msg = new StringBuffer();
        int allArBill = requiredID.size();
        int failArBill = resp.getBizFailBills().size();
        int sucessArBill = allArBill - failArBill;
        int allMkBill = relationMap.size();
        int sucessMkBill = mkBillIds.size();
        int failMkBill = allMkBill - sucessMkBill;
        msg.append("\u5e94\u6536\u5355\u751f\u6210\u5f00\u7968\u5355\u6210\u529f" + sucessArBill + "\u5f20\uff0c\u5931\u8d25" + failArBill + "\u5f20\uff1b\r\n\u5f00\u7968\u5355\u5f00\u7968\u6210\u529f" + (sucessMkBill - failCount) + "\u5f20\uff0c\u5931\u8d25" + (failMkBill + failCount) + "\u5f20\uff0c\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\r\n");
        msg.append(errorMsg).append("\r\n");
        msg.append(invokeErrorMsg);
        this.sendMsg(newCtx, errorMsg, msg.toString());
    }

    private String getArNumber(Map<String, String> arBillNumber, ArrayList arBillsID) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arBillsID.size(); ++i) {
            String id = arBillsID.get(i).toString();
            sb.append(arBillNumber.get(id)).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private void sendMsg(Context ctx, String errorMsg, String msg) {
        boolean isSucessed = true;
        if (errorMsg.length() > 0) {
            isSucessed = false;
        }
        MessageInfo info = new MessageInfo();
        info.setUserID(ctx.getCaller().toString());
        info.setbizAction("");
        info.setOrgNumber("AutoMakeEleInvoice");
        info.setSendMsg(true);
        info.setSuccessed(isSucessed);
        info.setExecption(msg);
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
    }

    private String getAccountUrl(Context ctx, MakeInvoiceInfo mkBillInfo) throws EASBizException, BOSException {
        Map map;
        Map map2;
        boolean isTest = false;
        String paramValue = IMFacadeFactory.getLocalInstance(ctx).getParamByKey("makeEleDebug");
        if ("1".equals(paramValue)) {
            isTest = true;
        }
        String kdAccessToken = null;
        String params = this.getAccountUrlParams();
        String kdAccessTokenUrl = "http://api.kingdee.com/auth/user/access_token?" + params;
        String kdAccessTokenJson = HttpClientUtil.doGet((String)kdAccessTokenUrl);
        if (kdAccessTokenJson != null && 0 == ((Double)(map2 = (Map)Kson.getGson().fromJson(kdAccessTokenJson, HashMap.class)).get("errcode")).intValue()) {
            Map data = (Map)map2.get("data");
            kdAccessToken = (String)data.get("access_token");
        }
        if (kdAccessToken == null) {
            throw new BOSException(" KD AccessToken is null... ; url = " + kdAccessTokenUrl);
        }
        String kdAuthCode = null;
        String kdAuthCodeUrl = "http://api.kingdee.com/auth/user/auth_code?access_token=";
        String kdAuthCodeJson = HttpClientUtil.doGet((String)(kdAuthCodeUrl + kdAccessToken));
        if (kdAuthCodeJson != null && 0 == ((Double)(map = (Map)Kson.getGson().fromJson(kdAuthCodeJson, HashMap.class)).get("errcode")).intValue()) {
            Map data = (Map)map.get("data");
            kdAuthCode = (String)data.get("auth_code");
        }
        if (kdAuthCode == null) {
            throw new BOSException(" AuthCode is null...; url = " + kdAuthCodeUrl);
        }
        logger.error((Object)("\u91d1\u8776\u4e91AuthCode\u4e3a" + kdAuthCode));
        String pwyAccessCode = null;
        String timestamp = String.valueOf(new Date().getTime());
        String signature = MD5.md5crypt("v4567hfrt9Kqic3w75fgfh7kjk09aq67gg7n990cc00mm9" + kdAuthCode + timestamp);
        String url = "https://api.piaozone.com/base/oauth/tin/token";
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("client_id", "v4567hfrt9Kqic");
        reqMap.put("sign", signature);
        reqMap.put("auth_code", kdAuthCode);
        reqMap.put("frevenueNumber", mkBillInfo.getCompany().getTaxNumber());
        reqMap.put("timestamp", timestamp);
        if (isTest) {
            url = "https://api-dev.piaozone.com/base/oauth/tin/token";
        }
        logger.error((Object)("\u8c03\u7528\u63a5\u53e3\u4e3a" + url));
        String returnJson = HttpClientUtil.doPost((String)url, (String)Kson.getGson().toJson(reqMap));
        if (returnJson == null) {
            throw new BOSException("get pwyAccessCode is null, please check net..." + url);
        }
        Map returnMap = (Map)Kson.getGson().fromJson(returnJson, HashMap.class);
        pwyAccessCode = (String)returnMap.get("access_token");
        if (pwyAccessCode == null) {
            throw new IMException(IMException.ERRORMSG, new String[]{" PWY AccessCode is null...", url});
        }
        String mkUrl = "https://api.piaozone.com/bill/hx/invoice/add?access_token=" + pwyAccessCode;
        if (isTest) {
            mkUrl = "https://api-dev.piaozone.com/bill/hx/invoice/add?access_token=" + pwyAccessCode;
        }
        return mkUrl;
    }

    protected String getAccountUrlParams() {
        try {
            return EncryptUtil.decrypt("qkGJigApaw2IcwkE5fCqdVp5eINMWfU4LY738vaKhguwgnM6rNCrVNrVmbbMnXUGk/ouoaFls9AmAnqxtB6vmz3P1Qp9Cbq2BVXEbp8N0AaNgQhBZedCHzbFCqyUtrkP8fKDlXQR0TNceMAqO2Ayo65Jbm2eszW8Q7TriabhLXI=", "accountUrlParams");
        }
        catch (Exception e) {
            return "";
        }
    }

    protected Map<String, String> getRequiredID(Context ctx, String company) throws BOSException, EASBizException {
        HashSet<String> orgSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        if (company != null && !"".equals(company)) {
            sb.append("SELECT fid FROM t_org_company where FNUMBER  = '" + company + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    orgSet.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sb.setLength(0);
        Calendar cad = Calendar.getInstance();
        String str = cad.get(1) + "-" + (cad.get(2) + 1) + "-" + cad.get(5);
        sb.append(" select fid,fnumber from t_ar_otherbill where ");
        sb.append(" fbillstatus = 3 and fismakeinvoiced = 0 and famount > 0 ");
        sb.append(" and FInvoiceType = '2' ");
        sb.append(this.buildCustomerFilter());
        if (!orgSet.isEmpty()) {
            String orgStr = IMUtils.getInStringFromSet(orgSet);
            sb.append("  and FCOMPANYID  in ").append(orgStr);
        }
        sb.append(" and FPlanInvoiceDate  <= to_date('" + str + " 23:59:59')  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString("fid"), rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public String buildCustomerFilter() {
        return " and 1=1 ";
    }

    private String getCombinRuleId(Context ctx, String ruleName) throws BOSException, EASBizException {
        if (ruleName == null || "".equals(ruleName)) {
            return null;
        }
        ICombinRuleSetting facade = CombinRuleSettingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ruleName", (Object)ruleName));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selector);
        CombinRuleSettingCollection coll = facade.getCombinRuleSettingCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getId().toString();
        }
        return null;
    }

    public void afterMakeInvoice4Elec(Context ctx, String invoiceID, String pwyRetvalue) throws EASBizException, BOSException {
        try {
            JSONObject value = new JSONObject(pwyRetvalue);
            JSONObject invoiceJson = value.getJSONObject("data");
            String invoiceNo = invoiceJson.getString("invoicenum");
            String invoiceNum = invoiceJson.getString("invoicecode");
            String pdfurl = invoiceJson.getString("pdfurl");
            String sn = invoiceJson.getString("serialnum");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("invoiceNo", invoiceNo);
            param.put("invoiceNum", invoiceNum);
            param.put("pdfurl", pdfurl);
            param.put("sn", sn);
            MakeInvoiceFactory.getLocalInstance(ctx).make((IObjectPK)new ObjectUuidPK(invoiceID), param);
        }
        catch (JSONException e) {
            throw new BOSException(e.getMessage() + pwyRetvalue);
        }
    }

    private String dealNullString(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    protected void _makeInvoice(Context ctx, InvoiceReqInfo req, OtherBillInfo info) throws BOSException, EASBizException {
    }
}

