/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceAnalysicSrcBillEnum;
import com.kingdee.eas.tm.im.app.AbstractBalanceAnalysisReportFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BalanceAnalysisReportFacadeControllerBean
extends AbstractBalanceAnalysisReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.BalanceAnalysisReportFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        params.setString("tempTable", tempTable);
        this.insertBillData(ctx, params);
        this.insertFooterData(ctx, params);
        this.updateTempTableData(ctx, params);
        this.deleteZeroRecord(ctx, params);
        RptTableHeader header = this.createTableHeader(ctx, params);
        params.setObject("header", (Object)header);
        return params;
    }

    private RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBillID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FGroupID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyName");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FBillType");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FCustomerID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCustomerName");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FCOSTCENTERNAME");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBizDate");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FBillNumber");
        col.setWidth(170);
        header.addColumn(col);
        col = new RptTableColumn("FInvoiceNo");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FRelationType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FPriceTax");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        String company_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "Company", ctx.getLocale());
        String billType_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "BillType", ctx.getLocale());
        String customer_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "Customer", ctx.getLocale());
        String bizDate_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "BizDate", ctx.getLocale());
        String billNumber_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "BillNumber", ctx.getLocale());
        String invoiceNumber_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "InvoiceNumber", ctx.getLocale());
        String relationType_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "RelationType", ctx.getLocale());
        String amout_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "Amout", ctx.getLocale());
        String taxAmont_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "TaxAmont", ctx.getLocale());
        String totalAmount_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "TotalAmount", ctx.getLocale());
        header.setLabels((Object[][])new Object[][]{{"FID", "FBillID", "FGroupID", "FIndex", "FCompanyID", company_alias, billType_alias, "FCustomerID", customer_alias, "FCOSTCENTERNAME", bizDate_alias, billNumber_alias, invoiceNumber_alias, relationType_alias, amout_alias, taxAmont_alias, totalAmount_alias}, {"FID", "FBillID", "FGroupID", "FIndex", "FCompanyID", company_alias, billType_alias, "FCustomerID", customer_alias, "FCOSTCENTERNAME", bizDate_alias, billNumber_alias, invoiceNumber_alias, relationType_alias, amout_alias, taxAmont_alias, totalAmount_alias}}, true);
        return header;
    }

    private void insertBillData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tmpGroupIDTable = this.createGroupIDTempTable(ctx, params);
        this.insertOtherBillData(ctx, tmpGroupIDTable, params);
        this.insertReqBillData(ctx, tmpGroupIDTable, params);
    }

    private void insertOtherBillData(Context ctx, String tmpGroupIDTable, RptParams params) throws EASBizException, BOSException {
        MakeInvoiceAnalysicSrcBillEnum srcBillType = (MakeInvoiceAnalysicSrcBillEnum)((Object)params.getObject("srcBillType"));
        if (MakeInvoiceAnalysicSrcBillEnum.MAKEINVOICEREQ.equals((Object)srcBillType)) {
            return;
        }
        String tempTable = params.getString("tempTable");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append(" ").append(" (FID, FBillID, FGroupID, FOperateTime, FIndex, FCompanyID, FCompanyName, FBillType, ").append(" FCustomerID, FCustomerName, FBizDate, FBillNumber, FInvoiceNo, ").append(" FRelationType, FCostCenterName, FAmount, FTaxAmt, FPriceTax) ");
        String selectSQL = this.getSelectDataSQL4OtherBill(ctx, tmpGroupIDTable, params);
        String sql = insertSQL + selectSQL;
        logger.info((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u5e94\u6536\u5355\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
    }

    private void insertReqBillData(Context ctx, String tmpGroupIDTable, RptParams params) throws EASBizException, BOSException {
        MakeInvoiceAnalysicSrcBillEnum srcBillType = (MakeInvoiceAnalysicSrcBillEnum)((Object)params.getObject("srcBillType"));
        if (MakeInvoiceAnalysicSrcBillEnum.OTHERBILL.equals((Object)srcBillType)) {
            return;
        }
        String tempTable = params.getString("tempTable");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append(" ").append(" (FID, FBillID, FGroupID, FOperateTime, FIndex, FCompanyID, FCompanyName, FBillType, ").append(" FCustomerID, FCustomerName, FBizDate, FBillNumber, FInvoiceNo, ").append(" FRelationType, FCostCenterName, FAmount, FTaxAmt, FPriceTax) ");
        String selectSQL = this.getSelectDataSQL4ReqBill(ctx, tmpGroupIDTable, params);
        String sql = insertSQL + selectSQL;
        logger.info((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
    }

    private void insertFooterData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        String diffAmount_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "DiffAmount", ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable).append(" (FID, FBillType, FGroupID, FOperateTime, FAmount, FTaxAmt, FPriceTax, FIndex) ");
        sql.append(" select newbosid('66666666') as FID, '").append(diffAmount_alias).append("' as FBillType, FGroupID, FOperateTime, SUM(FAmount) as FAmount, ");
        sql.append(" SUM(FTaxAmt) as FTaxAmt, SUM(FPriceTax) as FPriceTax, '999999' as FIndex from ").append(tempTable);
        sql.append(" group by FGroupID, FOperateTime ");
        this.executeUpdate(ctx, sql.toString(), null);
    }

    private void updateTempTableData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        String updateSQL = "update " + tempTable + " set FAmount = -1*FAmount, FTaxAmt = -1*FTaxAmt, FPriceTax = -1*FPriceTax where FIndex = '111111' OR FIndex = '333333'";
        this.executeUpdate(ctx, updateSQL, null);
    }

    private String getSelectDataSQL4OtherBill(Context ctx, String tmpGroupIDTable, RptParams params) throws BOSException, EASBizException {
        String otherbill_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "OtherBill", ctx.getLocale());
        String makeinvoicebill_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "MakeInvoiceBill", ctx.getLocale());
        String simMakeInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "SIMMakeInvoice", ctx.getLocale());
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" select newbosid('55555555') as FID, FBillID, FGroupID, FOperateTime, FIndex, FCompanyID, FCompanyName, FBillType, FCustomerID, FCustomerName, FBizDate, ");
        selectSQL.append(" FBillNumber, FInvoiceNo, FRelationType, FCostCenterName, FAmount, FTaxAmt, FPriceTax from (");
        selectSQL.append(" select distinct to_char(obill.FID) as FBillID, relation.FGroupID as FGroupID, relation.FOperateTime as FOperateTime, '000000' as FIndex, ");
        selectSQL.append("  to_char(obill.FCompanyID) as FCompanyID, orgUnit.FName_l2 as FCompanyName, '").append(otherbill_alias).append("' as FBillType, ");
        selectSQL.append(" obill.FAsstActID as FCustomerID, obill.FAsstActName_L2 as FCustomerName, ");
        selectSQL.append(" obill.FBizDate as FBizDate, to_char(obill.FNumber) as FBillNumber,  to_char(obill.FInvoiceNo) as FInvoiceNo, ");
        selectSQL.append(" '' as FRelationType, to_char(costCenter.FName_l2) as FCostCenterName, obill.FTotalAmount as FAmount, obill.FTotalTax as FTaxAmt, ");
        selectSQL.append(" obill.FAmount as FPriceTax ");
        selectSQL.append(" from T_AR_OtherBill obill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on relation.FBizBillID = obill.FID ");
        selectSQL.append(" inner join T_IM_MakeInvoice mkbill on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join ").append(tmpGroupIDTable).append(" tmp on tmp.FGroupID = relation.FGroupID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit orgUnit on orgUnit.FID = obill.FCompanyID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit costCenter on costCenter.FID = obill.FCostCenterID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        selectSQL.append(" union all ");
        selectSQL.append(" select distinct to_char(mkbill.FID) as FBillID, relation.FGroupID as FGroupID, relation.FOperateTime as FOperateTime, '111111' as FIndex, ");
        selectSQL.append("  to_char(mkbill.FCompanyID) as FCompanyID, orgUnit.FName_l2 as FCompanyName, ");
        selectSQL.append(" case mkbill.FBizType when '2' then '").append(simMakeInvoice_alias).append("' ");
        selectSQL.append(" else '").append(makeinvoicebill_alias).append("' end ");
        selectSQL.append(" as FBillType, ");
        selectSQL.append(" '' as FCustomerID, ");
        selectSQL.append(" case mkbill.FCurrentAccountType when '1' then customer.FName_l2 when '2' then supplier.FName_l2 else curracctCompany.FName_l2 end as FCustomerName, ");
        selectSQL.append(" mkbill.FApplicateDate as FBizDate, to_char(mkbill.FNumber) as FBillNumber, to_char(mkbill.FInvoiceNo) as FInvoiceNo, ");
        selectSQL.append(" case mkbill.FSrcSystem when '1' then '").append(InvoiceSrcSystem.MANUAL.getAlias(ctx.getLocale())).append("' when '2' then '").append(InvoiceSrcSystem.SYSTEM.getAlias(ctx.getLocale())).append("' when '3' then '").append(InvoiceSrcSystem.EXCEL.getAlias(ctx.getLocale())).append("' when '4' then '").append(InvoiceSrcSystem.REDINVOICE.getAlias(ctx.getLocale())).append("' when '5' then '").append(InvoiceSrcSystem.DOWNLOAD.getAlias(ctx.getLocale())).append("' else '' end as FRelationType, ");
        selectSQL.append("'' as FCostCenterName, ");
        selectSQL.append(" -1*mkbill.FNoTaxAmtTotal as FAmount, -1*mkbill.FTaxAmtTotal as FTaxAmt, -1*mkbill.FPriceTaxTotal as FPriceTax ");
        selectSQL.append(" from T_IM_MakeInvoice mkbill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join T_AR_OtherBill obill on obill.FID = relation.FBizBillID ");
        selectSQL.append(" inner join ").append(tmpGroupIDTable).append(" tmp on tmp.FGroupID = relation.FGroupID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit orgUnit on orgUnit.FID = mkbill.FCompanyID ");
        selectSQL.append(" left outer join T_BD_Customer customer on customer.FID = mkbill.FCurrAcctCustomerID ");
        selectSQL.append(" left outer join T_BD_Supplier supplier on supplier.FID = mkbill.FCurrAcctSupplierID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit curracctCompany on curracctCompany.FID = mkbill.FCurrAcctCompanyID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        selectSQL.append(" ) tbl ").append("\n");
        logger.info((Object)("\u53d6\u6570SQL\uff1a" + selectSQL.toString()));
        return selectSQL.toString();
    }

    private String getSelectDataSQL4ReqBill(Context ctx, String tmpGroupIDTable, RptParams params) throws BOSException, EASBizException {
        MakeInvoiceAnalysicSrcBillEnum srcBillType = (MakeInvoiceAnalysicSrcBillEnum)((Object)params.getObject("srcBillType"));
        if (MakeInvoiceAnalysicSrcBillEnum.OTHERBILL.equals((Object)srcBillType)) {
            return null;
        }
        String reqbill_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "MakeInvoiceReqBill", ctx.getLocale());
        String makeinvoicebill_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "MakeInvoiceBill", ctx.getLocale());
        String simMakeInvoiceReq_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "SIMMakeInvoiceReq", ctx.getLocale());
        String simMakeInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource", "SIMMakeInvoice", ctx.getLocale());
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" select newbosid('55555555') as FID, FBillID, FGroupID, FOperateTime, FIndex, FCompanyID, FCompanyName, FBillType, FCustomerID, FCustomerName, FBizDate, ");
        selectSQL.append(" FBillNumber, FInvoiceNo, FRelationType, FCostCenterName, FAmount, FTaxAmt, FPriceTax from (");
        selectSQL.append(" select distinct to_char(reqBill.FID) as FBillID, relation.FGroupID as FGroupID, relation.FOperateTime as FOperateTime, '222222' as FIndex, ");
        selectSQL.append("  to_char(reqBill.FCompanyID) as FCompanyID, orgUnit.FName_l2 as FCompanyName, ");
        selectSQL.append(" case mkbill.FBizType when '2' then '").append(simMakeInvoiceReq_alias).append("' ");
        selectSQL.append(" else '").append(reqbill_alias).append("' end ");
        selectSQL.append(" as FBillType, ");
        selectSQL.append(" reqBill.FAsstActID as FCustomerID, reqBill.FAsstActName as FCustomerName, ");
        selectSQL.append(" reqBill.FBizDate as FBizDate, to_char(reqBill.FNumber) as FBillNumber,  to_char(SUBSTRING (reqBill.FInvoiceNo,0,4000)) as FInvoiceNo, ");
        selectSQL.append(" '' as FRelationType, '' as FCostCenterName, reqBill.FPriceExcludingTax as FAmount, reqBill.FTax as FTaxAmt, ");
        selectSQL.append(" reqBill.FPriceIncludingTax as FPriceTax ");
        selectSQL.append(" from T_IM_MakeInvoiceReq reqBill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on relation.FBizBillID = reqBill.FID ");
        selectSQL.append(" inner join T_IM_MakeInvoice mkbill on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join ").append(tmpGroupIDTable).append(" tmp on tmp.FGroupID = relation.FGroupID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit orgUnit on orgUnit.FID = reqBill.FCompanyID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        selectSQL.append(" union all ");
        selectSQL.append(" select distinct to_char(mkbill.FID) as FBillID, relation.FGroupID as FGroupID, relation.FOperateTime as FOperateTime, '333333' as FIndex, ");
        selectSQL.append("  to_char(mkbill.FCompanyID) as FCompanyID, orgUnit.FName_l2 as FCompanyName, ");
        selectSQL.append(" case mkbill.FBizType when '2' then '").append(simMakeInvoice_alias).append("' ");
        selectSQL.append(" else '").append(makeinvoicebill_alias).append("' end ");
        selectSQL.append(" as FBillType, ");
        selectSQL.append(" '' as FCustomerID, ");
        selectSQL.append(" case mkbill.FCurrentAccountType when '1' then customer.FName_l2 when '2' then supplier.FName_l2 else curracctCompany.FName_l2 end as FCustomerName, ");
        selectSQL.append(" mkbill.FApplicateDate as FBizDate, to_char(mkbill.FNumber) as FBillNumber, to_char(mkbill.FInvoiceNo) as FInvoiceNo, ");
        selectSQL.append(" case mkbill.FSrcSystem when '1' then '").append(InvoiceSrcSystem.MANUAL.getAlias(ctx.getLocale())).append("' when '2' then '").append(InvoiceSrcSystem.SYSTEM.getAlias(ctx.getLocale())).append("' when '3' then '").append(InvoiceSrcSystem.EXCEL.getAlias(ctx.getLocale())).append("' when '4' then '").append(InvoiceSrcSystem.REDINVOICE.getAlias(ctx.getLocale())).append("' when '5' then '").append(InvoiceSrcSystem.DOWNLOAD.getAlias(ctx.getLocale())).append("' else '' end as FRelationType, ");
        selectSQL.append("'' as FCostCenterName, ");
        selectSQL.append(" -1*mkbill.FNoTaxAmtTotal as FAmount, -1*mkbill.FTaxAmtTotal as FTaxAmt, -1*mkbill.FPriceTaxTotal as FPriceTax ");
        selectSQL.append(" from T_IM_MakeInvoice mkbill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join T_IM_MakeInvoiceReq reqBill on reqBill.FID = relation.FBizBillID ");
        selectSQL.append(" inner join ").append(tmpGroupIDTable).append(" tmp on tmp.FGroupID = relation.FGroupID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit orgUnit on orgUnit.FID = mkbill.FCompanyID ");
        selectSQL.append(" left outer join T_BD_Customer customer on customer.FID = mkbill.FCurrAcctCustomerID ");
        selectSQL.append(" left outer join T_BD_Supplier supplier on supplier.FID = mkbill.FCurrAcctSupplierID ");
        selectSQL.append(" left outer join T_ORG_BaseUnit curracctCompany on curracctCompany.FID = mkbill.FCurrAcctCompanyID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        selectSQL.append(" ) tbl ").append("\n");
        logger.info((Object)("\u53d6\u6570SQL\uff1a" + selectSQL.toString()));
        return selectSQL.toString();
    }

    private String createGroupIDTmpTable(Context ctx) throws BOSException {
        String createSQL = "Create Table TempReportTable(FGroupID nvarchar(500) not null);";
        String tempTable = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSQL);
        return tempTable;
    }

    private String createGroupIDTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reqBillInsertSql;
        String tmpGroupIDTable = this.createGroupIDTmpTable(ctx);
        SqlParams sqlParams = new SqlParams();
        String otherBillInsertSql = this.getGroupIDTempTable4OtherBill(ctx, params, sqlParams);
        if (!StringUtils.isEmpty((String)otherBillInsertSql)) {
            String finalSQL = "insert into " + tmpGroupIDTable + " (FGroupID) select tbl.FGroupID from(" + otherBillInsertSql + ") tbl";
            this.executeUpdate(ctx, finalSQL, sqlParams);
        }
        if (!StringUtils.isEmpty((String)(reqBillInsertSql = this.getGroupIDTempTable4ReqBill(ctx, params, sqlParams = new SqlParams())))) {
            String finalSQL = "insert into " + tmpGroupIDTable + " (FGroupID) select tbl.FGroupID from(" + reqBillInsertSql + ") tbl";
            this.executeUpdate(ctx, finalSQL, sqlParams);
        }
        return tmpGroupIDTable;
    }

    protected String getGroupIDTempTable4OtherBill(Context ctx, RptParams params, SqlParams sqlParams) {
        String dateTo;
        String customerToID;
        MakeInvoiceAnalysicSrcBillEnum srcBillType = (MakeInvoiceAnalysicSrcBillEnum)((Object)params.getObject("srcBillType"));
        if (MakeInvoiceAnalysicSrcBillEnum.MAKEINVOICEREQ.equals((Object)srcBillType)) {
            return null;
        }
        StringBuffer selectSQL = new StringBuffer();
        String companyIds = params.getString("companyIds");
        HashSet<String> customerSet = new HashSet<String>();
        String customerFromID = params.getString("customerFrom");
        if (customerFromID != null) {
            customerSet.add(customerFromID);
        }
        if ((customerToID = params.getString("customerTo")) != null) {
            customerSet.add(customerToID);
        }
        String billNumber = params.getString("billNumber");
        String invoiceNo = params.getString("invoiceNo");
        selectSQL.append(" select FGroupID, FCompanyID, FCustomerID, FBizDate, FBillNumber, FInvoiceNo from ( ");
        selectSQL.append(" select relation.FGroupID as FGroupID, to_char(obill.FCompanyID) as FCompanyID, to_char(obill.FAsstActID) as FCustomerID, ");
        selectSQL.append(" obill.FBizDate as FBizDate, to_char(obill.FNumber) as FBillNumber, '' as FInvoiceNo ");
        selectSQL.append(" from T_AR_OtherBill obill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on relation.FBizBillID = obill.FID ");
        selectSQL.append(" inner join T_IM_MakeInvoice mkbill on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        if (companyIds != null) {
            selectSQL.append(" and obill.FCompanyID in ").append(companyIds);
        }
        if (customerSet.size() > 0) {
            selectSQL.append(" and obill.FAsstActID in ").append(IMUtils.getInStringFromSet(customerSet));
        }
        if (billNumber != null && !"".equals(billNumber)) {
            selectSQL.append(" and obill.FNumber like ?");
            sqlParams.addString("%" + billNumber + "%");
        }
        if (invoiceNo != null && !"".equals(invoiceNo)) {
            selectSQL.append(" and obill.FInvoiceNo like ?");
            sqlParams.addString("%" + invoiceNo + "%");
        }
        if (!params.getBoolean("isShowNoInvoice")) {
            selectSQL.append(" and mkbill.FInvoiceNo is not null ");
        }
        selectSQL.append(" union all ");
        selectSQL.append(" select relation.FGroupID as FGroupID, to_char(mkbill.FCompanyID) as FCompanyID, ");
        selectSQL.append(" '' as FCustomerID, ");
        selectSQL.append(" mkbill.FApplicateDate as FBizDate, to_char(mkbill.FNumber) as FBillNumber, '' as FInvoiceNo ");
        selectSQL.append(" from T_IM_MakeInvoice mkbill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join T_AR_OtherBill obill on obill.FID = relation.FBizBillID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        if (companyIds != null) {
            selectSQL.append(" and mkbill.FCompanyID in ").append(companyIds);
        }
        if (customerSet.size() > 0) {
            selectSQL.append(" and mkbill.FCURRACCTCUSTOMERID in ").append(IMUtils.getInStringFromSet(customerSet));
        }
        if (billNumber != null && !"".equals(billNumber)) {
            selectSQL.append(" and mkbill.FNumber like ?");
            sqlParams.addString("%" + billNumber + "%");
        }
        if (invoiceNo != null && !"".equals(invoiceNo)) {
            selectSQL.append(" and mkbill.FInvoiceNo like ?");
            sqlParams.addString("%" + invoiceNo + "%");
        }
        if (!params.getBoolean("isShowNoInvoice")) {
            selectSQL.append(" and mkbill.FInvoiceNo is not null ");
        }
        selectSQL.append(" ) t ");
        selectSQL.append(" where 1 = 1 ");
        String dateFrom = params.getString("dateFrom");
        if (dateFrom != null && !"".equals(dateFrom)) {
            selectSQL.append(" and FBizDate >= to_date('").append(dateFrom).append("')");
        }
        if ((dateTo = params.getString("dateTo")) != null && !"".equals(dateTo)) {
            dateTo = dateTo + " 23:59:59";
            selectSQL.append(" and FBizDate <= to_date('").append(dateTo).append("')");
        }
        logger.info((Object)("\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u6240\u6709\u7684groupID\uff1a" + selectSQL.toString()));
        return selectSQL.toString();
    }

    protected String getGroupIDTempTable4ReqBill(Context ctx, RptParams params, SqlParams sqlParams) {
        String dateTo;
        String customerToID;
        MakeInvoiceAnalysicSrcBillEnum srcBillType = (MakeInvoiceAnalysicSrcBillEnum)((Object)params.getObject("srcBillType"));
        if (MakeInvoiceAnalysicSrcBillEnum.OTHERBILL.equals((Object)srcBillType)) {
            return null;
        }
        StringBuffer selectSQL = new StringBuffer();
        String companyIds = params.getString("companyIds");
        HashSet<String> customerSet = new HashSet<String>();
        String customerFromID = params.getString("customerFrom");
        if (customerFromID != null) {
            customerSet.add(customerFromID);
        }
        if ((customerToID = params.getString("customerTo")) != null) {
            customerSet.add(customerToID);
        }
        String billNumber = params.getString("billNumber");
        String invoiceNo = params.getString("invoiceNo");
        selectSQL.append(" select FGroupID, FCompanyID, FCustomerID, FBizDate, FBillNumber, FInvoiceNo from ( ");
        selectSQL.append(" select relation.FGroupID as FGroupID, to_char(reqBill.FCompanyID) as FCompanyID, to_char(reqBill.FAsstActID) as FCustomerID, ");
        selectSQL.append(" reqBill.FBizDate as FBizDate, to_char(reqBill.FNumber) as FBillNumber, '' as FInvoiceNo ");
        selectSQL.append(" from T_IM_MakeInvoiceReq reqBill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on relation.FBizBillID = reqBill.FID ");
        selectSQL.append(" inner join T_IM_MakeInvoice mkbill on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        if (companyIds != null) {
            selectSQL.append(" and reqBill.FCompanyID in ").append(companyIds);
        }
        if (customerSet.size() > 0) {
            selectSQL.append(" and reqBill.FAsstActID in ").append(IMUtils.getInStringFromSet(customerSet));
        }
        if (billNumber != null && !"".equals(billNumber)) {
            selectSQL.append(" and reqBill.FNumber like ?");
            sqlParams.addString("%" + billNumber + "%");
        }
        if (invoiceNo != null && !"".equals(invoiceNo)) {
            selectSQL.append(" and reqBill.FInvoiceNo like ?");
            sqlParams.addString("%" + invoiceNo + "%");
        }
        if (!params.getBoolean("isShowNoInvoice")) {
            selectSQL.append(" and mkbill.FInvoiceNo is not null ");
        }
        selectSQL.append(" union all ");
        selectSQL.append(" select relation.FGroupID as FGroupID, to_char(mkbill.FCompanyID) as FCompanyID, ");
        selectSQL.append(" '' as FCustomerID, ");
        selectSQL.append(" mkbill.FApplicateDate as FBizDate, to_char(mkbill.FNumber) as FBillNumber, '' as FInvoiceNo ");
        selectSQL.append(" from T_IM_MakeInvoice mkbill ");
        selectSQL.append(" inner join T_IM_MakeInvoiceRelation relation on mkbill.FID = relation.FInvoiceBillID ");
        selectSQL.append(" inner join T_IM_MakeInvoiceReq reqBill on reqBill.FID = relation.FBizBillID ");
        selectSQL.append(" where relation.FGroupID is not null ");
        if (companyIds != null) {
            selectSQL.append(" and mkbill.FCompanyID in ").append(companyIds);
        }
        if (customerSet.size() > 0) {
            selectSQL.append(" and mkbill.FCURRACCTCUSTOMERID in ").append(IMUtils.getInStringFromSet(customerSet));
        }
        if (billNumber != null && !"".equals(billNumber)) {
            selectSQL.append(" and mkbill.FNumber like ?");
            sqlParams.addString("%" + billNumber + "%");
        }
        if (invoiceNo != null && !"".equals(invoiceNo)) {
            selectSQL.append(" and mkbill.FInvoiceNo like ?");
            sqlParams.addString("%" + invoiceNo + "%");
        }
        if (!params.getBoolean("isShowNoInvoice")) {
            selectSQL.append(" and mkbill.FInvoiceNo is not null ");
        }
        selectSQL.append(" ) t ");
        selectSQL.append(" where 1 = 1 ");
        String dateFrom = params.getString("dateFrom");
        if (dateFrom != null && !"".equals(dateFrom)) {
            selectSQL.append(" and FBizDate >= to_date('").append(dateFrom).append("')");
        }
        if ((dateTo = params.getString("dateTo")) != null && !"".equals(dateTo)) {
            dateTo = dateTo + " 23:59:59";
            selectSQL.append(" and FBizDate <= to_date('").append(dateTo).append("')");
        }
        logger.info((Object)("\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u6240\u6709\u7684groupID\uff1a" + selectSQL.toString()));
        return selectSQL.toString();
    }

    private void deleteZeroRecord(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        boolean isShowZero = params.getBoolean("isShowZero");
        if (!isShowZero) {
            StringBuffer sb = new StringBuffer();
            sb.append(" delete from ").append(tempTable).append(" where fgroupid in (");
            sb.append(" select fgroupid from ").append(tempTable).append(" where famount = 0 and ftaxamt = 0 and fpricetax = 0 )");
            this.executeUpdate(ctx, sb.toString(), null);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptParams pp = new RptParams();
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        if (!UUTN.isTempTable((String)tempTable)) {
            return pp;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID, FBillID, FGroupID, FIndex, FCompanyID, FCompanyName, FBillType, ").append(" FCustomerID, FCustomerName, FCOSTCENTERNAME, to_char(FBizDate,'YYYY-MM-dd') as FBizDate, FBillNumber, FInvoiceNo, ").append(" FRelationType, FAmount, FTaxAmt, FPriceTax from ").append(tempTable).append(" order by FOperateTime desc, FGroupID asc, FIndex asc, FBillType asc, FBillNumber asc;");
        rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        pp.setObject("rowset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        sql.setLength(0);
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = Long.valueOf(countRs.getLong("totalCount")).intValue();
        }
        pp.setInt("totalCount", totalCount);
        return pp;
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FBillID varchar(80),");
        sql.append("FGroupID nvarchar(500),");
        sql.append("FOperateTime datetime,");
        sql.append("FIndex varchar(10) not null default '000000',");
        sql.append("FCompanyID nvarchar(80),");
        sql.append("FCompanyName nvarchar(80),");
        sql.append("FBillType nvarchar(80),");
        sql.append("FCustomerID nvarchar(80),");
        sql.append("FCustomerName nvarchar(255),");
        sql.append("FBizDate datetime,");
        sql.append("FBillNumber nvarchar(80),");
        sql.append("FInvoiceNo nvarchar(2000),");
        sql.append("FRelationType nvarchar(80),");
        sql.append("FCostCenterName nvarchar(100), ");
        sql.append("FAmount Decimal(28, 10) not null default 0,");
        sql.append("FTaxAmt Decimal(28, 10) not null default 0,");
        sql.append("FPriceTax Decimal(28, 10) not null default 0");
        sql.append(");");
        logger.info((Object)("\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }
}

