/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginUtil;
import com.kingdee.eas.tm.im.basedata.AbstractCustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BuildInvoiceReq4Ar
extends AbstractBuildInvoiceReq {
    public BuildInvoiceReq4Ar(Context ctx, MakeInvoiceParam params) {
        this.setParams(params);
        this.setCtx(ctx);
    }

    protected void checkBillStatus(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        CoreBaseCollection infos = OtherBillFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (infos.size() > 0) {
            for (int i = 0; i < infos.size(); ++i) {
                CoreBaseInfo info = infos.get(i);
                String id = info.get("id").toString();
                this.getErrorMsgMap().put(id, IMUtils.getIMResource(ctx, "SOMEBILL_NOT_AUDIT", new String[0]));
                idSet.remove(id);
            }
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo bizEv = new EntityViewInfo();
        FilterInfo bizBillFilter = new FilterInfo();
        bizBillFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        bizBillFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)1, CompareType.EQUALS));
        bizEv.setFilter(bizBillFilter);
        SelectorItemCollection bizSic = new SelectorItemCollection();
        bizSic.add(new SelectorItemInfo("id"));
        bizEv.setSelector(bizSic);
        infos = OtherBillFactory.getLocalInstance((Context)ctx).getCollection(bizEv);
        if (infos.size() > 0) {
            for (int i = 0; i < infos.size(); ++i) {
                CoreBaseInfo info = infos.get(i);
                String id = info.get("id").toString();
                this.getErrorMsgMap().put(id, IMUtils.getIMResource(ctx, "BIZ_OTHERBILL", new String[0]));
                idSet.remove(id);
            }
        }
        this.checkSourceBillHasMakeInvoiceReq(ctx, idSet);
        this.checkAutoMakeInvoiceType(ctx, idSet);
    }

    private void checkAutoMakeInvoiceType(Context ctx, Set idSet) throws BOSException {
        String billName = (String)this.ctx.get((Object)"billName");
        if (StringUtils.isEmpty((String)billName)) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceType"));
        viewInfo.setSelector(sic);
        OtherBillCollection infos = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection(viewInfo);
        String reqInvoiceType = this.getParams().getInvoiceType();
        if (infos.size() > 0) {
            for (int i = 0; i < infos.size(); ++i) {
                OtherBillInfo info = infos.get(i);
                if (!(!"0".equals(reqInvoiceType) && reqInvoiceType != null || info.getInvoiceType() != null && info.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    this.getErrorMsgMap().put(info.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"MAKEINVOICE_ERROR", (Locale)IMUtils.getLocale()));
                    idSet.remove(info.getId().toString());
                    continue;
                }
                if ("0".equals(reqInvoiceType) || reqInvoiceType == null || info.getInvoiceType() == null || info.getInvoiceType() == PayInvoiceTypeEnum.DEFAULTTYPE || info.getInvoiceType().getValue().equals(this.getInvoiceType(reqInvoiceType))) continue;
                this.getErrorMsgMap().put(info.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"INVOICETYPE_INVALID", (Locale)IMUtils.getLocale()));
                idSet.remove(info.getId().toString());
            }
        }
    }

    protected void checkSourceBillHasMakeInvoiceReq(Context ctx, Set<String> idSet) throws BOSException {
        if (idSet.isEmpty()) {
            return;
        }
        if (!this.checkIsField()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select ar.fid from t_ar_otherbill ar");
        sb.append(" inner join t_ar_otherbillEntry are on  ar.fid = are.FParentID");
        sb.append(" where ar.fid in").append(IMUtils.getInStringFromSet(idSet));
        sb.append(" and (are.FInvoiceReqBaseQty!=0 or are.FInvoiceReqAmountLocal!=0)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                this.errorMsgMap.put(id, IMUtils.getIMResource(ctx, "SOURCEBILL_HAVE_INVOICEREQ", new String[0]));
                idSet.remove(id);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private boolean checkIsField() throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_ar_otherbillEntry' AND KSQL_COL_NAME = 'FInvoiceReqBaseQty'");
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    @Override
    protected void doEntryDiscount() throws EASBizException, BOSException {
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            OtherBillInfo info = (OtherBillInfo)this.getCombinBill().get(key);
            this.doEntryDiscount((IObjectValue)info);
            OtherBillCollection splitBillColl = (OtherBillCollection)info.get("splitBillColl");
            if (splitBillColl == null || splitBillColl.size() <= 0) continue;
            for (int j = 0; j < splitBillColl.size(); ++j) {
                this.doEntryDiscount((IObjectValue)splitBillColl.get(j));
            }
        }
    }

    @Override
    protected void doEntryDiscount(IObjectValue obj) throws EASBizException, BOSException {
        BigDecimal BIGDECIMAL_ONEHUNDRED = new BigDecimal("100.0");
        OtherBillInfo info = (OtherBillInfo)obj;
        boolean isSplit = this.getIsSplitPram(info);
        info.setBoolean("KEY_IS_SPLIT", isSplit);
        if (!isSplit) {
            return;
        }
        OtherBillentryCollection entrys = info.getEntry();
        OtherBillentryCollection newEntrys = new OtherBillentryCollection();
        int entrySeq = 1;
        OtherBillentryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            entry.setSourceBillEntryId(null);
            entry.setSeq(entrySeq);
            ++entrySeq;
            if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) == 0) continue;
            BigDecimal oldNoTaxAmt = entry.getAmount();
            BigDecimal discountAmt = entry.getDiscountAmount();
            BigDecimal amt = entry.getRecievePayAmount();
            BigDecimal totalAmt = discountAmt.add(amt);
            entry.setRecievePayAmount(totalAmt);
            entry.setAmount(entry.getRecievePayAmount().divide(entry.getTaxRate().divide(BIGDECIMAL_ONEHUNDRED).add(BigDecimal.ONE), 2, 4));
            entry.setTaxAmount(entry.getRecievePayAmount().subtract(entry.getAmount()));
            if (BigDecimal.ZERO.compareTo(entry.getQuantity()) == 0) {
                entry.setTaxPrice(BigDecimal.ZERO);
                entry.setPrice(BigDecimal.ZERO);
            } else {
                String key = (String)entry.get("combinKey");
                if (entry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                    entry.setTaxPrice(entry.getRecievePayAmount().divide(entry.getQuantity(), this.combinePricePrecision, 4));
                    entry.setPrice(entry.getAmount().divide(entry.getQuantity(), this.combinePricePrecision, 4));
                }
            }
            OtherBillentryInfo newEntry = (OtherBillentryInfo)entry.clone();
            entry.setSourceBillEntryId(null);
            newEntry.setSourceBillEntryId(entry.getId().toString());
            newEntry.setId(BOSUuid.create((String)"BC91693F"));
            newEntry.setSeq(entrySeq);
            ++entrySeq;
            newEntry.setQuantity(BigDecimal.ZERO);
            newEntry.setTaxPrice(BigDecimal.ZERO);
            newEntry.setPrice(BigDecimal.ZERO);
            BigDecimal totalAmt2 = newEntry.getDiscountAmount().negate();
            newEntry.setRecievePayAmount(totalAmt2);
            newEntry.setAmount(oldNoTaxAmt.subtract(entry.getAmount()));
            newEntry.setTaxAmount(totalAmt2.subtract(newEntry.getAmount()));
            newEntrys.add(newEntry);
        }
        entrys.addCollection(newEntrys);
        entrys.sort("seq");
    }

    private String getInvoiceType(OtherBillInfo info, String reqInvoiceType) throws EASBizException {
        String billName = (String)this.ctx.get((Object)"billName");
        if (!StringUtils.isEmpty((String)billName) && ("0".equals(reqInvoiceType) || reqInvoiceType == null && info.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE && info.getInvoiceType() != null)) {
            return info.getInvoiceType().getValue();
        }
        return this.getInvoiceType(reqInvoiceType);
    }

    private String getInvoiceType(String reqInvoiceType) {
        PayInvoiceTypeEnum retValue = null;
        if ("1".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if ("2".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if ("3".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if ("4".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if ("5".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if ("6".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        }
        if (retValue == null) {
            return null;
        }
        return retValue.getValue();
    }

    protected void setBills(InvoiceReqInfo req, Map combinBill) throws EASBizException, BOSException {
        ArrayList billList = this.getOrderBiz();
        for (int i = 0; i < billList.size(); ++i) {
            OtherBillInfo info = (OtherBillInfo)billList.get(i);
            req.getBills().add(this.getBillReqInfo((IObjectValue)info));
        }
    }

    @Override
    protected BillReqInfo getBillReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        BillReqInfo billReq = new BillReqInfo();
        OtherBillInfo otherBill = (OtherBillInfo)objectValue;
        String descript = otherBill.getDescription();
        String[] srcBillID = descript.split("_");
        billReq.setSrcBillID(srcBillID);
        billReq.setBillId(otherBill.getId().toString());
        String[] billNumbers = ((String)otherBill.get("billNumber")).split("_");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < billNumbers.length; ++i) {
            sb.append(billNumbers[i]).append(";");
        }
        billReq.setBillId(otherBill.getId().toString());
        billReq.setBillNumber(sb.substring(0, sb.length() - 1));
        billReq.setTotalAmount(otherBill.getTotalAmount());
        billReq.setInvoiceAmount(otherBill.getTotalAmount());
        billReq.setUsedAmount(BigDecimal.ZERO);
        billReq.setCustomerID(otherBill.getAsstActID());
        billReq.setAsstActType(otherBill.getAsstActType());
        billReq.setCurrencyID(otherBill.getCurrency().getId().toString());
        billReq.setCompanyID(otherBill.getCompany().getId().toString());
        billReq.setBizDate(otherBill.getBillDate());
        billReq.setDescription(otherBill.getAbstractName());
        billReq.setInvoiceType(otherBill.getInvoiceType());
        billReq.setSplit(otherBill.getBoolean("KEY_IS_SPLIT"));
        billReq.setRecOrgName(otherBill.getComInvoiceName());
        billReq.setTaxNumber(otherBill.getTaxNo());
        billReq.setAddress(otherBill.getAddressAndTel());
        billReq.setBankAccount(otherBill.getOBankAndAcountNum());
        billReq.setObjectValue((IObjectValue)otherBill);
        TaxManageCustomerImpl.getBillReqInfoFromReDevelop(billReq, otherBill);
        OtherBillentryCollection otherBillEntries = (OtherBillentryCollection)otherBill.getEntries();
        int size = otherBillEntries.size();
        for (int idx = 0; idx < size; ++idx) {
            billReq.getEntrys().add(this.getBillEntryReqInfo((IObjectValue)otherBillEntries.get(idx)));
        }
        return billReq;
    }

    @Override
    protected BillEntryReqInfo getBillEntryReqInfo(IObjectValue entryValue) throws EASBizException, BOSException {
        BillEntryReqInfo billEntryReq = new BillEntryReqInfo();
        OtherBillentryInfo otherBillEntry = (OtherBillentryInfo)entryValue;
        if (otherBillEntry.getMaterial() != null) {
            billEntryReq.setMaterialID(otherBillEntry.getMaterial().getId().toString());
            billEntryReq.setModel(otherBillEntry.getMaterial().getModel());
            billEntryReq.setMaterialName(otherBillEntry.getMaterial().getName());
            billEntryReq.setMaterialNumber(otherBillEntry.getMaterial().getNumber());
        }
        if (otherBillEntry.getExpenseItem() != null) {
            billEntryReq.setExpenseItemID(otherBillEntry.getExpenseItem().getId().toString());
            billEntryReq.setMaterialName(otherBillEntry.getExpenseItem().getName());
            billEntryReq.setMaterialNumber(otherBillEntry.getExpenseItem().getNumber());
        }
        billEntryReq.setBillEntryID(otherBillEntry.getId().toString());
        billEntryReq.put("parentNumber", otherBillEntry.getHead().getNumber());
        billEntryReq.setSrcEntryID(otherBillEntry.getSourceBillEntryId());
        billEntryReq.setEntryAmount(otherBillEntry.getAmount());
        billEntryReq.setInvoiceAmount(otherBillEntry.getAmount());
        billEntryReq.setUsedAmount(BigDecimal.ZERO);
        billEntryReq.setQty(otherBillEntry.getQuantity());
        billEntryReq.setBaseQty(otherBillEntry.getBaseQty());
        billEntryReq.setInvoiceQty(otherBillEntry.getQuantity());
        billEntryReq.setUsedQuantity(BigDecimal.ZERO);
        billEntryReq.setTaxPrice(otherBillEntry.getTaxPrice());
        billEntryReq.setNoTaxAmount(otherBillEntry.getAmount());
        billEntryReq.setNoTaxPrice(otherBillEntry.getPrice());
        if (otherBillEntry.getMeasureUnit() != null) {
            billEntryReq.setMeasureUnitID(otherBillEntry.getMeasureUnit().getId().toString());
            billEntryReq.setMakeInvoiceUnit(otherBillEntry.getMeasureUnit().getName());
        }
        billEntryReq.setTaxRate(otherBillEntry.getTaxRate().divide(new BigDecimal(100)));
        billEntryReq.setTax(otherBillEntry.getTaxAmount());
        billEntryReq.setTaxAmount(otherBillEntry.getRecievePayAmount());
        billEntryReq.setSeq(otherBillEntry.getSeq());
        billEntryReq.setLot(otherBillEntry.getLot());
        billEntryReq.setBoolean("KEY_IS_CONSTANTQTY", otherBillEntry.getBoolean("KEY_IS_COMBIN"));
        billEntryReq.setIsQtyZero(otherBillEntry.isIsQtyZero());
        if (BigDecimal.ZERO.compareTo(otherBillEntry.getQuantity()) != 0) {
            String key = (String)otherBillEntry.get("combinKey");
            if (otherBillEntry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                BigDecimal actualPrice = otherBillEntry.getRecievePayAmount().divide(otherBillEntry.getQuantity(), this.combinePricePrecision, 4);
                BigDecimal realPrice = otherBillEntry.getAmount().divide(otherBillEntry.getQuantity(), this.combinePricePrecision, 4);
                billEntryReq.setActualPrice(actualPrice);
                billEntryReq.setRealPrice(realPrice);
            } else {
                billEntryReq.setActualPrice(otherBillEntry.getActualPrice());
                billEntryReq.setRealPrice(otherBillEntry.getRealPrice());
            }
        } else {
            billEntryReq.setActualPrice(BigDecimal.ZERO);
            billEntryReq.setRealPrice(BigDecimal.ZERO);
        }
        billEntryReq.setObjectValue(entryValue);
        TaxManageCustomerImpl.getBillEntryReqInfoFromReDevelop(billEntryReq, otherBillEntry);
        return billEntryReq;
    }

    @Override
    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
        String[] id = this.getIds();
        ArrayList<String> headProp = new ArrayList<String>();
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(ruleID, headProp, entryProp);
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < id.length; ++i) {
            idset.add(id[i]);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        OtherBillCollection otherBillColl = OtherBillFactory.getLocalInstance((Context)this.getCtx()).getOtherBillCollection(ev);
        OtherBillInfo billInfo = null;
        String key = "";
        int abstractNameMode = 0;
        if (otherBillColl.size() > 0) {
            Map paramMap = IMUtils.getParam(this.ctx, otherBillColl.get(0).getCompany().getId().toString(), new String[]{"VATM018"});
            abstractNameMode = IMUtils.getIntegerValue((String)paramMap.get("VATM018"));
        }
        HashSet<String> abstractNameSet = new HashSet<String>();
        for (int i = 0; i < otherBillColl.size(); ++i) {
            billInfo = otherBillColl.get(i);
            key = IMUtils.buildKey(headProp, (IObjectValue)billInfo);
            OtherBillInfo value = (OtherBillInfo)this.getCombinBill().get(key);
            if (value == null) {
                billInfo.setDescription(billInfo.getId().toString());
                billInfo.put("billNumber", (Object)billInfo.getNumber());
                if (abstractNameMode == 2) {
                    billInfo.setAbstractName(null);
                }
                this.getCombinBill().put(key, (IObjectValue)billInfo);
                abstractNameSet.add(billInfo.getAbstractName());
                continue;
            }
            value.getEntries().addObjectCollection((IObjectCollection)billInfo.getEntries());
            value.setDescription(value.getDescription() + "_" + billInfo.getId().toString());
            value.put("billNumber", (Object)(value.get("billNumber") + "_" + billInfo.getNumber()));
            if (abstractNameMode != 2) {
                if (billInfo.getAbstractName() == null || billInfo.getAbstractName().isEmpty()) continue;
                if (value.getAbstractName() == null || value.getAbstractName().isEmpty()) {
                    value.setAbstractName(billInfo.getAbstractName());
                    continue;
                }
                if (abstractNameMode == 0) {
                    value.setAbstractName(value.getAbstractName() + ";" + billInfo.getAbstractName());
                    continue;
                }
                if (!abstractNameSet.add(billInfo.getAbstractName())) continue;
                value.setAbstractName(value.getAbstractName() + ";" + billInfo.getAbstractName());
                continue;
            }
            value.setAbstractName(null);
        }
        if (entryProp.size() == 0) {
            this.clearEntrySrcId((IObjectCollection)otherBillColl);
        }
        HashMap<String, OtherBillentryInfo> combinBillEntry = new HashMap<String, OtherBillentryInfo>();
        OtherBillentryCollection entrys = null;
        OtherBillentryInfo entry = null;
        int groupFalg = 1;
        InvoiceParamConfigInfo paramConfigInfo = null;
        this.getIsNeedCalMap().clear();
        boolean isNeedCalPrice = true;
        for (IObjectValue o : this.getCombinBill().values()) {
            OtherBillInfo info = (OtherBillInfo)o;
            entrys = info.getEntry();
            paramConfigInfo = this.getReq().getPluginService().getInvoiceParamConfig(info.getCompany().getId().toString());
            isNeedCalPrice = paramConfigInfo.isIsReverseCal();
            HashMap<String, OtherBillentryInfo> checkPriceSameEntry = new HashMap<String, OtherBillentryInfo>();
            if (!isNeedCalPrice) {
                for (int i = 0; i < entrys.size(); ++i) {
                    entry = entrys.get(i);
                    key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                    OtherBillentryInfo obj = (OtherBillentryInfo)checkPriceSameEntry.get(key);
                    if (obj == null) {
                        checkPriceSameEntry.put(key, entry);
                        this.getIsNeedCalMap().put(key, false);
                        continue;
                    }
                    if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) != 0) {
                        boolean isSplit = this.getIsSplitPram(info);
                        if (!isSplit) {
                            if (IMUtils.getDecimalValue(entry.getRealPrice()).compareTo(IMUtils.getDecimalValue(obj.getRealPrice())) == 0) continue;
                            this.getIsNeedCalMap().put(key, true);
                            continue;
                        }
                        if (IMUtils.getDecimalValue(entry.getPrice()).compareTo(IMUtils.getDecimalValue(obj.getPrice())) == 0) continue;
                        this.getIsNeedCalMap().put(key, true);
                        continue;
                    }
                    if (IMUtils.getDecimalValue(entry.getPrice()).compareTo(IMUtils.getDecimalValue(obj.getPrice())) == 0) continue;
                    this.getIsNeedCalMap().put(key, true);
                }
            }
            OtherBillentryCollection newEntrys = new OtherBillentryCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                OtherBillentryInfo obj = (OtherBillentryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    entry.put("parentNumber", (Object)entry.getHead().getNumber());
                    entry.put("parentIds", (Object)entry.getHead().getId().toString());
                    entry.put("combinKey", (Object)key);
                    continue;
                }
                obj.setQuantity(obj.getQuantity().add(entry.getQuantity()));
                obj.setBaseQty(obj.getBaseQty().add(entry.getBaseQty()));
                obj.setAmount(obj.getAmount().add(entry.getAmount()));
                obj.setRecievePayAmount(obj.getRecievePayAmount().add(entry.getRecievePayAmount()));
                if (obj.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                    obj.setTaxPrice(BigDecimal.ZERO);
                    obj.setPrice(BigDecimal.ZERO);
                } else if (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue()) {
                    obj.setTaxPrice(obj.getRecievePayAmount().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                    obj.setPrice(obj.getAmount().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                }
                obj.setDiscountAmount(obj.getDiscountAmount().add(entry.getDiscountAmount()));
                obj.setBoolean("KEY_IS_COMBIN", true);
                obj.put("parentNumber", (Object)(obj.get("parentNumber") + "_" + entry.getHead().getNumber()));
                obj.put("parentIds", (Object)(obj.get("parentIds") + "_" + entry.getHead().getId().toString()));
            }
            info.getEntry().clear();
            info.getEntry().addCollection(newEntrys);
            ++groupFalg;
        }
    }

    @Override
    public String buildErrorBillMsg() throws BOSException {
        Iterator iterator = this.errorMsgMap.keySet().iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String billid = iterator.next().toString();
            idSet.add(billid);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        OtherBillCollection otherBillColl = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillCollection(ev);
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < otherBillColl.size(); ++i) {
            OtherBillInfo info = otherBillColl.get(i);
            String id = info.getId().toString();
            msg.append(info.getNumber() + ": " + this.errorMsgMap.get(id)).append("\r\n");
        }
        return msg.toString();
    }

    @Override
    protected void splitBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> entryProp = this.buildSplitRule(ruleID);
        if (entryProp == null || entryProp.size() == 0) {
            return;
        }
        OtherBillentryCollection entrys = null;
        OtherBillentryCollection newEntrys = null;
        OtherBillentryInfo entry = null;
        for (IObjectValue o : this.getCombinBill().values()) {
            OtherBillInfo info = (OtherBillInfo)o;
            entrys = info.getEntry();
            HashMap<String, OtherBillentryCollection> splitBillEntryMap = new HashMap<String, OtherBillentryCollection>();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
                OtherBillentryCollection entryColl = (OtherBillentryCollection)splitBillEntryMap.get(key);
                if (entryColl == null) {
                    newEntrys = new OtherBillentryCollection();
                    newEntrys.add(entry);
                    splitBillEntryMap.put(key, newEntrys);
                    continue;
                }
                entryColl.add(entry);
            }
            if (splitBillEntryMap.size() <= 1) continue;
            boolean isFirstValue = true;
            OtherBillCollection splitBillColl = new OtherBillCollection();
            for (OtherBillentryCollection value : splitBillEntryMap.values()) {
                if (isFirstValue) {
                    info.getEntry().clear();
                    info.getEntry().addCollection(value);
                    isFirstValue = false;
                    this.updateInfoDescription(info);
                    continue;
                }
                OtherBillInfo tempBill = (OtherBillInfo)info.clone();
                tempBill.setId(BOSUuid.create((String)"FC910EF3"));
                tempBill.setString("tempID", info.getId().toString());
                tempBill.getEntry().clear();
                tempBill.getEntry().addCollection(value);
                this.updateInfoDescription(tempBill);
                splitBillColl.add(tempBill);
            }
            info.put("splitBillColl", (Object)splitBillColl);
        }
    }

    protected void updateInfoDescription(OtherBillInfo info) {
        OtherBillentryCollection entrys = info.getEntry();
        OtherBillentryInfo entry = null;
        HashSet<String> parentIdSet = new HashSet<String>();
        HashSet<String> parentNumberSet = new HashSet<String>();
        String parentIds = null;
        String parentNumber = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            parentIds = (String)entry.get("parentIds");
            parentNumber = (String)entry.get("parentNumber");
            if (parentIds != null) {
                parentIdSet.addAll(Arrays.asList(parentIds.split("_")));
            }
            if (parentNumber == null) continue;
            parentNumberSet.addAll(Arrays.asList(parentNumber.split("_")));
        }
        Iterator iter = parentIdSet.iterator();
        info.setDescription("");
        while (iter.hasNext()) {
            if (info.getDescription().equals("")) {
                info.setDescription((String)iter.next());
                continue;
            }
            info.setDescription(info.getDescription() + "_" + iter.next());
        }
        Iterator numberIter = parentNumberSet.iterator();
        info.put("billNumber", (Object)"");
        while (numberIter.hasNext()) {
            if (info.get("billNumber").equals("")) {
                info.put("billNumber", (Object)((String)numberIter.next()));
                continue;
            }
            info.put("billNumber", (Object)(info.get("billNumber") + "_" + numberIter.next()));
        }
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("saleOrg.*"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.head.number"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.expenseItem.*"));
        sic.addObjectCollection((IObjectCollection)InvoicePluginUtil.getEntryMeasureUnitSelector(this.ctx, "FC910EF3"));
        return sic;
    }

    @Override
    protected void clearEntrySrcId(IObjectCollection coll) {
        OtherBillentryInfo entry = null;
        OtherBillInfo info = null;
        OtherBillCollection otherBillColl = (OtherBillCollection)coll;
        for (int k = 0; k < otherBillColl.size(); ++k) {
            info = otherBillColl.get(k);
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entry = info.getEntry().get(i);
                entry.setSourceBillEntryId(null);
            }
        }
    }

    protected boolean getIsSplitPram(OtherBillInfo info) throws EASBizException, BOSException {
        if (this.getIsSplitMap().containsKey(info.getId().toString())) {
            return this.getIsSplitMap().get(info.getId().toString());
        }
        String companyId = info.getCompany().getId().toString();
        boolean isSplit = IMUtils.getBooleanParam(this.getCtx(), companyId, "VATM006");
        MakeInvoiceParam param = this.getParams();
        String invoiceType = param.getInvoiceType();
        if (info.getAsstActType() != null && ("T_BD_Supplier".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject()) || "T_BD_Customer".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject()))) {
            String custID;
            HashMap<String, String> params = new HashMap<String, String>();
            if ("T_BD_Supplier".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject())) {
                custID = StringUtils.isEmpty((String)info.getAsstActID()) ? "CUSTOMER_EMPTY" : info.getAsstActID();
                params.put("customerId", custID);
            } else {
                custID = StringUtils.isEmpty((String)info.getAsstActID()) ? "CUSTOMER_EMPTY" : info.getAsstActID();
                params.put("customerId", custID);
            }
            String realInvoiceType = this.getInvoiceType(info, invoiceType);
            params.put("invoiceType", realInvoiceType);
            if (companyId != null) {
                params.put("companyId", companyId);
            }
            params.put("receiveCompany", info.getComInvoiceName());
            Map ret = new HashMap();
            ret = CustomerTaxFactory.getLocalInstance(this.ctx).getCustomerTaxInfo(params);
            CustomerTaxInfo customertaxInfo = (CustomerTaxInfo)ret.get("value");
            AbstractCustomerTaxEntryInfo entryInfo = null;
            if (customertaxInfo != null && customertaxInfo.getEntries().size() > 0) {
                entryInfo = customertaxInfo.getEntries().get(0);
            }
            if (entryInfo != null) {
                String value = entryInfo.getDiscountType().getValue();
                if ("1".equals(value)) {
                    isSplit = true;
                } else if ("2".equals(value)) {
                    isSplit = false;
                }
            }
        }
        this.getIsSplitMap().put(info.getId().toString(), isSplit);
        return isSplit;
    }

    @Override
    protected String getSrcTable() {
        return "t_ar_otherbill";
    }
}

