/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.TaxSeparationCollection;
import com.kingdee.eas.tm.im.TaxSeparationEntryCollection;
import com.kingdee.eas.tm.im.TaxSeparationEntryInfo;
import com.kingdee.eas.tm.im.TaxSeparationFactory;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import com.kingdee.eas.tm.im.TaxSeparationStatusEnum;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BuildInvoiceReq4MKRequest
extends AbstractBuildInvoiceReq {
    public BuildInvoiceReq4MKRequest(Context ctx, MakeInvoiceParam params) {
        this.setParams(params);
        this.setCtx(ctx);
    }

    protected void checkBillStatus(Context ctx, Set idSet) throws BOSException {
        super.checkBillStatus(ctx, idSet);
        StringBuffer errorMessage = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TaxSeparationCollection collection = TaxSeparationFactory.getLocalInstance(ctx).getTaxSeparationCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            TaxSeparationInfo taxSep = collection.get(i);
            if (taxSep.getStatus() != TaxSeparationStatusEnum.treated) continue;
            String errMsg = IMUtils.getIMResource(ctx, "taxSeparation_makeInvoice_statusError", new String[0]);
            String id = taxSep.get("id").toString();
            this.getErrorMsgMap().put(id, errMsg);
            idSet.remove(id);
        }
        if (errorMessage.length() > 0) {
            throw new BOSException(errorMessage.toString());
        }
    }

    @Override
    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
        String[] id = this.getIds();
        ArrayList<String> headProp = new ArrayList<String>();
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(ruleID, headProp, entryProp);
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < id.length; ++i) {
            idset.add(id[i]);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        TaxSeparationCollection taxSeparationBillColl = TaxSeparationFactory.getLocalInstance(this.getCtx()).getTaxSeparationCollection(ev);
        TaxSeparationInfo billInfo = null;
        String key = "";
        for (int i = 0; i < taxSeparationBillColl.size(); ++i) {
            billInfo = taxSeparationBillColl.get(i);
            billInfo.put("remark", billInfo.getDescription());
            key = IMUtils.buildKey(headProp, (IObjectValue)billInfo);
            TaxSeparationInfo value = (TaxSeparationInfo)this.getCombinBill().get(key);
            if (value == null) {
                billInfo.setDescription(billInfo.getId().toString());
                this.getCombinBill().put(key, (IObjectValue)billInfo);
                continue;
            }
            value.getEntries().addObjectCollection((IObjectCollection)billInfo.getEntries());
            value.setDescription(value.getDescription() + "_" + billInfo.getId().toString());
        }
        if (entryProp.size() == 0) {
            this.clearEntrySrcId((IObjectCollection)taxSeparationBillColl);
        }
        HashMap<String, TaxSeparationEntryInfo> combinBillEntry = new HashMap<String, TaxSeparationEntryInfo>();
        TaxSeparationEntryCollection entrys = null;
        TaxSeparationEntryInfo entry = null;
        int groupFalg = 1;
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            TaxSeparationInfo info = (TaxSeparationInfo)this.getCombinBill().get(key);
            entrys = info.getEntries();
            TaxSeparationEntryCollection newEntrys = new TaxSeparationEntryCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                TaxSeparationEntryInfo obj = (TaxSeparationEntryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    continue;
                }
                obj.setQuantity(obj.getQuantity().add(entry.getQuantity()));
                obj.setPriceExcludingTax(obj.getPriceExcludingTax().add(entry.getPriceExcludingTax()));
                obj.setPriceIncludingTax(obj.getPriceIncludingTax().add(entry.getPriceIncludingTax()));
                if (obj.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                    obj.setPrice(BigDecimal.ZERO);
                    obj.setNoTaxPrice(BigDecimal.ZERO);
                } else {
                    obj.setPrice(obj.getPriceIncludingTax().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                    obj.setNoTaxPrice(obj.getPriceExcludingTax().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                }
                obj.setDiscountAmount(obj.getDiscountAmount().add(entry.getDiscountAmount()));
            }
            info.getEntries().clear();
            info.getEntries().addCollection(newEntrys);
            ++groupFalg;
        }
    }

    @Override
    protected void clearEntrySrcId(IObjectCollection coll) {
        TaxSeparationEntryInfo entry = null;
        TaxSeparationInfo info = null;
        TaxSeparationCollection taxSeparationBillColl = (TaxSeparationCollection)coll;
        for (int k = 0; k < taxSeparationBillColl.size(); ++k) {
            info = taxSeparationBillColl.get(k);
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = info.getEntries().get(i);
                entry.setSourceBillEntryId(null);
            }
        }
    }

    protected void setBills(InvoiceReqInfo req, Map combinBill) throws EASBizException, BOSException {
        ArrayList billList = this.getOrderBiz();
        for (int i = 0; i < billList.size(); ++i) {
            TaxSeparationInfo info = (TaxSeparationInfo)billList.get(i);
            req.getBills().add(this.getBillReqInfo((IObjectValue)info));
        }
    }

    @Override
    protected BillReqInfo getBillReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        TaxSeparationInfo taxBill = (TaxSeparationInfo)objectValue;
        BillReqInfo billReq = new BillReqInfo();
        String descript = taxBill.getDescription();
        String[] srcBillID = descript.split("_");
        billReq.setSrcBillID(srcBillID);
        billReq.setBillId(taxBill.getId().toString());
        billReq.setBillNumber(taxBill.getNumber());
        billReq.setTotalAmount(taxBill.getPriceExcludingTax());
        billReq.setInvoiceAmount(taxBill.getPriceExcludingTax());
        billReq.setUsedAmount(BigDecimal.ZERO);
        if (taxBill.getCustomer() != null && taxBill.getCustomer().getId() != null) {
            billReq.setCustomerID(taxBill.getCustomer().getId().toString());
        }
        if (taxBill.getCurrency() != null && taxBill.getCurrency().getId() != null) {
            billReq.setCurrencyID(taxBill.getCurrency().getId().toString());
        } else {
            billReq.setCurrencyID("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC");
        }
        billReq.setCompanyID(taxBill.getCompany().getId().toString());
        billReq.setBizDate(taxBill.getBizDate());
        billReq.setDescription(taxBill.getString("remark"));
        billReq.setRecOrgName(taxBill.getRecOrgName());
        billReq.setTaxNumber(taxBill.getTaxNumber());
        billReq.setAddress(taxBill.getAddress());
        billReq.setBankAccount(taxBill.getBankAccount());
        billReq.setSplit(taxBill.getBoolean("KEY_IS_SPLIT"));
        TaxSeparationEntryCollection taxBillEntries = taxBill.getEntries();
        int size = taxBillEntries.size();
        for (int idx = 0; idx < size; ++idx) {
            billReq.getEntrys().add(this.getBillEntryReqInfo((IObjectValue)taxBillEntries.get(idx)));
        }
        billReq.setObjectValue((IObjectValue)taxBill);
        return billReq;
    }

    @Override
    protected BillEntryReqInfo getBillEntryReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        BillEntryReqInfo billEntryReq = new BillEntryReqInfo();
        TaxSeparationEntryInfo taxBillEntry = (TaxSeparationEntryInfo)objectValue;
        if (taxBillEntry.getProductCode() != null) {
            billEntryReq.setProductCode(taxBillEntry.getProductCode());
        }
        billEntryReq.setBillEntryID(taxBillEntry.getId().toString());
        billEntryReq.setSrcEntryID(taxBillEntry.getSourceBillEntryId());
        billEntryReq.setEntryAmount(taxBillEntry.getPriceExcludingTax());
        billEntryReq.setInvoiceAmount(taxBillEntry.getPriceExcludingTax());
        billEntryReq.setUsedAmount(BigDecimal.ZERO);
        billEntryReq.setQty(taxBillEntry.getQuantity());
        billEntryReq.setInvoiceQty(taxBillEntry.getQuantity());
        billEntryReq.setUsedQuantity(BigDecimal.ZERO);
        billEntryReq.setTaxPrice(taxBillEntry.getPrice());
        billEntryReq.setNoTaxAmount(taxBillEntry.getPriceExcludingTax());
        billEntryReq.setNoTaxPrice(taxBillEntry.getNoTaxPrice());
        if (taxBillEntry.getMeasureUnit() != null) {
            billEntryReq.setMeasureUnitID(taxBillEntry.getMeasureUnit().getId().toString());
            billEntryReq.setMakeInvoiceUnit(taxBillEntry.getMeasureUnit().getName());
        }
        if (taxBillEntry.getProductCode() != null) {
            billEntryReq.setModel(taxBillEntry.getProductCode().getModel());
        }
        billEntryReq.setTaxRate(taxBillEntry.getTaxRate());
        billEntryReq.setTax(taxBillEntry.getTax());
        billEntryReq.setTaxAmount(taxBillEntry.getPriceIncludingTax());
        billEntryReq.setSeq(taxBillEntry.getSeq());
        if (taxBillEntry.getQuantity() == null) {
            taxBillEntry.setQuantity(BigDecimal.ZERO);
        }
        if (BigDecimal.ZERO.compareTo(taxBillEntry.getQuantity()) != 0) {
            BigDecimal actualPrice = taxBillEntry.getPriceIncludingTax().divide(taxBillEntry.getQuantity(), this.combinePricePrecision, 4);
            BigDecimal realPrice = taxBillEntry.getPriceExcludingTax().divide(taxBillEntry.getQuantity(), this.combinePricePrecision, 4);
            billEntryReq.setActualPrice(actualPrice);
            billEntryReq.setRealPrice(realPrice);
        } else {
            billEntryReq.setActualPrice(BigDecimal.ZERO);
            billEntryReq.setRealPrice(BigDecimal.ZERO);
        }
        billEntryReq.setProductName(taxBillEntry.getProductName());
        billEntryReq.setTaxClassificationCode(taxBillEntry.getTaxClassificationCode());
        billEntryReq.setModel(taxBillEntry.getSpecification());
        return billEntryReq;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.productCode.*"));
        sic.add(new SelectorItemInfo("entries.measureUnit.*"));
        return sic;
    }

    @Override
    protected void doEntryDiscount(IObjectValue obj) throws EASBizException, BOSException {
        TaxSeparationInfo info = (TaxSeparationInfo)obj;
        TaxSeparationEntryCollection entrys = info.getEntries();
        TaxSeparationEntryCollection newEntrys = new TaxSeparationEntryCollection();
        int entrySeq = 1;
        TaxSeparationEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            entry.setSourceBillEntryId(null);
            entry.setSeq(entrySeq);
            ++entrySeq;
            if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) == 0) continue;
            BigDecimal discountAmt = entry.getDiscountAmount();
            BigDecimal amt = entry.getPriceIncludingTax();
            BigDecimal totalAmt = discountAmt.add(amt);
            entry.setPriceIncludingTax(totalAmt);
            entry.setPriceExcludingTax(entry.getPriceIncludingTax().divide(entry.getTaxRate().add(BigDecimal.ONE), 2, 4));
            entry.setTax(entry.getPriceIncludingTax().subtract(entry.getPriceExcludingTax()));
            entry.setPrice(entry.getPriceIncludingTax().divide(entry.getQuantity(), this.combinePricePrecision, 4));
            entry.setNoTaxPrice(entry.getPriceExcludingTax().divide(entry.getQuantity(), this.combinePricePrecision, 4));
            TaxSeparationEntryInfo newEntry = (TaxSeparationEntryInfo)entry.clone();
            entry.setSourceBillEntryId(null);
            newEntry.setSourceBillEntryId(entry.getId().toString());
            newEntry.setId(BOSUuid.create((String)"BC91693F"));
            newEntry.setSeq(entrySeq);
            ++entrySeq;
            newEntry.setQuantity(BigDecimal.ZERO);
            newEntry.setPrice(BigDecimal.ZERO);
            newEntry.setNoTaxPrice(BigDecimal.ZERO);
            totalAmt = newEntry.getDiscountAmount().negate();
            newEntry.setPriceIncludingTax(totalAmt);
            newEntry.setPriceExcludingTax(totalAmt.divide(newEntry.getTaxRate().add(BigDecimal.ONE), 4, 4));
            newEntry.setTax(totalAmt.subtract(newEntry.getPriceExcludingTax()));
            newEntrys.add(newEntry);
        }
        entrys.addCollection(newEntrys);
        entrys.sort("seq");
    }

    @Override
    protected void doEntryDiscount() throws EASBizException, BOSException {
        String companyId = null;
        boolean isSplit = false;
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            TaxSeparationInfo info = (TaxSeparationInfo)this.getCombinBill().get(key);
            companyId = info.getCompany().getId().toString();
            isSplit = IMUtils.getBooleanParam(this.getCtx(), companyId, "VATM006");
            info.setBoolean("KEY_IS_SPLIT", isSplit);
            if (!isSplit) continue;
            this.doEntryDiscount((IObjectValue)info);
        }
    }

    @Override
    public String buildErrorBillMsg() throws BOSException {
        Iterator iterator = this.getErrorMsgMap().keySet().iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String billid = iterator.next().toString();
            idSet.add(billid);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        TaxSeparationCollection billColl = TaxSeparationFactory.getLocalInstance(this.getCtx()).getTaxSeparationCollection(ev);
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < billColl.size(); ++i) {
            TaxSeparationInfo info = billColl.get(i);
            String id = info.getId().toString();
            msg.append(info.getNumber() + ": " + this.getErrorMsgMap().get(id)).append("\r\n");
        }
        return msg.toString();
    }

    @Override
    protected String getSrcTable() {
        return null;
    }
}

