/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceForDepFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqFacadeFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.util.UsedCarServerUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildInvoiceReq4UsedCarToMake
extends AbstractBuildInvoiceReq {
    private List<String> selectBillIds = null;
    private List<String> selectEntryIds = null;
    private Set<String> volidBillIds = null;
    private Set<String> volidEntryIds = null;
    private boolean isException = false;

    public BuildInvoiceReq4UsedCarToMake(Context ctx, MakeInvoiceParam params) {
        this.setParams(params);
        this.setCtx(ctx);
    }

    @Override
    public InvoiceReqInfo getInvoiceReqInfo() throws BOSException, EASBizException {
        try {
            InvoiceReqInfo req = super.getInvoiceReqInfo();
            return req;
        }
        catch (EASBizException e) {
            this.isException = true;
            throw e;
        }
        catch (BOSException ex) {
            this.isException = true;
            throw ex;
        }
    }

    @Override
    protected void initParam() throws BOSException, EASBizException {
        super.initParam();
        this.selectBillIds = new ArrayList<String>();
        this.selectEntryIds = new ArrayList<String>();
        this.volidBillIds = new HashSet<String>();
        this.volidEntryIds = new HashSet<String>();
        String[] ids = this.params.getBilBillIds().split(",");
        for (int i = 0; i < ids.length; ++i) {
            this.selectBillIds.add(ids[i]);
        }
    }

    @Override
    public void beforeCheckMakeInvoice() throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billIds", this.selectBillIds);
        param.put("entryIds", this.selectEntryIds);
        param.put("isReq", this.params.isReq());
        param.put("invoiceType", this.params.getInvoiceType());
        Map checkResult = UsedCarInvoiceReqFacadeFactory.getLocalInstance(this.getCtx()).checkBeforeInvoice(param);
        this.volidBillIds = (Set)checkResult.get("volidBillIds");
        this.volidEntryIds = (Set)checkResult.get("volidEntryIds");
        this.errorMsgMap = (Map)checkResult.get("billErrMap");
        this.errorMsgEntryMap = (Map)checkResult.get("billEntryErrMap");
    }

    @Override
    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> headProp = new ArrayList<String>();
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(ruleID, headProp, entryProp);
        UsedCarInvoiceReqCollection bizColl = UsedCarServerUtil.getUsedCarInvoiceReqCollection(this.getCtx(), this.volidBillIds, this.volidEntryIds);
        UsedCarInvoiceReqInfo billInfo = null;
        String key = "";
        int abstractNameMode = 0;
        if (bizColl.size() > 0) {
            Map paramMap = IMUtils.getParam(this.ctx, bizColl.get(0).getCompany().getId().toString(), new String[]{"VATM018"});
            abstractNameMode = IMUtils.getIntegerValue((String)paramMap.get("VATM018"));
        }
        HashSet<String> remarkSet = new HashSet<String>();
        for (int i = 0; i < bizColl.size(); ++i) {
            billInfo = bizColl.get(i);
            billInfo.put("remark", billInfo.getRemark());
            key = IMUtils.buildKey(headProp, (IObjectValue)billInfo);
            UsedCarInvoiceReqInfo value = (UsedCarInvoiceReqInfo)this.getCombinBill().get(key);
            if (value == null) {
                billInfo.setDescription(billInfo.getId().toString());
                if (abstractNameMode == 2) {
                    billInfo.setRemark(null);
                }
                this.getCombinBill().put(key, (IObjectValue)billInfo);
                billInfo.put("billNumber", billInfo.getNumber());
                remarkSet.add(billInfo.getRemark());
                continue;
            }
            value.getEntries().addObjectCollection((IObjectCollection)billInfo.getEntries());
            value.setDescription(value.getDescription() + "_" + billInfo.getId().toString());
            value.put("billNumber", value.get("billNumber") + "_" + billInfo.getNumber());
            if (abstractNameMode != 2) {
                if (billInfo.getRemark() == null || billInfo.getRemark().isEmpty()) continue;
                if (value.getRemark() == null || value.getRemark().isEmpty()) {
                    value.setRemark(billInfo.getRemark());
                    continue;
                }
                if (abstractNameMode == 0) {
                    value.setRemark(value.getRemark() + ";" + billInfo.getRemark());
                    continue;
                }
                if (!remarkSet.add(billInfo.getRemark())) continue;
                value.setRemark(value.getRemark() + ";" + billInfo.getRemark());
                continue;
            }
            value.setRemark(null);
        }
        if (entryProp.size() == 0) {
            this.clearEntrySrcId((IObjectCollection)bizColl);
        }
        HashMap<String, UsedCarInvoiceReqEntryInfo> combinBillEntry = new HashMap<String, UsedCarInvoiceReqEntryInfo>();
        UsedCarInvoiceReqEntryCollection entrys = null;
        UsedCarInvoiceReqEntryInfo entry = null;
        int groupFalg = 1;
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)this.getCombinBill().get(key);
            entrys = info.getEntries();
            UsedCarInvoiceReqEntryCollection newEntrys = new UsedCarInvoiceReqEntryCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                UsedCarInvoiceReqEntryInfo obj = (UsedCarInvoiceReqEntryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    entry.put("parentNumber", entry.getParent().getNumber());
                    entry.put("parentIds", entry.getParent().getId().toString());
                    continue;
                }
                obj.setQuantity(obj.getQuantity().add(entry.getQuantity()));
                obj.setPriceExcludingTax(obj.getPriceExcludingTax().add(entry.getPriceExcludingTax()));
                obj.setPriceIncludingTax(obj.getPriceIncludingTax().add(entry.getPriceIncludingTax()));
                if (obj.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                    obj.setPrice(BigDecimal.ZERO);
                    obj.setNoTaxPrice(BigDecimal.ZERO);
                } else {
                    obj.setPrice(obj.getPriceIncludingTax().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                    obj.setNoTaxPrice(obj.getPriceExcludingTax().divide(obj.getQuantity(), this.combinePricePrecision, RoundingMode.HALF_UP));
                }
                obj.setBoolean("KEY_IS_COMBIN", true);
                obj.put("parentNumber", obj.get("parentNumber") + "_" + entry.getParent().getNumber());
                obj.put("parentIds", obj.get("parentIds") + "_" + entry.getParent().getId().toString());
            }
            info.getEntries().clear();
            info.getEntries().addCollection(newEntrys);
            ++groupFalg;
        }
    }

    @Override
    protected void splitBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> entryProp = this.buildSplitRule(ruleID);
        if (entryProp == null || entryProp.size() == 0) {
            return;
        }
        UsedCarInvoiceReqEntryCollection entrys = null;
        UsedCarInvoiceReqEntryCollection newEntrys = null;
        UsedCarInvoiceReqEntryInfo entry = null;
        for (IObjectValue o : this.getCombinBill().values()) {
            UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)o;
            entrys = info.getEntries();
            HashMap<String, UsedCarInvoiceReqEntryCollection> splitBillEntryMap = new HashMap<String, UsedCarInvoiceReqEntryCollection>();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
                UsedCarInvoiceReqEntryCollection entryColl = (UsedCarInvoiceReqEntryCollection)((Object)splitBillEntryMap.get(key));
                if (entryColl == null) {
                    newEntrys = new UsedCarInvoiceReqEntryCollection();
                    newEntrys.add(entry);
                    splitBillEntryMap.put(key, newEntrys);
                    continue;
                }
                entryColl.add(entry);
            }
            if (splitBillEntryMap.size() <= 1) continue;
            boolean isFirstValue = true;
            UsedCarInvoiceReqCollection splitBillColl = new UsedCarInvoiceReqCollection();
            for (UsedCarInvoiceReqEntryCollection value : splitBillEntryMap.values()) {
                if (isFirstValue) {
                    info.getEntries().clear();
                    info.getEntries().addCollection(value);
                    isFirstValue = false;
                    this.updateInfoDescription(info);
                    continue;
                }
                UsedCarInvoiceReqInfo tempBill = (UsedCarInvoiceReqInfo)info.clone();
                tempBill.setId(BOSUuid.create((String)"0CADF79B"));
                tempBill.setString("tempID", info.getId().toString());
                tempBill.getEntries().clear();
                tempBill.getEntries().addCollection(value);
                this.updateInfoDescription(tempBill);
                splitBillColl.add(tempBill);
            }
            info.put("splitBillColl", (Object)splitBillColl);
        }
    }

    @Override
    protected void doEntryDiscount() throws EASBizException, BOSException {
    }

    @Override
    protected void doEntryDiscount(IObjectValue obj) throws EASBizException, BOSException {
    }

    protected void updateInfoDescription(UsedCarInvoiceReqInfo info) {
        UsedCarInvoiceReqEntryCollection entrys = info.getEntries();
        UsedCarInvoiceReqEntryInfo entry = null;
        HashSet<String> parentIdSet = new HashSet<String>();
        HashSet<String> parentNumberSet = new HashSet<String>();
        String parentIds = null;
        String parentNumber = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            parentIds = (String)entry.get("parentIds");
            parentNumber = (String)entry.get("parentNumber");
            if (parentIds != null) {
                parentIdSet.addAll(Arrays.asList(parentIds.split("_")));
            }
            if (parentNumber == null) continue;
            parentNumberSet.addAll(Arrays.asList(parentNumber.split("_")));
        }
        Iterator iter = parentIdSet.iterator();
        info.setDescription("");
        while (iter.hasNext()) {
            if (info.getDescription().equals("")) {
                info.setDescription((String)iter.next());
                continue;
            }
            info.setDescription(info.getDescription() + "_" + iter.next());
        }
        Iterator numberIter = parentNumberSet.iterator();
        info.put("billNumber", "");
        while (iter.hasNext()) {
            if (info.get("billNumber").equals("")) {
                info.put("billNumber", (String)iter.next());
                continue;
            }
            info.put("billNumber", info.get("billNumber") + "_" + iter.next());
        }
    }

    @Override
    protected void clearEntrySrcId(IObjectCollection coll) {
        UsedCarInvoiceReqEntryInfo entry = null;
        UsedCarInvoiceReqInfo info = null;
        UsedCarInvoiceReqCollection UsedCarInvoiceReqBillColl = (UsedCarInvoiceReqCollection)coll;
        for (int k = 0; k < UsedCarInvoiceReqBillColl.size(); ++k) {
            info = UsedCarInvoiceReqBillColl.get(k);
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = info.getEntries().get(i);
                entry.setSourceBillEntryId(null);
            }
        }
    }

    protected void setBills(InvoiceReqInfo req, Map combinBill) throws EASBizException, BOSException {
        ArrayList billList = this.getOrderBiz();
        for (int i = 0; i < billList.size(); ++i) {
            UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)billList.get(i);
            req.getBills().add(this.getBillReqInfo((IObjectValue)info));
        }
    }

    @Override
    protected BillReqInfo getBillReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)objectValue;
        BillReqInfo billReq = new BillReqInfo();
        String[] billNumbers = ((String)info.get("billNumber")).split("_");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < billNumbers.length; ++i) {
            sb.append(billNumbers[i]).append(";");
        }
        billReq.setBillNumber(sb.substring(0, sb.length() - 1));
        billReq.setSplit(info.getBoolean("KEY_IS_SPLIT"));
        MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).getBillReqInfoForDep(billReq, objectValue);
        UsedCarInvoiceReqEntryCollection taxBillEntries = info.getEntries();
        int size = taxBillEntries.size();
        for (int idx = 0; idx < size; ++idx) {
            billReq.getEntrys().add(this.getBillEntryReqInfo((IObjectValue)taxBillEntries.get(idx)));
        }
        billReq.setObjectValue(objectValue);
        return billReq;
    }

    @Override
    protected BillEntryReqInfo getBillEntryReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        BillEntryReqInfo billEntryReq = new BillEntryReqInfo();
        UsedCarInvoiceReqEntryInfo reqEntry = (UsedCarInvoiceReqEntryInfo)objectValue;
        if (reqEntry.getProductCode() != null) {
            billEntryReq.setProductCode(reqEntry.getProductCode());
        }
        billEntryReq.setBillEntryID(reqEntry.getId().toString());
        billEntryReq.put("parentNumber", reqEntry.getParent().getNumber());
        billEntryReq.setSrcEntryID(reqEntry.getSourceBillEntryId());
        billEntryReq.setProductName(reqEntry.getProductName());
        billEntryReq.setModel(reqEntry.getSpecs());
        if (reqEntry.getUnit() != null) {
            billEntryReq.setMeasureUnitID(reqEntry.getUnit().getId().toString());
            billEntryReq.setMakeInvoiceUnit(reqEntry.getUnit().getName());
        }
        if (!IMUtils.isEmpty(reqEntry.getUnitName())) {
            billEntryReq.setMakeInvoiceUnit(reqEntry.getUnitName());
        }
        billEntryReq.setEntryAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setInvoiceAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setUsedAmount(BigDecimal.ZERO);
        billEntryReq.setQty(reqEntry.getQuantity());
        billEntryReq.setInvoiceQty(reqEntry.getQuantity());
        billEntryReq.setUsedQuantity(BigDecimal.ZERO);
        billEntryReq.setTaxPrice(reqEntry.getPrice());
        billEntryReq.setNoTaxAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setNoTaxPrice(reqEntry.getNoTaxPrice());
        billEntryReq.setTaxRate(reqEntry.getTaxRate().divide(new BigDecimal(100)));
        billEntryReq.setTax(reqEntry.getTax());
        billEntryReq.setTaxAmount(reqEntry.getPriceIncludingTax());
        billEntryReq.setSeq(reqEntry.getSeq());
        if (reqEntry.getQuantity() == null) {
            reqEntry.setQuantity(BigDecimal.ZERO);
        }
        if (BigDecimal.ZERO.compareTo(reqEntry.getQuantity()) != 0) {
            if (reqEntry.getBoolean("KEY_IS_COMBIN")) {
                BigDecimal actualPrice = reqEntry.getPriceIncludingTax().divide(reqEntry.getQuantity(), this.combinePricePrecision, 4);
                BigDecimal realPrice = reqEntry.getPriceExcludingTax().divide(reqEntry.getQuantity(), this.combinePricePrecision, 4);
                billEntryReq.setActualPrice(actualPrice);
                billEntryReq.setRealPrice(realPrice);
            } else {
                billEntryReq.setActualPrice(reqEntry.getPrice());
                billEntryReq.setRealPrice(reqEntry.getNoTaxPrice());
            }
        } else {
            billEntryReq.setActualPrice(BigDecimal.ZERO);
            billEntryReq.setRealPrice(BigDecimal.ZERO);
        }
        billEntryReq.setTaxClassificationCode(reqEntry.getTaxClassificationCode());
        return billEntryReq;
    }

    @Override
    public String buildErrorBillMsg() throws BOSException {
        StringBuffer errorMsg = new StringBuffer();
        UsedCarServerUtil.buildBillErrorMsg(this.ctx, this.errorMsgMap, errorMsg, null, null);
        return errorMsg.toString();
    }

    @Override
    protected ArrayList getFailBills() {
        ArrayList failBills = new ArrayList();
        if (this.isException) {
            failBills = (ArrayList)this.selectEntryIds;
        } else {
            Iterator iterator = this.errorMsgEntryMap.keySet().iterator();
            while (iterator.hasNext()) {
                String billid = iterator.next().toString();
                failBills.add(billid);
            }
        }
        return failBills;
    }

    @Override
    protected String getSrcTable() {
        return "T_IM_UsedCarInvoiceReq";
    }
}

