/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceForDepFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.VehicleInvoiceReqCollection;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.VehicleInvoiceReqFacadeFactory;
import com.kingdee.eas.tm.im.VehicleInvoiceReqInfo;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.util.VehicleServerUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildInvoiceReq4Vehicle
extends AbstractBuildInvoiceReq {
    private List<String> selectBillIds = null;
    private List<String> selectEntryIds = null;
    private Set<String> volidBillIds = null;
    private Set<String> volidEntryIds = null;
    private boolean isException = false;

    public BuildInvoiceReq4Vehicle(Context ctx, MakeInvoiceParam params) {
        this.setParams(params);
        this.setCtx(ctx);
    }

    @Override
    public InvoiceReqInfo getInvoiceReqInfo() throws BOSException, EASBizException {
        try {
            InvoiceReqInfo req = super.getInvoiceReqInfo();
            return req;
        }
        catch (EASBizException e) {
            this.isException = true;
            throw e;
        }
        catch (BOSException ex) {
            this.isException = true;
            throw ex;
        }
    }

    @Override
    protected void initParam() throws BOSException, EASBizException {
        int i;
        super.initParam();
        this.selectBillIds = new ArrayList<String>();
        this.selectEntryIds = new ArrayList<String>();
        this.volidBillIds = new HashSet<String>();
        this.volidEntryIds = new HashSet<String>();
        String[] ids = this.params.getBilBillIds().split(",");
        String[] entryIds = this.params.getBillBillEntryIds().split(",");
        for (i = 0; i < ids.length; ++i) {
            this.selectBillIds.add(ids[i]);
        }
        for (i = 0; i < entryIds.length; ++i) {
            this.selectEntryIds.add(entryIds[i]);
        }
    }

    @Override
    public void beforeCheckMakeInvoice() throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billIds", this.selectBillIds);
        param.put("entryIds", this.selectEntryIds);
        param.put("isReq", this.params.isReq());
        Map checkResult = VehicleInvoiceReqFacadeFactory.getLocalInstance(this.getCtx()).checkBeforeInvoice(param);
        this.volidBillIds = (Set)checkResult.get("volidBillIds");
        this.volidEntryIds = (Set)checkResult.get("volidEntryIds");
        this.errorMsgMap = (Map)checkResult.get("billErrMap");
        this.errorMsgEntryMap = (Map)checkResult.get("billEntryErrMap");
    }

    @Override
    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> headProp = new ArrayList<String>();
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(ruleID, headProp, entryProp);
        VehicleInvoiceReqCollection bizColl = VehicleServerUtil.getVehicleInvoiceReqCollection(this.getCtx(), this.volidBillIds, this.volidEntryIds);
        VehicleInvoiceReqInfo billInfo = null;
        String key = "";
        for (int i = 0; i < bizColl.size(); ++i) {
            billInfo = bizColl.get(i);
            key = IMUtils.buildKey(headProp, (IObjectValue)billInfo);
            VehicleInvoiceReqInfo value = (VehicleInvoiceReqInfo)this.getCombinBill().get(key);
            if (value == null) {
                billInfo.setDescription(billInfo.getId().toString());
                this.getCombinBill().put(key, (IObjectValue)billInfo);
                MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).combinBizBillForDep((IObjectValue)billInfo, null);
                continue;
            }
            value.getEntries().addObjectCollection((IObjectCollection)billInfo.getEntries());
            value.setDescription(value.getDescription() + "_" + billInfo.getId().toString());
            MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).combinBizBillForDep((IObjectValue)value, (IObjectValue)billInfo);
        }
        if (entryProp.size() == 0) {
            this.clearEntrySrcId((IObjectCollection)bizColl);
        }
        HashMap<String, VehicleInvoiceReqEntryInfo> combinBillEntry = new HashMap<String, VehicleInvoiceReqEntryInfo>();
        VehicleInvoiceReqEntryCollection entrys = null;
        VehicleInvoiceReqEntryInfo entry = null;
        int groupFalg = 1;
        for (IObjectValue o : this.getCombinBill().values()) {
            VehicleInvoiceReqInfo info = (VehicleInvoiceReqInfo)o;
            entrys = info.getEntries();
            VehicleInvoiceReqEntryCollection newEntrys = new VehicleInvoiceReqEntryCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                VehicleInvoiceReqEntryInfo obj = (VehicleInvoiceReqEntryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    entry.put("parentIds", entry.getParent().getId().toString());
                    entry.put("entryIds", entry.getId().toString());
                    MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).combinBizBillEntryForDep((IObjectValue)entry, null);
                    continue;
                }
                obj.setTax(obj.getTax().add(entry.getTax()));
                obj.setPriceExcludingTax(obj.getPriceExcludingTax().add(entry.getPriceExcludingTax()));
                obj.setPriceIncludingTax(obj.getPriceIncludingTax().add(entry.getPriceIncludingTax()));
                obj.put("parentIds", obj.get("parentIds") + "_" + entry.getParent().getId().toString());
                obj.put("entryIds", obj.get("entryIds") + "_" + entry.getId().toString());
                MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).combinBizBillEntryForDep((IObjectValue)obj, (IObjectValue)entry);
            }
            info.getEntries().clear();
            info.getEntries().addCollection(newEntrys);
            ++groupFalg;
        }
    }

    @Override
    protected void buildCombinRule(String ruleID, ArrayList<String> headProp, ArrayList<String> entryProp) throws EASBizException, BOSException {
        if (ruleID == null || "".equals(ruleID)) {
            headProp.add("id");
            entryProp.add("vehicleIdentificationCode");
            entryProp.add("taxRate");
        } else {
            CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, ruleID);
            if (combinRule == null || combinRule.getCombinFields() == null) {
                headProp.add("id");
                entryProp.add("vehicleIdentificationCode");
                entryProp.add("taxRate");
            } else {
                String[] properties = combinRule.getCombinFields().split("_");
                for (int i = 0; i < properties.length; ++i) {
                    String value = properties[i];
                    String[] tempValue = value.split("\\.");
                    if (tempValue.length > 1) {
                        if (entryProp.contains(tempValue[1])) continue;
                        entryProp.add(tempValue[1]);
                        continue;
                    }
                    if (headProp.contains(value)) continue;
                    headProp.add(value);
                }
            }
        }
        if (!entryProp.contains("vehicleIdentificationCode")) {
            entryProp.add("vehicleIdentificationCode");
        }
        if (!entryProp.contains("taxRate")) {
            entryProp.add("taxRate");
        }
    }

    @Override
    protected void splitBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> entryProp = this.buildSplitRule(ruleID);
        if (entryProp == null || entryProp.size() == 0) {
            return;
        }
        VehicleInvoiceReqEntryCollection entrys = null;
        VehicleInvoiceReqEntryCollection newEntrys = null;
        VehicleInvoiceReqEntryInfo entry = null;
        for (IObjectValue o : this.getCombinBill().values()) {
            VehicleInvoiceReqInfo info = (VehicleInvoiceReqInfo)o;
            entrys = info.getEntries();
            HashMap<String, VehicleInvoiceReqEntryCollection> splitBillEntryMap = new HashMap<String, VehicleInvoiceReqEntryCollection>();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
                VehicleInvoiceReqEntryCollection entryColl = (VehicleInvoiceReqEntryCollection)((Object)splitBillEntryMap.get(key));
                if (entryColl == null) {
                    newEntrys = new VehicleInvoiceReqEntryCollection();
                    newEntrys.add(entry);
                    splitBillEntryMap.put(key, newEntrys);
                    continue;
                }
                entryColl.add(entry);
            }
            if (splitBillEntryMap.size() <= 1) continue;
            boolean isFirstValue = true;
            VehicleInvoiceReqCollection splitBillColl = new VehicleInvoiceReqCollection();
            for (VehicleInvoiceReqEntryCollection value : splitBillEntryMap.values()) {
                if (isFirstValue) {
                    info.getEntries().clear();
                    info.getEntries().addCollection(value);
                    isFirstValue = false;
                    this.updateInfoDescription(info);
                    continue;
                }
                VehicleInvoiceReqInfo tempBill = (VehicleInvoiceReqInfo)info.clone();
                tempBill.setId(BOSUuid.create((String)"DC794E3A"));
                tempBill.setString("tempID", info.getId().toString());
                tempBill.getEntries().clear();
                tempBill.getEntries().addCollection(value);
                this.updateInfoDescription(tempBill);
                splitBillColl.add(tempBill);
            }
            info.put("splitBillColl", (Object)splitBillColl);
        }
    }

    @Override
    protected ArrayList<String> buildSplitRule(String ruleID) throws EASBizException, BOSException {
        ArrayList<String> entryProp = new ArrayList<String>();
        if (ruleID == null || "".equals(ruleID)) {
            entryProp.add("id");
            return entryProp;
        }
        CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.getCtx(), ruleID);
        if (combinRule.getSplitFields() == null) {
            entryProp.add("id");
            return entryProp;
        }
        String[] properties = combinRule.getSplitFields().split("_");
        for (int i = 0; i < properties.length; ++i) {
            String value = properties[i];
            String[] tempValue = value.split("\\.");
            if (tempValue.length <= 1 || entryProp.contains(tempValue[1])) continue;
            entryProp.add(tempValue[1]);
        }
        if (!entryProp.contains("id")) {
            entryProp.add("id");
        }
        return entryProp;
    }

    protected void updateInfoDescription(VehicleInvoiceReqInfo info) {
        VehicleInvoiceReqEntryCollection entrys = info.getEntries();
        VehicleInvoiceReqEntryInfo entry = null;
        HashSet<String> parentIdSet = new HashSet<String>();
        String parentIds = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            parentIds = (String)entry.get("parentIds");
            if (parentIds == null) continue;
            parentIdSet.addAll(Arrays.asList(parentIds.split("_")));
        }
        Iterator iter = parentIdSet.iterator();
        info.setDescription("");
        while (iter.hasNext()) {
            if (info.getDescription().equals("")) {
                info.setDescription((String)iter.next());
                continue;
            }
            info.setDescription(info.getDescription() + "_" + iter.next());
        }
    }

    protected void setBills(InvoiceReqInfo req, Map combinBill) throws EASBizException, BOSException {
        ArrayList billList = this.getOrderBiz();
        for (int i = 0; i < billList.size(); ++i) {
            VehicleInvoiceReqInfo info = (VehicleInvoiceReqInfo)billList.get(i);
            req.getBills().add(this.getBillReqInfo((IObjectValue)info));
        }
    }

    @Override
    protected BillReqInfo getBillReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        VehicleInvoiceReqInfo info = (VehicleInvoiceReqInfo)objectValue;
        BillReqInfo billReq = new BillReqInfo();
        billReq.setBillNumber(info.getNumber());
        MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).getBillReqInfoForDep(billReq, objectValue);
        billReq.setObjectValue(objectValue);
        return billReq;
    }

    @Override
    protected ArrayList getFailBills() {
        ArrayList failBills = new ArrayList();
        if (this.isException) {
            failBills = (ArrayList)this.selectEntryIds;
        } else {
            Iterator iterator = this.errorMsgEntryMap.keySet().iterator();
            while (iterator.hasNext()) {
                String billid = iterator.next().toString();
                failBills.add(billid);
            }
        }
        return failBills;
    }

    @Override
    public String buildErrorBillMsg() throws BOSException {
        StringBuffer errorMsg = new StringBuffer();
        VehicleServerUtil.buildBillErrorMsg(this.ctx, this.errorMsgMap, errorMsg, this.selectEntryIds, this.errorMsgEntryMap);
        VehicleServerUtil.buildEntryErrorMsg(this.ctx, this.errorMsgEntryMap, errorMsg);
        return errorMsg.toString();
    }
}

