/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.tm.im.app.AbstractCheckAccountFacadeControllerBean;
import com.kingdee.eas.tm.im.md5.MD5Util;
import com.kingdee.eas.tm.im.util.IMDBUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckAccountFacadeControllerBean
extends AbstractCheckAccountFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.CheckAccountFacadeControllerBean");

    @Override
    protected Map _takeBillData(Context ctx, String takeDataSQL, int from, int len) throws BOSException, EASBizException {
        IRowSet rowSet = IMDBUtils.getRowSet(ctx, takeDataSQL, from, len);
        int rowCount = this.getRowCount(ctx, takeDataSQL);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowSet", rowSet);
        data.put("rowCount", rowCount);
        return data;
    }

    @Override
    protected void _checkSupplierPassword(Context ctx, String supplier) throws BOSException, EASBizException {
        if (supplier == null || "".equals(supplier)) {
            throw new BOSException(IMUtils.getIMResource(ctx, "SUPPLIER_ISNULL", new String[0]));
        }
        String supplierNumber = supplier.split("\\|")[0];
        if (supplierNumber == null || "".equals(supplierNumber)) {
            throw new BOSException(IMUtils.getIMResource(ctx, "SUPPLIER_NUMBER_ISNULL", new String[0]));
        }
        String supplierPassword = supplier.split("\\|")[1];
        if (supplierPassword == null || "".equals(supplierPassword)) {
            throw new BOSException(IMUtils.getIMResource(ctx, "SUPPLIER_PASSWORLD_ISNULL", new String[0]));
        }
        String sql = "select FSupplierPassword from T_TMIM_Supplier where FSupplierNumber = '" + supplierNumber + "'";
        String password = null;
        try {
            IRowSet rs = IMDBUtils.executeQuery(ctx, sql);
            if (rs.next()) {
                password = rs.getString("FSupplierPassword");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        if (password != null && !"".equals(password)) {
            password = MD5Util.getMD5String(password);
        }
        if (!supplierPassword.equals(password)) {
            throw new BOSException(IMUtils.getIMResource(ctx, "SUPPLIER_PASSWORLD_ERROR", new String[0]));
        }
    }

    private int getRowCount(Context ctx, String takeDataSQL) throws EASBizException, BOSException {
        int rowCount = 0;
        try {
            String sql = "select count(billId) as count from (" + takeDataSQL + ")";
            IRowSet rs = IMDBUtils.executeQuery(ctx, sql);
            if (rs.next()) {
                rowCount = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return rowCount;
    }

    @Override
    protected void _updateRelationsData(Context ctx, List relationList) throws BOSException, EASBizException {
        String selectSql = "select * from t_tmim_relations where fbillid = ? and fbillentryid = ?";
        String updateSql = "update t_tmim_relations set finvoicenumber = ? where fbillid = ? and fbillentryid = ?";
        String insertSql = "insert into t_tmim_relations(fbillid, fbillentryid, finvoicenumber) values(?, ?, ?)";
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        try {
            for (int i = 0; i < relationList.size(); ++i) {
                Object[] selectParams;
                IRowSet rs;
                Map relation = (Map)relationList.get(i);
                String billId = relation.get("billId").toString();
                String entryId = relation.get("entryId").toString();
                String invoiceNumber = null;
                if (relation.get("invoiceNumber") != null) {
                    invoiceNumber = relation.get("invoiceNumber").toString();
                }
                if (invoiceNumber != null && billId != null) {
                    this.checkRelationData(ctx, billId, invoiceNumber);
                }
                if ((rs = DBUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])(selectParams = new Object[]{billId, entryId}))).next()) {
                    Object[] updateParams = new Object[]{invoiceNumber, billId, entryId};
                    updateParamList.add(updateParams);
                    continue;
                }
                Object[] insertParams = new Object[]{billId, entryId, invoiceNumber};
                insertParamList.add(insertParams);
            }
            if (updateParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)updateSql, (Object[][])((Object[][])updateParamList.toArray((T[])new Object[updateParamList.size()][3])));
            }
            if (insertParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)insertSql, (Object[][])((Object[][])insertParamList.toArray((T[])new Object[insertParamList.size()][3])));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void checkRelationData(Context ctx, String billId, String invoiceNumber) throws BOSException {
        try {
            String selectSql = "select fbillid from t_tmim_relations where finvoicenumber = ?";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{invoiceNumber});
            if (rs.next()) {
                String bBOSType;
                String bid = rs.getString("fbillid");
                String aBOSType = BOSUuid.read((String)billId).getType().toString();
                if (!aBOSType.equalsIgnoreCase(bBOSType = BOSUuid.read((String)bid).getType().toString())) {
                    throw new BOSException(IMUtils.getIMResource(ctx, "RELATION_ERROR", new String[0]));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }
}

