/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IUsedCarMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceForDepFacadeFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceBillTypeEnum;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceFactory;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.AbstractGenerateInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.app.UsedCarMakeInvoiceControllerBean;
import com.kingdee.eas.tm.im.common.InvoiceTypeEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateUsedCarInvoiceHandler
extends AbstractGenerateInvoiceReqHandler {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.GenerateUsedCarInvoiceHandler");
    protected Map<String, Map<String, Set>> destBillEntryRelation = new HashMap<String, Map<String, Set>>();
    private LowTimer timer = new LowTimer();

    public GenerateUsedCarInvoiceHandler(Context ctx, InvoiceReqInfo invoiceReq) {
        super(ctx, invoiceReq);
    }

    @Override
    protected ArrayList handleBills(List exList) throws Exception {
        this.timer.reset();
        List<UsedCarMakeInvoiceInfo> invoiceInfos = this.invoiceReq2UsedCarInvoiceBills(this.invoiceReq.getBills(), exList);
        if (invoiceInfos.isEmpty()) {
            return null;
        }
        this.logger.error((Object)("\u5f00\u7968\u7533\u8bf7\u5355\u8f6c\u6362\u4e8c\u624b\u8f66\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.removeZeroInvoice(invoiceInfos, exList);
        this.timer.reset();
        ArrayList ids = this.saveUsedCarInvoice(invoiceInfos);
        this.logger.error((Object)("\u4e8c\u624b\u8f66\u5f00\u7968\u5355\u4fdd\u5b58\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        this.saveBillRelattion();
        this.logger.error((Object)("\u6784\u9020\u4e1a\u52a1\u5355\u636e\u8ddf\u4e8c\u624b\u8f66\u5f00\u7968\u5355\u62c6\u5206\u5408\u5e76\u5173\u7cfb\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        List errorID = this.submitUsedCarInvoice(invoiceInfos, exList);
        this.logger.error((Object)("\u63d0\u4ea4\u3001\u5ba1\u6838\u4e8c\u624b\u8f66\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.doOtherErrorInvoice(errorID, exList);
        this.getResp().setMkFailBills((ArrayList)errorID);
        this.remvoeErrorID(ids, errorID);
        return ids;
    }

    protected void removeZeroInvoice(List<UsedCarMakeInvoiceInfo> afterGroupList, List exList) {
        UsedCarMakeInvoiceInfo invoice = null;
        boolean hasZeroInvoice = false;
        for (int i = 0; i < afterGroupList.size(); ++i) {
            invoice = afterGroupList.get(i);
            if (invoice.getPriceTaxTotal().compareTo(BigDecimal.ZERO) != 0) continue;
            afterGroupList.remove(i);
            --i;
            hasZeroInvoice = true;
        }
        if (hasZeroInvoice) {
            exList.add(new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "MSG_ZEOR_ENTRIES", this.ctx.getLocale())}));
        }
    }

    protected List<UsedCarMakeInvoiceInfo> invoiceReq2UsedCarInvoiceBills(List<BillReqInfo> bills, List exList) throws BOSException, EASBizException {
        ArrayList<UsedCarMakeInvoiceInfo> retValue = new ArrayList<UsedCarMakeInvoiceInfo>();
        int size = bills.size();
        for (int idx = 0; idx < size; ++idx) {
            UsedCarMakeInvoiceInfo info = null;
            try {
                info = this.invoiceReq2UsedCarInvoiceInfo(bills.get(idx));
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                exList.add(e);
            }
            if (info == null) continue;
            retValue.add(info);
        }
        return retValue;
    }

    protected UsedCarMakeInvoiceInfo invoiceReq2UsedCarInvoiceInfo(BillReqInfo billReqInfo) throws BOSException, EASBizException {
        String asstActID;
        String assActBosType;
        UsedCarInvoiceReqInfo invoiceReq = (UsedCarInvoiceReqInfo)billReqInfo.getObjectValue();
        UsedCarMakeInvoiceInfo invoice = UsedCarMakeInvoiceInfo.createMakeInvoiceInfo();
        invoice.setCompany(invoiceReq.getCompany());
        invoice.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.ctx));
        invoice.setInvoiceType(InvoiceTypeEnum.USEDCARINVOICE);
        invoice.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        if (!StringUtils.isEmpty((String)invoiceReq.getAsstActID()) && "37C67DFC".equalsIgnoreCase(assActBosType = BOSUuid.read((String)invoiceReq.getAsstActID()).getType().toString())) {
            invoice.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        if (!StringUtils.isEmpty((String)(asstActID = invoiceReq.getAsstActID()))) {
            SupplierInfo info;
            if (CurrentAccountType.SUPPLIER == invoice.getCurrentAccountType()) {
                info = new SupplierInfo();
                info.setId(BOSUuid.read((String)asstActID));
                invoice.setCurrAcctSupplier(info);
            } else if (CurrentAccountType.CUSTOMER == invoice.getCurrentAccountType()) {
                info = new CustomerInfo();
                info.setId(BOSUuid.read((String)asstActID));
                invoice.setCurrAcctCustomer((CustomerInfo)info);
            }
        }
        invoice.setBizDate(new java.util.Date());
        invoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        invoice.setSrcSystem(InvoiceSrcSystem.SYSTEM);
        invoice.setCurrency(invoiceReq.getCurrency());
        invoice.setBuyerName(invoiceReq.getBuyerName());
        invoice.setBuyerCardNo(invoiceReq.getBuyerCardNo());
        invoice.setBuyerAddress(invoiceReq.getBuyerAddress());
        invoice.setBuyerPhoneNumber(invoiceReq.getBuyerPhoneNumber());
        invoice.setSourceBillType(UsedCarMakeInvoiceBillTypeEnum.UsedCarInvoiceReq);
        invoice.setSourceBillNumber(invoiceReq.getNumber());
        invoice.setSourceBillId(invoiceReq.getId() != null ? invoiceReq.getId().toString() : null);
        UsedCarInvoiceReqEntryInfo invoiceReqEntry = invoiceReq.getEntries().get(0);
        invoice.setProductCode(invoiceReqEntry.getProductCode());
        invoice.setLicensePlateNumber(invoiceReqEntry.getLicensePlateNumber());
        invoice.setRegistrationNumber(invoiceReqEntry.getRegistrationNumber());
        invoice.setVehicleType(invoiceReqEntry.getVehicleType());
        invoice.setVehicleIdentificationCode(invoiceReqEntry.getVehicleIdentificationCode());
        invoice.setFacPlateModel(invoiceReqEntry.getFacPlateModel());
        invoice.setTransferInVehilceManager(invoiceReqEntry.getTransferInVehilceManager());
        invoice.setPriceTaxTotal(invoiceReqEntry.getPriceIncludingTax());
        invoice.setTaxClassificationCode(invoiceReqEntry.getTaxClassificationCode());
        invoice.setRemark(invoiceReqEntry.getRemark());
        invoice.setIsPrint(false);
        invoice.setIsDelete(false);
        invoice.setIsRedVoicedBill(false);
        invoice.setFiVouchered(false);
        invoice.setSalerEnterpriseType(invoiceReq.getSalerEnterpriseType());
        MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).setProductInfo(billReqInfo, (IObjectValue)invoice);
        MakeInvoiceForDepFacadeFactory.getLocalInstance(this.getCtx()).setCustomerInfo(billReqInfo, (IObjectValue)invoice);
        this.setDestBillRalation(invoice, invoiceReq);
        this.setDestBillEntryRalation(invoice, invoiceReq);
        return invoice;
    }

    protected void setDestBillRalation(UsedCarMakeInvoiceInfo invoice, UsedCarInvoiceReqInfo invoiceReq) {
        String descript = invoiceReq.getDescription();
        String[] srcBillID = descript.split("_");
        ArrayList<String> srcBillIDs = new ArrayList<String>();
        for (int i = 0; i < srcBillID.length; ++i) {
            srcBillIDs.add(srcBillID[i]);
        }
        this.destBillRelation.put(invoice.getId().toString(), srcBillIDs);
    }

    protected void setDestBillEntryRalation(UsedCarMakeInvoiceInfo invoice, UsedCarInvoiceReqInfo invoiceReq) {
        UsedCarInvoiceReqEntryInfo invoiceReqEntry = invoiceReq.getEntries().get(0);
        String parentIds = (String)invoiceReqEntry.get("parentIds");
        String entryIds = (String)invoiceReqEntry.get("entryIds");
        HashMap<String, HashSet<String>> billEntryMap = new HashMap<String, HashSet<String>>();
        String[] parentIdArr = parentIds.split("_");
        String[] entryIdArr = entryIds.split("_");
        int size = parentIdArr.length;
        for (int i = 0; i < size; ++i) {
            String parentId = parentIdArr[i];
            String entryId = entryIdArr[i];
            HashSet<String> entrySet = (HashSet<String>)billEntryMap.get(parentId);
            if (entrySet == null) {
                entrySet = new HashSet<String>();
                billEntryMap.put(parentId, entrySet);
            }
            entrySet.add(entryId);
        }
        this.destBillEntryRelation.put(invoice.getId().toString(), billEntryMap);
    }

    protected ArrayList saveUsedCarInvoice(List<UsedCarMakeInvoiceInfo> invoiceColl) throws EASBizException, BOSException {
        IUsedCarMakeInvoice facade = UsedCarMakeInvoiceFactory.getLocalInstance(this.ctx);
        ArrayList<String> invoiceIdList = new ArrayList<String>();
        for (int i = 0; i < invoiceColl.size(); ++i) {
            IObjectPK id = facade.saveWithoutBusiness((CoreBaseInfo)invoiceColl.get(i));
            if (invoiceIdList.contains(id.toString())) continue;
            invoiceIdList.add(id.toString());
        }
        return invoiceIdList;
    }

    protected List submitUsedCarInvoice(List<UsedCarMakeInvoiceInfo> invoiceColl, List exList) throws BOSException, EASBizException {
        IUsedCarMakeInvoice facade = UsedCarMakeInvoiceFactory.getLocalInstance(this.ctx);
        ArrayList<String> errorIDs = new ArrayList<String>();
        if (this.isReq()) {
            for (int i = 0; i < invoiceColl.size(); ++i) {
                UsedCarMakeInvoiceInfo info = invoiceColl.get(i);
                facade.save((CoreBaseInfo)info);
            }
            return errorIDs;
        }
        for (int i = 0; i < invoiceColl.size(); ++i) {
            UsedCarMakeInvoiceInfo info = invoiceColl.get(i);
            String billID = info.getId().toString();
            try {
                facade.save((CoreBaseInfo)info);
                this.submitMakeInvoiceWithNewTx(this.ctx, info);
                this.auditMakeInvoiceWithNewTx(this.ctx, info);
                continue;
            }
            catch (Throwable e) {
                String billType = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "UsedCarMakeInvoice", this.ctx.getLocale());
                String msgBillError = billType + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_BILL_ERROR", this.ctx.getLocale(), new Object[]{info.getNumber(), e.getMessage()});
                this.logger.error((Object)e.getMessage(), e);
                exList.add(new IMException(IMException.ERRORMSG, new Object[]{msgBillError}));
                errorIDs.add(billID);
            }
        }
        return errorIDs;
    }

    protected boolean submitMakeInvoiceWithNewTx(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, EASBizException {
        try {
            Method method = UsedCarMakeInvoiceControllerBean.class.getDeclaredMethod("_submit", Context.class, IObjectValue.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new UsedCarMakeInvoiceControllerBean());
            txInvoker.invoke(method, new Object[]{ctx, info}, 0);
            return true;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected boolean auditMakeInvoiceWithNewTx(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, EASBizException {
        try {
            Method method = UsedCarMakeInvoiceControllerBean.class.getDeclaredMethod("_audit", Context.class, IObjectPK.class, IObjectValue.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new UsedCarMakeInvoiceControllerBean());
            txInvoker.invoke(method, new Object[]{ctx, new ObjectUuidPK(info.getId().toString()), info}, 0);
            return true;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected void saveBillRelattion() throws BOSException, EASBizException {
        Map<String, String> groupIDMap = this.processDestBillRelation();
        if (groupIDMap.size() == 0) {
            return;
        }
        HashSet<String> allBizBillIDSet = new HashSet<String>();
        HashSet<String> allBizBillEntryIDSet = new HashSet<String>();
        String insertRelationSql = "insert into T_IM_MakeInvoiceRelation(FID, FSrcBosType, FBizBillID, FInvoiceBillID, FAmount, FQty, FGroupID, FOperateTime) values (?, ?, ?, ?, ?, ?, ?, ?)";
        String insertRelationEntrySql = "insert into T_IM_MakeInvoiceRelationEntry(FID,FParentID, FSrcObjectID, FSrcEntryID, FDestObjectID, FDestEntryID) values (?, ?, ?, ?, ?, ?)";
        String insertBotRalationSql = "insert into T_BOT_Relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FType,FDate,FisEffected) values(?,?,?,?,?,?,?,?,?)";
        Set keys = this.destBillRelation.keySet();
        Iterator iterator = keys.iterator();
        String groupID = BOSUuid.create((String)"55555555").toString();
        Timestamp operateTime = new Timestamp(new java.util.Date().getTime());
        HashSet<String> invoiceIdSet = new HashSet<String>();
        ArrayList<Object[]> relationParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> relationEntryParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> botRelationParamList = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            String makeBillID = (String)iterator.next();
            invoiceIdSet.add(makeBillID);
            ArrayList bizIds = (ArrayList)this.destBillRelation.get(makeBillID);
            Map<String, Set> bizEntryMap = this.destBillEntryRelation.get(makeBillID);
            relationParamList = new ArrayList();
            relationEntryParamList = new ArrayList();
            botRelationParamList = new ArrayList();
            for (int i = 0; i < bizIds.size(); ++i) {
                String bizId = bizIds.get(i).toString();
                String relationId = BOSUuid.create((String)"0EBBB5B4").toString();
                Object[] relationParam = new Object[]{relationId, this.invoiceReq.getBosType(), bizId, makeBillID, BigDecimal.ZERO, BigDecimal.ZERO, groupIDMap.get(bizIds.get(i).toString()) + groupID, operateTime};
                relationParamList.add(relationParam);
                Object[] botRelationParam = new Object[]{BOSUuid.create((String)"59302EC6").toString(), this.invoiceReq.getBosType(), "03DDCDAF", bizId, makeBillID, "unknown", 0, new Date(new java.util.Date().getTime()), 0};
                botRelationParamList.add(botRelationParam);
                allBizBillIDSet.add(bizId);
                if (bizEntryMap == null) continue;
                Set bizEntryIdSet = bizEntryMap.get(bizId);
                for (String bizEntryId : bizEntryIdSet) {
                    allBizBillEntryIDSet.add(bizEntryId);
                    Object[] relationEntryParam = new Object[]{BOSUuid.create((String)"0275D31E").toString(), relationId, bizId, bizEntryId, makeBillID, null};
                    relationEntryParamList.add(relationEntryParam);
                }
            }
            if (relationParamList.size() > 0) {
                DBUtil.executeBatch((Context)this.ctx, (String)"insert into T_IM_MakeInvoiceRelation(FID, FSrcBosType, FBizBillID, FInvoiceBillID, FAmount, FQty, FGroupID, FOperateTime) values (?, ?, ?, ?, ?, ?, ?, ?)", (Object[][])((Object[][])relationParamList.toArray((T[])new Object[relationParamList.size()][])));
            }
            if (relationEntryParamList.size() > 0) {
                DBUtil.executeBatch((Context)this.ctx, (String)"insert into T_IM_MakeInvoiceRelationEntry(FID,FParentID, FSrcObjectID, FSrcEntryID, FDestObjectID, FDestEntryID) values (?, ?, ?, ?, ?, ?)", (Object[][])((Object[][])relationEntryParamList.toArray((T[])new Object[relationEntryParamList.size()][])));
            }
            if (botRelationParamList.size() <= 0) continue;
            DBUtil.executeBatch((Context)this.ctx, (String)"insert into T_BOT_Relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FType,FDate,FisEffected) values(?,?,?,?,?,?,?,?,?)", (Object[][])((Object[][])botRelationParamList.toArray((T[])new Object[botRelationParamList.size()][])));
        }
        if ("0CADF79B".equals(this.invoiceReq.getBosType()) && allBizBillEntryIDSet.size() > 0) {
            String[] arr = allBizBillEntryIDSet.toArray(new String[allBizBillEntryIDSet.size()]);
            String updateSql = "update T_IM_UsedCarInvoiceReqEntry set FIsMakeInoviced = 1 where fid in" + IMUtils.getInStringFromArray(arr);
            DBUtil.executeUpdate((Context)this.ctx, (String)updateSql, null);
        }
    }

    protected Map<String, String> processDestBillRelation() throws BOSException {
        try {
            Set keys = this.destBillRelation.keySet();
            HashSet<String> existIDs = new HashSet<String>();
            HashSet<String> notExistIDs = new HashSet<String>();
            String selectSQL = "select fid from t_im_UsedCarmakeinvoice where fid in" + IMUtils.getInStringFromSet(keys);
            IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)selectSQL, null);
            while (rs.next()) {
                String mkBillID = rs.getString("fid");
                existIDs.add(mkBillID);
            }
            for (String id : keys) {
                if (existIDs.contains(id)) continue;
                notExistIDs.add(id);
            }
            keys.removeAll(notExistIDs);
            String ruleID = this.invoiceReq.getSrcCombinRuleID();
            CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, ruleID);
            String[] properties = new String[]{"id"};
            if (combinRule != null && combinRule.getCombinFields() != null) {
                properties = combinRule.getCombinFields().split("_");
            }
            ArrayList<String> headProp = new ArrayList<String>();
            for (int i = 0; i < properties.length; ++i) {
                String value = properties[i];
                String[] tempValue = value.split("\\.");
                if (tempValue.length > 1 || headProp.contains(value)) continue;
                headProp.add(value);
            }
            HashMap<String, String> groupIDMap = new HashMap<String, String>();
            Set allMkIDs = this.destBillRelation.keySet();
            Iterator ite = allMkIDs.iterator();
            HashSet bizIDSet = new HashSet();
            while (ite.hasNext()) {
                String makeBillID = (String)ite.next();
                ArrayList bizIds = (ArrayList)this.destBillRelation.get(makeBillID);
                bizIDSet.addAll(bizIds);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bizIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getCollection(BOSObjectType.create((String)this.invoiceReq.getBosType()), view);
            for (int i = 0; i < collection.size(); ++i) {
                IObjectValue object = collection.getObject(i);
                String groupID = IMUtils.buildKey(headProp, object);
                groupIDMap.put(object.get("id").toString(), groupID);
            }
            return groupIDMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void checkInvoiceReq() throws IMException {
        InvoiceReqUtils.checkInvoiceReq(this.invoiceReq, null);
    }
}

