/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RedMsgTypeEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.AbstractIMInvoiceRedFacadeControllerBean;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.ICustomerMailing;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMInvoiceRedFacadeControllerBean
extends AbstractIMInvoiceRedFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IMInvoiceRedFacadeControllerBean");

    protected MakeInvoiceInfo getBlueInvoice(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        String blueVoiceNum = mkInvoice.getBlueVoiceNum();
        String blueVoiceCode = mkInvoice.getBlueVoiceCode();
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        if (!StringUtils.isEmpty((String)blueVoiceNum) && !StringUtils.isEmpty((String)blueVoiceCode)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)blueVoiceNum, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)blueVoiceCode, CompareType.EQUALS));
            view.setFilter(filter);
            mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        }
        if (mkInvoiceCol.size() > 0) {
            return mkInvoiceCol.get(0);
        }
        return null;
    }

    @Override
    protected Map _parseDownLoadRedInvoice(Context ctx, String jsonStr) throws BOSException, EASBizException {
        HashSet<String> ztmSet = new HashSet<String>();
        ztmSet.add("TZD0000");
        ztmSet.add("01");
        ztmSet.add("04");
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        int successCount = 0;
        try {
            JSONArray jsonArray;
            JSONObject jsonData = new JSONObject(jsonStr);
            String errcode = this.getStringValue(jsonData, "errcode");
            if ("0000".equals(errcode) && (jsonArray = this.getJSONArray(jsonData, "lists")) != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    CompanyOrgUnitInfo company;
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    String ztm = this.getStringValue(jsonObj, "ztm");
                    if (!ztmSet.contains(ztm)) continue;
                    String hzxxbm = this.getStringValue(jsonObj, "hzxxbm");
                    MakeInvoiceInfo mkBill = MakeInvoiceInfo.createMakeInvoiceInfo();
                    JSONObject invoiceData = jsonObj.getJSONObject("invoice");
                    String kpzl = this.getStringValue(invoiceData, "kpzl");
                    if ("61".equals(kpzl)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE);
                    } else if ("26".equals(kpzl)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE);
                    } else if ("27".equals(kpzl)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE);
                    } else {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
                    }
                    String fpdm = this.getStringValue(invoiceData, "fpdm");
                    String fphm = this.getStringValue(invoiceData, "fphm");
                    String ghf_mc = this.getStringValue(invoiceData, "ghf_mc");
                    String ghf_nsrsbh = this.getStringValue(invoiceData, "ghf_nsrsbh");
                    String hjbhsje = this.getStringValue(invoiceData, "hjbhsje");
                    String jshjje = this.getStringValue(invoiceData, "jshjje");
                    String kphjse = this.getStringValue(invoiceData, "kphjse");
                    String hsbz = this.getStringValue(invoiceData, "hsbz");
                    String kprq = this.getStringValue(invoiceData, "kprq");
                    String xhf_mc = this.getStringValue(invoiceData, "xhf_mc");
                    String xhf_nsrsbh = this.getStringValue(invoiceData, "xhf_nsrsbh");
                    String xxblx = this.getStringValue(invoiceData, "xxblx");
                    if ("3".equals(xxblx)) {
                        mkBill.setIsVehicle(true);
                        mkBill.setRedMsgType(RedMsgTypeEnum.VEHICLE_DISCOUNT);
                    } else if ("2".equals(xxblx)) {
                        mkBill.setIsVehicle(true);
                        mkBill.setRedMsgType(RedMsgTypeEnum.VEHICLE_REJECT);
                    }
                    mkBill.setRedVoiceNumber(hzxxbm);
                    if (!"0000000000".equals(fpdm)) {
                        mkBill.setBlueVoiceCode(fpdm);
                    }
                    if (!"00000000".equals(fphm)) {
                        mkBill.setBlueVoiceNum(fphm);
                    }
                    if ((company = this.getDefaultCompany(ctx, mkBill, xhf_nsrsbh)) == null) continue;
                    mkBill.setCompany(company);
                    mkBill.setReceiveCompany(ghf_mc);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("taxNumber", ghf_nsrsbh);
                    params.put("invoiceType", "1");
                    params.put("companyId", company.getId().toString());
                    Map ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params);
                    CustomerTaxInfo custTaxInfo = (CustomerTaxInfo)ret.get("value");
                    if (custTaxInfo != null) {
                        mkBill.setCustomerTax(custTaxInfo);
                        mkBill.setTaxNumber(custTaxInfo.getTaxNumber());
                        mkBill.setAddress(custTaxInfo.getAddressTel());
                        mkBill.setBankAccount(custTaxInfo.getBankAccount());
                        mkBill.setCurrAcctCustomer(custTaxInfo.getCustomer());
                        mkBill.setCurrentAccountType(CurrentAccountType.CUSTOMER);
                        if (mkBill.getCurrAcctCustomer() != null && mkBill.getCurrAcctCustomer().getId() != null) {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("comOrgUnitId", mkBill.getCompany() == null ? null : mkBill.getCompany().getId().toString());
                            param.put("customerId", mkBill.getCurrAcctCustomer().getId().toString());
                            ICustomerMailing iCustomerMailing = CustomerMailingFactory.getLocalInstance(ctx);
                            Map entryMap = iCustomerMailing.getDefaultCustomerMailInfo(param);
                            CustomerMailingEntryInfo cmEntryInfo = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
                            if (cmEntryInfo != null) {
                                mkBill.setDisInvoicer(cmEntryInfo.getContacts());
                                mkBill.setCellphone(cmEntryInfo.getTelephone());
                                mkBill.setMailNumber(cmEntryInfo.getPostalcode());
                                mkBill.setRecBillComName(cmEntryInfo.getCompanyName());
                                mkBill.setRecBillAdress(cmEntryInfo.getAddress());
                                mkBill.setRecBillEmail(cmEntryInfo.getMailbox());
                            }
                        }
                    }
                    mkBill.setTaxNumber(ghf_nsrsbh);
                    mkBill.setNoTaxAmtTotal(new BigDecimal(hjbhsje));
                    mkBill.setIsContainTax("1".equals(hsbz));
                    mkBill.setPriceTaxTotal(new BigDecimal(jshjje));
                    mkBill.setTaxAmtTotal(new BigDecimal(kphjse));
                    mkBill.setApplicateDate(new Date());
                    mkBill.setSrcSystem(InvoiceSrcSystem.DOWNLOAD);
                    mkBill.setStatus(InvoiceBillStatus.TEMPSTROE);
                    mkBill.setIsRedVoice(true);
                    String redReqNumber = mkBill.getRedVoiceNumber();
                    String str = IMUtils.getIMResource(ctx, "RED_INVOICE_REMORK", new String[0]) + redReqNumber;
                    mkBill.setRemark(str);
                    JSONArray items = invoiceData.getJSONArray("items");
                    boolean isContainTax = mkBill.isIsContainTax();
                    for (int m = 0; m < items.length(); ++m) {
                        JSONObject taxCode;
                        JSONObject item = items.getJSONObject(m);
                        MakeInvoiceEntryInfo entryInfo = MakeInvoiceEntryInfo.createMakeInvoiceEntryInfo(mkBill);
                        String ggxh = this.getStringValue(item, "ggxh");
                        String se = this.getBigDecimalValue(this.getStringValue(item, "se"));
                        String sl = this.getBigDecimalValue(this.getStringValue(item, "sl"));
                        String spbm = this.getStringValue(item, "spbm");
                        String xmdj = this.getBigDecimalValue(this.getStringValue(item, "xmdj"));
                        if (xmdj == null) {
                            xmdj = "0";
                        }
                        String xmdw = this.getStringValue(item, "xmdw");
                        String xmje = this.getBigDecimalValue(this.getStringValue(item, "xmje"));
                        String xmmc = this.getStringValue(item, "xmmc");
                        String xmsl = this.getBigDecimalValue(this.getStringValue(item, "xmsl"));
                        if (xmsl == null) {
                            xmsl = "0";
                        }
                        if ((taxCode = item.getJSONObject("taxcode")).get("kce") != null && !"".equals(taxCode.get("kce"))) {
                            String kce = this.getBigDecimalValue(this.getStringValue(taxCode, "kce"));
                            entryInfo.setDeductAmt(new BigDecimal(kce));
                            mkBill.setIsDiffTax(true);
                        }
                        String ssflbm = this.getStringValue(taxCode, "ssflbm");
                        entryInfo.setTaxClassificationCode(ssflbm);
                        if (ssflbm != null && ssflbm.length() == 19) {
                            EntityViewInfo taxClassView = new EntityViewInfo();
                            FilterInfo taxClassFilter = new FilterInfo();
                            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)ssflbm, CompareType.EQUALS));
                            taxClassView.setFilter(taxClassFilter);
                            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
                            if (taxClassColl != null && taxClassColl.size() > 0) {
                                TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                                entryInfo.setTaxClassName(taxClassInfo.getName());
                            }
                        }
                        ggxh = IMUtils.cutStr(ggxh, 40);
                        entryInfo.setSpecs(ggxh);
                        entryInfo.setTaxAmt(new BigDecimal(se));
                        entryInfo.setTaxRate(new BigDecimal(sl));
                        EntityViewInfo unitView = new EntityViewInfo();
                        FilterInfo unitFilter = new FilterInfo();
                        unitFilter.getFilterItems().add(new FilterItemInfo("name", (Object)xmdw));
                        unitView.setFilter(unitFilter);
                        MeasureUnitCollection collection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitView);
                        MeasureUnitInfo unitInfo = null;
                        if (collection != null && collection.size() > 0) {
                            unitInfo = collection.get(0);
                        }
                        entryInfo.setMeasureUnit(unitInfo);
                        entryInfo.setMakeInvoiceUnit(xmdw);
                        if (!StringUtils.isEmpty((String)xmmc)) {
                            String[] xmmcStr = xmmc.split("\\*");
                            if (xmmcStr.length > 1) {
                                entryInfo.setTaxClassName(xmmcStr[1]);
                                entryInfo.setProduceName(xmmc.substring(xmmc.indexOf("*", 1) + 1));
                            } else {
                                entryInfo.setProduceName(xmmc);
                            }
                        }
                        BigDecimal downPrice = new BigDecimal(xmdj);
                        if (isContainTax) {
                            entryInfo.setPrice(downPrice);
                            entryInfo.setNoTaxPrice(downPrice.divide(entryInfo.getTaxRate().add(BigDecimal.ONE), 10, 4));
                        } else {
                            entryInfo.setNoTaxPrice(downPrice);
                            entryInfo.setPrice(downPrice.multiply(entryInfo.getTaxRate().add(BigDecimal.ONE)).setScale(10, 4));
                        }
                        entryInfo.setNoTaxAmt(new BigDecimal(xmje));
                        entryInfo.setQuantity(new BigDecimal(xmsl));
                        entryInfo.setPriceTax(entryInfo.getTaxAmt().add(entryInfo.getNoTaxAmt()));
                        entryInfo.setDiscountAmt(BigDecimal.ZERO);
                        entryInfo.setDiscountRate(BigDecimal.ZERO);
                        mkBill.getEntries().add(entryInfo);
                    }
                    if (!this.checkExists(ctx, mkBill)) {
                        MakeInvoiceFactory.getLocalInstance(ctx).addnew(mkBill);
                        this.buildBOTRelations(ctx, mkBill);
                    } else {
                        --successCount;
                    }
                    String companyId = company.getId().toString();
                    if (retMap.containsKey(companyId)) {
                        retMap.put(companyId, (Integer)retMap.get(companyId) + 1);
                    } else {
                        retMap.put(companyId, 1);
                    }
                    ++successCount;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        retMap.put("successCount", successCount < 0 ? 0 : successCount);
        return retMap;
    }

    private CompanyOrgUnitInfo getDefaultCompany(Context ctx, MakeInvoiceInfo invoice, String taxNumber) throws BOSException {
        CompanyOrgUnitInfo cou = null;
        if (invoice == null || StringUtils.isEmpty((String)taxNumber)) {
            return null;
        }
        MakeInvoiceInfo blueInvoice = this.getBlueInvoice(ctx, invoice);
        if (blueInvoice != null) {
            cou = blueInvoice.getCompany();
        } else {
            CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)ctx.get((Object)"ctx_company");
            String currentTaxNumber = currentCompany.getTaxNumber();
            if (!StringUtils.isEmpty((String)currentTaxNumber)) {
                currentTaxNumber = currentTaxNumber.trim();
            }
            if (taxNumber.equals(currentTaxNumber)) {
                cou = currentCompany;
            }
        }
        return cou;
    }

    private void buildBOTRelations(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        String blueVoiceNum = mkInvoice.getBlueVoiceNum();
        String blueVoiceCode = mkInvoice.getBlueVoiceCode();
        String srcBillID = "";
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        if (!StringUtils.isEmpty((String)blueVoiceNum) && !StringUtils.isEmpty((String)blueVoiceCode)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)blueVoiceNum, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)blueVoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)false, CompareType.EQUALS));
            view.setFilter(filter);
            mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
            if (mkInvoiceCol.size() > 0) {
                srcBillID = mkInvoiceCol.get(0).getId().toString();
                String destBillID = mkInvoice.getId().toString();
                String bostype = mkInvoice.getBOSType().toString();
                if (srcBillID != null && !IMUtils.hasBotpRelation(ctx, srcBillID, destBillID, bostype, bostype)) {
                    IMUtils.traceUpAndDown(ctx, srcBillID, destBillID, bostype, bostype);
                }
            }
        }
    }

    protected JSONArray getJSONArray(JSONObject data, String key) {
        JSONArray value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONArray(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getStringValue(JSONObject data, String key) {
        String value = null;
        if (data.has(key)) {
            try {
                String valueStr = data.getString(key);
                if (valueStr != null && valueStr.length() > 0) {
                    value = valueStr;
                }
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getBigDecimalValue(String valueStr) {
        String value = "0";
        if (valueStr != null && valueStr.length() > 0) {
            value = valueStr;
        }
        return value;
    }

    private boolean checkExists(Context ctx, MakeInvoiceInfo mkBill) throws BOSException {
        String redVoiceNumber = mkBill.getRedVoiceNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("redVoiceNumber", (Object)redVoiceNumber));
        view.setFilter(filter);
        MakeInvoiceCollection makeInvoiceCollection = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        return makeInvoiceCollection != null && makeInvoiceCollection.size() > 0;
    }
}

