/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.webservice.app.util.EipWebServiceTaskUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.common.app.service.BillVoucherService;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsFactory;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceException;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.AbstractIncomeInvoiceControllerBean;
import com.kingdee.eas.tm.im.app.incomeinvoice.action.DelInvoiceAction;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.NonCompliantInvoiceUtils;
import com.kingdee.eas.tm.im.util.rim.RIMUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class IncomeInvoiceControllerBean
extends AbstractIncomeInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IncomeInvoiceControllerBean");
    private static final BigDecimal zeroValue = new BigDecimal(0);
    private static final String INCOMEINVOICE_BOSTYPE = "1343913D";
    private static final String TAXTRANSFER_BOSTYPE = "573282EF";
    private static final String NEXTLINE = ";\r\n";
    private LowTimer timer = new LowTimer();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo income = (IncomeInvoiceInfo)model;
        if (income.getCompany() == null) throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
        try {
            if (!("2".equals(income.getResourceType().getValue()) || "3".equals(income.getResourceType().getValue()) || "4".equals(income.getResourceType().getValue()))) {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(income.getCompany().getId().toString(), "im_incomeInvoice_new");
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        this.setNumber(model);
        this.traceUpAndDown(ctx, model);
        this.updateSupplierByTaxNumber(ctx, model);
        this.setSupplierByTaxNo(ctx, model);
        this.updatetaxClassificationCodeByTaxClassificationNumber(ctx, model);
        this.setTmInvoiceType(model);
        this.setStatus(model);
        this.updateCheckAbs(ctx, model);
        this.setCheckStatus(model);
        this.updateNonCompliantInvoice(ctx, model);
        return super._addnew(ctx, model);
    }

    private void setSupplierByTaxNo(Context ctx, IObjectValue model) throws BOSException {
        String remark;
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        String taxRegisterNoStr = "";
        String taxRegisterNo = "";
        HashMap dataValue = new HashMap();
        if (info.getCurrAcctSupplier() == null && info.isIsIssue() && !IMUtils.isEmpty(remark = info.getDescription())) {
            String issueTaxNo = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ISSUETAXNO", (Locale)ctx.getLocale());
            String issueTaxName = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ISSUETAXNAME", (Locale)ctx.getLocale());
            int taxNoIndex = remark.indexOf(issueTaxNo);
            int taxNameIndex = remark.indexOf(issueTaxName);
            if (taxNoIndex > -1 && taxNameIndex > -1 && taxNameIndex > taxNoIndex) {
                taxRegisterNoStr = remark.substring(taxNoIndex + 6, taxNameIndex);
                String regEx = "[^0-9A-Z]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(taxRegisterNoStr);
                taxRegisterNo = m.replaceAll("").trim();
            }
            if (!IMUtils.isEmpty(taxRegisterNo)) {
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT FID as id FROM T_BD_Supplier AS supplier  where FTaxRegisterNo='");
                sql.append(taxRegisterNo);
                sql.append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        SupplierInfo supplierInfo = new SupplierInfo();
                        supplierInfo.setId(BOSUuid.read((String)rs.getString("id")));
                        info.setCurrAcctSupplier(supplierInfo);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void setTmInvoiceType(IObjectValue model) {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (TMInvoiceType.INVOICETYPE_COMMON_PAPER_ROLL.equals((Object)info.getTmInvoiceType())) {
            return;
        }
        if (info.getInvoiceType() == PayInvoiceTypeEnum.COMMONINVOICE) {
            info.setTmInvoiceType(TMInvoiceType.INVOICETYPE_COMMON_PAPER);
        } else if (info.getInvoiceType() == PayInvoiceTypeEnum.ELECTRONICINVOICE) {
            info.setTmInvoiceType(TMInvoiceType.INVOICETYPE_COMMON_ELECTRONIC);
        } else if (info.getInvoiceType() == PayInvoiceTypeEnum.VALUEADDEDTAXINV) {
            info.setTmInvoiceType(TMInvoiceType.INVOICETYPE_SPECIAL_PAPER);
        } else if (info.getInvoiceType() == PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE) {
            info.setTmInvoiceType(TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL);
        }
    }

    private void setNumber(IObjectValue model) {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        info.setNumber(info.getInvoiceCode() + "_" + info.getInvoiceNumber());
    }

    private void traceUpAndDown(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo invoiceInfo = (IncomeInvoiceInfo)model;
        IncomeInvoiceInfo srcInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceInvoiceCode", (Object)invoiceInfo.getInvoiceCode(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceInvoiceNumber", (Object)invoiceInfo.getInvoiceNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCreditNote", (Object)new Boolean(true), CompareType.EQUALS));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        if (coll != null && coll.size() > 0) {
            srcInfo = coll.get(0);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID from T_BOT_Relation WHERE FDESTENTITYID ='1343913D' AND FSRCENTITYID='1343913D'");
            sql.append(" AND FSRCOBJECTID = '").append(srcInfo.getId().toString()).append("'");
            sql.append(" AND FDESTOBJECTID = '").append(invoiceInfo.getId().toString()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) {
                    IMUtils.traceUpAndDown(ctx, srcInfo.getId().toString(), INCOMEINVOICE_BOSTYPE, invoiceInfo.getId().toString(), INCOMEINVOICE_BOSTYPE);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        IncomeInvoiceInfo income = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceInfo(pk);
        if (!income.getBizDate().equals(info.getBizDate())) {
            this.setDueDate(info);
        }
        this.setNumber((IObjectValue)income);
        this.updateSupplierByTaxNumber(ctx, (IObjectValue)info);
        this.setSupplierByTaxNo(ctx, (IObjectValue)info);
        this.setTmInvoiceType((IObjectValue)model);
        this.setStatus((IObjectValue)income);
        this.updateCheckAbs(ctx, (IObjectValue)info);
        this.setCheckStatus((IObjectValue)model);
        this.updateNonCompliantInvoice(ctx, (IObjectValue)model);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DelInvoiceAction delInvoiceAction = new DelInvoiceAction(ctx);
        ActionParam params = new ActionParam();
        params.setInvoiceId(pk.toString());
        delInvoiceAction.execute(IncomeInvoiceActionTypeEnum.SAME, params);
        HashSet<String> ids = new HashSet<String>();
        ids.add(pk.toString());
        this.deleteByInvoiceIDs(ctx, ids);
    }

    private void setDueDate(IncomeInvoiceInfo info) {
        Date bizDate = info.getBizDate();
        Date dueDate = DateTimeUtils.addDay((Date)bizDate, (long)360L);
        info.setDueDate(dueDate);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.inComeInvoiceSave(ctx, model);
    }

    private IObjectPK inComeInvoiceSave(Context ctx, IObjectValue model) throws EASBizException, BOSException, IMException {
        IncomeInvoiceInfo income = (IncomeInvoiceInfo)model;
        this.verify(ctx, income);
        this.putBillValues(ctx, income);
        this.setDueDate(income);
        this.setNumber((IObjectValue)income);
        this.updateSupplierByTaxNumber(ctx, model);
        this.setSupplierByTaxNo(ctx, model);
        this.updatetaxClassificationCodeByTaxClassificationNumber(ctx, model);
        this.setTmInvoiceType(model);
        this.setStatus((IObjectValue)income);
        this.updateCheckAbs(ctx, model);
        this.setCheckStatus(model);
        this.updateNonCompliantInvoice(ctx, model);
        if (ctx.get((Object)"isFromCPBC") != null) {
            return this._saveIgnorePermission(ctx, (IObjectValue)income);
        }
        return super._save(ctx, (IObjectValue)income);
    }

    protected IObjectPK _saveIgnorePermission(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        IObjectPK retValue = null;
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            retValue = new ObjectUuidPK(coreBaseInfo.getId());
            this._update(ctx, retValue, (IObjectValue)coreBaseInfo);
            return retValue;
        }
        try {
            retValue = this._addnew(ctx, (IObjectValue)coreBaseInfo);
        }
        catch (BOSException e) {
            this.handlerEffectDateException(ctx, e);
        }
        return retValue;
    }

    private void setStatus(IObjectValue model) {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (info.getAmount() != null && info.getAmount().compareTo(BigDecimal.ZERO) < 0) {
            info.setIsCreditNote(true);
        }
    }

    private void setCheckStatus(IObjectValue model) {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (info.getCheckStatus() == null) {
            info.setCheckStatus(TMCheckStatus.UNVERIFIED);
        }
    }

    private void putBillValues(Context ctx, IncomeInvoiceInfo income) throws EASBizException, BOSException {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amountTax = BigDecimal.ZERO;
        IncomeInvoiceEntryCollection entries = income.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            amount = amount.add(entries.get(i).getMoney() != null ? entries.get(i).getMoney() : BigDecimal.ZERO);
            tax = tax.add(entries.get(i).getTaxAmt() != null ? entries.get(i).getTaxAmt() : BigDecimal.ZERO);
            amountTax = amountTax.add(entries.get(i).getTaxTotal() != null ? entries.get(i).getTaxTotal() : BigDecimal.ZERO);
        }
        if (!entries.isEmpty()) {
            income.setAmount(amount);
            income.setTax(tax);
            income.setAmountTax(amountTax);
        }
        if (income.getCheckAbs() != null) {
            CheckAbsInfo checkAbs = income.getCheckAbs();
            if (!PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)income.getInvoiceType()) && !PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)income.getInvoiceType())) {
                income.getCheckAbs().setEffectiveTaxAmt(null);
            }
            CheckAbsFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)checkAbs);
        }
    }

    private void verify(Context ctx, IncomeInvoiceInfo income) throws BOSException, IMException {
        StringBuffer errorMsg = new StringBuffer();
        if (income.getInvoiceCode() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "INCOMECODEISNULL", new String[0])).append(";");
        }
        IncomeInvoiceEntryCollection entries = income.getEntries();
        if (!("2".equals(income.getResourceType().getValue()) || entries != null && entries.size() != 0)) {
            errorMsg.append(IMUtils.getIMResource(ctx, "NOENTRY", new String[0])).append(";");
        } else {
            for (int idx = 0; idx < entries.size(); ++idx) {
                StringBuffer lineMsg = new StringBuffer();
                IncomeInvoiceEntryInfo entry = entries.get(idx);
                if (entry.getMoney() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "NOTAXAMOUTISNULL", new String[0]));
                }
                if (entry.getTaxAmt() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "TAXAMTISNULL", new String[0]));
                }
                if (entry.getTaxTotal() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "PRICETAXISNULL", new String[0]));
                }
                if (lineMsg.length() <= 0) continue;
                errorMsg.append(IMUtils.getIMResource(ctx, "ENTRYLINE", idx + 1 + "")).append(lineMsg.toString().substring(1)).append(";");
            }
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        String code = income.getInvoiceCode();
        String number = income.getInvoiceNumber();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)code, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        IncomeInvoiceCollection invoiceCollection = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        if (!invoiceCollection.isEmpty()) {
            logger.error((Object)("IncomeInvoiceControllerBean:INCOMEREPETITION: invoiceCode:" + code + " invoiceNumber:" + number));
        }
        if (income.getId() != null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)code, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)income.getId().toString(), CompareType.NOTEQUALS));
            view.setFilter(filter);
        }
        if (!(invoiceCollection = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view)).isEmpty()) {
            throw new IMException(IMException.INCOMEREPETITION);
        }
    }

    @Override
    protected Map _getInvoiceCount(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap<String, Integer> billCount = new HashMap<String, Integer>();
        try {
            String idStr = this.splitCompanyId(companyID);
            String sql = "SELECT count(FID) FCount FROM T_IM_IncomeInvoice WHERE FCompanyId in ('" + idStr + "')  AND FAuthenticateStatus = '" + "0" + "'  AND fisReceive = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt("FCount");
            }
            billCount.put(IncomeAuthenticateStatusEnum.UNAUTHORIZED.toString(), count);
            sql = "SELECT count(FID) FCount FROM T_IM_IncomeInvoice WHERE FCompanyId in ('" + idStr + "')  AND FAuthenticateStatus = '" + "2" + "' ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            count = 0;
            while (rs.next()) {
                count = rs.getInt("FCount");
            }
            billCount.put(IncomeAuthenticateStatusEnum.PASSED.toString(), count);
            sql = "SELECT count(FID) FCount FROM T_IM_IncomeInvoice WHERE FCompanyId in ('" + idStr + "')  AND (fisReceive = 0 or fisReceive is NULL)";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            count = 0;
            while (rs.next()) {
                count = rs.getInt("FCount");
            }
            billCount.put("UNRECEIVE", count);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billCount;
    }

    private String splitCompanyId(String companyId) {
        StringBuffer sb = new StringBuffer();
        String[] companys = companyId.split(",");
        for (int i = 0; i < companys.length; ++i) {
            sb.append("','").append(companys[i]);
        }
        return sb.substring(3);
    }

    @Override
    protected IObjectPK _importSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.preHandlerInvoice(ctx, (IncomeInvoiceInfo)model);
        this.putBillValues(ctx, (IncomeInvoiceInfo)model);
        return this._save(ctx, model);
    }

    private void preHandlerInvoice(Context ctx, IncomeInvoiceInfo income) throws EASBizException, BOSException {
        IncomeInvoiceEntryCollection entries = income.getEntries();
        int size = entries.size();
        if (size == 0) {
            return;
        }
        CompanyOrgUnitInfo company = income.getCompany();
        if (company == null) {
            return;
        }
        int pricePrecision = this.getPricePrecision(ctx, company.getId().toString());
        for (int idx = 0; idx < size; ++idx) {
            IncomeInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal quantity = entry.getQuantity();
            BigDecimal taxExcluded = entry.getTaxExcluded();
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal money = entry.getMoney();
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal taxAmt = entry.getTaxAmt();
            BigDecimal taxTotal = entry.getTaxTotal();
            if (taxRate == null || taxRate.compareTo(zeroValue) == 0) continue;
            if (taxPrice == null && taxExcluded != null) {
                taxPrice = taxExcluded.multiply(new BigDecimal(1).add(taxRate)).setScale(pricePrecision, 6);
                entry.setTaxPrice(taxPrice);
            }
            if (taxExcluded == null && taxPrice != null) {
                taxExcluded = taxPrice.divide(new BigDecimal(1).add(taxRate), pricePrecision, 6);
                entry.setTaxExcluded(taxExcluded);
            }
            if (quantity != null && quantity.compareTo(zeroValue) != 0 && taxExcluded != null && money == null) {
                money = taxExcluded.multiply(new BigDecimal(1).add(quantity)).setScale(2, 6);
            }
            if (money == null && taxTotal != null) {
                money = taxTotal.divide(new BigDecimal(1).add(taxRate), 2, 6);
                entry.setMoney(money);
            }
            if (taxTotal == null && money != null) {
                taxTotal = money.multiply(new BigDecimal(1).add(taxRate)).setScale(2, 6);
                entry.setTaxTotal(taxTotal);
            }
            if (taxAmt != null || money == null) continue;
            taxAmt = money.multiply(taxRate).setScale(2, 6);
            entry.setTaxAmt(taxAmt);
        }
    }

    private int getPricePrecision(Context ctx, String companyId) throws EASBizException, BOSException {
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM001"}).intValue();
    }

    @Override
    protected boolean _setUseing(Context ctx, ArrayList ids, String useing) throws BOSException, EASBizException {
        String id = IMUtils.getInStringFromList(ids);
        String selectSql = " select top 1 fid from T_IM_IncomeInvoice where fid in " + id + " and FBelongTaxPeriodID is not null";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql, null);
        try {
            if (rs.next()) {
                throw new IMException(IMException.SET_USEING_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSql = " update T_IM_IncomeInvoice set FUseing = ? where fid = ?";
        Object[][] params = new Object[ids.size()][2];
        for (int i = 0; i < ids.size(); ++i) {
            String inInoviceId = ids.get(i).toString();
            params[i][0] = useing;
            params[i][1] = inInoviceId;
        }
        DBUtil.executeBatch((Context)ctx, (String)updateSql, (Object[][])params);
        return true;
    }

    @Override
    protected Map _setDeduct(Context ctx, ArrayList ids, String deduct) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId,FInvoiceNumber,FInvoiceCode,FCompanyID from t_im_IncomeInvoice where fid in ");
        sql.append(IMUtils.getInStringFromList(ids));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
        IIMFacade iMFacade = IMFacadeFactory.getLocalInstance(ctx);
        StringBuffer msg = new StringBuffer();
        int successNum = 0;
        int errorNum = 0;
        try {
            while (rs.next()) {
                String FId = rs.getString("FId");
                String FCompanyID = rs.getString("FCompanyID");
                if (permissionMap.containsKey(FCompanyID)) {
                    if (!((Boolean)permissionMap.get(FCompanyID)).booleanValue()) {
                        ++errorNum;
                        continue;
                    }
                } else {
                    try {
                        iMFacade.checkFunctionPermission(FCompanyID, "im_incomeinvoice_setdeduct");
                        permissionMap.put(FCompanyID, true);
                    }
                    catch (Exception e) {
                        msg.append(e.getMessage());
                        permissionMap.put(FCompanyID, false);
                        ++errorNum;
                        continue;
                    }
                }
                String FInvoiceNumber = rs.getString("FInvoiceNumber");
                String FInvoiceCode = rs.getString("FInvoiceCode");
                String instanceDetail = ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"instanceDeatil", (Locale)ctx.getLocale(), (Object[])new Object[]{FInvoiceCode, FInvoiceNumber});
                IObjectPK logPk = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"im_incomeInvoice_setdeduct", (Locale)ctx.getLocale()), BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE), (IObjectPK)new ObjectUuidPK(FId), instanceDetail, "im_incomeInvoice_setdeduct", FCompanyID);
                StringBuffer sb = new StringBuffer();
                if (StringUtils.isEmpty((String)deduct) || "0".equals(deduct)) {
                    sb.append(" update T_IM_IncomeInvoice set FIsDeduct = null");
                } else {
                    sb.append(" update T_IM_IncomeInvoice set FIsDeduct ='");
                    sb.append(deduct);
                    sb.append("'");
                }
                sb.append(" where fid ='");
                sb.append(FId).append("' ");
                DbUtil.execute((Context)ctx, (String)sb.toString());
                LogUtils.afterLog(ctx, logPk);
                ++successNum;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("successNum", successNum);
        result.put("errorNum", errorNum);
        if (msg.length() > 0) {
            result.put("errorMsg", msg.toString());
        }
        return result;
    }

    @Override
    protected Map _setIncomeType(Context ctx, ArrayList ids, String FIncomeTypeID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId,FInvoiceNumber,FInvoiceCode,FCompanyID from t_im_IncomeInvoice where fid in ");
        sql.append(IMUtils.getInStringFromList(ids));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
        IIMFacade iMFacade = IMFacadeFactory.getLocalInstance(ctx);
        StringBuffer msg = new StringBuffer();
        int successNum = 0;
        int errorNum = 0;
        try {
            while (rs.next()) {
                String FId = rs.getString("FId");
                String FCompanyID = rs.getString("FCompanyID");
                if (permissionMap.containsKey(FCompanyID)) {
                    if (!((Boolean)permissionMap.get(FCompanyID)).booleanValue()) {
                        ++errorNum;
                        continue;
                    }
                } else {
                    try {
                        iMFacade.checkFunctionPermission(FCompanyID, "im_incomeinvoice_setincometype");
                        permissionMap.put(FCompanyID, true);
                    }
                    catch (Exception e) {
                        msg.append(e.getMessage()).append("\n");
                        permissionMap.put(FCompanyID, false);
                        ++errorNum;
                        continue;
                    }
                }
                String FInvoiceNumber = rs.getString("FInvoiceNumber");
                String FInvoiceCode = rs.getString("FInvoiceCode");
                String instanceDetail = ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"instanceDeatil", (Locale)ctx.getLocale(), (Object[])new Object[]{FInvoiceCode, FInvoiceNumber});
                IObjectPK logPk = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"im_incomeInvoice_setincometype", (Locale)ctx.getLocale()), BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE), (IObjectPK)new ObjectUuidPK(FId), instanceDetail, "im_incomeInvoice_setincometype", FCompanyID);
                StringBuffer sb = new StringBuffer();
                sb.append(" update T_IM_IncomeInvoice set FIncomeTypeID ='");
                sb.append(FIncomeTypeID);
                sb.append("'");
                sb.append(" where fid ='");
                sb.append(FId).append("' ");
                DbUtil.execute((Context)ctx, (String)sb.toString());
                LogUtils.afterLog(ctx, logPk);
                ++successNum;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("successNum", successNum);
        result.put("errorNum", errorNum);
        if (msg.length() > 0) {
            result.put("errorMsg", msg.toString());
        }
        return result;
    }

    private void updateSupplierByTaxNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (info.getCurrAcctSupplier() == null) {
            String taxNumber = info.getTaxNumber();
            String companyId = info.getCompany().getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT SUPPLIER.FID AS id FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" LEFT OUTER JOIN  T_BD_SupplierCompanyInfo AS SUPCOMPANY ON  SUPPLIER.FID = SUPCOMPANY.FSupplierID ");
            sql.append(" WHERE SUPCOMPANY.FComOrgID = '").append(companyId).append("' ");
            sql.append(" AND SUPPLIER.FTaxRegisterNo = '").append(taxNumber).append("'");
            sql.append(" AND SUPPLIER.FUsedStatus = '1'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    SupplierInfo supplierInfo = new SupplierInfo();
                    supplierInfo.setId(BOSUuid.read((String)rs.getString("id")));
                    info.setCurrAcctSupplier(supplierInfo);
                } else {
                    info.setCurrAcctSupplier(null);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _setSupplier(Context ctx, ArrayList ids, String FCurrAcctSupplierID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID, FInvoiceNumber FROM T_IM_IncomeInvoice where FBizBIllTypeID = '9Rg2HWkfSP6nrCBS+MJLEEUgBI8=' and FID in ");
        sql.append(IMUtils.getInStringFromList(ids));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> invalidIDs = new HashSet<String>();
        HashSet<String> invalidNums = new HashSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                invalidIDs.add(rs.getString("FID"));
                invalidNums.add(rs.getString("FInvoiceNumber"));
            }
            ids.removeAll(invalidIDs);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!invalidNums.isEmpty()) {
            throw new IncomeInvoiceException(IncomeInvoiceException.SETSUPPLIERERROR, new Object[]{IMUtils.getInStringFromSet(invalidNums)});
        }
        HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
        IIMFacade iMFacade = IMFacadeFactory.getLocalInstance(ctx);
        StringBuffer msg = new StringBuffer();
        int successNum = 0;
        int errorNum = 0;
        if (!ids.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("select FID,FInvoiceNumber,FInvoiceCode,FCompanyID from t_im_IncomeInvoice where fid in ");
            sb.append(IMUtils.getInStringFromList(ids));
            IRowSet res = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (res.next()) {
                    String FID = res.getString("FID");
                    String FCompanyID = res.getString("FCompanyID");
                    if (permissionMap.containsKey(FCompanyID)) {
                        if (!((Boolean)permissionMap.get(FCompanyID)).booleanValue()) {
                            ++errorNum;
                            continue;
                        }
                    } else {
                        try {
                            iMFacade.checkFunctionPermission(FCompanyID, "im_incomeinvoice_setsupplier");
                            permissionMap.put(FCompanyID, true);
                        }
                        catch (Exception e) {
                            msg.append(e.getMessage());
                            permissionMap.put(FCompanyID, false);
                            ++errorNum;
                            continue;
                        }
                    }
                    String FInvoiceNumber = res.getString("FInvoiceNumber");
                    String FInvoiceCode = res.getString("FInvoiceCode");
                    String instanceDetail = ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"instanceDeatil", (Locale)ctx.getLocale(), (Object[])new Object[]{FInvoiceCode, FInvoiceNumber});
                    IObjectPK logPk = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"im_incomeInvoice_setsupplier", (Locale)ctx.getLocale()), BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE), (IObjectPK)new ObjectUuidPK(FID), instanceDetail, "im_incomeInvoice_setsupplier", FCompanyID);
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append(" update T_IM_IncomeInvoice set FCurrAcctSupplierID = '");
                    updateSql.append(FCurrAcctSupplierID);
                    updateSql.append("'");
                    updateSql.append(" where fid ='");
                    updateSql.append(FID).append("' ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    LogUtils.afterLog(ctx, logPk);
                    ++successNum;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        result.put("successNum", successNum);
        result.put("errorNum", errorNum);
        if (msg.length() > 0) {
            result.put("errorMsg", msg.toString());
        }
        return result;
    }

    @Override
    protected Set _getSupplierIds(Context ctx, Set companyIds) throws BOSException, EASBizException {
        this.timer.reset();
        logger.error((Object)("enter method _getSupplierIds." + this.timer.msValue()));
        this.timer.reset();
        StringBuffer sql = new StringBuffer();
        String companyIDs = IMUtils.getInMarkStringFromSet(companyIds);
        HashSet<String> ids = new HashSet<String>();
        if (IMUtils.isEmpty(companyIDs)) {
            return ids;
        }
        if (companyIds.size() > 1) {
            sql.append(" SELECT companyInfo.FSupplierID as id,count(1) as count FROM T_BD_SupplierCompanyInfo companyInfo ");
            sql.append(" INNER  JOIN T_BD_Supplier supplier on supplier.fid = companyInfo.FSupplierID");
            sql.append(" where supplier.FUsedStatus=").append(1);
            sql.append(" and companyInfo.FUsingStatus=").append(0);
            sql.append(" and companyInfo.FComOrgID in " + companyIDs);
            sql.append(" group by FSupplierID ");
        } else {
            sql.append(" SELECT companyInfo.FSupplierID as id FROM T_BD_SupplierCompanyInfo  companyInfo");
            sql.append(" INNER  JOIN T_BD_Supplier supplier on supplier.fid = companyInfo.FSupplierID");
            sql.append(" where supplier.FUsedStatus=").append(1);
            sql.append(" and companyInfo.FUsingStatus=").append(0);
            sql.append(" and companyInfo.FComOrgID in " + companyIDs);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyIds.toArray(new Object[companyIds.size()]));
        try {
            while (rs.next()) {
                if (companyIds.size() != 1 && (companyIds.size() <= 1 || rs.getInt("count") != companyIds.size()) || rs.getString("id") == null || rs.getString("id") == null) continue;
                ids.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.error((Object)("exit method _getSupplierIds." + this.timer.msValue()));
        this.timer.reset();
        return ids;
    }

    @Override
    protected boolean _checkPermission(Context ctx, Set companyIds, String permissionItemName) throws BOSException, EASBizException {
        boolean flag = true;
        for (Object companyId : companyIds) {
            flag = IMFacadeFactory.getLocalInstance(ctx).hasFunctionPermission((String)companyId, permissionItemName);
            if (flag) continue;
            return flag;
        }
        return flag;
    }

    @Override
    protected Map _downLoadInvoice(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        String parserClass = (String)params.get("parserClass");
        CoreBaseCollection invoiceColl = new CoreBaseCollection();
        try {
            Class<?> clazz = Class.forName(parserClass);
            AbstractIncomeInvoiceParser parser = (AbstractIncomeInvoiceParser)clazz.newInstance();
            invoiceColl.addObjectCollection((IObjectCollection)parser.parse(ctx, params));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (invoiceColl.size() == 0 && IncomeInvoicePwyHelper.isCQPurCloudReceive(params)) {
            ret.put("invoiceDataIsNull", true);
        }
        Map imTempParams = IMFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"isSendBMCMessage"});
        IncomeInvoiceInfo invoiceInfo = new IncomeInvoiceInfo();
        Object statusChaged = null;
        if (imTempParams != null && "1".equals((String)imTempParams.get("isSendBMCMessage"))) {
            String title = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "INVOICESTATUS_CHANGE_WARNING", ctx.getLocale());
            StringBuffer bmcMsg = new StringBuffer();
            int size = invoiceColl.size();
            for (int i = 0; i < size; ++i) {
                invoiceInfo = (IncomeInvoiceInfo)invoiceColl.get(i);
                statusChaged = invoiceInfo.get("statusChaged");
                if (statusChaged == null || !Boolean.parseBoolean(statusChaged.toString())) continue;
                bmcMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "STATUS_WARNING_CONTENT", IMUtils.getLocale(), new Object[]{invoiceInfo.getCompany().getName(), invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber(), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
            }
            if (bmcMsg.length() > 0) {
                IMUtils.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, ctx.getCaller().toString());
                if (!"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(ctx.getCaller().toString())) {
                    IMUtils.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
                }
            }
        }
        ret.put("invoiceColl", (Boolean)invoiceColl);
        return ret;
    }

    protected IncomeInvoiceInfo getIncomeInvoiceInfo(Context ctx, CoreBillBaseInfo invoice) throws BOSException {
        IncomeInvoiceInfo invoiceInfo = new IncomeInvoiceInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoice.getString("invoiceCode")));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoice.getString("invoiceNo")));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = this.getIncomeInvoiceCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        } else {
            invoiceInfo.setId(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE)));
        }
        return invoiceInfo;
    }

    private void updatetaxClassificationCodeByTaxClassificationNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        IncomeInvoiceEntryCollection entries = info.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            IncomeInvoiceEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getTaxClassificationNumber() == null) continue;
            EntityViewInfo taxClassView = new EntityViewInfo();
            FilterInfo taxClassFilter = new FilterInfo();
            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entryInfo.getTaxClassificationNumber(), CompareType.EQUALS));
            taxClassView.setFilter(taxClassFilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            taxClassView.setSelector(sic);
            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
            if (taxClassColl == null || taxClassColl.size() <= 0) continue;
            TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
            entryInfo.setTaxClassificationCode(taxClassInfo);
        }
    }

    protected void updateCheckAbs(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (!PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) && !PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
            return;
        }
        CheckAbsInfo checkAbs = info.getCheckAbs();
        if (checkAbs == null && info.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceID", (Object)info.getId().toString()));
            view.setFilter(filter);
            CheckAbsCollection colls = CheckAbsFactory.getLocalInstance((Context)ctx).getCheckAbsCollection(view);
            if (colls.size() > 0) {
                checkAbs = colls.get(0);
            }
        }
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(info);
            info.setCheckAbs(checkAbs);
        }
        checkAbs.setCompany(info.getCompany());
        checkAbs.setSalerName(info.getBillingCompany());
        checkAbs.setSalerTaxNo(info.getTaxNumber());
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        checkAbs.setInvoiceID(info.getId().toString());
        checkAbs.setInvoiceCode(info.getInvoiceCode());
        checkAbs.setInvoiceNo(info.getInvoiceNumber());
        checkAbs.setInvoiceDate(info.getBizDate());
        checkAbs.setAmount(info.getAmount());
        checkAbs.setTaxAmt(info.getTax());
        if (IncomeStatusEnum.NORMAL.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.NORMAL);
        } else if (IncomeStatusEnum.LOSECONTROL.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.OUT_OF_CONTROL);
        } else if (IncomeStatusEnum.CANCEL.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.CANCEL);
        } else if (IncomeStatusEnum.CREDIT.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.RED);
        } else if (IncomeStatusEnum.UNUSUAL.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.ABNORMAL);
        } else if (IncomeStatusEnum.UNNORMAL.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.UNNORMAL);
        } else if (IncomeStatusEnum.UNCONFIRMRED.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.UNCONFIRMRED);
        } else if (IncomeStatusEnum.PARTLYRED.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.PARTLYRED);
        } else if (IncomeStatusEnum.FULLRED.equals((Object)info.getStatus())) {
            checkAbs.setInvoiceState(TMInvoiceStatus.FULLRED);
        }
        checkAbs.setIsAllowCheck(true);
        checkAbs.setInvoiceType(info.getTmInvoiceType());
        this.updateCheckAbsInfo(ctx, checkAbs, info);
        CheckAbsFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)checkAbs);
    }

    protected void updateNonCompliantInvoice(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        Object statusChaged = null;
        statusChaged = info.get("statusChaged");
        if (statusChaged != null && Boolean.parseBoolean(statusChaged.toString())) {
            NonCompliantInvoiceInfo nonCompliantInvoice = info.getNonCompliantInvoice();
            if (info.getId() != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.*"));
                sic.add(new SelectorItemInfo("entry.*"));
                sic.add(new SelectorItemInfo("entry.nonCompliantType.*"));
                sic.add(new SelectorItemInfo("entry.handler.*"));
                view.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("invoiceID", (Object)info.getId().toString()));
                view.setFilter(filter);
                NonCompliantInvoiceCollection colls = NonCompliantInvoiceFactory.getLocalInstance((Context)ctx).getNonCompliantInvoiceCollection(view);
                if (colls.size() > 0) {
                    nonCompliantInvoice = colls.get(0);
                    info.setNonCompliantInvoice(nonCompliantInvoice);
                }
            }
            if (nonCompliantInvoice == null) {
                nonCompliantInvoice = new NonCompliantInvoiceInfo();
                info.setNonCompliantInvoice(nonCompliantInvoice);
            }
            NonCompliantInvoiceUtils.updateNonCompliantInvoice(ctx, nonCompliantInvoice, info);
            this.updateNonCompliantInvoiceInfo(ctx, nonCompliantInvoice, info);
            NonCompliantInvoiceFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)nonCompliantInvoice);
            info.setNonCompliantInvoice(nonCompliantInvoice);
        }
    }

    protected void deleteByInvoiceIDs(Context ctx, Set idSet) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete From T_TM_CheckAbs where ");
        sql.append(TMCommonUtil.buildIn((String)"FInvoiceID", (Object[])idSet.toArray()));
        logger.error((Object)sql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void updateCheckAbsInfo(Context ctx, CheckAbsInfo checkAbs, IncomeInvoiceInfo info) {
    }

    protected void updateNonCompliantInvoiceInfo(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, IncomeInvoiceInfo info) {
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        new BillVoucherService().batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected Map _checkCanClaimInvoice(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        Map<String, String> retMap = new HashMap<String, String>();
        String errorMsg = "";
        StringBuffer detailMsg = new StringBuffer();
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(ids);
        IncomeInvoiceCollection incomeInvoiceColl = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection("where id in " + IMUtils.getInStringFromSet(idSet));
        if (incomeInvoiceColl == null || incomeInvoiceColl.size() == 0) {
            retMap.put("errorMsg", IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "incomeInvoiceIsNull", ctx.getLocale()));
            return retMap;
        }
        HashSet<String> companyIdSet = new HashSet<String>();
        HashSet<String> buyerTaxNoSet = new HashSet<String>();
        int j = incomeInvoiceColl.size();
        for (int i = 0; i < j; ++i) {
            companyIdSet.add(incomeInvoiceColl.get(i).getCompany().getId().toString());
            if (StringUtils.isEmpty((String)incomeInvoiceColl.get(i).getBuyerTaxNo())) continue;
            buyerTaxNoSet.add(incomeInvoiceColl.get(i).getBuyerTaxNo());
        }
        Iterator iter = companyIdSet.iterator();
        String orgPk = null;
        while (iter.hasNext()) {
            orgPk = (String)iter.next();
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(orgPk, "im_incomeInvoice_update");
        }
        if (buyerTaxNoSet.size() > 1) {
            retMap.put("errorMsg", IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "BuyerTaxNoNotSame", ctx.getLocale()));
            return retMap;
        }
        retMap = this.checkBotpDown4ClaimInvoice(ctx, idSet);
        return retMap;
    }

    public Map checkBotpDown4ClaimInvoice(Context ctx, Set<String> idSet) throws BOSException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        StringBuffer detailMsg = new StringBuffer();
        HashMap msgMap = new HashMap();
        ArrayList reasonList = new ArrayList();
        String errorMsg = "";
        boolean hasError = false;
        String defaultMainErrorMsg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "canNotClaimInvoice", ctx.getLocale());
        String invoiceIsAccepted = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "invoiceIsAccepted", ctx.getLocale());
        String invoiceFiVouchered = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "invoiceFiVouchered", ctx.getLocale());
        String invoiceHasBizBIllType = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "invoiceHasBizBIllType", ctx.getLocale());
        String invoiceIsTaxTransfered = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "invoiceIsTaxTransfered", ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select FInvoiceNumber,FInvoiceNumber,FInvoiceCode,FInvoiceType,FIsAccept,FAuthenticateStatus,FAuthenticateType,FFiVouchered,FCompanyID,FTmInvoiceType,FBizBIllTypeID from t_im_IncomeInvoice ");
        sql.append(" where FID in " + IMUtils.getInStringFromSet(idSet));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                int FIsAccept = rs.getInt("FIsAccept");
                int FFiVouchered = rs.getInt("FFiVouchered");
                String FInvoiceNumber = rs.getString("FInvoiceNumber");
                String FBizBIllTypeID = rs.getString("FBizBIllTypeID");
                if (!msgMap.containsKey(FInvoiceNumber)) {
                    msgMap.put(FInvoiceNumber, new ArrayList());
                }
                if (FIsAccept == 1) {
                    errorMsg = defaultMainErrorMsg;
                    ((List)msgMap.get(FInvoiceNumber)).add(invoiceIsAccepted);
                    hasError = true;
                }
                if (FFiVouchered == 1) {
                    errorMsg = defaultMainErrorMsg;
                    ((List)msgMap.get(FInvoiceNumber)).add(invoiceFiVouchered);
                    hasError = true;
                }
                if (FBizBIllTypeID == null || FBizBIllTypeID.isEmpty()) continue;
                errorMsg = defaultMainErrorMsg;
                ((List)msgMap.get(FInvoiceNumber)).add(invoiceHasBizBIllType);
                hasError = true;
            }
            ArrayList hasTaxTransferIds = new ArrayList();
            StringBuffer sql1 = new StringBuffer();
            sql1.append("select distinct ii.FInvoiceNumber FInvoiceNumber from T_IM_IncomeInvoice ii ");
            sql1.append(" left join T_BOT_Relation br on ii.FID = br.FSRCOBJECTID");
            sql1.append(" where br.FSRCENTITYID = '1343913D' ");
            sql1.append(" and  br.FDESTENTITYID = '573282EF' ");
            sql1.append(" and  br.FSRCOBJECTID in " + IMUtils.getInStringFromSet(idSet));
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
            while (rs1.next()) {
                if (!msgMap.containsKey(rs1.getString("FInvoiceNumber"))) {
                    ArrayList list = new ArrayList();
                    msgMap.put(rs1.getString("FInvoiceNumber"), list);
                    continue;
                }
                ((List)msgMap.get(rs1.getString("FInvoiceNumber"))).add(invoiceIsTaxTransfered);
                hasError = true;
            }
            if (hasError) {
                errorMsg = defaultMainErrorMsg;
                detailMsg.setLength(0);
                List tempList = new ArrayList();
                StringBuffer tempSB = new StringBuffer();
                for (Map.Entry entry : msgMap.entrySet()) {
                    tempList = (List)entry.getValue();
                    if (tempList.size() == 0) continue;
                    tempSB.setLength(0);
                    int j = tempList.size();
                    for (int i = 0; i < j; ++i) {
                        tempSB.append((String)tempList.get(i));
                    }
                    detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "CANTCLAIM", ctx.getLocale(), new Object[]{entry.getKey(), tempSB.substring(1)})).append(NEXTLINE);
                }
            }
            retMap.put("errorMsg", errorMsg);
            retMap.put("detailMsg", detailMsg.toString());
            return retMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _claimInvoice(Context ctx, ArrayList ids, String newCompanyId) throws BOSException, EASBizException {
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate((List)ids);
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)ids.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                thisLockList.add(id);
                continue;
            }
            otherLockList.add(id);
        }
        if (otherLockList.size() > 0) {
            throw new IMException(IMException.BILL_LOCKED);
        }
        Map<String, String> retMap = new HashMap();
        String errorMsg = "";
        String detailMsg = "";
        retMap = this._checkCanClaimInvoice(ctx, ids);
        if (!StringUtils.isEmpty((String)((String)retMap.get("errorMsg")))) {
            return retMap;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newCompanyId)));
        if (StringUtils.isEmpty((String)newCompanyId) && companyInfo == null) {
            errorMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"claimCompanyIsNull", (Locale)ctx.getLocale());
            retMap.put("errorMsg", errorMsg);
            return retMap;
        }
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(newCompanyId, "im_incomeInvoice_claimInvoice");
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(newCompanyId, "im_incomeInvoice_accept");
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("checkAbs.company.*"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IncomeInvoiceCollection incomeInvoiceColl = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(viewInfo);
        IObjectPK logPk = null;
        try {
            if (incomeInvoiceColl != null) {
                int i;
                IncomeInvoiceInfo incomeinvoiceInfo = null;
                IObjectPK userPk = ctx.getCaller();
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(userPk);
                HashSet<String> taxNumberSet = new HashSet<String>();
                ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
                int j = incomeInvoiceColl.size();
                for (int i2 = 0; i2 < j; ++i2) {
                    incomeinvoiceInfo = incomeInvoiceColl.get(i2);
                    if (!StringUtils.isEmpty((String)incomeinvoiceInfo.getTaxNumber())) {
                        taxNumberSet.add(incomeinvoiceInfo.getTaxNumber());
                    }
                    logPk = LogUtils.beginLog(ctx, "claimInvoice", BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE), (IObjectPK)new ObjectUuidPK(incomeinvoiceInfo.getId().toString()), incomeinvoiceInfo.getNumber() + ":" + incomeinvoiceInfo.getCompany().getName() + " to " + companyInfo.getName(), "im_incomeInvoice_claimInvoice", newCompanyId);
                    logPkList.add(logPk);
                }
                HashMap<String, String> supplierIdMap = new HashMap<String, String>();
                if (taxNumberSet.size() > 0) {
                    HashSet<String> companyIdSet = new HashSet<String>();
                    companyIdSet.add(newCompanyId);
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT SUPPLIER.FTaxRegisterNo AS FTaxRegisterNo,SUPPLIER.FID AS FID FROM T_BD_Supplier AS SUPPLIER ");
                    sql.append(" LEFT OUTER JOIN  T_BD_SupplierCompanyInfo AS SUPCOMPANY ON  SUPPLIER.FID = SUPCOMPANY.FSupplierID ");
                    sql.append(" WHERE SUPCOMPANY.FComOrgID IN ({0}) ");
                    sql.append(" AND SUPPLIER.FTaxRegisterNo IN ({1}) ");
                    IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyIdSet, taxNumberSet});
                    while (rs.next()) {
                        supplierIdMap.put(rs.getString("FTaxRegisterNo"), rs.getString("FID"));
                    }
                }
                int j2 = incomeInvoiceColl.size();
                for (i = 0; i < j2; ++i) {
                    incomeinvoiceInfo = incomeInvoiceColl.get(i);
                    incomeinvoiceInfo.setCompany(companyInfo);
                    incomeinvoiceInfo.setIsAccept(true);
                    incomeinvoiceInfo.setAcceptInvoiceDate(new Date());
                    incomeinvoiceInfo.setAcceptUser(userInfo);
                    if (incomeinvoiceInfo.isIsIssue()) {
                        this.setSupplierByTaxNo(ctx, (IObjectValue)incomeinvoiceInfo);
                    } else if (incomeinvoiceInfo.getTaxNumber() != null && supplierIdMap.containsKey(incomeinvoiceInfo.getTaxNumber())) {
                        SupplierInfo supplierInfo = new SupplierInfo();
                        supplierInfo.setId(BOSUuid.read((String)((String)supplierIdMap.get(incomeinvoiceInfo.getTaxNumber()))));
                        incomeinvoiceInfo.setCurrAcctSupplier(supplierInfo);
                    } else {
                        incomeinvoiceInfo.setCurrAcctSupplier(null);
                    }
                    CheckAbsInfo checkAbs = incomeinvoiceInfo.getCheckAbs();
                    if (checkAbs != null) {
                        checkAbs.setCompany(companyInfo);
                        CheckAbsFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)checkAbs);
                    }
                    super._update(ctx, (IObjectPK)new ObjectUuidPK(incomeinvoiceInfo.getId()), (IObjectValue)incomeinvoiceInfo);
                }
                j2 = logPkList.size();
                for (i = 0; i < j2; ++i) {
                    LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            retMap.put("errorMsg", e.getMessage() == null ? "NullPointerException" : e.getMessage());
            Map<String, String> map = retMap;
            return map;
        }
        finally {
            if (thisLockList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        return retMap;
    }

    @Override
    protected Map _checkBeforeGenApOtherBill(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashSet<String> companySet = new HashSet<String>();
        HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
        ArrayList idsList = (ArrayList)param.get("ids");
        StringBuffer errorMsg = new StringBuffer();
        IncomeInvoiceInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("invoiceCode"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("bizBillType.billBosType"));
        sic.add(new SelectorItemInfo("isPurchaseSyn"));
        sic.add(new SelectorItemInfo("isAccept"));
        sic.add(new SelectorItemInfo("currAcctSupplier.id"));
        sic.add(new SelectorItemInfo("currAcctSupplier.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        HashSet idSet = IMUtils.list2Set(idsList);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(viewInfo);
        ArrayList<String> passedList = new ArrayList<String>();
        ArrayList<String> passedIDList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            companySet.add(info.getCompany().getId().toString());
        }
        IIMFacade iMFacade = IMFacadeFactory.getLocalInstance(ctx);
        Iterator it = companySet.iterator();
        String companyID = "";
        while (it.hasNext()) {
            companyID = it.next().toString();
            if (permissionMap.containsKey(companyID)) continue;
            try {
                iMFacade.checkFunctionPermission(companyID, "im_incomeInvoice_genApOtherBill");
                permissionMap.put(companyID, true);
            }
            catch (Exception e) {
                permissionMap.put(companyID, false);
            }
        }
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            companyID = info.getCompany().getId().toString();
            if (permissionMap.get(companyID) == null || !((Boolean)permissionMap.get(companyID)).booleanValue()) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"genAPOtherBill_noPermission", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getInvoiceCode() + "  " + info.getInvoiceNumber(), info.getCompany().getName()})).append(NEXTLINE);
                continue;
            }
            if (info.getBizBillType() != null) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"invoiceHasBizBill", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getInvoiceCode() + "  " + info.getInvoiceNumber()})).append(NEXTLINE);
                continue;
            }
            if (!info.isIsPurchaseSyn() || !info.isIsAccept()) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"notPurSyn_genApBill", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getInvoiceCode() + "  " + info.getInvoiceNumber()})).append(NEXTLINE);
                continue;
            }
            if (info.getCurrAcctSupplier() == null) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"genAP_supplierIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getInvoiceCode() + "  " + info.getInvoiceNumber()})).append(NEXTLINE);
                continue;
            }
            passedList.add(info.getInvoiceCode() + "_" + info.getInvoiceNumber());
            passedIDList.add(info.getId().toString());
        }
        retMap.put("passedList", passedList);
        retMap.put("passedIDList", passedIDList);
        retMap.put("errorMsg", errorMsg.toString());
        return retMap;
    }

    @Override
    protected Set _getSupplierIdsForWeb(Context ctx, List companyIds) throws BOSException, EASBizException {
        return this._getSupplierIds(ctx, new HashSet(companyIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _genApOtherBill(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList idsList = (ArrayList)param.get("passedIDList");
        logger.error((Object)("[genApOtherBill]:" + idsList.toString()));
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate((List)idsList);
        int size = idsList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)idsList.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                thisLockList.add(id);
                continue;
            }
            otherLockList.add(id);
        }
        if (otherLockList.size() > 0) {
            throw new IMException(IMException.BILL_LOCKED);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            JSONObject config = new JSONObject();
            config.put("interfaceId", (Object)"EAS_RequestBillRelation");
            config.put("license", (Object)"EAS_DEFAULT");
            config.put("synchronized", (Object)"1");
            EipWebServiceTaskUtil.httpSendService((Context)ctx, (String)config.toString(), (Object)idsList, (Boolean)true);
            String totalMsg = "";
            String msg = "";
            if (ctx.get((Object)"RequestBillRelationMsg") != null) {
                totalMsg = ctx.get((Object)"RequestBillRelationMsg").toString();
            }
            if (ctx.get((Object)"RequestBillRelationDetailMsg") != null) {
                msg = ctx.get((Object)"RequestBillRelationDetailMsg").toString();
            }
            if (ctx.get((Object)"successFailCount") != null) {
                List successFailCount = (List)ctx.get((Object)"successFailCount");
                retMap.put("successCount", successFailCount.get(0));
                retMap.put("failCount", successFailCount.get(1));
            }
            if (!StringUtils.isEmpty((String)totalMsg)) {
                retMap.put("totalMsg", totalMsg);
            }
            if (!StringUtils.isEmpty((String)msg)) {
                retMap.put("msg", msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            retMap.put("errorMsg", e.getMessage() == null ? "NullPointerException" : e.getMessage());
            HashMap<String, Object> hashMap = retMap;
            return hashMap;
        }
        finally {
            if (thisLockList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(thisLockList);
            }
            if (ctx.get((Object)"successFailCount") != null) {
                ctx.remove((Object)"successFailCount");
            }
            if (ctx.get((Object)"RequestBillRelationMsg") != null) {
                ctx.remove((Object)"RequestBillRelationMsg");
            }
            if (ctx.get((Object)"RequestBillRelationDetailMsg") != null) {
                ctx.remove((Object)"RequestBillRelationDetailMsg");
            }
        }
        return retMap;
    }

    @Override
    protected Map _batchSetProject(Context ctx, List ids, String projectID) throws BOSException, EASBizException {
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE));
        HashMap<String, Object> result = new HashMap<String, Object>();
        int errorCount = 0;
        try {
            if (ids.size() > 0) {
                int i;
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                BatchExecuteParamsEntry entry = null;
                Class[] paramTypes = new Class[]{IObjectPK.class, String.class};
                for (int i2 = 0; i2 < ids.size(); ++i2) {
                    entry = new BatchExecuteParamsEntry(paramTypes);
                    entry.add(0, (Object)new ObjectUuidPK(ids.get(i2).toString()));
                    entry.add(1, (Object)projectID);
                    paramEntries[i2] = entry;
                }
                ServiceStateManager.getInstance().enableNextCallServices();
                ServiceStateManager.getInstance().getServiceState().enableServices();
                BatchExecuteResult exeResult = bizCtrl.batchExecute("setProject", paramTypes, paramEntries);
                if (exeResult.getBatchResult() == null) {
                    Throwable[] exps = exeResult.getExceptions();
                    for (i = 0; i < exps.length; ++i) {
                        if (exps[i] == null) continue;
                        ++errorCount;
                        result.put(paramEntries[i].get(0).toString(), exps[i].getMessage());
                    }
                } else {
                    BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                    for (i = 0; i < paramEntries.length; ++i) {
                        Object id = paramEntries[i].get(0);
                        ActionResult actionResult = actionResults.getActionResult(id);
                        if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                        result.put(id.toString(), actionResult.getMessage());
                        ++errorCount;
                    }
                }
            }
            StringBuffer errorMsg = new StringBuffer();
            if (errorCount > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
                view.setFilter(filter);
                IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
                IncomeInvoiceInfo info = null;
                HashMap<String, String> numMap = new HashMap<String, String>();
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    numMap.put(info.getId().toString(), info.getNumber());
                }
                for (String id : result.keySet()) {
                    errorMsg.append(numMap.get(id) + ":" + result.get(id).toString() + "\r\n");
                }
            }
            result.put("ERROR_COUNT", errorCount);
            result.put("ERRORMSG", errorMsg.toString());
        }
        catch (BaseException e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        return result;
    }

    @Override
    protected void _setProject(Context ctx, IObjectPK id, String projectID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("checkAbs.checkState"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IncomeInvoiceCollection incomeInvoiceColl = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(viewInfo);
        IncomeInvoiceInfo info = incomeInvoiceColl.get(0);
        IObjectPK logPk = LogUtils.beginLog(ctx, "_setProject", BOSObjectType.create((String)INCOMEINVOICE_BOSTYPE), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_incomeInvoice_setProject", info.getCompany().getId().toString());
        if ((PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) && CheckStateEnum.Checked.equals((Object)info.getCheckAbs().getCheckState())) {
            throw new IncomeInvoiceException(IncomeInvoiceException.CHECKEDINVOICEERROR);
        }
        if (StringUtils.isEmpty((String)projectID)) {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_IM_IncomeInvoice set FProjectID = null where fid = ?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{id.toString()});
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_IM_IncomeInvoice set FProjectID = ? where fid = ?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{projectID, id.toString()});
        }
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected void _checkTaxTransfer(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo("unTransferTaxAmt"));
        sic.add(new SelectorItemInfo("transferTaxAmt"));
        sic.add(new SelectorItemInfo("checkAbs.confirmState"));
        view.setSelector(sic);
        IncomeInvoiceCollection coll = this.getIncomeInvoiceCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet<String> companyIDSet = new HashSet<String>();
        IncomeInvoiceInfo info = null;
        String companyID = null;
        String invoiceNumber = null;
        BigDecimal tax = null;
        BigDecimal unTransferTaxAmt = null;
        BigDecimal transferTaxAmt = null;
        IIMFacade iMFacade = IMFacadeFactory.getLocalInstance(ctx);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            companyID = info.getCompany().getId().toString();
            invoiceNumber = info.getInvoiceNumber();
            tax = IMUtils.isNullToZero(info.getTax());
            unTransferTaxAmt = IMUtils.isNullToZero(info.getUnTransferTaxAmt());
            transferTaxAmt = IMUtils.isNullToZero(info.getTransferTaxAmt());
            if (!companyIDSet.contains(companyID)) {
                iMFacade.checkFunctionPermission(companyID, "im_taxTransfer_new");
                companyIDSet.add(companyID);
            }
            if (companyIDSet.size() > 1) {
                throw new IncomeInvoiceException(IncomeInvoiceException.TAXTRANSFER_COMPANYNOTSAME, new Object[]{invoiceNumber});
            }
            if (info.getCheckAbs() == null || !ConfirmStateEnum.Confirmed.equals((Object)info.getCheckAbs().getConfirmState()) || !PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) && !PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
                throw new IncomeInvoiceException(IncomeInvoiceException.TAXTRANSFER_STATUS_CHECK, new Object[]{invoiceNumber});
            }
            if (tax.compareTo(BigDecimal.ZERO) != 1) {
                throw new IncomeInvoiceException(IncomeInvoiceException.TAXTRANSFER_TAX_CHECK, new Object[]{invoiceNumber});
            }
            if (!(unTransferTaxAmt.compareTo(BigDecimal.ZERO) != 0 ? unTransferTaxAmt.compareTo(transferTaxAmt) != 1 : tax.compareTo(transferTaxAmt) != 1)) continue;
            throw new IncomeInvoiceException(IncomeInvoiceException.TAXTRANSFER_AMOUNT_CHECK, new Object[]{invoiceNumber});
        }
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = "com.kingdee.eas.tm.im.incomeInvoiceListPage";
            if (RIMUtil.isOpenRIM(ctx)) {
                uiPk = RIMUtil.getAssignUipk4RIM(ctx, uiPk);
            }
        }
        return uiPk;
    }
}

