/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.InvoiceProperty;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeCollection;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeFactory;
import com.kingdee.eas.tm.common.invoicePool.ICheckInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMConstant;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.ExchInvStrategy;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceException;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.TaxManageOperationImpl;
import com.kingdee.eas.tm.im.app.AbstractIncomeInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.app.incomeinvoice.ActionFactory;
import com.kingdee.eas.tm.im.app.incomeinvoice.action.AcceptInvoiceAction;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.ActionResult;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.invoice.IncomeInvoiceServerService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeInvoiceFacadeControllerBean
extends AbstractIncomeInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IncomeInvoiceFacadeControllerBean");
    TMTraceLogger tmLogger = TMLoggerFactory.getTraceLogger((String)"IncomeInvoiceFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionResult _doOperation(Context ctx, ActionParam params) throws BOSException, EASBizException {
        ActionResult actionResult;
        block12: {
            TaxManageOperationImpl.beforeOperation(ctx, params);
            actionResult = new ActionResult();
            ArrayList<String> requestLockList = new ArrayList<String>();
            ArrayList thisLockList = new ArrayList();
            ArrayList otherLockList = new ArrayList();
            try {
                if (IncomeInvoiceActionTypeEnum.SAME.equals((Object)params.getActiontype()) || IncomeInvoiceActionTypeEnum.REVERSE.equals((Object)params.getActiontype())) {
                    Iterator iter = params.getSortIds() != null && params.getSortIds().size() != 0 ? params.getSortIds().iterator() : params.getIds().iterator();
                    while (iter.hasNext()) {
                        String invoiceId = (String)iter.next();
                        requestLockList.add(invoiceId);
                    }
                    this.requestLocks(ctx, requestLockList, thisLockList, otherLockList);
                }
                if (!params.isBatch()) {
                    Iterator iter;
                    int failNum = 0;
                    int successNum = 0;
                    HashMap errorMsg = new HashMap();
                    HashMap errorDetailMsg = new HashMap();
                    ArrayList<String> invoiceIds = new ArrayList<String>();
                    Iterator iterator = iter = params.getSortIds().size() > 0 ? params.getSortIds().iterator() : params.getIds().iterator();
                    while (iter.hasNext()) {
                        String invoiceId = (String)iter.next();
                        if (StringUtils.isEmpty((String)invoiceId)) continue;
                        boolean result = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).executeAction(params, errorMsg, errorDetailMsg, invoiceId);
                        if (result) {
                            ++successNum;
                            invoiceIds.add(invoiceId);
                            continue;
                        }
                        ++failNum;
                    }
                    HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
                    retMap.put("failNum", Integer.valueOf(failNum));
                    retMap.put("successNum", Integer.valueOf(successNum));
                    retMap.put("invoiceIds", invoiceIds);
                    retMap.put("errorMsg", errorMsg);
                    retMap.put("errorDetailMsg", errorDetailMsg);
                    actionResult.setRetMap(retMap);
                    break block12;
                }
                try {
                    ActionResult batchResult = ActionFactory.getAction(ctx, params.getAction()).executeBatch(params.getActiontype(), params);
                    if (batchResult != null) {
                        actionResult = batchResult;
                    }
                }
                catch (IncomeInvoiceException e) {
                    HashMap<String, String> retMap = new HashMap<String, String>();
                    retMap.put("summaryMsg", e.getMessage());
                    actionResult.setRetMap(retMap);
                }
            }
            finally {
                if (thisLockList.size() > 0) {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(thisLockList);
                }
            }
        }
        TaxManageOperationImpl.afterOperation(ctx, params, actionResult);
        return actionResult;
    }

    private void requestLocks(Context ctx, List requestLockList, List thisLockList, List otherLockList) throws BOSException, EASBizException {
        Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(requestLockList);
        int size = requestLockList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)requestLockList.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                thisLockList.add(id);
                continue;
            }
            otherLockList.add(id);
        }
        if (otherLockList.size() > 0) {
            throw new IMException(IMException.BILL_LOCKED);
        }
    }

    @Override
    protected Map _createIncomeInvoiceForOtherBill(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceEntryInfo invoiceEntryInfo = null;
        boolean isAddNew = false;
        String otherBillId = (String)params.get("otherBillId");
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        if (invoiceCode == null || invoiceNumber == null) {
            return ret;
        }
        invoiceInfo = this.getIncomeInvoiceInfo(ctx, invoiceCode, invoiceNumber);
        if (invoiceInfo == null) {
            invoiceInfo = new IncomeInvoiceInfo();
            isAddNew = true;
        }
        OtherBillInfo otherbill = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(otherBillId), this.getOtherBillSelector());
        this.buildHead(ctx, invoiceInfo, otherbill, params);
        invoiceInfo.getEntries().clear();
        OtherBillentryInfo otherbillEntry = null;
        BigDecimal amount = new BigDecimal(0);
        BigDecimal tax = new BigDecimal(0);
        BigDecimal amountTax = new BigDecimal(0);
        int size = otherbill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            otherbillEntry = (OtherBillentryInfo)otherbill.getEntries().getObject(i);
            invoiceEntryInfo = this.buildEntry(invoiceInfo, otherbillEntry, params);
            invoiceInfo.getEntries().add(invoiceEntryInfo);
            amount = amount.add(invoiceEntryInfo.getMoney());
            tax = tax.add(invoiceEntryInfo.getTaxAmt());
            amountTax = amountTax.add(invoiceEntryInfo.getTaxTotal());
        }
        invoiceInfo.setAmount(amount);
        invoiceInfo.setTax(tax);
        invoiceInfo.setAmountTax(amountTax);
        if (isAddNew) {
            IncomeInvoiceFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)invoiceInfo);
        } else {
            IncomeInvoiceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(invoiceInfo.getId().toString()), (CoreBaseInfo)invoiceInfo);
        }
        IMUtils.traceUpAndDown(ctx, invoiceInfo.getId().toString(), "1343913D", otherBillId, "48DA3A71");
        return ret;
    }

    private SelectorItemCollection getOtherBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("entry.material.*"));
        return selector;
    }

    private void buildHead(Context ctx, IncomeInvoiceInfo info, OtherBillInfo otherbill, Map params) {
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        Date bizDate = (Date)params.get("bizDate");
        PayInvoiceTypeEnum invoiceType = (PayInvoiceTypeEnum)params.get("invoiceType");
        String billingCompany = (String)params.get("billingCompany");
        String taxNumber = (String)params.get("taxNumber");
        String contact = (String)params.get("contact");
        String bankInformation = (String)params.get("bankInformation");
        String invoiceUrl = (String)params.get("invoiceUrl");
        info.setInvoiceCode(invoiceCode);
        info.setInvoiceNumber(invoiceNumber);
        info.setBizDate(bizDate);
        info.setInvoiceType(invoiceType);
        info.setBillingCompany(billingCompany);
        info.setTaxNumber(taxNumber);
        info.setContact(contact);
        info.setBankInformation(bankInformation);
        info.setCompany(otherbill.getCompany());
        info.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        info.setCurrAcctSupplier(this.getSupplier(ctx, otherbill.getAsstActID()));
        info.setStatus(IncomeStatusEnum.NORMAL);
        info.setPdfUrl(invoiceUrl);
    }

    private IncomeInvoiceEntryInfo buildEntry(IncomeInvoiceInfo info, OtherBillentryInfo otherbillEntry, Map params) {
        IncomeInvoiceEntryInfo entryInfo = new IncomeInvoiceEntryInfo();
        entryInfo.setProductName(otherbillEntry.getMaterial().getName());
        entryInfo.setSpecs(otherbillEntry.getMaterial().getModel());
        entryInfo.setQuantity(otherbillEntry.getQuantity());
        entryInfo.setTaxExcluded(otherbillEntry.getPrice());
        entryInfo.setTaxPrice(otherbillEntry.getTaxPrice());
        entryInfo.setMoney(otherbillEntry.getAmount());
        entryInfo.setTaxAmt(otherbillEntry.getTaxAmount());
        entryInfo.setTaxRate(otherbillEntry.getTaxRate());
        entryInfo.setTaxTotal(otherbillEntry.getRecievePayAmount());
        return entryInfo;
    }

    private SupplierInfo getSupplier(Context ctx, String supplierId) {
        SupplierInfo supplierInfo = null;
        try {
            supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierId));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return supplierInfo;
    }

    private IncomeInvoiceInfo getIncomeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) {
        IncomeInvoiceInfo invoiceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = null;
        try {
            coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        }
        return invoiceInfo;
    }

    @Override
    protected Map _exchangeInvoice(Context ctx, Map param) throws BOSException, EASBizException {
        param.put("ctx", ctx);
        param.put("isExchange", true);
        IObjectPK logPK = LogUtils.beginLog(ctx, ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"im_incomeInvoice_exchange", (Locale)ctx.getLocale()), BOSObjectType.create((String)"1343913D"), (IObjectPK)new ObjectUuidPK((String)param.get("srcId")), ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)"instanceDeatil", (Locale)ctx.getLocale(), (Object[])new Object[]{(String)param.get("srcCode"), (String)param.get("srcNum")}), "im_incomeInvoice_exchange", (String)param.get("companyId"));
        ExchInvStrategy exchInvStrategy = new ExchInvStrategy(param);
        Map result = exchInvStrategy.doExchange();
        LogUtils.afterLog(ctx, logPK);
        return result;
    }

    @Override
    protected Map _removeTrace(Context ctx, Map params) throws BOSException, EASBizException {
        Set traceID = (Set)params.get("traceID");
        if (traceID == null || traceID.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_BOT_Relation where FID in ").append(IMUtils.getInStringFromSet(traceID));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return params;
    }

    @Override
    protected Map _getTrace(Context ctx, Map params) throws BOSException, EASBizException {
        HashSet<String> traceID = new HashSet<String>();
        String obID = (String)params.get("id");
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FID from T_BOT_Relation where FSRCEntityID = '1343913D' ").append("\n");
            sql.append(" and FDESTObjectID = '").append(obID).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                traceID.add(rs.getString("FID"));
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        params.put("traceID", traceID);
        return params;
    }

    @Override
    protected void _checkExchange(Context ctx, Map params) throws BOSException, EASBizException {
        List idList = (List)params.get("idList");
        Boolean isExchange = (Boolean)params.get("isExchange");
        try {
            StringBuffer sql = new StringBuffer();
            String errorMsg = "";
            sql.append(" Select 1 from T_BOT_Relation ").append("\n");
            sql.append(" where FSRCEntityID = '1343913D' ").append("\n");
            sql.append(" and FDESTEntityID = '1343913D' ").append("\n");
            sql.append(" and FOperatorID = 'exchangeInvoice' ").append("\n");
            if (isExchange.booleanValue()) {
                sql.append(" and FSrcObjectID = '").append(idList.get(0)).append("' ");
                errorMsg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "HasExchangeRelation", ctx.getLocale());
            } else {
                sql.append(" and FSrcObjectID in ").append(IMUtils.getInStringFromList(idList));
                errorMsg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "OtherHasExchangeRelation", ctx.getLocale());
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg});
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected Set _getInvoiceIds(Context ctx, Map params) throws BOSException, EASBizException {
        String billId = (String)params.get("billId");
        BOSUuid uuid = BOSUuid.read((String)billId);
        String bostype = uuid.getType().toString();
        HashSet<String> invoiceIds = new HashSet<String>();
        if ("1343913D".equals(bostype)) {
            invoiceIds.add(billId);
        } else if ("48DA3A71".equals(bostype) || "D001019A".equals(bostype)) {
            String sql = this.getInvoiceIDsSql(billId);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    invoiceIds.add(rs.getString("FDestObjectID"));
                }
            }
            catch (SQLException e) {
                throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
            }
        }
        return invoiceIds;
    }

    private String getIncomeInvoiceIDsSql(String srcObjectID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FDestObjectID FROM T_BOT_Relation ").append("\r\n");
        sql.append(" WHERE FSrcObjectID = '");
        sql.append(srcObjectID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FDestEntityID = '1343913D'");
        return sql.toString();
    }

    private String getInvoiceIDsSql(String srcObjectID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FDestEntityID,FDestObjectID FROM T_BOT_Relation ").append("\r\n");
        sql.append(" WHERE FSrcObjectID = '");
        sql.append(srcObjectID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FDestEntityID in ");
        Set apSupportBosType = TMPwyHelperUtils.getAPInvoiceBosTypeSet();
        sql.append(TMCommonUtil.getInStringFromSet((Set)apSupportBosType));
        return sql.toString();
    }

    @Override
    protected void _acceptInvoice(Context ctx, String invoiceCode, String invoiceNumber) throws BOSException, EASBizException {
        AcceptInvoiceAction action = new AcceptInvoiceAction(ctx);
        ActionParam params = new ActionParam();
        params.setInvoiceCode(invoiceCode);
        params.setInvoiceNumber(invoiceNumber);
        action.execute(IncomeInvoiceActionTypeEnum.SAME, params);
    }

    @Override
    protected boolean _executeAction(Context ctx, ActionParam params, Map errorMsg, Map errorDetailMsg, String invoiceId) throws BOSException, EASBizException {
        Object isThrowException;
        params.setInvoiceId(invoiceId);
        String invoiceNumber = null;
        String invoiceCode = null;
        BOSObjectType bosType = BOSUuid.read((String)invoiceId).getType();
        try {
            if (bosType != null && !StringUtils.isEmpty((String)bosType.toString()) && "1343913D".equals(bosType.toString())) {
                IncomeInvoiceInfo invoiceInfo = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
                invoiceNumber = invoiceInfo.getInvoiceNumber();
                invoiceCode = invoiceInfo.getInvoiceCode();
            } else {
                ICheckInvoiceBase iCheckInvoice = (ICheckInvoiceBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
                CheckInvoiceBaseInfo checkInvoiceBaseInfo = iCheckInvoice.getCheckInvoiceBaseInfo((IObjectPK)new ObjectUuidPK(invoiceId));
                invoiceNumber = checkInvoiceBaseInfo.getInvoiceNo();
                invoiceCode = checkInvoiceBaseInfo.getInvoiceCode();
            }
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)("Missingrecord:" + invoiceId + ":" + e.getMessage()), (Throwable)e);
            throw new IncomeInvoiceException(IncomeInvoiceException.NOTEXISTINVOICEERROR);
        }
        params.setInvoiceCode(invoiceCode);
        params.setInvoiceNumber(invoiceNumber);
        params.setData(bosType.toString());
        try {
            ActionFactory.getAction(ctx, params.getAction()).execute(params.getActiontype(), params);
            return true;
        }
        catch (IncomeInvoiceException e) {
            errorMsg.put(e.getCode(), e.getMessage());
            ArrayList<String> errorDetailList = (ArrayList<String>)errorDetailMsg.get(e.getCode());
            if (errorDetailList == null) {
                errorDetailList = new ArrayList<String>();
                errorDetailMsg.put(e.getCode(), errorDetailList);
            }
            if (StringUtils.isEmpty((String)invoiceCode)) {
                errorDetailList.add("    " + invoiceNumber);
            } else {
                errorDetailList.add(invoiceCode + "    " + invoiceNumber);
            }
            isThrowException = params.get("isThrowException");
            if (isThrowException != null && ((Boolean)isThrowException).booleanValue()) {
                throw e;
            }
            return false;
        }
        catch (EASBizException ex) {
            errorMsg.put(invoiceId, ex.getMessage());
            ArrayList<String> errorDetailList = (ArrayList<String>)errorDetailMsg.get(invoiceId);
            if (errorDetailList == null) {
                errorDetailList = new ArrayList<String>();
                errorDetailMsg.put(invoiceId, errorDetailList);
            }
            if (StringUtils.isEmpty((String)invoiceCode)) {
                errorDetailList.add("    " + invoiceNumber);
            } else {
                errorDetailList.add(invoiceCode + "    " + invoiceNumber);
            }
            isThrowException = params.get("isThrowException");
            if (isThrowException != null && ((Boolean)isThrowException).booleanValue()) {
                throw ex;
            }
            return false;
        }
    }

    @Override
    protected Map _getPdfUrlMap(Context ctx, Set invoiceIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        HashSet<String> tableNameSet = new HashSet<String>();
        InvoiceProperty invoiceProperty = null;
        sql.append(" SELECT FID,to_char(FPdfUrl)  as pdfUrl FROM T_TM_ExtendInvoice WHERE FID in").append(IMUtils.getInStringFromSet(invoiceIds));
        int size = TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = (InvoiceProperty)TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.get(i);
            if (StringUtils.isEmpty((String)invoiceProperty.getTableName()) || !tableNameSet.add(invoiceProperty.getTableName())) continue;
            sql.append(" UNION ALL ");
            sql.append(" SELECT FID,to_char(FPdfUrl) as pdfUrl FROM ").append(invoiceProperty.getTableName()).append(" WHERE FID in").append(IMUtils.getInStringFromSet(invoiceIds));
        }
        HashMap<String, String> pdfUrlMap = new HashMap<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String id = rs.getString("FID");
                String pdfUrl = rs.getString("pdfUrl");
                pdfUrlMap.put(id, pdfUrl);
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        return pdfUrlMap;
    }

    @Override
    protected Map _updateInvoiceInfoAndBotp(Context ctx, Map params) throws BOSException, EASBizException {
        block11: {
            Boolean isSubmit;
            IncomeInvoiceServerService service;
            block10: {
                logger.error((Object)"enter method updateInvoiceInfoAndBotp.");
                params.put("ctx", ctx);
                service = new IncomeInvoiceServerService();
                isSubmit = params.get("isSubmit") == null ? false : (Boolean)params.get("isSubmit");
                try {
                    service.delInvoiceInfoAndBotp(params);
                }
                catch (Exception e) {
                    logger.error((Object)("delInvoiceInfoAndBotp error,e=" + e));
                    if (!isSubmit.booleanValue()) break block10;
                    if (e instanceof EASBizException) {
                        throw (EASBizException)((Object)e);
                    }
                    if (!(e instanceof BOSException)) break block10;
                    throw (BOSException)((Object)e);
                }
            }
            String billId = (String)params.get("billId");
            String bizBillNumber = (String)params.get("bizBillNumber");
            String bizBillType = (String)params.get("bizBillType");
            String srcEntityID = BOSUuid.read((String)billId).getType().toString();
            String invoiceCodes = "";
            if (params.get("invoiceCode") != null) {
                invoiceCodes = (String)params.get("invoiceCode");
            }
            String invoiceNumbers = "";
            if (params.get("invoiceNumber") != null) {
                invoiceNumbers = (String)params.get("invoiceNumber");
            }
            String[] invoiceCodeColl = invoiceCodes.split(";");
            String[] invoiceNumberColl = invoiceNumbers.split(";");
            PoolInvoiceInfo invoiceInfo = null;
            ArrayList<String> codeNumber = new ArrayList<String>();
            StringBuffer updateSql = new StringBuffer();
            ArrayList<String> fidArray = new ArrayList<String>();
            for (int i = 0; i < invoiceNumberColl.length; ++i) {
                String key = invoiceCodeColl[i] + "_" + invoiceNumberColl[i];
                if (codeNumber.contains(key)) continue;
                codeNumber.add(key);
                invoiceInfo = service.getInvoiceInfo(ctx, invoiceCodeColl[i], invoiceNumberColl[i]);
                if (invoiceInfo == null) continue;
                if (!StringUtils.isEmpty((String)invoiceInfo.getSerialNo())) {
                    fidArray.add(invoiceInfo.getSerialNo());
                }
                IncomeInvoiceServerService.buildBOTPRelation(ctx, billId, srcEntityID, invoiceInfo.getBosType(), invoiceInfo.getId().toString(), "MANUAL");
                String tableName = (String)TMConstant.INVOICE_TABLE_MAP.get(invoiceInfo.getBosType());
                updateSql.append(" update ").append(tableName).append(" ");
                updateSql.append(" set FBizBillID = '").append(billId).append("', ");
                updateSql.append(" FBizBillNumber = '").append(bizBillNumber).append("', ");
                updateSql.append(" FBizBIllTypeID = '").append(bizBillType).append("' ");
                updateSql.append(" where FID = '").append(invoiceInfo.getId()).append("' ");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            try {
                service.getPoolSyncService().saveAndUpdateInvoiceStatus(params, fidArray);
            }
            catch (Exception e) {
                logger.error((Object)("saveInvoiceStatus/updateInvoiceStatus error,e=" + e));
                if (!isSubmit.booleanValue()) break block11;
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"exit method updateInvoiceInfoAndBotp.");
        HashMap ret = new HashMap();
        return ret;
    }

    @Override
    protected HashSet _getInvoiceSerialNo(Context ctx, List invoiceCodes, List invoiceNumbers) throws BOSException {
        HashSet<String> invoiceSet = new HashSet<String>();
        for (int i = 0; i < invoiceCodes.size(); ++i) {
            String sign = null;
            sign = invoiceCodes.get(i).equals("FULL") ? "-" + invoiceNumbers.get(i) : (String)invoiceCodes.get(i) + "-" + invoiceNumbers.get(i);
            invoiceSet.add(sign);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select CONVERT(NVARCHAR,FInvoiceNumber) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_IM_IncomeInvoice where finvoiceNumber in ({0})");
        sb.append(" union all ");
        sb.append("select CONVERT(NVARCHAR,FInvoiceNo) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_TM_VehicleInvoice where FInvoiceNo in ({1})");
        sb.append(" union all ");
        sb.append("select CONVERT(NVARCHAR,FInvoiceNo) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_TM_SecondHandCarInvoice where FInvoiceNo in ({2})");
        sb.append(" union all ");
        sb.append("select CONVERT(NVARCHAR,FInvoiceNo) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_TM_MachineInvoice where FInvoiceNo in ({3})");
        sb.append(" union all ");
        sb.append("select CONVERT(NVARCHAR,FInvoiceNo) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_TM_QuotaInvoice where FInvoiceNo in ({4})");
        sb.append(" union all ");
        sb.append("select CONVERT(NVARCHAR,FInvoiceNo) as invoiceNumber,CONVERT(NVARCHAR,FInvoiceCode) as invoiceCode,CONVERT(NVARCHAR(40),FSerialNo) as serialno from T_TM_FullElectricInvoice where FInvoiceNo in ({5})");
        HashSet<String> serialnoSet = new HashSet<String>();
        Object[] params = new Object[]{invoiceNumbers, invoiceNumbers, invoiceNumbers, invoiceNumbers, invoiceNumbers, invoiceNumbers};
        try {
            IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sb.toString(), (Object[])params);
            String sign = null;
            while (rs.next()) {
                sign = rs.getString("InvoiceCode") != null ? rs.getString("InvoiceCode") + "-" + rs.getString("invoiceNumber") : "-" + rs.getString("invoiceNumber");
                if (!invoiceSet.contains(sign)) continue;
                serialnoSet.add(rs.getString("serialno"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return serialnoSet;
    }

    @Override
    protected Map _getBosTypeIdsMap(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        String billId = (String)param.get("billId");
        String sql = this.getInvoiceIDsSql(billId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String bosType = "";
        String invoiceId = "";
        try {
            while (rs.next()) {
                bosType = rs.getString("FDestEntityID");
                invoiceId = rs.getString("FDestObjectID");
                if (retMap.containsKey(bosType)) {
                    ((Set)retMap.get(bosType)).add(invoiceId);
                    continue;
                }
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(invoiceId);
                retMap.put(bosType, idSet);
            }
        }
        catch (SQLException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        return retMap;
    }

    @Override
    protected Map _getInvoiceList(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        List invoiceList = (List)params.get("invoiceList");
        if (invoiceList == null || invoiceList.size() == 0) {
            return ret;
        }
        HashSet<String> codeNumSet = new HashSet<String>();
        String[] codeNum = null;
        String code = null;
        StringBuffer invoiceNumsStr = new StringBuffer();
        for (int i = 0; i < invoiceList.size(); ++i) {
            codeNum = (String[])invoiceList.get(i);
            invoiceNumsStr.append("'").append(codeNum[1]).append("'");
            if (i != invoiceList.size() - 1) {
                invoiceNumsStr.append(",");
            }
            code = "FULL".equals(codeNum[0]) ? " " : codeNum[0];
            codeNumSet.add(code + "-" + codeNum[1]);
        }
        StringBuffer sb = new StringBuffer();
        HashSet<String> tableNameSet = new HashSet<String>();
        String[] fieldNames = new String[]{"invoiceNumber", "invoiceCode", "serialNo", "invoiceType", "billingCompany", "amount", "tax", "amountTax"};
        String fieldName2 = null;
        InvoiceProperty invoiceProperty = TMPwyHelperUtils.EXTEND_INVOICE;
        int index = 0;
        do {
            if (index > 0) {
                invoiceProperty = (InvoiceProperty)TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.get(index - 1);
                if (!tableNameSet.add(invoiceProperty.getTableName())) {
                    ++index;
                    continue;
                }
                sb.append(" union all ");
            }
            sb.append(" select FID as ID");
            for (String fieldName2 : fieldNames) {
                if ("invoiceType".equals(fieldName2) && TMPwyHelperUtils.EXTEND_INVOICE.equals(invoiceProperty)) {
                    sb.append(",CONVERT(NVARCHAR(44),FExtendInvoiceTypeID) as invoiceType");
                    continue;
                }
                String realName = (String)invoiceProperty.getFieldsName().get(fieldName2);
                if (!StringUtils.isEmpty((String)realName)) {
                    sb.append(",CONVERT(NVARCHAR(255),F").append(realName).append(") as ").append(fieldName2);
                    continue;
                }
                sb.append(",'' as ").append(fieldName2);
            }
            sb.append(" from ").append(invoiceProperty.getTableName());
            sb.append(" where ").append("F" + invoiceProperty.getFieldsName().get("invoiceNumber")).append(" in (").append(invoiceNumsStr.toString()).append(")");
            ++index;
        } while (index <= TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.size());
        ArrayList<PoolInvoiceInfo> queryInvoiceList = new ArrayList<PoolInvoiceInfo>();
        try {
            IRowSet rs = TMSqlUtil.executeQuery((Context)ctx, (String)sb.toString());
            String invoiceCode = null;
            String invoiceNumber = null;
            ExtendTMInvoiceTypeCollection typeCol = ExtendTMInvoiceTypeFactory.getLocalInstance((Context)ctx).getExtendTMInvoiceTypeCollection();
            HashMap<String, String> typeMap = new HashMap<String, String>();
            int j = typeCol.size();
            for (int i = 0; i < j; ++i) {
                typeMap.put(typeCol.get(i).getId().toString(), typeCol.get(i).getName());
            }
            while (rs.next()) {
                invoiceCode = rs.getString("invoiceCode") == null ? " " : rs.getString("invoiceCode");
                invoiceNumber = rs.getString("invoiceNumber");
                if (!codeNumSet.contains(invoiceCode + "-" + invoiceNumber)) continue;
                PoolInvoiceInfo info = new PoolInvoiceInfo();
                info.setId(rs.getString("ID"));
                info.setInvoiceCode(invoiceCode);
                info.setInvoiceNumber(rs.getString("invoiceNumber"));
                String tmInvoiceType = this.getTMInvoiceType(rs.getString("invoiceType"));
                info.setInvoiceType(tmInvoiceType);
                if (typeMap.get(tmInvoiceType) != null) {
                    info.setInvoiceTypeAlias((String)typeMap.get(tmInvoiceType));
                } else {
                    info.setInvoiceTypeAlias(TMInvoiceType.getEnum((String)tmInvoiceType) == null ? null : TMInvoiceType.getEnum((String)tmInvoiceType).getAlias());
                }
                info.setSerialNo(rs.getString("serialno"));
                info.setBillingCompany(rs.getString("billingCompany"));
                info.setAmount(new BigDecimal(StringUtils.isEmpty((String)rs.getString("amount")) ? "0" : rs.getString("amount")));
                info.setTax(new BigDecimal(StringUtils.isEmpty((String)rs.getString("tax")) ? "0" : rs.getString("tax")));
                info.setAmountTax(new BigDecimal(StringUtils.isEmpty((String)rs.getString("amountTax")) ? "0" : rs.getString("amountTax")));
                queryInvoiceList.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ret.put("queryInvoiceList", queryInvoiceList);
        return ret;
    }

    private String getTMInvoiceType(String invoiceType) {
        if (StringUtils.isEmpty((String)invoiceType)) {
            return "";
        }
        if (invoiceType.equals("0")) {
            invoiceType = "3";
        } else if (invoiceType.equals("1")) {
            invoiceType = "4";
        } else if (invoiceType.equals("2")) {
            invoiceType = "1";
        } else if (invoiceType.equals("3")) {
            invoiceType = "2";
        }
        return invoiceType;
    }
}

