/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.im.app.AbstractIncomeInvoiceReportFacadeControllerBean;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeInvoiceReportFacadeControllerBean
extends AbstractIncomeInvoiceReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IncomeInvoiceReportFacadeControllerBean");
    private static final String[] sumFields = new String[]{"FInvoiceType_0", "FInvoiceType_1", "FInvoiceType_2", "FAuthenticateStatus_0", "FAuthenticateStatus_1", "FAuthenticateStatus_2", "FStatus_0", "FStatus_1", "FStatus_2", "FStatus_3", "FStatus_4", "FStatus_5", "FResourceType_0", "FResourceType_1", "FResourceType_2", "FIsAccept_0", "FIsAccept_1", "FIsReceive_0", "FIsReceive_1", "FTotalAmount", "FTotalTax", "FTotalAmountTax"};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        params.setString("tempTable", tempTable);
        this.insertBillData(ctx, params);
        this.updateInvoiceTypeData(ctx, params);
        this.insertTotalData(ctx, params);
        return params;
    }

    private void insertTotalData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String totalCount_alias = IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "TotalCount", ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append(" ( FID,FIndex,FCompanyName,");
        sql.append(this.getSumFieldsSelectSQL(null));
        sql.append(" ) ");
        sql.append(" (SELECT newbosid('88888888'),1,'").append(totalCount_alias).append("',");
        sql.append(this.getSumFieldsSumSQL());
        sql.append(" FROM ").append(tempTable).append(" WHERE FIndex = 0)");
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID, FIndex, FCompanyID, FCompanyNumber, FCompanyName, FYear, FPeriod, ");
        sql.append(this.getSumFieldsSelectSQL(null));
        sql.append(" FROM ").append(tempTable).append(" WHERE FINDEX = 0");
        sql.append(" ORDER BY FIndex asc,FCompanyNumber asc,FYear desc,FPeriod desc;");
        rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        sql.setLength(0);
        sql.append(" SELECT FID, FIndex, FCompanyID, FCompanyNumber, FCompanyName, FYear, FPeriod, ");
        sql.append(this.getSumFieldsSelectSQL(null));
        sql.append(" FROM ").append(tempTable).append(" WHERE FINDEX = 1");
        rs = this.executeQuery(sql.toString(), null, ctx);
        pp.setObject("totalset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        sql.setLength(0);
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        pp.setInt("totalCount", totalCount);
        return pp;
    }

    private void insertBillData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        Set companyIds = (Set)params.getObject("companyIds");
        int periodFrom = params.getInt("periodFrom");
        int periodTo = params.getInt("periodTo");
        Connection conn = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection orgColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(this.getInsertSQL(tempTable));
            CompanyOrgUnitInfo company = null;
            int size = orgColl.size();
            for (int i = 0; i < size; ++i) {
                company = orgColl.get(i);
                for (int periodNow = periodFrom; periodNow <= periodTo; ++periodNow) {
                    int year = Integer.parseInt((periodNow + "").substring(0, 4));
                    int period = Integer.parseInt((periodNow + "").substring(4, 6));
                    if (period > 12 || period < 1) continue;
                    ps.setString(1, BOSUuid.create((String)"88888888").toString());
                    ps.setInt(2, 0);
                    ps.setString(3, company.getId().toString());
                    ps.setString(4, company.getNumber());
                    ps.setString(5, company.getName());
                    ps.setInt(6, year);
                    ps.setInt(7, period);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private String getInsertSQL(String tempTable) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable);
        insertSQL.append(" (FID,FIndex,FCompanyID,FCompanyNumber,FCompanyName,FYear,FPeriod)");
        insertSQL.append("\n VALUES(?,?,?,?,?,?,?)");
        return insertSQL.toString();
    }

    private void updateInvoiceTypeData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        Set companyIds = (Set)params.getObject("companyIds");
        int periodFrom = params.getInt("periodFrom");
        int periodTo = params.getInt("periodTo");
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tempTable).append(" as tempTbl ");
        sql.append("\n SET ( ");
        sql.append(this.getSumFieldsSelectSQL(null));
        sql.append(" ) =");
        sql.append("\n (SELECT ");
        sql.append(this.getSumFieldsSelectSQL("invoice"));
        sql.append("\n FROM");
        sql.append("\n (SELECT FCompanyId,year(FBizDate) as FYear,month(FBizDate) as FPeriod,");
        sql.append("\n   SUM(CASE WHEN FInvoiceType = '0' THEN 1 ELSE 0 END) as FInvoiceType_0,");
        sql.append("\n   SUM(CASE WHEN FInvoiceType = '1' THEN 1 ELSE 0 END) as FInvoiceType_1,");
        sql.append("\n   SUM(CASE WHEN FInvoiceType = '2' THEN 1 ELSE 0 END) as FInvoiceType_2, ");
        sql.append("\n   SUM(CASE WHEN FAuthenticateStatus = '0' THEN 1 ELSE 0 END) as FAuthenticateStatus_0,");
        sql.append("\n   SUM(CASE WHEN FAuthenticateStatus = '1' THEN 1 ELSE 0 END) as FAuthenticateStatus_1,");
        sql.append("\n   SUM(CASE WHEN FAuthenticateStatus = '2' THEN 1 ELSE 0 END) as FAuthenticateStatus_2,");
        sql.append("\n   SUM(CASE WHEN FStatus = '0' THEN 1 ELSE 0 END) as FStatus_0,");
        sql.append("\n   SUM(CASE WHEN FStatus = '1' THEN 1 ELSE 0 END) as FStatus_1,");
        sql.append("\n   SUM(CASE WHEN FStatus = '2' THEN 1 ELSE 0 END) as FStatus_2,");
        sql.append("\n   SUM(CASE WHEN FStatus = '3' THEN 1 ELSE 0 END) as FStatus_3,");
        sql.append("\n   SUM(CASE WHEN FStatus = '4' THEN 1 ELSE 0 END) as FStatus_4,");
        sql.append("\n   SUM(CASE WHEN FStatus = '5' THEN 1 ELSE 0 END) as FStatus_5,");
        sql.append("\n   SUM(CASE WHEN FResourceType = '0' THEN 1 ELSE 0 END) as FResourceType_0,");
        sql.append("\n   SUM(CASE WHEN FResourceType = '1' THEN 1 ELSE 0 END) as FResourceType_1,");
        sql.append("\n   SUM(CASE WHEN FResourceType = '2' THEN 1 ELSE 0 END) as FResourceType_2,");
        sql.append("\n   SUM(CASE WHEN FIsAccept = 0 THEN 1 ELSE 0 END) as FIsAccept_0,");
        sql.append("\n   SUM(CASE WHEN FIsAccept = 1 THEN 1 ELSE 0 END) as FIsAccept_1,");
        sql.append("\n   SUM(CASE WHEN FIsReceive = 0 THEN 1 ELSE 0 END) as FIsReceive_0,");
        sql.append("\n   SUM(CASE WHEN FIsReceive = 1 THEN 1 ELSE 0 END) as FIsReceive_1,");
        sql.append("\n   SUM(FAmount) as FTotalAmount,");
        sql.append("\n   SUM(FTax) as FTotalTax,");
        sql.append("\n   SUM(FAmountTax) as FTotalAmountTax");
        sql.append("\n   FROM T_IM_IncomeInvoice ");
        sql.append("\n WHERE FCompanyId in (").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(") ");
        sql.append("\n  AND year(FBizDate)*100+month(FBizDate)>=").append(periodFrom);
        sql.append("\n  AND year(FBizDate)*100+month(FBizDate)<=").append(periodTo);
        sql.append("\n GROUP BY FCompanyId,year(FBizDate),month(FBizDate) ) invoice ");
        sql.append("\n INNER JOIN ").append(tempTable).append(" temp ");
        sql.append("\n ON  invoice.FCompanyId = temp.FCompanyId");
        sql.append("\n AND invoice.FYear = temp.FYear");
        sql.append("\n AND invoice.FPeriod = temp.FPeriod WHERE tempTbl.FID = temp.FID)");
        logger.info((Object)("\u66f4\u65b0\u53d1\u7968\u7c7b\u578b\u7edf\u8ba1\u6570\u636e\uff1a" + sql.toString()));
        this.executeUpdate(ctx, sql.toString(), null);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FIndex int ,");
        sql.append("FCompanyID varchar(44),");
        sql.append("FCompanyNumber varchar(80),");
        sql.append("FCompanyName nvarchar(255),");
        sql.append("FYear int,");
        sql.append("FPeriod int,");
        sql.append(this.getSumFieldsCreateSQL());
        sql.append(");");
        logger.info((Object)("\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }

    private String getSumFieldsCreateSQL() {
        StringBuffer sql = new StringBuffer();
        String decimalDefStr = " Decimal(28,10) not null default 0";
        for (int i = 0; i < sumFields.length; ++i) {
            sql.append(sumFields[i]).append(decimalDefStr);
            if (i == sumFields.length - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private String getSumFieldsSelectSQL(String prefix) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < sumFields.length; ++i) {
            if (prefix != null) {
                sql.append(prefix).append(".");
            }
            sql.append(sumFields[i]);
            if (i == sumFields.length - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private String getSumFieldsSumSQL() {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < sumFields.length; ++i) {
            sql.append("sum(isnull(").append(sumFields[i]).append(",0))");
            if (i == sumFields.length - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }
}

