/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.InvoiceBookCollection;
import com.kingdee.eas.tm.im.InvoiceBookFactory;
import com.kingdee.eas.tm.im.InvoiceBookInfo;
import com.kingdee.eas.tm.im.app.AbstractInvoiceBookControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class InvoiceBookControllerBean
extends AbstractInvoiceBookControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.InvoiceBookControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceBookInfo book = (InvoiceBookInfo)model;
        this.verify(ctx, book, null);
        book.setInvalidCount(0);
        book.setBackCount(0);
        InvoiceBookInfo saveBook = this.setCalcCount(book);
        return super._save(ctx, (IObjectValue)saveBook);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvoiceBookInfo book = (InvoiceBookInfo)model;
        this.verify(ctx, book, pk);
        InvoiceBookInfo updateInfo = this.setCalcCount(book);
        super._update(ctx, pk, (IObjectValue)updateInfo);
    }

    private void verify(Context ctx, InvoiceBookInfo book, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceBookCollection bookCollection;
        String typecode = book.getTypeCode();
        String startNumber = book.getStartNumber();
        String endNumber = book.getEndNumber();
        StringBuffer errorMsg = new StringBuffer();
        if (book == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        if (book.getCompany() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])).append(";");
        }
        if (book.getReceiptDate() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "RECEIPTDATEISNULL", new String[0])).append(";");
        }
        if (book.getReceiptPerson() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "RECEIPTPERSONISNULL", new String[0])).append(";");
        }
        if (typecode == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TYPECODEISNULL", new String[0])).append(";");
        }
        if (book.getTypeName() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TYPENAMEISNULL", new String[0])).append(";");
        }
        if (book.getVolumeNum() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "VOLUMEISNULL", new String[0])).append(";");
        }
        if (startNumber == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "STARTNUMISNULL", new String[0])).append(";");
        }
        if (endNumber == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "ENDNUMISNULL", new String[0])).append(";");
        }
        if (startNumber != null && endNumber != null && Integer.parseInt(book.getStartNumber()) > Integer.parseInt(book.getEndNumber())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "STARTMORETHANEND", new String[0])).append(";");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        String oql = "select typecode,startNumber,endNumber where typecode = '" + typecode + "' and status = 0 ";
        if (pk != null) {
            oql = oql + "and id <> '" + pk.toString() + "'";
        }
        if (!(bookCollection = InvoiceBookFactory.getLocalInstance(ctx).getInvoiceBookCollection(oql)).isEmpty()) {
            int i;
            ArrayList<InvoiceBookInfo> bookList = new ArrayList<InvoiceBookInfo>();
            for (i = 0; i < bookCollection.size(); ++i) {
                bookList.add(bookCollection.get(i));
            }
            Collections.sort(bookList, new Comparator<InvoiceBookInfo>(){

                @Override
                public int compare(InvoiceBookInfo f1, InvoiceBookInfo f2) {
                    return f1.getStartNumber().compareTo(f2.getStartNumber());
                }
            });
            for (i = 0; i < bookList.size(); ++i) {
                if (startNumber != null && startNumber.compareTo(((InvoiceBookInfo)bookList.get(i)).getEndNumber()) > 0 || endNumber != null && endNumber.compareTo(((InvoiceBookInfo)bookList.get(i)).getStartNumber()) < 0) continue;
                throw new IMException(IMException.NUM_RANGE_DUPLICATE);
            }
        }
    }

    private InvoiceBookInfo setCalcCount(InvoiceBookInfo book) {
        int startNumber = Integer.parseInt(book.getStartNumber());
        int endNumber = Integer.parseInt(book.getEndNumber());
        int totalCount = endNumber - startNumber + 1;
        book.setTotalCount(totalCount);
        int usedCount = 0;
        book.setUsedCount(usedCount);
        int usableCount = totalCount - usedCount;
        book.setUsableCount(usableCount);
        return book;
    }
}

