/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Set;

public class InvoiceReqUtils {
    public static void checkInvoiceReq(InvoiceReqInfo invoiceReq, String[] fields) throws IMException {
        if (StringUtils.isEmpty((String)invoiceReq.getSn())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{"sn is null"});
        }
        if (StringUtils.isEmpty((String)invoiceReq.getSrcSystem())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{"srcSystem is null "});
        }
        if (invoiceReq.getBills() == null || invoiceReq.getBills().size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{"billID is null"});
        }
        if (fields == null || fields.length > 0) {
            // empty if block
        }
    }

    public static void checkPrintInvoice(Context ctx, MakeInvoiceInfo invoice) throws IMException {
        if (invoice.isIsPrint()) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Invoice_HasPrint", ctx.getLocale())});
        }
        if (InvoiceBillStatus.MAKED.equals((Object)invoice.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "NotMake_CannotPrint", ctx.getLocale())});
        }
    }

    public static void checkPrintInvoiceList(Context ctx, MakeInvoiceInfo invoice) throws IMException {
        if (!invoice.isIsList()) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "NotList_PrintListFailure", ctx.getLocale())});
        }
    }

    public static String concat(String[] strArr) {
        if (strArr == null || strArr.length == 0) {
            return null;
        }
        String retStr = "";
        for (int idx = 0; idx < strArr.length; ++idx) {
            retStr = retStr + "'" + strArr[idx] + "'";
            if (idx >= strArr.length - 1) continue;
            retStr = retStr + ",";
        }
        return retStr;
    }

    public static String concat(Set<String> strSet) {
        if (strSet == null || strSet.size() == 0) {
            return null;
        }
        String[] strArr = new String[strSet.size()];
        strSet.toArray(strArr);
        return InvoiceReqUtils.concat(strArr);
    }

    public static String concat(List<String> strList) {
        if (strList == null || strList.size() == 0) {
            return null;
        }
        String[] strArr = new String[strList.size()];
        strList.toArray(strArr);
        return InvoiceReqUtils.concat(strArr);
    }
}

