/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.common.app.service.BillVoucherService;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.AbstractMakeInvoiceInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.IPwyLog;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceBizStatus;
import com.kingdee.eas.tm.im.InvoiceBookCollection;
import com.kingdee.eas.tm.im.InvoiceBookEntryCollection;
import com.kingdee.eas.tm.im.InvoiceBookEntryFactory;
import com.kingdee.eas.tm.im.InvoiceBookEntryInfo;
import com.kingdee.eas.tm.im.InvoiceBookEntryStatusEnum;
import com.kingdee.eas.tm.im.InvoiceBookFactory;
import com.kingdee.eas.tm.im.InvoiceBookInfo;
import com.kingdee.eas.tm.im.InvoiceCombinRuleFactory;
import com.kingdee.eas.tm.im.InvoiceCombinRuleInfo;
import com.kingdee.eas.tm.im.InvoiceCombinRuleType;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceException;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceRelationCollection;
import com.kingdee.eas.tm.im.MakeInvoiceRelationFactory;
import com.kingdee.eas.tm.im.MakeInvoiceRelationInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceTypeEnum;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyLogFactory;
import com.kingdee.eas.tm.im.PwyLogInfo;
import com.kingdee.eas.tm.im.PwyLogStatus;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.RedMsgTypeEnum;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.RushRedReasonEnum;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.AbstractMakeInvoiceControllerBean;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.writeback.WriteBackFacadeFactory;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposerAdapter;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.tm.im.inv.IInvoiceDetail;
import com.kingdee.eas.tm.im.inv.InvoiceDetailFactory;
import com.kingdee.eas.tm.im.inv.InvoiceDetailInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrFactory;
import com.kingdee.eas.tm.im.util.Collection2MapUtils;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMParamUtils;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MakeInvoiceControllerBean
extends AbstractMakeInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceControllerBean");
    private static final String NEXTLINE = "\r\n";
    private static final String SEPARATOR = ";";
    private static final int SPEC_MAX_LENGTH = 40;
    private static final int ADDRESS_MAX_LENGTH = 100;
    private static final int REMARK_MAX_LENGTH = 230;
    private static final int BANKACCOUNT_MAX_LENGTH = 100;

    @Override
    protected int _getAllNotMakeInvoice(Context ctx) throws BOSException {
        int i = 0;
        StringBuffer getInvoiceNum = new StringBuffer();
        getInvoiceNum.append("SELECT count(FSTATUS) as count FROM T_IM_MakeInvoice where not (FSTATUS = '4') and not (FSTATUS  = '99')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getInvoiceNum.toString());
        try {
            while (rs.next()) {
                i = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return i;
    }

    private void putBillValues(Context ctx, MakeInvoiceInfo model) {
        MakeInvoiceInfo mkInvoice = model;
        MakeInvoiceEntryCollection entryCol = mkInvoice.getEntries();
        BigDecimal noTaxAmtTotal = BigDecimal.ZERO;
        BigDecimal taxAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxAmtTotal = BigDecimal.ZERO;
        for (int idx = 0; idx < entryCol.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entryCol.get(idx);
            BigDecimal noTaxAmt = entry.getNoTaxAmt();
            BigDecimal taxAmt = entry.getTaxAmt();
            BigDecimal priceTax = entry.getPriceTax();
            noTaxAmtTotal = noTaxAmtTotal.add(noTaxAmt != null ? noTaxAmt : BigDecimal.ZERO);
            taxAmtTotal = taxAmtTotal.add(taxAmt != null ? taxAmt : BigDecimal.ZERO);
            priceTaxAmtTotal = priceTaxAmtTotal.add(priceTax != null ? priceTax : BigDecimal.ZERO);
            if (mkInvoice.isIsDiffTax()) continue;
            entry.setDeductAmt(null);
        }
        mkInvoice.setNoTaxAmtTotal(noTaxAmtTotal);
        mkInvoice.setTaxAmtTotal(taxAmtTotal);
        mkInvoice.setPriceTaxTotal(priceTaxAmtTotal);
        if (mkInvoice.getCurrency() == null) {
            mkInvoice.setCurrency(ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency());
        }
        mkInvoice.setReceiveCompany(this.trimStr(mkInvoice.getReceiveCompany()));
        mkInvoice.setTaxNumber(this.trimStr(mkInvoice.getTaxNumber()));
        mkInvoice.setAddress(this.trimStr(mkInvoice.getAddress()));
        mkInvoice.setBankAccount(this.trimStr(mkInvoice.getBankAccount()));
        mkInvoice.setDisInvoicer(this.trimStr(mkInvoice.getDisInvoicer()));
        mkInvoice.setCellphone(this.trimStr(mkInvoice.getCellphone()));
        mkInvoice.setMailNumber(this.trimStr(mkInvoice.getMailNumber()));
        mkInvoice.setRecBillComName(this.trimStr(mkInvoice.getRecBillComName()));
        mkInvoice.setRecBillAdress(this.trimStr(mkInvoice.getRecBillAdress()));
        mkInvoice.setRecBillEmail(this.trimStr(mkInvoice.getRecBillEmail()));
        mkInvoice.setRecBillPhone(this.trimStr(mkInvoice.getRecBillPhone()));
        mkInvoice.setReceiveCompany(this.trimStr(mkInvoice.getReceiveCompany()));
        mkInvoice.setRemark(this.trimStr(mkInvoice.getRemark()));
        mkInvoice.setDrawertxt(this.trimStr(mkInvoice.getDrawertxt()));
        mkInvoice.setPayeetxt(this.trimStr(mkInvoice.getPayeetxt()));
        mkInvoice.setChecktxt(this.trimStr(mkInvoice.getChecktxt()));
        mkInvoice.setAgentName(this.trimStr(mkInvoice.getAgentName()));
        mkInvoice.setAgentIDNumber(this.trimStr(mkInvoice.getAgentIDNumber()));
        mkInvoice.setTaxIDNumber(this.trimStr(mkInvoice.getTaxIDNumber()));
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType())) {
            mkInvoice.setIsList(false);
        }
    }

    private void putEntryQtyAndPriceValues(Context ctx, MakeInvoiceInfo model) {
        MakeInvoiceInfo mkInvoice = model;
        MakeInvoiceEntryCollection entryCol = mkInvoice.getEntries();
        for (int idx = 0; idx < entryCol.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entryCol.get(idx);
            if (entry.getQuantity() != null && entry.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
                entry.setQuantity(null);
            }
            if (entry.getPrice() != null && entry.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                entry.setPrice(null);
            }
            if (entry.getNoTaxPrice() == null || entry.getNoTaxPrice().compareTo(BigDecimal.ZERO) != 0) continue;
            entry.setNoTaxPrice(null);
        }
    }

    private String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        HashSet<String> invoiceSet = new HashSet<String>();
        HashMap<String, OtherBillInfo> billMap = new HashMap<String, OtherBillInfo>();
        MakeInvoiceInfo info1 = (MakeInvoiceInfo)collection.getObject(0);
        if (info1.getBOSType().toString().equals("FC910EF3")) {
            int i;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("disInvoicer"));
            sic.add(new SelectorItemInfo("recBillPhone"));
            sic.add(new SelectorItemInfo("recBillComName"));
            sic.add(new SelectorItemInfo("recBillAdress"));
            sic.add(new SelectorItemInfo("mailNumber"));
            sic.add(new SelectorItemInfo("recBillEmail"));
            sic.add(new SelectorItemInfo("expressBillNum"));
            sic.add(new SelectorItemInfo("mailDate"));
            sic.add(new SelectorItemInfo("id"));
            viewInfo.setSelector(sic);
            int n = collection.size();
            for (int i2 = 0; i2 < n; ++i2) {
                MakeInvoiceInfo info = (MakeInvoiceInfo)collection.getObject(i2);
                String sourceId = info.getSourceBillId();
                invoiceSet.add(sourceId);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invoiceSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            OtherBillCollection col = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection(viewInfo);
            int n2 = col.size();
            for (i = 0; i < n2; ++i) {
                billMap.put(col.get(i).getId().toString(), col.get(i));
            }
            n2 = collection.size();
            for (i = 0; i < n2; ++i) {
                MakeInvoiceInfo info = (MakeInvoiceInfo)collection.getObject(i);
                String sourceId = info.getSourceBillId();
                OtherBillInfo billInfo = (OtherBillInfo)billMap.get(sourceId);
                info.setDisInvoicer(billInfo.getDisInvoicer());
                info.setRecBillPhone(billInfo.getRecBillPhone());
                info.setRecBillComName(billInfo.getRecBillComName());
                info.setRecBillAdress(billInfo.getRecBillAdress());
                info.setMailNumber(billInfo.getMailNumber());
                info.setRecBillEmail(billInfo.getRecBillEmail());
                info.setExpressBillNum(billInfo.getExpressBillNum());
                info.setMailDate(billInfo.getMailDate());
            }
        }
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.setNewNumber(ctx, mkInvoice);
        this.setInvoiceNo(ctx, mkInvoice);
        return super.save(ctx, (CoreBaseInfo)mkInvoice);
    }

    public void save(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.setNewNumber(ctx, mkInvoice);
        this.setInvoiceNo(ctx, mkInvoice);
        super.save(ctx, pk, (CoreBaseInfo)mkInvoice);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.innerSave(ctx, model, false);
    }

    private IObjectPK innerSave(Context ctx, IObjectValue model, boolean isBotp) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.setNewNumber(ctx, mkInvoice);
        this.setInvoiceNo(ctx, mkInvoice);
        if (mkInvoice.getCompany() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{mkInvoice.getNumber() + " : " + IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
        }
        if (mkInvoice.getId() != null) {
            this.checkStatusEqualsInDB(ctx, mkInvoice);
        }
        if (mkInvoice.getStatus() == null) {
            mkInvoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        }
        if (mkInvoice.getBizType() == null) {
            mkInvoice.setBizType(IMKBizTypeEnum.EAS);
        }
        if (!mkInvoice.getStatus().equals((Object)InvoiceBillStatus.TEMPSTROE)) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "NOTADDORSAVE", new String[0])});
        }
        this.putBillValues(ctx, mkInvoice);
        this.putEntryQtyAndPriceValues(ctx, mkInvoice);
        this.redInvoiceHandler(ctx, mkInvoice);
        this.setBizYearMonthNull(mkInvoice);
        String remark = IMUtils.cutStr(mkInvoice.getRemark(), 230);
        mkInvoice.setRemark(remark);
        this.updateSpecificInformationInfo(ctx, (IObjectValue)mkInvoice);
        IObjectPK pk = super._save(ctx, (IObjectValue)mkInvoice);
        if (!isBotp) {
            this.setBillUsers(ctx, mkInvoice);
        }
        mkInvoice.setId(BOSUuid.read((String)pk.toString()));
        this.extendsBlueRelateionData(ctx, mkInvoice);
        this.extendsRelationData(ctx, mkInvoice);
        if (mkInvoice.isIsRedVoice()) {
            this.writeBackRedFields(ctx, mkInvoice, true);
        }
        return pk;
    }

    private void checkStatusEqualsInDB(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, IMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)mkInvoice.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        view.setSelector(sic);
        MakeInvoiceCollection infos = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        if (infos.size() == 1 && infos.get(0).getStatus() != null && !mkInvoice.getStatus().equals((Object)infos.get(0).getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{mkInvoice.getNumber() + " : " + IMUtils.getIMResource(ctx, "BillStatusChange", new String[0])});
        }
    }

    private void setBizYearMonthNull(MakeInvoiceInfo info) {
        if (info.getBizYear() == 0) {
            info.put("bizYear", null);
        }
        if (info.getBizMonth() == 0) {
            info.put("bizMonth", null);
        }
        if (info.getMakeInvoiceType() == null) {
            info.put("makeInvoiceType", null);
        }
    }

    private void checkOverLimitRowAmt(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        BigDecimal listRow;
        boolean isList = mkInvoice.isIsList();
        int rowAmout = mkInvoice.getEntries().size();
        String companyId = mkInvoice.getCompany().getId().toString();
        PayInvoiceTypeEnum invoiceType = mkInvoice.getInvoiceType();
        if (!isList) {
            int invoiceLimitRow = this.getMaxLineNo(ctx, invoiceType.getValue(), companyId);
            if (rowAmout > invoiceLimitRow) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LimitRows", IMUtils.getLocale(), new Object[]{invoiceLimitRow})});
            }
        } else if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType)) {
            BigDecimal listRow2 = IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM012"});
            if (rowAmout > listRow2.intValue()) {
                String listLimitRow = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ListLimitRow", IMUtils.getLocale(), new Object[]{listRow2});
                throw new IMException(IMException.ERRORMSG, new Object[]{listLimitRow});
            }
        } else if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType)) {
            BigDecimal listRow3 = IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM013"});
            if (rowAmout > listRow3.intValue()) {
                String listLimitRow = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ListLimitRow", IMUtils.getLocale(), new Object[]{listRow3});
                throw new IMException(IMException.ERRORMSG, new Object[]{listLimitRow});
            }
        } else if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) {
            BigDecimal listRow4 = IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM014"});
            if (rowAmout > listRow4.intValue()) {
                String listLimitRow = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ListLimitRow", IMUtils.getLocale(), new Object[]{listRow4});
                throw new IMException(IMException.ERRORMSG, new Object[]{listLimitRow});
            }
        } else if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType) && rowAmout > (listRow = IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM017"})).intValue()) {
            String listLimitRow = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ListLimitRow", IMUtils.getLocale(), new Object[]{listRow});
            throw new IMException(IMException.ERRORMSG, new Object[]{listLimitRow});
        }
        BigDecimal limitAmt = this.getMaxAmt(ctx, mkInvoice, companyId);
        BigDecimal noTaxAmt = mkInvoice.getNoTaxAmtTotal().abs();
        BigDecimal customerLimitAmt = this.getCustomerLimitAmt(ctx, mkInvoice, companyId);
        BigDecimal smallerAmt = customerLimitAmt.compareTo(BigDecimal.ZERO) != 0 ? (limitAmt.compareTo(customerLimitAmt) < 0 ? limitAmt : customerLimitAmt) : limitAmt;
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType)) {
            if (noTaxAmt.compareTo(smallerAmt) > 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ValueInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
            }
        } else if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType)) {
            if (noTaxAmt.compareTo(smallerAmt) > 0 && smallerAmt.compareTo(BigDecimal.ZERO) != 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ComInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
            }
        } else if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) {
            if (noTaxAmt.compareTo(smallerAmt) > 0 && smallerAmt.compareTo(BigDecimal.ZERO) != 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ElecInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
            }
        } else if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType)) {
            if (noTaxAmt.compareTo(smallerAmt) > 0 && smallerAmt.compareTo(BigDecimal.ZERO) != 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "EleSpeInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
            }
        } else if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoiceType)) {
            if (noTaxAmt.compareTo(smallerAmt) > 0 && smallerAmt.compareTo(BigDecimal.ZERO) != 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DigElecInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
            }
        } else if (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoiceType) && noTaxAmt.compareTo(smallerAmt) > 0 && smallerAmt.compareTo(BigDecimal.ZERO) != 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DigElecSpeInvoiceLimitAmt", IMUtils.getLocale(), new Object[]{smallerAmt})});
        }
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        if (pk != null && !this._exists(ctx, pk)) {
            pk = null;
            mkInvoice.setId(null);
        }
        this.innerSave(ctx, (IObjectValue)mkInvoice, false);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.makeInvoiceSubmit(ctx, model);
    }

    private IObjectPK makeInvoiceSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException, IMException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.setNewNumber(ctx, mkInvoice);
        this.setInvoiceNo(ctx, mkInvoice);
        this.checkBeforeSubmit(ctx, mkInvoice);
        this.putBillValues(ctx, mkInvoice);
        this.putEntryQtyAndPriceValues(ctx, mkInvoice);
        this.checkOverLimitRowAmt(ctx, mkInvoice);
        if (mkInvoice.getId() != null) {
            this.checkStatusEqualsInDB(ctx, mkInvoice);
        }
        mkInvoice.setStatus(InvoiceBillStatus.SUBMITED);
        if (mkInvoice.getSpecificService() != null && !SpecificServiceEnum.Normal.equals((Object)mkInvoice.getSpecificService()) && mkInvoice.getSpecificInformation() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"SpecInfomation_NOTNULL", (Locale)ctx.getLocale())});
        }
        if (mkInvoice.getBizType() == null) {
            mkInvoice.setBizType(IMKBizTypeEnum.EAS);
        }
        this.redInvoiceHandler(ctx, mkInvoice);
        this.doRedBillRemork(ctx, mkInvoice);
        String remark = IMUtils.cutStr(mkInvoice.getRemark(), 230);
        mkInvoice.setRemark(remark);
        this.updateSpecificInformationInfo(ctx, (IObjectValue)mkInvoice);
        IObjectPK pk = super._submit(ctx, (IObjectValue)mkInvoice);
        this.extendsBlueRelateionData(ctx, mkInvoice);
        this.extendsRelationData(ctx, mkInvoice);
        this.setBillUsers(ctx, mkInvoice);
        this.checkAmtOver(ctx, mkInvoice.getId().toString());
        if (mkInvoice.isIsRedVoice()) {
            this.writeBackRedFields(ctx, mkInvoice, true);
        }
        return pk;
    }

    protected void redInvoiceHandler(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        block20: {
            MakeInvoiceEntryInfo entry;
            int i;
            MakeInvoiceEntryCollection entries;
            block19: {
                entries = mkInvoice.getEntries();
                if (mkInvoice.getPriceTaxTotal().compareTo(BigDecimal.ZERO) >= 0) break block19;
                mkInvoice.setIsRedVoice(true);
                if (mkInvoice.getBlueInvoiceType() == null || PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)mkInvoice.getBlueInvoiceType())) {
                    mkInvoice.setBlueInvoiceType(mkInvoice.getInvoiceType());
                }
                for (int i2 = 0; i2 < entries.size(); ++i2) {
                    MakeInvoiceEntryInfo entry2 = entries.get(i2);
                    if (entry2.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) || entry2.getPriceTax() == null || entry2.getPriceTax().compareTo(BigDecimal.ZERO) <= 0) continue;
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "REDENTRY_ERROR", new String[0])});
                }
                if (mkInvoice.getId() == null) {
                    mkInvoice.setId(BOSUuid.create((BOSObjectType)mkInvoice.getBOSType()));
                }
                MakeInvoiceInfo blueInvoice = null;
                if (InvoiceSrcSystem.REDINVOICE.equals((Object)mkInvoice.getSrcSystem())) {
                    blueInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkInvoice.getRedBillId()), this.getSelectors());
                } else {
                    String blueVoiceNum = mkInvoice.getBlueVoiceNum();
                    if (!StringUtils.isEmpty((String)blueVoiceNum)) {
                        String blueVoiceCode = mkInvoice.getBlueVoiceCode();
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)blueVoiceNum, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)blueVoiceCode, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)false, CompareType.EQUALS));
                        view.setFilter(filter);
                        view.setSelector(this.getSelectors());
                        MakeInvoiceCollection mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
                        if (mkInvoiceCol.size() > 0) {
                            blueInvoice = mkInvoiceCol.get(0);
                        }
                    }
                }
                if (blueInvoice != null) {
                    String blueBillID = blueInvoice.getId().toString();
                    String redBillID = mkInvoice.getId().toString();
                    String bosType = mkInvoice.getBOSType().toString();
                    mkInvoice.setRedBillId(blueBillID);
                    if (!mkInvoice.isIsRedBlueSourceBill() && !mkInvoice.getBoolean("fromReGenRedInvoice") || blueInvoice.getBizYear() == 0 && blueInvoice.getBizMonth() == 0) {
                        mkInvoice.put("bizYear", null);
                        mkInvoice.put("bizMonth", null);
                    } else {
                        mkInvoice.setBizYear(blueInvoice.getBizYear());
                        mkInvoice.setBizMonth(blueInvoice.getBizMonth());
                    }
                    if (!this.hasBotpRelation(ctx, blueBillID, redBillID, bosType, bosType)) {
                        StringBuffer sql = new StringBuffer();
                        sql.append(" update T_IM_MakeInvoice set fisredvoicedbill = 1 where fid = '");
                        sql.append(blueBillID);
                        sql.append("' ");
                        DbUtil.execute((Context)ctx, (String)sql.toString());
                        this.traceUpAndDown(ctx, blueBillID, redBillID, bosType, bosType);
                    }
                }
                this.clearRedVoiceNumber(ctx, mkInvoice);
                for (int i3 = 0; i3 < entries.size(); ++i3) {
                    MakeInvoiceEntryInfo entry3 = entries.get(i3);
                    if (entry3.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
                    entry3.setUnRedQty(null);
                    entry3.setUnRedPriceTax(null);
                    entry3.setRedPriceTax(null);
                    entry3.setRedQty(null);
                }
                break block20;
            }
            mkInvoice.setIsRedVoice(false);
            mkInvoice.setIsRedBlueSourceBill(false);
            mkInvoice.setBlueVoiceCode(null);
            mkInvoice.setBlueVoiceNum(null);
            mkInvoice.setRedVoiceNumber(null);
            mkInvoice.setRedMsgType(null);
            mkInvoice.put("blueInvoiceType", null);
            mkInvoice.setBlueInvoiceDate(null);
            mkInvoice.put("rushRedReason", null);
            for (int i4 = 0; i4 < entries.size(); ++i4) {
                MakeInvoiceEntryInfo entry4 = entries.get(i4);
                if (entry4.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) || IMUtils.isNullToZero(entry4.getPriceTax()).compareTo(BigDecimal.ZERO) > 0) continue;
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "BLUEENTRY_ERROR", new String[0])});
            }
            if (!InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus())) break block20;
            HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> blueQty = new HashMap<String, BigDecimal>();
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                String key = null;
                if (entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) {
                    key = entry.getSourceBillEntryId();
                } else {
                    if (entry.getId() == null) {
                        entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    }
                    key = entry.getId().toString();
                }
                if (bluePriceTax.containsKey(key)) {
                    bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax()));
                    blueQty.put(key, ((BigDecimal)blueQty.get(key)).add(entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity()));
                    continue;
                }
                bluePriceTax.put(key, entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax());
                blueQty.put(key, entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity());
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
                entry.setUnRedQty((BigDecimal)blueQty.get(entry.getId().toString()));
                entry.setUnRedPriceTax((BigDecimal)bluePriceTax.get(entry.getId().toString()));
                entry.setRedPriceTax(BigDecimal.ZERO);
                entry.setRedQty(BigDecimal.ZERO);
            }
        }
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = null;
        mkInvoice = model == null ? MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors()) : (MakeInvoiceInfo)model;
        this.submit(ctx, (CoreBaseInfo)mkInvoice);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.makeInvoiceSubmit(ctx, pk, model);
    }

    private void makeInvoiceSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException, IMException {
        MakeInvoiceInfo mkInvoice = null;
        mkInvoice = model == null ? MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors()) : (MakeInvoiceInfo)model;
        this.makeInvoiceSubmit(ctx, (IObjectValue)mkInvoice);
    }

    private void extendsBlueRelateionData(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        if (!mkInvoice.isIsRedBlueSourceBill()) {
            this.delBlueRelationData(ctx, mkInvoice);
        } else {
            this.addBlueRelationData(ctx, mkInvoice);
        }
    }

    private void addBlueRelationData(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        String billId = mkInvoice.getId().toString();
        String selectSQL = "select * from t_im_makeinvoicerelation where finvoicebillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                return;
            }
            String sourceBillId = mkInvoice.getRedBillId();
            selectSQL = "select * from t_im_makeinvoicerelation where finvoicebillid = ?";
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{sourceBillId});
            this.doBillRelation(ctx, mkInvoice, mkInvoice.getRedBillId(), rs);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void delBlueRelationData(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        if (!mkInvoice.isIsRedVoice()) {
            return;
        }
        String billId = mkInvoice.getId().toString();
        String selectSQL = "select FSrcBosType from t_im_makeinvoicerelation where finvoicebillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                String srcBosType = rs.getString("FSrcBosType");
                String delSql = "delete from t_im_makeinvoicerelation where finvoicebillid  = ?";
                DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{billId});
                String delSql1 = "delete from T_BOT_RELATION where FDESTOBJECTID = ? and FSRCENTITYID = ?";
                DbUtil.execute((Context)ctx, (String)delSql1, (Object[])new Object[]{billId, srcBosType});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void extendsRelationData(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        try {
            if (mkInvoice.get("isCopySrcBill") == null) {
                return;
            }
            boolean isCopySrcBill = (Boolean)mkInvoice.get("isCopySrcBill");
            String srcbillid = (String)mkInvoice.get("srcbillid");
            if (!isCopySrcBill || "".equals(srcbillid)) {
                return;
            }
            String existsSQL = "select 1 from t_im_makeinvoice where fcopybillid = ?";
            IRowSet existRs = DbUtil.executeQuery((Context)ctx, (String)existsSQL, (Object[])new Object[]{srcbillid});
            if (existRs.next()) {
                return;
            }
            String updateSQL = "update t_im_makeinvoice set fcopybillid = ? where fid = ?";
            Object[] params = new Object[]{srcbillid, mkInvoice.getId().toString()};
            MakeInvoiceInfo info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(srcbillid));
            if (info != null) {
                updateSQL = "update t_im_makeinvoice set fcopybillid = ? , fbizYear = ? ,FbizMonth = ? where fid = ?";
                params = new Object[]{srcbillid, info.getBizYear(), info.getBizMonth(), mkInvoice.getId().toString()};
            }
            DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
            String selectSQL = "select * from t_im_makeinvoicerelation where finvoicebillid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{srcbillid});
            this.doBillRelation(ctx, mkInvoice, srcbillid, rs);
            this.updateRedInvoiceDataWhenCopy(ctx, srcbillid, mkInvoice.getId().toString());
            mkInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(mkInvoice.getId().toString()));
            this.writeBackRedFields(ctx, mkInvoice, true);
            InvoiceReq2SaleOrderDisposerAdapter disposerAdapter = new InvoiceReq2SaleOrderDisposerAdapter();
            disposerAdapter.dispose(ctx, "save", mkInvoice.getId().toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void doBillRelation(Context ctx, MakeInvoiceInfo mkInvoice, String srcbillid, IRowSet rs) throws SQLException, BOSException, EASBizException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        while (rs.next()) {
            String srcbostype = rs.getString("fsrcbostype");
            String id = BOSUuid.create((String)"0EBBB5B4").toString();
            String invoicebillid = mkInvoice.getId().toString();
            String bizbillid = rs.getString("fbizbillid");
            BigDecimal amount = rs.getBigDecimal("famount");
            BigDecimal qty = rs.getBigDecimal("fqty");
            String groupid = rs.getString("fgroupid");
            Timestamp operatetime = rs.getTimestamp("foperatetime");
            Object[] params = new Object[]{id, srcbostype, bizbillid, invoicebillid, amount, qty, groupid, operatetime};
            paramList.add(params);
        }
        if (paramList != null && paramList.size() > 0) {
            String insertSQL = "insert into t_im_makeinvoicerelation(fid, fsrcbostype, fbizbillid, finvoicebillid, famount, fqty, fgroupid, foperatetime) values(?, ?, ?, ?, ?, ?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, paramList);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)mkInvoice.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)srcbillid, CompareType.EQUALS));
        view.setFilter(filter);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                BOTRelationInfo relation = collection.get(i);
                relation.setId(null);
                if (relation.getRelationEntries() != null) {
                    for (int j = 0; j < relation.getRelationEntries().size(); ++j) {
                        relation.getRelationEntries().get(j).setId(null);
                    }
                }
                relation.setDestObjectID(mkInvoice.getId().toString());
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(relation);
            }
        }
    }

    protected void updateRedInvoiceDataWhenCopy(Context ctx, String srcbillId, String makeinvoiceId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)srcbillId) || StringUtils.isEmpty((String)makeinvoiceId)) {
            return;
        }
        MakeInvoiceInfo srcMakeInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(srcbillId), this.getSelectors());
        MakeInvoiceInfo makeInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(makeinvoiceId), this.getSelectors());
        makeInvoice.setRedVoiceNumber(srcMakeInvoice.getRedVoiceNumber());
        makeInvoice.setBlueVoiceCode(srcMakeInvoice.getBlueVoiceCode());
        makeInvoice.setBlueVoiceNum(srcMakeInvoice.getBlueVoiceNum());
        makeInvoice.setRedBillId(srcMakeInvoice.getRedBillId());
        super._update(ctx, (IObjectPK)new ObjectUuidPK(makeInvoice.getId().toString()), (IObjectValue)makeInvoice);
    }

    @Override
    protected IObjectValue _combin(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = this.getCollectionByIds(ctx, billIDs);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        InvoiceCombinRuleInfo rule = (InvoiceCombinRuleInfo)InvoiceCombinRuleFactory.getLocalInstance(ctx).getRuleByCreator(user.getId().toString());
        InvoiceCombinRuleType type = rule.getType();
        MakeInvoiceInfo mkInvoice = this.getInvoiceHeader(mkInvoiceCol, rule);
        MakeInvoiceEntryCollection entryCol = this.getEntrys(mkInvoiceCol);
        Map entryMap = this.getCombinMap(entryCol, type);
        this.setCombinEntrys(mkInvoice, entryMap);
        int pricePrecision = this.getPricePrecision(ctx, mkInvoice.getCompany().getId().toString());
        this.calcPriceAndDiscountRate(mkInvoice.getEntries(), pricePrecision);
        return mkInvoice;
    }

    private MakeInvoiceInfo getInvoiceHeader(MakeInvoiceCollection mkInvoiceCol, InvoiceCombinRuleInfo rule) throws BOSException {
        MakeInvoiceInfo mkInvoice = this.cloneMakeInvoiceInfo(mkInvoiceCol.get(0));
        mkInvoice.setBizStatus(InvoiceBizStatus.AFTER_COMBIN);
        mkInvoice.setIsList(rule.isIsList());
        return mkInvoice;
    }

    private MakeInvoiceEntryCollection getEntrys(MakeInvoiceCollection mkInvoiceCol) {
        MakeInvoiceEntryCollection entryCol = new MakeInvoiceEntryCollection();
        for (int idx = 0; idx < mkInvoiceCol.size(); ++idx) {
            entryCol.addCollection(mkInvoiceCol.get(idx).getEntries());
        }
        return entryCol;
    }

    private Map getCombinMap(MakeInvoiceEntryCollection entryCol, InvoiceCombinRuleType type) {
        HashMap<String, MakeInvoiceEntryInfo> entryMap = new HashMap<String, MakeInvoiceEntryInfo>();
        for (int idx = 0; idx < entryCol.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entryCol.get(idx);
            String key = this.getEntryKey(entry, type, "" + idx);
            if (entryMap.containsKey(key)) {
                MakeInvoiceEntryInfo entryExist = (MakeInvoiceEntryInfo)entryMap.get(key);
                this.sumEntryTotal(entryExist, entry);
                continue;
            }
            entry.setId(null);
            entryMap.put(key, entry);
        }
        return entryMap;
    }

    private void setCombinEntrys(MakeInvoiceInfo mkInvoice, Map entryMap) {
        Set keySet = entryMap.keySet();
        for (Object key : keySet) {
            mkInvoice.getEntries().add((MakeInvoiceEntryInfo)entryMap.get(key));
        }
    }

    private void calcPriceAndDiscountRate(MakeInvoiceEntryCollection entries, int pricePrecision) {
        int size = entries.size();
        for (int idx = 0; idx < size; ++idx) {
            MakeInvoiceEntryInfo entry = entries.get(idx);
            if (entry.getQuantity() != null && entry.getQuantity().compareTo(BigDecimal.ZERO) > 0) {
                entry.setNoTaxPrice(entry.getNoTaxAmt().divide(entry.getQuantity(), pricePrecision, 6));
                entry.setPrice(entry.getPriceTax().divide(entry.getQuantity(), pricePrecision, 6));
            }
            if (entry.getDiscountAmt() == null) continue;
            entry.setDiscountRate(entry.getDiscountAmt().divide(entry.getNoTaxAmt(), 2, 6));
        }
    }

    private String getEntryKey(MakeInvoiceEntryInfo entry, InvoiceCombinRuleType type, String defaultKey) {
        String discountRate;
        String key = defaultKey;
        String entryNameId = entry.getEntryName().getId().toString();
        String specs = entry.getSpecs() == null ? "" : entry.getSpecs();
        String measureUnitId = entry.getMeasureUnit() == null ? "" : entry.getMeasureUnit().getId().toString();
        String price = entry.getPrice().toString();
        String string = discountRate = entry.getDiscountRate() == null ? "0" : entry.getDiscountRate().toString();
        if (InvoiceCombinRuleType.NSM.equals((Object)type)) {
            key = this.concat(entryNameId, specs, measureUnitId);
        } else if (InvoiceCombinRuleType.NSMP.equals((Object)type)) {
            key = this.concat(entryNameId, specs, measureUnitId, price);
        } else if (InvoiceCombinRuleType.NSMPD.equals((Object)type)) {
            key = this.concat(entryNameId, specs, measureUnitId, price, discountRate);
        }
        return key;
    }

    private String concat(String ... str) {
        String PREFIX = "_";
        StringBuffer sb = new StringBuffer();
        if (str.length > 0) {
            int len = str.length;
            for (int idx = 0; idx < len; ++idx) {
                sb.append(str[idx] == null ? "" : str[idx]);
                if (idx >= len - 1) continue;
                sb.append(PREFIX);
            }
        }
        return sb.toString();
    }

    private void sumEntryTotal(MakeInvoiceEntryInfo destEntry, MakeInvoiceEntryInfo srcEntry) {
        destEntry.setNoTaxAmt(destEntry.getNoTaxAmt().add(srcEntry.getNoTaxAmt()));
        destEntry.setTaxAmt(destEntry.getTaxAmt().add(srcEntry.getTaxAmt()));
        destEntry.setPriceTax(destEntry.getPriceTax().add(srcEntry.getPriceTax()));
        destEntry.setQuantity(destEntry.getQuantity().add(srcEntry.getQuantity()));
        BigDecimal discountAmtExist = destEntry.getDiscountAmt() == null ? BigDecimal.ZERO : destEntry.getDiscountAmt();
        BigDecimal discountAmt = srcEntry.getDiscountAmt() == null ? BigDecimal.ZERO : srcEntry.getDiscountAmt();
        destEntry.setDiscountAmt(discountAmtExist.add(discountAmt));
    }

    @Override
    protected void _split(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeAudit(ctx, mkInvoice);
        this.checkOverLimitRowAmt(ctx, mkInvoice);
        this.checkAmtOver(ctx, mkInvoice.getId().toString());
        mkInvoice.setStatus(InvoiceBillStatus.AUDITED);
        mkInvoice.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        mkInvoice.setAuditTime(new Timestamp(System.currentTimeMillis()));
        MakeInvoiceEntryCollection entryCol = mkInvoice.getEntries();
        for (int i = 0; i < entryCol.size(); ++i) {
            MakeInvoiceEntryInfo entry = entryCol.get(i);
            if (entry.getTaxClassificationCode() != null || entry.getEntryName() == null || entry.getEntryName().getTaxClassificationCode() == null) continue;
            entry.setTaxClassificationCode(entry.getEntryName().getTaxClassificationCode().getMergeCode());
        }
        this.setBizYearMonthNull(mkInvoice);
        super._update(ctx, pk, (IObjectValue)mkInvoice);
        this.setBillUsers(ctx, mkInvoice);
    }

    @Override
    protected IObjectPK _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(mkInvoice.getId().toString());
        this._audit(ctx, (IObjectPK)pk, null);
        return pk;
    }

    private void setBillUsers(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if (mkInvoice.getCompany() == null) {
            return;
        }
        String companyOrgId = mkInvoice.getCompany().getId().toString();
        OPTypeEnum opType = OPTypeEnum.MakeInvoice;
        String invoiceId = mkInvoice.getId().toString();
        PwySettingInfo settingInfo = PwySettingFactory.getLocalInstance(ctx).getCollectionByCompany(companyOrgId, opType, invoiceId, null);
        if (settingInfo != null) {
            boolean needUpdate = false;
            if (settingInfo.getPwyeetxt() != null && StringUtils.isEmpty((String)mkInvoice.getPayeetxt())) {
                mkInvoice.setPayeetxt(settingInfo.getPwyeetxt());
                needUpdate = true;
            }
            if (settingInfo.getDrawertxt() != null && StringUtils.isEmpty((String)mkInvoice.getDrawertxt())) {
                mkInvoice.setDrawertxt(settingInfo.getDrawertxt());
                needUpdate = true;
            }
            if (settingInfo.getCheckertxt() != null && StringUtils.isEmpty((String)mkInvoice.getChecktxt())) {
                mkInvoice.setChecktxt(settingInfo.getCheckertxt());
                needUpdate = true;
            }
            if (needUpdate) {
                ObjectUuidPK pk = new ObjectUuidPK(mkInvoice.getId().toString());
                this.setBizYearMonthNull(mkInvoice);
                super._update(ctx, (IObjectPK)pk, (IObjectValue)mkInvoice);
            }
        }
    }

    @Override
    protected void _unaudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeUnAudit(ctx, mkInvoice);
        mkInvoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        mkInvoice.setAuditor(null);
        mkInvoice.setAuditTime(null);
        this.setBizYearMonthNull(mkInvoice);
        super._update(ctx, pk, (IObjectValue)mkInvoice);
    }

    @Override
    protected IObjectPK _unaudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(mkInvoice.getId().toString());
        this._unaudit(ctx, (IObjectPK)pk, null);
        return pk;
    }

    @Override
    protected void _checkBeforeCombin(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = this.getCollectionByIds(ctx, billIDs);
        this.checkBeforeCombin(ctx, mkInvoiceCol);
    }

    @Override
    protected void _checkBeforeSplit(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        this.checkBeforeSplit(ctx, mkInvoice);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null || !this._exists(ctx, pk)) {
            return;
        }
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeDelete(ctx, mkInvoice);
        this.beforeDelete(ctx, mkInvoice);
        this.reverseBotpRelation(ctx, new ObjectUuidPK(pk.toString()));
        this.deleteRelation(ctx, new String[]{pk.toString()});
        this.handleInvoiceDetail(ctx, mkInvoice);
        this.recycleNumber(ctx, pk, mkInvoice);
        this.deleteSpecDataByBizBill(ctx, mkInvoice);
        super._delete(ctx, pk);
        if (mkInvoice.isIsRedVoice()) {
            this.writeBackRedFields(ctx, mkInvoice, false);
        }
    }

    private void handleInvoiceDetail(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        String detailBostype = new InvoiceDetailInfo().getBOSType().toString();
        String selectSql = "select FDESTOBJECTID from t_bot_relation where fdestentityid = ? and fsrcobjectid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{detailBostype, mkInvoice.getId().toString()});
        try {
            if (rowSet.next()) {
                String invoiceDetailId = rowSet.getString(1);
                IInvoiceDetail iInvoiceDetail = InvoiceDetailFactory.getLocalInstance(ctx);
                InvoiceDetailInfo detailInfo = iInvoiceDetail.getInvoiceDetailInfo((IObjectPK)new ObjectUuidPK(invoiceDetailId));
                if (detailInfo != null && detailInfo.isIsTaxPlateSync() && mkInvoice.getSrcSystem() != InvoiceSrcSystem.EXCEL) {
                    String updateSql = "update T_IM_InvoiceDetail set FStatus='1' where FID=?";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{invoiceDetailId});
                } else {
                    String deleteBotpSql = "delete from t_bot_relation where fdestentityid = ? and fsrcobjectid = ?";
                    DbUtil.execute((Context)ctx, (String)deleteBotpSql, (Object[])new Object[]{detailBostype, mkInvoice.getId().toString()});
                    String deleteSQL = "delete from T_IM_InvoiceDetail where FID=?";
                    DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{invoiceDetailId});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet, null, null);
        }
    }

    private void beforeDelete(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        try {
            String selectSQL = "select fbizbillid from t_im_makeinvoicerelation where finvoicebillid in" + IMUtils.getInStringFromArray(new String[]{mkInvoice.getId().toString()});
            HashSet<String> idSet = new HashSet<String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            while (rs.next()) {
                String bizBillID = rs.getString("fbizbillid");
                idSet.add(bizBillID);
            }
            if (mkInvoice.isIsRedVoice()) {
                String selectSQL2 = "select fsrcobjectid from T_BOT_Relation where fdestobjectid in" + IMUtils.getInStringFromArray(new String[]{mkInvoice.getId().toString()});
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)selectSQL2);
                while (rs2.next()) {
                    idSet.add(rs2.getString("fsrcobjectid"));
                }
            }
            if (idSet != null && idSet.size() > 0) {
                String upSQL;
                Iterator iterator = idSet.iterator();
                ArrayList<Object[]> tsIds = new ArrayList<Object[]>();
                ArrayList<Object[]> mqIds = new ArrayList<Object[]>();
                ArrayList<Object[]> obIds = new ArrayList<Object[]>();
                ArrayList<Object[]> miIds = new ArrayList<Object[]>();
                ArrayList<Object[]> usedMqIds = new ArrayList<Object[]>();
                String blueBillID = null;
                while (iterator.hasNext()) {
                    int count;
                    String srcBillID = (String)iterator.next();
                    String hasMkBillsql = "SELECT count(*) as count FROM t_im_makeinvoicerelation where fbizbillid = '" + srcBillID + "'";
                    boolean hasOtherMkBill = false;
                    IRowSet countRs = DbUtil.executeQuery((Context)ctx, (String)hasMkBillsql);
                    if (countRs.next() && (count = countRs.getInt("count")) > 1) {
                        hasOtherMkBill = true;
                    }
                    if (StringUtils.isEmpty((String)srcBillID)) continue;
                    String srcBillBosType = BOSUuid.read((String)srcBillID).getType().toString();
                    if ("3D667D4A".equals(srcBillBosType) && !hasOtherMkBill) {
                        tsIds.add(new Object[]{srcBillID});
                    }
                    if ("FC910EF3".equals(srcBillBosType) && !hasOtherMkBill) {
                        obIds.add(new Object[]{srcBillID});
                    }
                    if ("AC368D2D".equals(srcBillBosType) && !hasOtherMkBill) {
                        mqIds.add(new Object[]{srcBillID});
                    }
                    if ("412A6F98".equals(srcBillBosType)) {
                        miIds.add(new Object[]{srcBillID});
                        blueBillID = srcBillID;
                    }
                    if (!"0CADF79B".equals(srcBillBosType)) continue;
                    usedMqIds.add(new Object[]{srcBillID});
                }
                if (!tsIds.isEmpty()) {
                    upSQL = "update t_im_taxseparation set fstatus = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, tsIds);
                }
                if (!obIds.isEmpty()) {
                    upSQL = "update t_ar_otherbill set fismakeinvoiced = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, obIds);
                }
                if (!mqIds.isEmpty()) {
                    upSQL = "update T_IM_MakeInvoiceReq set FIsMakeInoviced = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, mqIds);
                }
                if (!usedMqIds.isEmpty()) {
                    upSQL = "update T_IM_UsedCarInvoiceReq set FIsMakeInvoiced = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, usedMqIds);
                }
                if (!miIds.isEmpty()) {
                    String redIdSql = "select fdestobjectid as redInvoiceId from T_BOT_Relation where fsrcobjectid in" + IMUtils.getInStringFromArray(new String[]{blueBillID}) + " and FDESTENTITYID = '" + "412A6F98" + "'";
                    boolean hasOtherRedBill = false;
                    IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)redIdSql);
                    HashSet<String> redInvoiceIdSet = new HashSet<String>();
                    while (rs1.next()) {
                        redInvoiceIdSet.add(rs1.getString("redInvoiceId"));
                    }
                    if (redInvoiceIdSet.size() > 0) {
                        int count;
                        HashSet<String> statusSet = new HashSet<String>();
                        statusSet.add("1");
                        statusSet.add("2");
                        statusSet.add("3");
                        statusSet.add("4");
                        String redCountSql = "select count(*) as count from t_im_makeinvoice where FStatus in " + IMUtils.getInStringFromSet(statusSet) + " and fid in " + IMUtils.getInStringFromSet(redInvoiceIdSet);
                        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)redCountSql);
                        if (rs2.next() && (count = rs2.getInt("count")) > 1) {
                            hasOtherRedBill = true;
                        }
                    }
                    if (!hasOtherRedBill) {
                        String upSQL2 = "update T_IM_MakeInvoice set fisredvoicedbill = 0 where fid = ? ";
                        DbUtil.executeBatch((Context)ctx, (String)upSQL2, miIds);
                    }
                }
                InvoiceReq2SaleOrderDisposerAdapter disposerAdapter = new InvoiceReq2SaleOrderDisposerAdapter();
                disposerAdapter.dispose(ctx, "delete", mkInvoice.getId().toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void reverseBotpRelation(Context ctx, ObjectUuidPK objectUuidPK) throws BOSException {
        try {
            String pk = objectUuidPK.toString();
            String bostype = new MakeInvoiceInfo().getBOSType().toString();
            String deleSQL = "delete from t_bot_relation where fdestentityid = ? and fdestobjectid = ?";
            DbUtil.execute((Context)ctx, (String)deleSQL, (Object[])new Object[]{bostype, pk});
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void updatePwyLog(Context ctx, PwyLogInfo pwyLog, MakeInvoiceInfo mkInvoice) throws BOSException, IMException {
        IPwyLog iPwyLog = PwyLogFactory.getLocalInstance(ctx);
        PwyLogInfo pwyLogDB = iPwyLog.getValue((IObjectPK)new ObjectUuidPK(pwyLog.getId().toString()));
        if (pwyLogDB == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND_LOG", mkInvoice.getNumber())});
        }
        pwyLogDB.setStatus(PwyLogStatus.FINISH);
        pwyLogDB.setRemark(null);
        logger.info((Object)("\u7968\u65e0\u5fe7\u65e5\u5fd7" + PwyLogInfo.toString(pwyLog)));
        pwyLog.setUpdateTime(Calendar.getInstance().getTime());
        iPwyLog.update((IObjectPK)new ObjectUuidPK(pwyLogDB.getId().toString()), pwyLogDB);
    }

    private void addInvoiceBookEntry(Context ctx, MakeInvoiceInfo invoiceInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("typeCode", (Object)invoiceInfo.getInvoiceNumber()));
        filter.getFilterItems().add(new FilterItemInfo("startNumber", (Object)invoiceInfo.getInvoiceNo(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endNumber", (Object)invoiceInfo.getInvoiceNo(), CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        InvoiceBookCollection bookCol = InvoiceBookFactory.getLocalInstance(ctx).getInvoiceBookCollection(view);
        if (bookCol.size() > 0) {
            InvoiceBookInfo invoiceBook = bookCol.get(0);
            invoiceBook.setUsableCount(invoiceBook.getUsableCount() - 1);
            invoiceBook.setUsedCount(invoiceBook.getUsedCount() + 1);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("usableCount");
            selector.add("usedCount");
            InvoiceBookFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)invoiceBook, selector);
            InvoiceBookEntryInfo bookEntry = new InvoiceBookEntryInfo();
            bookEntry.setStatus(InvoiceBookEntryStatusEnum.USED);
            bookEntry.setInvoiceNumber(invoiceInfo.getInvoiceNo());
            bookEntry.setDrawDate(Calendar.getInstance().getTime());
            bookEntry.setDrawer(ContextUtil.getCurrentUserInfo((Context)ctx));
            bookEntry.setInvoiceBook(invoiceBook);
            InvoiceBookEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)bookEntry);
        }
    }

    private void redInvoiceCancel(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException {
        if (!mkInvoice.isIsRedVoice()) {
            return;
        }
        String blueBillId = mkInvoice.getRedBillId();
        String redIdSql = "select fdestobjectid as redInvoiceId from T_BOT_Relation where fsrcobjectid ='" + blueBillId + "' and FDESTENTITYID = '" + "412A6F98" + "'";
        boolean hasOtherRedBill = false;
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)redIdSql);
        HashSet<String> redInvoiceIdSet = new HashSet<String>();
        try {
            while (rs1.next()) {
                redInvoiceIdSet.add(rs1.getString("redInvoiceId"));
            }
            if (redInvoiceIdSet.size() > 0) {
                int count;
                HashSet<String> statusSet = new HashSet<String>();
                statusSet.add("1");
                statusSet.add("2");
                statusSet.add("3");
                statusSet.add("4");
                String redCountSql = "select count(*) as count from t_im_makeinvoice where FStatus in " + IMUtils.getInStringFromSet(statusSet) + " and fid in " + IMUtils.getInStringFromSet(redInvoiceIdSet);
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)redCountSql);
                if (rs2.next() && (count = rs2.getInt("count")) > 0) {
                    hasOtherRedBill = true;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!hasOtherRedBill) {
            StringBuffer sb = new StringBuffer();
            sb.append(" update T_IM_MakeInvoice set FIsRedVoicedBill = 0 where fid = ?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{blueBillId});
        }
    }

    @Override
    protected void _afterCancelInvoice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeCancel(ctx, mkInvoice);
        mkInvoice.setStatus(InvoiceBillStatus.DELETED);
        mkInvoice.setIsDelete(true);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        mkInvoice.setDeleteUser(currentUserInfo);
        mkInvoice.setDeleteDate(new Date());
        super._update(ctx, pk, (IObjectValue)mkInvoice);
        this.updateInvoiceBook(ctx, mkInvoice.getInvoiceNumber(), mkInvoice.getInvoiceNo());
        this.redInvoiceCancel(ctx, mkInvoice);
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose("cancel", (IObjectValue)mkInvoice);
        if (mkInvoice.isIsRedVoice()) {
            this.writeBackRedFields(ctx, mkInvoice, false);
        }
    }

    private void updateInvoiceBook(Context ctx, String invoiceNumber, String invoiceNo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("typeCode", (Object)invoiceNumber));
        view.setFilter(filter);
        InvoiceBookCollection bookCol = InvoiceBookFactory.getLocalInstance(ctx).getInvoiceBookCollection(view);
        if (bookCol.size() > 0) {
            InvoiceBookInfo invoiceBook = bookCol.get(0);
            String bookId = invoiceBook.getId().toString();
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNo));
            filter.getFilterItems().add(new FilterItemInfo("invoiceBook.id", (Object)bookId));
            filter.getFilterItems().add(new FilterItemInfo("invoiceBook.startNumber", (Object)invoiceNo, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceBook.endNumber", (Object)invoiceNo, CompareType.GREATER_EQUALS));
            view.setFilter(filter);
            InvoiceBookEntryCollection bookEntryCol = InvoiceBookEntryFactory.getLocalInstance(ctx).getInvoiceBookEntryCollection(view);
            if (bookEntryCol.size() > 0) {
                InvoiceBookEntryInfo bookEntry = bookEntryCol.get(0);
                bookEntry.setStatus(InvoiceBookEntryStatusEnum.INVALID);
                bookEntry.setInvalidDate(Calendar.getInstance().getTime());
                bookEntry.setInvalidPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
                bookEntry.setReason(IMUtils.getIMResource(ctx, "CANCELREASON1", new String[0]));
                InvoiceBookEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(bookEntry.getId().toString()), (CoreBaseInfo)bookEntry);
            }
        }
    }

    @Override
    protected IObjectValue _red(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        if (ctx.get((Object)"isBatchRed") == null || !"1".equals(ctx.get((Object)"isBatchRed"))) {
            this.checkBeforeRed(ctx, mkInvoice);
        }
        mkInvoice.remove("");
        String redInvoiceID = null;
        String redInvoiceNumber = null;
        String redVoiceNumber = null;
        String redInvoiceStatus = null;
        String redMsgType = null;
        String rushRedReason = null;
        if (ctx.get((Object)"redInvoiceParam") != null) {
            Map param = (Map)ctx.get((Object)"redInvoiceParam");
            redInvoiceID = (String)param.get("redInvoiceID");
            redInvoiceNumber = (String)param.get("redInvoiceNumber");
            redVoiceNumber = (String)param.get("redVoiceNumber");
            redInvoiceStatus = (String)param.get("redInvoiceStatus");
            redMsgType = (String)param.get("redMsgType");
            rushRedReason = (String)param.get("rushRedReason");
            ctx.remove((Object)"redInvoiceParam");
        }
        mkInvoice.setApplicateDate(Calendar.getInstance().getTime());
        mkInvoice.setBizDate(Calendar.getInstance().getTime());
        mkInvoice.setApplicant(ContextUtil.getCurrentUserInfo((Context)ctx));
        this.combinRedBillEntry(ctx, mkInvoice);
        if (!StringUtils.isEmpty((String)redInvoiceID)) {
            mkInvoice.setId(BOSUuid.read((String)redInvoiceID));
        } else {
            mkInvoice.setId(BOSUuid.create((String)"412A6F98"));
        }
        MakeInvoiceEntryCollection entries = mkInvoice.getEntries();
        for (int idx = 0; idx < entries.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entries.get(idx);
            entry.setSourceBillEntryId(entry.getId().toString());
            entry.setId(null);
            MakeInvoiceInfo newMakeInvoice = new MakeInvoiceInfo();
            newMakeInvoice.setId(mkInvoice.getId());
            entry.setMakeInvoice(newMakeInvoice);
            if (entry.getQuantity() != null) {
                entry.setQuantity(entry.getQuantity().negate());
            }
            entry.setNoTaxAmt(entry.getNoTaxAmt().negate());
            entry.setTaxAmt(entry.getTaxAmt().negate());
            entry.setPriceTax(entry.getPriceTax().negate());
            if (entry.getDiscountAmt() != null) {
                entry.setDiscountAmt(entry.getDiscountAmt().negate());
            }
            if (entry.getDeductAmt() == null) continue;
            entry.setDeductAmt(entry.getDeductAmt().negate());
        }
        mkInvoice.setRedBillId(billID);
        if (!StringUtils.isEmpty((String)redVoiceNumber)) {
            mkInvoice.setRedVoiceNumber(redVoiceNumber);
        }
        if (!StringUtils.isEmpty((String)redInvoiceStatus)) {
            mkInvoice.setStatus(InvoiceBillStatus.getEnum(redInvoiceStatus));
        } else {
            mkInvoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        }
        if (!StringUtils.isEmpty((String)redMsgType) && mkInvoice.isIsVehicle()) {
            mkInvoice.setRedMsgType(RedMsgTypeEnum.getEnum(redMsgType));
        } else {
            mkInvoice.setRedMsgType(null);
        }
        mkInvoice.setBlueInvoiceType(mkInvoice.getInvoiceType());
        mkInvoice.setBlueInvoiceDate(mkInvoice.getInvoiceDate());
        if (!StringUtils.isEmpty((String)rushRedReason) && !"null".equals(rushRedReason)) {
            mkInvoice.setRushRedReason(RushRedReasonEnum.getEnum(rushRedReason));
        } else if (mkInvoice.getRushRedReason() == null) {
            mkInvoice.setRushRedReason(RushRedReasonEnum.MakeInvWrong);
        }
        mkInvoice.setBizStatus(InvoiceBizStatus.NULL);
        mkInvoice.setBlueVoiceCode(mkInvoice.getInvoiceNumber());
        mkInvoice.setBlueVoiceNum(mkInvoice.getInvoiceNo());
        mkInvoice.setInvoiceNo(null);
        mkInvoice.setInvoiceNumber(null);
        mkInvoice.setInvoiceDate(null);
        mkInvoice.put("makeInvoiceType", null);
        mkInvoice.setSrcSystem(InvoiceSrcSystem.REDINVOICE);
        mkInvoice.setIsPrint(false);
        mkInvoice.setApplicant(ContextUtil.getCurrentUserInfo((Context)ctx));
        mkInvoice.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp createtime = this.getTime();
        mkInvoice.setCreateTime(createtime);
        mkInvoice.setFiVouchered(false);
        mkInvoice.setIsRedVoice(true);
        mkInvoice.setIsRedVoicedBill(false);
        mkInvoice.setAuditor(null);
        mkInvoice.setAuditTime(null);
        mkInvoice.setLastUpdateUser(null);
        mkInvoice.setLastUpdateTime(null);
        mkInvoice.setDrawer(null);
        mkInvoice.setPayee(null);
        mkInvoice.setChecker(null);
        mkInvoice.setDrawertxt(null);
        mkInvoice.setPayeetxt(null);
        mkInvoice.setChecktxt(null);
        mkInvoice.setSnapShotUrl(null);
        mkInvoice.setIsDelete(false);
        mkInvoice.setPlateNo(null);
        mkInvoice.setExtensionNo(null);
        mkInvoice.setInvoiceUrl(null);
        if (!StringUtils.isEmpty((String)redInvoiceNumber)) {
            mkInvoice.setNumber(redInvoiceNumber);
        } else {
            String redNumber = "red_" + mkInvoice.getNumber();
            String strCompanyID = mkInvoice.getCompany() != null && mkInvoice.getCompany().getId() != null ? mkInvoice.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)mkInvoice, strCompanyID);
            if (ruleInfo != null) {
                redNumber = this.getNumer(ctx, mkInvoice);
            }
            mkInvoice.setNumber(redNumber);
        }
        if (this.checkIsPreMakeInvoice(ctx, billID)) {
            mkInvoice.setIsRedBlueSourceBill(true);
        }
        this.doRedBillRemork(ctx, mkInvoice);
        return mkInvoice;
    }

    @Override
    protected IObjectValue _reGenRedInvoice(Context ctx, String blueBillID, Map param) throws BOSException, EASBizException {
        ctx.put((Object)"redInvoiceParam", (Object)param);
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)this._red(ctx, blueBillID);
        ObjectUuidPK pk = new ObjectUuidPK(mkInvoice.getId());
        this._update(ctx, (IObjectPK)pk, (IObjectValue)mkInvoice);
        return this._getValue(ctx, (IObjectPK)pk, IMSelectorFactory.getMakeInvoiceSelectors());
    }

    private void combinRedBillEntry(Context ctx, MakeInvoiceInfo invoice) throws EASBizException, BOSException {
        MakeInvoiceCollection redColl = this.getRedInvoicesByRed(ctx, invoice.getId().toString());
        Map unRedNoTaxAmt = new HashMap();
        unRedNoTaxAmt = this.calUnRedNoTaxAmt(invoice, redColl);
        MakeInvoiceEntryCollection entrys = null;
        entrys = invoice.getEntries();
        MakeInvoiceEntryCollection tempEntrys = null;
        tempEntrys = (MakeInvoiceEntryCollection)((Object)entrys.clone());
        entrys.clear();
        int seq = 0;
        for (int j = 0; j < tempEntrys.size(); ++j) {
            MakeInvoiceEntryInfo tempEntry = tempEntrys.get(j);
            if (tempEntry.getUnRedPriceTax() == null || BigDecimal.ZERO.compareTo(tempEntry.getUnRedPriceTax()) == 0) continue;
            if (tempEntry.getUnRedPriceTax() != null && tempEntry.getUnRedPriceTax().compareTo(tempEntry.getPriceTax() == null ? BigDecimal.ZERO : tempEntry.getPriceTax()) == 0) {
                tempEntry.put("priceTaxSame", true);
            } else if (unRedNoTaxAmt.size() > 0 && unRedNoTaxAmt.containsKey(tempEntry.getId().toString())) {
                tempEntry.setNoTaxAmt((BigDecimal)unRedNoTaxAmt.get(tempEntry.getId().toString()));
            }
            tempEntry.setSeq(seq);
            tempEntry.setBillRowType(RowType.NORMAL_ROW);
            tempEntry.setQuantity(tempEntry.getUnRedQty());
            tempEntry.setPriceTax(tempEntry.getUnRedPriceTax());
            tempEntry.setUnRedPriceTax(null);
            tempEntry.setUnRedQty(null);
            tempEntry.setRedPriceTax(null);
            tempEntry.setRedQty(null);
            entrys.add(tempEntry);
            ++seq;
        }
        this.calInvoiceFields(invoice);
    }

    protected Map calUnRedNoTaxAmt(MakeInvoiceInfo blueInfo, MakeInvoiceCollection redColl) {
        HashMap<String, BigDecimal> alreadyRedNoTaxAmt = new HashMap<String, BigDecimal>();
        MakeInvoiceEntryCollection redEntryColl = null;
        MakeInvoiceEntryInfo redEntryInfo = null;
        BigDecimal noTaxAmt = BigDecimal.ZERO;
        if (redColl != null && redColl.size() > 0) {
            int j = redColl.size();
            for (int i = 0; i < j; ++i) {
                redEntryColl = redColl.get(i).getEntries();
                int l = redEntryColl.size();
                for (int k = 0; k < l; ++k) {
                    redEntryInfo = redEntryColl.get(k);
                    if (alreadyRedNoTaxAmt.containsKey(redEntryInfo.getSourceBillEntryId())) {
                        noTaxAmt = (BigDecimal)alreadyRedNoTaxAmt.get(redEntryInfo.getSourceBillEntryId());
                        noTaxAmt = noTaxAmt.add(redEntryInfo.getNoTaxAmt() == null ? BigDecimal.ZERO : redEntryInfo.getNoTaxAmt());
                        alreadyRedNoTaxAmt.put(redEntryInfo.getSourceBillEntryId(), noTaxAmt);
                        continue;
                    }
                    alreadyRedNoTaxAmt.put(redEntryInfo.getSourceBillEntryId(), redEntryInfo.getNoTaxAmt() == null ? BigDecimal.ZERO : redEntryInfo.getNoTaxAmt());
                }
            }
        }
        HashMap<String, BigDecimal> unRedNoTaxAmt = new HashMap<String, BigDecimal>();
        MakeInvoiceEntryCollection blueEntryColl = null;
        MakeInvoiceEntryInfo blueEntryInfo = null;
        blueEntryColl = blueInfo.getEntries();
        int j = blueEntryColl.size();
        for (int i = 0; i < j; ++i) {
            blueEntryInfo = blueEntryColl.get(i);
            if (blueEntryInfo.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) {
                if (alreadyRedNoTaxAmt.containsKey(blueEntryInfo.getSourceBillEntryId())) {
                    noTaxAmt = (BigDecimal)alreadyRedNoTaxAmt.get(blueEntryInfo.getSourceBillEntryId());
                    noTaxAmt = noTaxAmt.add(blueEntryInfo.getNoTaxAmt() == null ? BigDecimal.ZERO : blueEntryInfo.getNoTaxAmt());
                    alreadyRedNoTaxAmt.put(blueEntryInfo.getSourceBillEntryId(), noTaxAmt);
                    continue;
                }
                alreadyRedNoTaxAmt.put(blueEntryInfo.getSourceBillEntryId(), blueEntryInfo.getNoTaxAmt() == null ? BigDecimal.ZERO : blueEntryInfo.getNoTaxAmt());
                continue;
            }
            unRedNoTaxAmt.put(blueEntryInfo.getId().toString(), blueEntryInfo.getNoTaxAmt() == null ? BigDecimal.ZERO : blueEntryInfo.getNoTaxAmt());
        }
        Iterator it = unRedNoTaxAmt.keySet().iterator();
        String key = "";
        while (it.hasNext()) {
            key = it.next().toString();
            if (!alreadyRedNoTaxAmt.containsKey(key)) continue;
            noTaxAmt = ((BigDecimal)unRedNoTaxAmt.get(key)).add((BigDecimal)alreadyRedNoTaxAmt.get(key));
            unRedNoTaxAmt.put(key, noTaxAmt);
        }
        return unRedNoTaxAmt;
    }

    private void calInvoiceEntryFields(boolean isInTax, MakeInvoiceEntryInfo entry) {
        BigDecimal notTaxPrice = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal priceTax = entry.getPriceTax();
        BigDecimal notTaxAmt = entry.getNoTaxAmt();
        BigDecimal tax = priceTax.subtract(entry.getNoTaxAmt());
        if (entry.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
            price = priceTax.divide(entry.getQuantity(), 10, 4);
            notTaxPrice = notTaxAmt.divide(entry.getQuantity(), 10, 4);
        }
        entry.setTaxAmt(tax);
        entry.setNoTaxPrice(notTaxPrice);
        entry.setPrice(price);
        entry.setBillRowType(RowType.NORMAL_ROW);
    }

    private void calInvoiceFields(MakeInvoiceInfo info) {
        MakeInvoiceEntryCollection entrys = null;
        MakeInvoiceEntryInfo entry = null;
        BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        entrys = info.getEntries();
        for (int j = 0; j < entrys.size(); ++j) {
            entry = entrys.get(j);
            if (entry.get("priceTaxSame") == null) {
                this.calInvoiceEntryFields(info.isIsContainTax(), entry);
            }
            totalNoTaxAmt = totalNoTaxAmt.add(entry.getNoTaxAmt());
            totalTax = totalTax.add(entry.getTaxAmt());
            totalTaxAmt = totalTaxAmt.add(entry.getPriceTax());
        }
        info.setNoTaxAmtTotal(totalNoTaxAmt);
        info.setTaxAmtTotal(totalTax);
        info.setPriceTaxTotal(totalTaxAmt);
    }

    public void setNewNumber(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if (mkInvoice.getNumber() != null) {
            this.isSameNumber(ctx, mkInvoice);
            return;
        }
        if (StringUtils.isEmpty((String)mkInvoice.getNumber())) {
            String number = this.getNumer(ctx, mkInvoice);
            mkInvoice.setNumber(number);
        }
    }

    private void isSameNumber(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        OrgUnitInfo company;
        if (mkInvoice.isIERPBizType()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)mkInvoice.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (mkInvoice.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)mkInvoice.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((company = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)mkInvoice)) != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo cufilter = new FilterInfo();
            cufilter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getId().toString(), CompareType.EQUALS));
            view.setFilter(cufilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("CU.id"));
            view.setSelector(sic);
            CompanyOrgUnitCollection companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            company = companyOrgUnit.get(0);
            if (company.getCU() != null) {
                filterItem = new FilterItemInfo("CU", (Object)company.getCU().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            } else {
                filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (mkInvoice.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)mkInvoice.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        int size = filter.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            throw new MakeInvoiceException(MakeInvoiceException.NUMBEREXISTS_ERROR, new String[]{mkInvoice.getNumber()});
        }
    }

    private String getNumer(Context ctx, MakeInvoiceInfo caller) throws BOSException, EASBizException {
        IMakeInvoice iBillBase = MakeInvoiceFactory.getLocalInstance(ctx);
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + strCompanyID + "'").getCU());
        int maxCycleNum = 100;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyID, CompareType.EQUALS));
        if (caller.get("id") != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", caller.get("id"), CompareType.NOTEQUALS));
        }
        while (number == null || number.equals("") || iBillBase.exists(filter)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID);
            number = iCodingRuleManager.getNumber((IObjectValue)caller, ruleInfo);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyID, CompareType.EQUALS));
            if (caller.get("id") == null) continue;
            filter.getFilterItems().add(new FilterItemInfo("id", caller.get("id"), CompareType.NOTEQUALS));
        }
        return number;
    }

    private void recycleNumber(Context ctx, IObjectPK pk, MakeInvoiceInfo info) throws EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, sic);
        }
        if (info.getNumber() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getNumber());
            }
        }
    }

    public void checkBeforeSubmit(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        if (mkInvoice.getCompany() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])).append(NEXTLINE);
        } else {
            try {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_edit");
            }
            catch (Exception e) {
                errorMsg.append(e.getMessage()).append(NEXTLINE);
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
            }
        }
        if (mkInvoice.getStatus() != null && !InvoiceBillStatus.TEMPSTROE.equals((Object)mkInvoice.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "STATUSNETEMPSTORE", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.getApplicateDate() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "APPLICATEDATEISNULL", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.getInvoiceType() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "INVOICETYPEISNULL", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.isIsPurchaseInvoice() && (mkInvoice.getInvoiceType() == null || "1".equals(mkInvoice.getInvoiceType().getValue()) || "3".equals(mkInvoice.getInvoiceType().getValue()) || "5".equals(mkInvoice.getInvoiceType().getValue()))) {
            errorMsg.append(IMUtils.getIMResource(ctx, "INVOICETYPE_ERROR", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.getCurrentAccountType() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "CURRACCTTYPEISNULL", new String[0])).append(NEXTLINE);
        }
        if (StringUtils.isEmpty((String)mkInvoice.getReceiveCompany())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "RECVCOMPANYISNULL", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.getInvoiceType() != null && ("1".equals(mkInvoice.getInvoiceType().getValue()) || "3".equals(mkInvoice.getInvoiceType().getValue()) || "5".equals(mkInvoice.getInvoiceType().getValue())) && (mkInvoice.getTaxNumber() == null || "".equals(mkInvoice.getTaxNumber().trim()))) {
            errorMsg.append(mkInvoice.getInvoiceType().getAlias() + IMUtils.getIMResource(ctx, "TAXNUMBERISNULL", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.getInvoiceType() != null && ("1".equals(mkInvoice.getInvoiceType().getValue()) || "3".equals(mkInvoice.getInvoiceType().getValue()))) {
            if (mkInvoice.getAddress() == null || "".equals(mkInvoice.getAddress().trim())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "ADDRESSTELISNULL", new String[0])).append(NEXTLINE);
            }
            if (mkInvoice.getBankAccount() == null || "".equals(mkInvoice.getBankAccount().trim())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "BANKACCOUNTISNULL", new String[0])).append(NEXTLINE);
            }
        }
        if (this.isRedVoice(mkInvoice) && mkInvoice.getInvoiceType() != null && (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)mkInvoice.getInvoiceType())) && mkInvoice.getRushRedReason() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "RUSHREDREASONISNULL", new String[0])).append(NEXTLINE);
        }
        if (IMUtils.getStringlength(mkInvoice.getAddress()) > 100) {
            errorMsg.append(IMUtils.getIMResource(ctx, "ADDRESS_OVER_LENGTH", new String[0])).append(NEXTLINE);
        }
        String remark = IMUtils.cutStr(mkInvoice.getRemark(), 230);
        mkInvoice.setRemark(remark);
        if (IMUtils.getStringlength(mkInvoice.getBankAccount()) > 100) {
            errorMsg.append(IMUtils.getIMResource(ctx, "BANKACCOUNT_OVER_LENGTH", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.isIsPurchaseInvoice() && mkInvoice.isIsVehicle()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", ctx.getLocale())).append(NEXTLINE);
        }
        PayInvoiceTypeEnum invoiceType = mkInvoice.getInvoiceType();
        PayInvoiceTypeEnum blueInvoiceType = mkInvoice.getBlueInvoiceType();
        if (this.isRedVoice(mkInvoice) && invoiceType != null && blueInvoiceType != null && !PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)invoiceType) && !PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)blueInvoiceType)) {
            if ((PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType) || PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) && !PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)blueInvoiceType) && !PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)blueInvoiceType)) {
                errorMsg.append(IMUtils.getIMResource(ctx, "invoiceTypeDiff", new String[0])).append(NEXTLINE);
            } else if ((PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType)) && !PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)blueInvoiceType) && !PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)blueInvoiceType)) {
                errorMsg.append(IMUtils.getIMResource(ctx, "invoiceTypeDiff", new String[0])).append(NEXTLINE);
            }
        }
        HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
        if (mkInvoice.getRedBillId() != null) {
            MakeInvoiceInfo blue = (MakeInvoiceInfo)MakeInvoiceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(mkInvoice.getRedBillId()));
            MakeInvoiceEntryCollection entries = blue.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                MakeInvoiceEntryInfo entry = entries.get(i);
                String key = null;
                key = entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) ? entry.getSourceBillEntryId() : entry.getId().toString();
                if (bluePriceTax.containsKey(key)) {
                    bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(entry.getPriceTax()));
                    continue;
                }
                bluePriceTax.put(key, entry.getPriceTax());
            }
        }
        String companyId = mkInvoice.getCompany().getId().toString();
        int limitSplitMethod = IMUtils.getIntegerParam(ctx, companyId, "VATM010");
        mkInvoice.setLimitSplitMethod(limitSplitMethod);
        int goldenTaxControl = -1;
        goldenTaxControl = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()) ? 2 : IMUtils.getIntegerParam(ctx, companyId, "VATM015");
        mkInvoice.setGoldenTaxControl(goldenTaxControl);
        Map<String, String> taxControlMap = IMUtils.getTaxControlParam(ctx, goldenTaxControl, new String[]{"diffFactor", "allowDiffMax", "allowTotalDiffMax", "allowDiffAmtMax", "allowDiffMaxAvg"});
        BigDecimal allowDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMax"));
        mkInvoice.setAllowDiffMax(allowDiffMax);
        BigDecimal diffFactor = IMUtils.getDecimalValue(taxControlMap.get("diffFactor"));
        mkInvoice.setDiffFactor(diffFactor);
        BigDecimal allowTotalDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowTotalDiffMax"));
        mkInvoice.setAllowTotalDiffMax(allowTotalDiffMax);
        BigDecimal allowDiffAmtMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffAmtMax"));
        mkInvoice.setAllowDiffAmtMax(allowDiffAmtMax);
        BigDecimal allowDiffMaxAvg = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMaxAvg"));
        mkInvoice.setAllowDiffMaxAvg(allowDiffMaxAvg);
        MakeInvoiceEntryCollection entries = mkInvoice.getEntries();
        Map<String, TaxClassificationCodeInfo> tccMap = null;
        if (mkInvoice.isIsVehicle()) {
            MakeInvoiceEntryInfo entry = null;
            HashSet<String> tccCodeSet = new HashSet<String>();
            for (int i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (StringUtils.isEmpty((String)entry.getTaxClassificationCode())) continue;
                tccCodeSet.add(entry.getTaxClassificationCode());
            }
            tccMap = Collection2MapUtils.getTaxClassificationCodeInfoMap(ctx, tccCodeSet);
        }
        this.checkBillDiffer(ctx, mkInvoice, errorMsg, goldenTaxControl);
        HashMap<String, String> taxClassCodeMap = new HashMap<String, String>();
        if (entries == null || entries.size() == 0) {
            errorMsg.append(IMUtils.getIMResource(ctx, "NOENTRY", new String[0])).append(NEXTLINE);
        } else {
            boolean isTCCRequired = true;
            MakeInvoiceEntryInfo entryInfo = entries.get(0);
            if (InvoiceSrcSystem.DOWNLOAD.equals((Object)mkInvoice.getSrcSystem()) && mkInvoice.isIsRedVoice() && !StringUtils.isEmpty((String)entryInfo.getProduceName()) && entryInfo.getProduceName().contains("\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355")) {
                isTCCRequired = false;
            }
            Map paramMap = IMUtils.getParam(ctx, mkInvoice.getCompany().getId().toString(), new String[]{"VATM020"});
            boolean vatm020 = Boolean.valueOf(paramMap.get("VATM020").toString());
            TaxClassificationCodeCollection taxClassCodeColl = null;
            HashSet<String> taxClassCodeSet = new HashSet<String>();
            if (vatm020) {
                for (int i = 0; i < entries.size(); ++i) {
                    MakeInvoiceEntryInfo entry = entries.get(i);
                    String taxClassCode = entry.getTaxClassificationCode();
                    if (StringUtils.isEmpty((String)taxClassCode)) continue;
                    taxClassCodeSet.add(taxClassCode);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("mergeCode"));
                sic.add(new SelectorItemInfo("simpleName"));
                view.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("mergeCode", taxClassCodeSet, CompareType.INCLUDE));
                view.setFilter(filter);
                taxClassCodeColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(view);
                for (int i = 0; i < taxClassCodeColl.size(); ++i) {
                    taxClassCodeMap.put(taxClassCodeColl.get(i).getMergeCode(), taxClassCodeColl.get(i).getSimpleName());
                }
            }
            BigDecimal priceTaxTotal = BigDecimal.ZERO;
            for (int idx = 0; idx < entries.size(); ++idx) {
                TaxClassificationCodeInfo tccInfo;
                StringBuffer lineMsg = new StringBuffer();
                MakeInvoiceEntryInfo entry = entries.get(idx);
                if (IMUtils.getStringlength(entry.getSpecs()) > 40) {
                    lineMsg.append(IMUtils.getResource("com.kingdee.eas.tm.im.ProductCodeResource", "model", ctx));
                    lineMsg.append(IMUtils.getResource("com.kingdee.eas.tm.im.ProductCodeResource", "OVERLENGTH", ctx));
                }
                if (entry.getEntryName() == null && entry.getProduceName() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "PRODNAMEISNULL", new String[0]));
                }
                if (entry.getPrice() != null && entry.getPrice().signum() == -1) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "PRICECANNOTNEG", new String[0]));
                }
                if (entry.getNoTaxPrice() != null && entry.getNoTaxPrice().signum() == -1) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "NPRICECANNOTNEG", new String[0]));
                }
                if (entry.getNoTaxAmt() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "NOTAXAMOUTISNULL", new String[0]));
                }
                if (entry.getTaxRate() == null) {
                    entry.setTaxRate(BigDecimal.ZERO);
                }
                if (BigDecimal.ZERO.compareTo(entry.getTaxRate()) == 0 && (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()))) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "VATRATEISZERO", new String[0]));
                }
                if (entry.getTaxAmt() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "TAXAMTISNULL", new String[0]));
                }
                if (entry.getPriceTax() == null) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "PRICETAXISNULL", new String[0]));
                } else if (entry.getPriceTax().compareTo(BigDecimal.ZERO) == 0) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "PRICETAXNOTZERO", new String[0]));
                } else {
                    priceTaxTotal = priceTaxTotal.add(entry.getPriceTax());
                }
                if (isTCCRequired && (entry.getTaxClassificationCode() == null || "".equals(entry.getTaxClassificationCode()))) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "TAXCLASSCODENULL", new String[0]));
                }
                this.checkEntryDiffer(ctx, mkInvoice, entries, idx, lineMsg, entry);
                if (mkInvoice.getRedBillId() != null && bluePriceTax.get(entry.getSourceBillEntryId()) != null && entry.getPriceTax().abs().compareTo(((BigDecimal)bluePriceTax.get(entry.getSourceBillEntryId())).abs()) > 0) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "REDOVERBLUE", new String[0]));
                }
                if (mkInvoice.isIsVehicle()) {
                    if (RedMsgTypeEnum.VEHICLE_REJECT.equals((Object)mkInvoice.getRedMsgType())) {
                        if (StringUtils.isEmpty((String)entry.getSpecs())) {
                            lineMsg.append(",").append(IMUtils.getIMResource(ctx, "SPECS_NOTNULL", new String[0]));
                        }
                        if (StringUtils.isEmpty((String)entry.getMakeInvoiceUnit())) {
                            lineMsg.append(",").append(IMUtils.getIMResource(ctx, "UNIT_NOTNULL", new String[0]));
                        }
                    } else if (RedMsgTypeEnum.VEHICLE_DISCOUNT.equals((Object)mkInvoice.getRedMsgType()) && StringUtils.isEmpty((String)entry.getMakeInvoiceUnit())) {
                        lineMsg.append(",").append(IMUtils.getIMResource(ctx, "UNIT_NOTNULL", new String[0]));
                    }
                }
                if (vatm020) {
                    int taxClassCodeLength = 0;
                    Object taxSimpleName = taxClassCodeMap.get(entry.getTaxClassificationCode());
                    taxClassCodeLength = taxSimpleName != null ? IMUtils.getStringlength(entry.getProduceName()) + IMUtils.getStringlength((String)taxSimpleName) : IMUtils.getStringlength(entry.getProduceName());
                    if (taxClassCodeLength > 90) {
                        lineMsg.append(",").append(IMUtils.getIMResource(ctx, "TAXCLASSCODE_TOLONG", "" + taxClassCodeLength));
                    }
                }
                if (lineMsg.length() > 0) {
                    errorMsg.append(IMUtils.getIMResource(ctx, "ENTRYLINE", idx + 1 + "")).append(lineMsg.toString().substring(1)).append(NEXTLINE);
                }
                if (!mkInvoice.isIsVehicle()) continue;
                StringBuffer vehicleLineMsg = new StringBuffer();
                String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_BILL", ctx.getLocale());
                if (!(RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType()) || entry.getPrice() != null && entry.getNoTaxPrice() != null && entry.getQuantity() != null && BigDecimal.ZERO.compareTo(entry.getPrice()) != 0 && BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) != 0 && BigDecimal.ZERO.compareTo(entry.getQuantity()) != 0)) {
                    vehicleLineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", ctx.getLocale())).append("\u3001");
                }
                if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = tccMap.get(entry.getTaxClassificationCode())) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                    vehicleLineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", ctx.getLocale())).append("\u3001");
                }
                if (vehicleLineMsg.length() <= 0) continue;
                String line = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_LINE_MSG", ctx.getLocale(), new Object[]{idx + 1});
                String msg = line + "\uff0c" + billMsg + vehicleLineMsg.substring(0, vehicleLineMsg.length() - 1);
                errorMsg.append(msg).append(NEXTLINE);
            }
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) == 0) {
                errorMsg.append(IMUtils.getIMResource(ctx, "PRICETAXNOTGTZERO", new String[0])).append(NEXTLINE);
            }
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    protected void checkBillDiffer(Context ctx, MakeInvoiceInfo mkInvoice, StringBuffer errorMsg, int goldenTaxControl) {
        if (!mkInvoice.isIsDiffTax()) {
            if (mkInvoice.getTotalDiffer().abs().compareTo(mkInvoice.getAllowTotalDiffMax().abs()) > 0) {
                errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "TOTAL_DIFFER_ERROR", ctx.getLocale(), new Object[]{mkInvoice.getAllowTotalDiffMax().abs().toPlainString()})).append(NEXTLINE);
            }
            if (goldenTaxControl == 1 && mkInvoice.getDiffAvgAmount().compareTo(mkInvoice.getAllowDiffMaxAvg()) > 0) {
                errorMsg.append(IMUtils.getIMResource(ctx, "DIFFAMOUNTTOTALERROR", new String[0])).append(NEXTLINE);
            }
        }
    }

    protected void checkEntryDiffer(Context ctx, MakeInvoiceInfo mkInvoice, MakeInvoiceEntryCollection entries, int idx, StringBuffer lineMsg, MakeInvoiceEntryInfo entry) {
        if (!mkInvoice.isIsDiffTax()) {
            if (0 == mkInvoice.getGoldenTaxControl()) {
                if (IMUtils.isNotSatisfyRelations(mkInvoice, entry)) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "RELATIONSCHECK", mkInvoice.getAllowDiffMax().toPlainString()));
                }
                if (entry.getTaxAmt().compareTo(BigDecimal.ZERO) == 0 && entry.getNoTaxAmt().multiply(IMUtils.isNullToZero(entry.getTaxRate())).setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.ZERO) != 0) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "RELATIONSCHECK2", new String[0]));
                }
            }
            if (2 == mkInvoice.getGoldenTaxControl()) {
                if (IMUtils.isNotSatisfyRelations(mkInvoice, entry)) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "RELATIONSCHECK", mkInvoice.getAllowDiffMax().toPlainString()));
                }
                if (entry.getTaxAmt().compareTo(BigDecimal.ZERO) == 0 && entry.getNoTaxAmt().multiply(IMUtils.isNullToZero(entry.getTaxRate())).setScale(2, RoundingMode.HALF_UP).compareTo(BigDecimal.ZERO) != 0) {
                    lineMsg.append(",").append(IMUtils.getIMResource(ctx, "RELATIONSCHECK2", new String[0]));
                }
            }
        } else {
            boolean doCheck = true;
            MakeInvoiceEntryInfo curRow = entry;
            MakeInvoiceEntryInfo disCountedRow = null;
            MakeInvoiceEntryInfo disCountRow = null;
            if (RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType())) {
                disCountedRow = idx - 1 >= 0 ? entries.get(idx - 1) : null;
                disCountRow = entry;
            } else if (RowType.DISCOUNTED_ROW.equals((Object)entry.getBillRowType())) {
                disCountedRow = entry;
                MakeInvoiceEntryInfo makeInvoiceEntryInfo = disCountRow = idx + 1 < entries.size() ? entries.get(idx + 1) : null;
            }
            if (IMUtils.isNullToZero(curRow.getTaxAmt()).compareTo(BigDecimal.ZERO) == 0) {
                doCheck = false;
            } else if (disCountedRow != null && disCountRow != null && IMUtils.isNullToZero(disCountedRow.getTaxAmt()).add(IMUtils.isNullToZero(disCountRow.getTaxAmt())).compareTo(BigDecimal.ZERO) == 0) {
                doCheck = false;
            }
            if (doCheck && IMUtils.isDiffNotSatisfyRelations(mkInvoice, entry)) {
                String resourceKey = 0 == mkInvoice.getGoldenTaxControl() ? "DIFFRELATIONSCHECK" : "DIFFRELATIONSCHECK2";
                lineMsg.append(",").append(IMUtils.getIMResource(ctx, resourceKey, mkInvoice.getAllowDiffAmtMax().toPlainString()));
            }
        }
    }

    public void checkBeforeCombin(Context ctx, MakeInvoiceCollection mkInvoiceCol) throws BOSException, EASBizException {
    }

    public void checkBeforeCombin(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
    }

    public void checkBeforeSplit(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_split");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "SUBMITEDSPLIT", new String[0])});
        }
        if (mkInvoice.getBizStatus() != null && !InvoiceBizStatus.NULL.equals((Object)mkInvoice.getBizStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "NULLBIZSTATUSSPLIT", new String[0])});
        }
        boolean isOverageAmt = this.isOverageAmt(ctx, mkInvoice);
        boolean isMultiTaxRate = this.isMultiTaxRate(mkInvoice);
        boolean isOverLineNo = this.isOverLineNo(ctx, mkInvoice);
        if (!(isOverageAmt || isMultiTaxRate || isOverLineNo || mkInvoice.isIsList())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "OverSPLIT", new String[0])});
        }
    }

    public void checkBeforeDelete(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_del");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        boolean isModify = false;
        if (InvoiceSrcSystem.EXCEL.equals((Object)mkInvoice.getSrcSystem()) || InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)mkInvoice.getSrcSystem())) {
            String selectSQL;
            IRowSet rs;
            if (!mkInvoice.getCreateTime().equals(mkInvoice.getLastUpdateTime())) {
                isModify = true;
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(selectSQL = "select fbizbillid from t_im_makeinvoicerelation where finvoicebillid in" + IMUtils.getInStringFromArray(new String[]{mkInvoice.getId().toString()})))).size() > 0) {
                throw new IMException(IMException.HASBIZBILL);
            }
            if (!InvoiceBillStatus.TEMPSTROE.equals((Object)mkInvoice.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus()) && isModify) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
            }
        } else if (!(InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)mkInvoice.getSrcSystem()) || InvoiceBillStatus.TEMPSTROE.equals((Object)mkInvoice.getStatus()) || InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus()))) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
        }
    }

    public void checkBeforeAudit(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_audit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.SUBMITED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "SUBMITEDAUTIT", new String[0])).append(";\r\n");
        }
        if (mkInvoice.isIsRedVoice()) {
            if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType())) {
                if ((mkInvoice.getRedVoiceNumber() == null || mkInvoice.getRedVoiceNumber().isEmpty()) && (mkInvoice.getBlueVoiceCode() == null || mkInvoice.getBlueVoiceCode().isEmpty() || mkInvoice.getBlueVoiceNum() == null || mkInvoice.getBlueVoiceNum().isEmpty())) {
                    errorMsg.append(IMUtils.getIMResource(ctx, "REDVALUEADDEDTAXINV_AUDIT", new String[0])).append(";\r\n");
                }
            } else if (mkInvoice.getBlueVoiceCode() == null || mkInvoice.getBlueVoiceCode().isEmpty() || mkInvoice.getBlueVoiceNum() == null || mkInvoice.getBlueVoiceNum().isEmpty()) {
                errorMsg.append(IMUtils.getIMResource(ctx, "REDINVOICE_AUDIT", new String[0])).append(";\r\n");
            }
            if (mkInvoice.isIsVehicle() && mkInvoice.getRedMsgType() == null) {
                String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_BILL", ctx.getLocale());
                String msg = billMsg + "\uff0c" + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "REDMSGTYPE_NOTNULL", ctx.getLocale());
                errorMsg.append(msg).append(NEXTLINE);
            }
        }
        String companyId = mkInvoice.getCompany().getId().toString();
        int limitSplitMethod = IMUtils.getIntegerParam(ctx, companyId, "VATM010");
        mkInvoice.setLimitSplitMethod(limitSplitMethod);
        int goldenTaxControl = -1;
        goldenTaxControl = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()) ? 2 : IMUtils.getIntegerParam(ctx, companyId, "VATM015");
        mkInvoice.setGoldenTaxControl(goldenTaxControl);
        Map<String, String> taxControlMap = IMUtils.getTaxControlParam(ctx, goldenTaxControl, new String[]{"diffFactor", "allowDiffMax", "allowTotalDiffMax", "allowDiffAmtMax", "allowDiffMaxAvg"});
        BigDecimal allowDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMax"));
        mkInvoice.setAllowDiffMax(allowDiffMax);
        BigDecimal diffFactor = IMUtils.getDecimalValue(taxControlMap.get("diffFactor"));
        mkInvoice.setDiffFactor(diffFactor);
        BigDecimal allowTotalDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowTotalDiffMax"));
        mkInvoice.setAllowTotalDiffMax(allowTotalDiffMax);
        BigDecimal allowDiffAmtMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffAmtMax"));
        mkInvoice.setAllowDiffAmtMax(allowDiffAmtMax);
        BigDecimal allowDiffMaxAvg = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMaxAvg"));
        mkInvoice.setAllowDiffMaxAvg(allowDiffMaxAvg);
        this.checkBillDiffer(ctx, mkInvoice, errorMsg, goldenTaxControl);
        MakeInvoiceEntryCollection entries = mkInvoice.getEntries();
        for (int idx = 0; idx < entries.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entries.get(idx);
            StringBuffer lineMsg = new StringBuffer();
            this.checkEntryDiffer(ctx, mkInvoice, entries, idx, lineMsg, entry);
            if (lineMsg.length() <= 0) continue;
            errorMsg.append(IMUtils.getIMResource(ctx, "ENTRYLINE", idx + 1 + "")).append(lineMsg.toString().substring(1)).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void checkBeforeUnAudit(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_unaudit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.AUDITED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "AUDITEDUNAUTIT", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.isFiVouchered()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "HasVoucher_NotUnAudit", ctx.getLocale())).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void checkBeforeMake(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_make");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.AUDITED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(mkInvoice.getNumber() + ":" + IMUtils.getIMResource(ctx, "AUDITEDMAKE", new String[0]));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void checkBeforeElecMake(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_make");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.AUDITED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(mkInvoice.getNumber() + ":" + IMUtils.getIMResource(ctx, "AUDITEDMAKE", new String[0])).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void checkBeforeCancel(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.MAKED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "MAKEDCANCEL", new String[0])).append(NEXTLINE);
        }
        if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType())) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "EleInvoice_NotCancel", ctx.getLocale())).append(NEXTLINE);
        }
        if (InvoiceSrcSystem.PWYDOWNLOAD == mkInvoice.getSrcSystem()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "cancelInvoiceError", ctx.getLocale(), new Object[]{mkInvoice.getNumber()}));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{mkInvoice.getNumber() + ":" + errorMsg.toString()});
        }
    }

    public void checkBeforeRed(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (mkInvoice == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_red");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.MAKED.equals((Object)mkInvoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "MAKEDRED", new String[0])).append(NEXTLINE);
        }
        if (mkInvoice.isIsRedVoice()) {
            errorMsg.append(IMUtils.getIMResource(ctx, "REDINVOICE_RED", new String[0])).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        boolean canRed = false;
        MakeInvoiceEntryCollection mkInvoiceEntry = mkInvoice.getEntries();
        int j = mkInvoiceEntry.size();
        for (int i = 0; i < j; ++i) {
            if (mkInvoiceEntry.get(i).getBillRowType().getValue() == 2 || mkInvoiceEntry.get(i).getUnRedPriceTax() == null || mkInvoiceEntry.get(i).getUnRedPriceTax().compareTo(BigDecimal.ZERO) <= 0) continue;
            canRed = true;
            break;
        }
        if (!canRed) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "NOCANRED", mkInvoice.getNumber())});
        }
    }

    public MakeInvoiceCollection getCollectionByIds(Context ctx, String[] billIDs) throws BOSException {
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (String billID : billIDs) {
            idSet.add(billID);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        return mkInvoiceCol;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("payee.id"));
        sic.add(new SelectorItemInfo("payee.name"));
        sic.add(new SelectorItemInfo("drawer.id"));
        sic.add(new SelectorItemInfo("drawer.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("applicant.id"));
        sic.add(new SelectorItemInfo("applicant.name"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currAcctCustomer.id"));
        sic.add(new SelectorItemInfo("currAcctCustomer.name"));
        sic.add(new SelectorItemInfo("currAcctCustomer.number"));
        sic.add(new SelectorItemInfo("currAcctSupplier.id"));
        sic.add(new SelectorItemInfo("currAcctSupplier.name"));
        sic.add(new SelectorItemInfo("currAcctSupplier.number"));
        sic.add(new SelectorItemInfo("currAcctCompany.id"));
        sic.add(new SelectorItemInfo("currAcctCompany.name"));
        sic.add(new SelectorItemInfo("currAcctCompany.number"));
        sic.add(new SelectorItemInfo("customerTax.id"));
        sic.add(new SelectorItemInfo("entries.produceName"));
        sic.add(new SelectorItemInfo("entries.specs"));
        sic.add(new SelectorItemInfo("entries.noTaxPrice"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.noTaxAmt"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.taxAmt"));
        sic.add(new SelectorItemInfo("entries.priceTax"));
        sic.add(new SelectorItemInfo("entries.discountRate"));
        sic.add(new SelectorItemInfo("entries.discountAmt"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.taxClassificationCode"));
        sic.add(new SelectorItemInfo("entries.billRowType"));
        sic.add(new SelectorItemInfo("entries.taxClassName"));
        sic.add(new SelectorItemInfo("entries.hasPreferential"));
        sic.add(new SelectorItemInfo("entries.preferentialPolicies"));
        sic.add(new SelectorItemInfo("entries.makeInvoiceUnit"));
        sic.add(new SelectorItemInfo("entries.deductAmt"));
        sic.add(new SelectorItemInfo("entries.redPriceTax"));
        sic.add(new SelectorItemInfo("entries.redQty"));
        sic.add(new SelectorItemInfo("entries.unRedPriceTax"));
        sic.add(new SelectorItemInfo("entries.unRedQty"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.entryName.id"));
        sic.add(new SelectorItemInfo("entries.entryName.name"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        sic.add(new SelectorItemInfo("entries.entryName.taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("isRedVoice"));
        sic.add(new SelectorItemInfo("redBillId"));
        sic.add(new SelectorItemInfo("entries.entryName.taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        sic.add(new SelectorItemInfo("makeInvoiceUnit"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("specificInformation.*"));
        sic.add(new SelectorItemInfo("specificInformation.entries.*"));
        return sic;
    }

    @Override
    protected void _setCombinStatus(Context ctx, String[] billIDs, String billID) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = this.getCollectionByIds(ctx, billIDs);
        for (int idx = 0; idx < mkInvoiceCol.size(); ++idx) {
            MakeInvoiceInfo mkInvoice = mkInvoiceCol.get(idx);
            mkInvoice.setBizStatus(InvoiceBizStatus.BOFORE_COMBIN);
            mkInvoice.setDestBillId(billID);
            super._save(ctx, (IObjectValue)mkInvoice);
        }
    }

    @Override
    protected void _cancelCombinStatus(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        this.cancelStatus(ctx, billIDs);
    }

    private void cancelStatus(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = this.getCollectionByIds(ctx, billIDs);
        for (int idx = 0; idx < mkInvoiceCol.size(); ++idx) {
            MakeInvoiceInfo mkInvoice = mkInvoiceCol.get(idx);
            this.cancelStatus(ctx, mkInvoice);
        }
    }

    private void cancelStatus(Context ctx, MakeInvoiceInfo mkInvoice) throws BOSException, EASBizException {
        mkInvoice.setStatus(InvoiceBillStatus.SUBMITED);
        mkInvoice.setBizStatus(InvoiceBizStatus.NULL);
        mkInvoice.setDestBillId(null);
        mkInvoice.setSourceBillId(null);
        super._save(ctx, (IObjectValue)mkInvoice);
    }

    private int getPricePrecision(Context ctx, String companyId) throws EASBizException, BOSException {
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM001"}).intValue();
    }

    private BigDecimal getMaxAmt(Context ctx, MakeInvoiceInfo mkInvoice, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM002";
        if ("0".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM003";
        } else if ("2".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM004";
        } else if ("3".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM016";
        } else if ("4".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM023";
        } else if ("5".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM022";
        }
        BigDecimal amt = IMUtils.getDecimalParam(ctx, companyId, new String[]{paramNumber});
        if (("4".equals(mkInvoice.getInvoiceType().getValue()) || "5".equals(mkInvoice.getInvoiceType().getValue())) && amt.compareTo(BigDecimal.ZERO) == 0) {
            amt = IMConstant.DIGELECAMT;
        }
        return amt;
    }

    private int getListMaxLineNo(Context ctx, MakeInvoiceInfo mkInvoice, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM012";
        if ("0".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM013";
        } else if ("2".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM014";
        } else if ("3".equals(mkInvoice.getInvoiceType().getValue())) {
            paramNumber = "VATM017";
        }
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{paramNumber}).intValue();
    }

    private BigDecimal getCustomerLimitAmt(Context ctx, MakeInvoiceInfo mkInvoice, String companyId) throws BOSException, EASBizException {
        if (mkInvoice.getCurrAcctCustomer() != null && mkInvoice.getCurrAcctCustomer().getId() != null || mkInvoice.getCurrAcctSupplier() != null && mkInvoice.getCurrAcctSupplier().getId() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (mkInvoice.getCurrAcctCustomer() != null) {
                params.put("customerId", mkInvoice.getCurrAcctCustomer().getId().toString());
            } else {
                params.put("customerId", mkInvoice.getCurrAcctSupplier().getId().toString());
            }
            params.put("invoiceType", mkInvoice.getInvoiceType().getValue());
            params.put("receiveCompany", mkInvoice.getReceiveCompany());
            params.put("companyId", companyId);
            Map ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params);
            CustomerTaxInfo customerTax = (CustomerTaxInfo)ret.get("value");
            CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
            CustomerTaxEntryCollection coll = null;
            if (customerTax != null && customerTax.getEntries() != null) {
                coll = customerTax.getEntries();
                int size = coll.size();
                for (int j = 0; j < size && !(entryInfo = coll.get(j)).getInvoiceType().getValue().equals(mkInvoice.getInvoiceType().getValue()); ++j) {
                }
                if (entryInfo.getLimitAmt() != null) {
                    return entryInfo.getLimitAmt();
                }
            }
        }
        return BigDecimal.ZERO;
    }

    private int getMaxLineNo(Context ctx, String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM005";
        if ("4".equals(invoiceType) || "5".equals(invoiceType)) {
            paramNumber = "VATM024";
        }
        int limit = IMUtils.getDecimalParam(ctx, companyId, new String[]{paramNumber}).intValue();
        if (("4".equals(invoiceType) || "5".equals(invoiceType)) && limit == 0) {
            limit = IMConstant.DIGELECLIMIT;
        }
        return limit;
    }

    private MakeInvoiceInfo cloneMakeInvoiceInfo(MakeInvoiceInfo mkInvoice) throws BOSException {
        MakeInvoiceInfo invoice = (MakeInvoiceInfo)mkInvoice.clone();
        invoice.getEntries().clear();
        invoice.setNumber(null);
        invoice.setBOSUuid("id", BOSUuid.create((BOSObjectType)invoice.getBOSType()));
        return invoice;
    }

    private boolean isOverageAmt(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if (mkInvoice != null) {
            String companyId = mkInvoice.getCompany().getId().toString();
            BigDecimal orgLimitAmt = this.getMaxAmt(ctx, mkInvoice, companyId);
            BigDecimal custLimitAmt = this.getCustomerLimitAmt(ctx, mkInvoice, companyId);
            BigDecimal minAmt = orgLimitAmt;
            if (custLimitAmt.compareTo(BigDecimal.ZERO) != 0 && custLimitAmt.compareTo(orgLimitAmt) < 0) {
                minAmt = custLimitAmt;
            }
            return this.isOverageAmt(minAmt, mkInvoice);
        }
        return false;
    }

    private boolean isOverageAmt(BigDecimal maxAmt, MakeInvoiceInfo mkInvoice) {
        return mkInvoice.getNoTaxAmtTotal().abs().compareTo(maxAmt) > 0;
    }

    private boolean isMultiTaxRate(MakeInvoiceInfo mkInvoice) {
        MakeInvoiceEntryCollection entryCol;
        if (mkInvoice != null && (entryCol = mkInvoice.getEntries()).size() > 1) {
            BigDecimal taxRate0 = mkInvoice.getEntries().get(0).getTaxRate();
            for (int idx = 1; idx < entryCol.size(); ++idx) {
                MakeInvoiceEntryInfo entry = entryCol.get(idx);
                if (taxRate0.compareTo(entry.getTaxRate()) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOverLineNo(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if (mkInvoice != null) {
            String companyId = mkInvoice.getCompany().getId().toString();
            String invoiceType = mkInvoice.getInvoiceType().getValue();
            return this.isOverLineNo(this.getMaxLineNo(ctx, invoiceType, companyId), this.getListMaxLineNo(ctx, mkInvoice, companyId), mkInvoice);
        }
        return false;
    }

    private boolean isOverLineNo(int maxLineNo, int listMaxLineNo, MakeInvoiceInfo mkInvoice) {
        return this.isOverLineNo(maxLineNo, listMaxLineNo, mkInvoice.getEntries().size(), mkInvoice.isIsList());
    }

    private boolean isOverLineNo(int maxLineNo, int listMaxLineNo, int entrySize, boolean isList) {
        boolean isOverLineNo = false;
        isOverLineNo = isList ? entrySize > listMaxLineNo : entrySize > maxLineNo;
        return isOverLineNo;
    }

    @Override
    protected Map _getInvoiceCount(Context ctx, String companyId) throws BOSException, EASBizException {
        HashMap<String, Integer> billCount = new HashMap<String, Integer>();
        try {
            String idStr = this.splitCompanyId(companyId);
            idStr = "'" + idStr + "'";
            Map params = IMUtils.getInQuestionParams(idStr, true);
            String sql = "SELECT count(Fstatus) FCount,FStatus FROM T_IM_makeInvoice WHERE FCompanyId in (" + params.get("marks") + ") GROUP BY FStatus";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])params.get("objs")));
            int count = 0;
            while (rs.next()) {
                int status = rs.getInt("FStatus");
                count = rs.getInt("FCount");
                String statusStr = "";
                if (status == 2) {
                    statusStr = InvoiceBillStatus.SUBMITED.toString();
                } else if (status == 3) {
                    statusStr = InvoiceBillStatus.AUDITED.toString();
                } else {
                    if (status != 4) continue;
                    statusStr = InvoiceBillStatus.MAKED.toString();
                }
                billCount.put(statusStr, count);
            }
            if (!billCount.keySet().contains(InvoiceBillStatus.AUDITED.toString())) {
                billCount.put(InvoiceBillStatus.AUDITED.toString(), 0);
            }
            if (!billCount.keySet().contains(InvoiceBillStatus.SUBMITED.toString())) {
                billCount.put(InvoiceBillStatus.SUBMITED.toString(), 0);
            }
            if (!billCount.keySet().contains(InvoiceBillStatus.MAKED.toString())) {
                billCount.put(InvoiceBillStatus.MAKED.toString(), 0);
            }
        }
        catch (SQLException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        return billCount;
    }

    private String splitCompanyId(String companyId) {
        StringBuffer sb = new StringBuffer();
        String[] companys = companyId.split(",");
        for (int i = 0; i < companys.length; ++i) {
            sb.append("','").append(companys[i]);
        }
        return sb.substring(3);
    }

    @Override
    protected IObjectCollection _getSplitBillsBySourceBillId(Context ctx, String sourceBillId, String selector) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        if (selector == null || selector.length() == 0) {
            sic.add("id");
        } else {
            String[] selArr;
            for (String str : selArr = selector.split(",")) {
                sic.add(str);
            }
        }
        view.setSelector(sic);
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        return mkInvoiceCol;
    }

    @Override
    protected void _checkBeforeMake(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        this.checkBeforeMake(ctx, mkInvoice);
        this.checkAmtOver(ctx, mkInvoice.getId().toString());
    }

    @Override
    protected void _checkBeforeElecMake(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        this.checkBeforeElecMake(ctx, mkInvoice);
        this.checkAmtOver(ctx, mkInvoice.getId().toString());
    }

    private void preHandlerInvoice(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        MakeInvoiceEntryCollection entries = mkInvoice.getEntries();
        int size = entries.size();
        if (size == 0) {
            return;
        }
        CompanyOrgUnitInfo company = mkInvoice.getCompany();
        if (company == null) {
            return;
        }
        int pricePrecision = this.getPricePrecision(ctx, company.getId().toString());
        for (int idx = 0; idx < size; ++idx) {
            MakeInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal quantity = entry.getQuantity();
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal noTaxPrice = entry.getNoTaxPrice();
            BigDecimal price = entry.getPrice();
            BigDecimal noTaxAmt = entry.getNoTaxAmt();
            BigDecimal taxAmt = entry.getTaxAmt();
            BigDecimal priceTax = entry.getPriceTax();
            if (taxRate == null || taxRate.compareTo(BigDecimal.ZERO) == 0) continue;
            if (price == null && noTaxPrice != null) {
                price = noTaxPrice.multiply(new BigDecimal(1).add(taxRate)).setScale(pricePrecision, 6);
                entry.setPrice(price);
            }
            if (price != null && noTaxPrice == null) {
                noTaxPrice = price.divide(new BigDecimal(1).add(taxRate), pricePrecision, 6);
                entry.setNoTaxPrice(noTaxPrice);
            }
            if (quantity != null && quantity.compareTo(BigDecimal.ZERO) != 0 && noTaxPrice != null && noTaxAmt == null) {
                noTaxAmt = noTaxPrice.multiply(new BigDecimal(1).add(quantity)).setScale(2, 6);
            }
            if (noTaxAmt == null && priceTax != null) {
                noTaxAmt = priceTax.divide(new BigDecimal(1).add(taxRate), 2, 6);
                entry.setNoTaxAmt(noTaxAmt);
            }
            if (noTaxAmt != null && priceTax == null) {
                priceTax = noTaxAmt.multiply(new BigDecimal(1).add(taxRate)).setScale(2, 6);
                entry.setPriceTax(priceTax);
            }
            if (taxAmt != null || noTaxAmt == null) continue;
            taxAmt = noTaxAmt.multiply(taxRate).setScale(2, 6);
            entry.setTaxAmt(taxAmt);
        }
    }

    @Override
    protected IObjectPK _impSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.preHandlerInvoice(ctx, mkInvoice);
        this.putBillValues(ctx, mkInvoice);
        this.redInvoiceHandler(ctx, mkInvoice);
        this.checkOverLimitRowAmt(ctx, mkInvoice);
        IObjectPK pk = this.addnew(ctx, mkInvoice);
        if (mkInvoice.getInvoiceNo() != null && !"".equals(mkInvoice.getInvoiceNo()) && mkInvoice.getInvoiceNumber() != null && !"".equals(mkInvoice.getInvoiceNumber())) {
            InvoiceDetailFactory.getLocalInstance(ctx).makeReverse(mkInvoice);
        }
        return pk;
    }

    @Override
    protected void _checkBeforeRed(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        this.checkBeforeRed(ctx, mkInvoice);
    }

    @Override
    protected void _checkBeforeCancel(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        this.checkBeforeCancel(ctx, mkInvoice);
    }

    @Override
    protected void _updateIsPrint(Context ctx, String billID, IObjectValue pwyLog) throws BOSException, EASBizException {
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        MakeInvoiceInfo mkInvoice = iMkInvoice.getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID));
        if (!mkInvoice.isIsPrint()) {
            mkInvoice.setIsPrint(true);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("isPrint");
            iMkInvoice.updatePartial(mkInvoice, selector);
        }
    }

    @Override
    protected void _makeElec(Context ctx, IObjectPK pk, IObjectValue model, IObjectValue pwyLog) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeMake(ctx, mkInvoice);
        MakeInvoiceInfo invoiceInfo = (MakeInvoiceInfo)model;
        mkInvoice.setStatus(InvoiceBillStatus.MAKED);
        mkInvoice.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICINVOICE);
        mkInvoice.setInvoiceSn(invoiceInfo.getInvoiceSn());
        mkInvoice.setInvoiceUrl(invoiceInfo.getInvoiceUrl());
        mkInvoice.setInvoiceDate(invoiceInfo.getInvoiceDate());
        mkInvoice.setInvoiceNumber(invoiceInfo.getInvoiceNumber());
        mkInvoice.setInvoiceNo(invoiceInfo.getInvoiceNo());
        if (mkInvoice.getDrawertxt() == null) {
            mkInvoice.setDrawer(ContextUtil.getCurrentUserInfo((Context)ctx));
            mkInvoice.setDrawertxt(mkInvoice.getDrawer().getName());
        }
        super._save(ctx, (IObjectValue)mkInvoice);
        this.updatePwyLog(ctx, (PwyLogInfo)pwyLog, mkInvoice);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] sourceBillPks, CoreBillBaseCollection sourceBillVos, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        new BillVoucherService().batchReverseSave(ctx, sourceBillPks, sourceBillVos, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected void _make(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(pk, this.getSelectors());
        this.checkBeforeMake(ctx, mkInvoice);
        String invoiceNo = (String)param.get("invoiceNo");
        String invoiceNum = (String)param.get("invoiceNum");
        String card_no = (String)param.get("card_no");
        String subid = (String)param.get("subid");
        mkInvoice.setPlateNo(card_no);
        mkInvoice.setExtensionNo(subid);
        String pdfurl = null;
        String sn = "";
        if (param.get("sn") != null) {
            sn = param.get("sn").toString();
        }
        PayInvoiceTypeEnum type = (PayInvoiceTypeEnum)param.get("invoiceType");
        if (param.get("pdfurl") != null) {
            pdfurl = (String)param.get("pdfurl");
        }
        if (mkInvoice.getInvoiceType() == null || "".equals(mkInvoice.getInvoiceType())) {
            mkInvoice.setInvoiceType(type);
        }
        mkInvoice.setId(BOSUuid.read((String)pk.toString()));
        mkInvoice.setStatus(InvoiceBillStatus.MAKED);
        mkInvoice.setInvoiceDate(new Date());
        mkInvoice.put("makeInvoiceType", (Object)this.getMakeInvoiceType(mkInvoice.getInvoiceDate(), mkInvoice.getBizYear(), mkInvoice.getBizMonth()));
        mkInvoice.setInvoiceNumber(invoiceNum);
        mkInvoice.setInvoiceNo(invoiceNo);
        mkInvoice.setInvoiceSn(sn);
        if (mkInvoice.getDrawertxt() == null) {
            mkInvoice.setDrawer(ContextUtil.getCurrentUserInfo((Context)ctx));
            mkInvoice.setDrawertxt(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
        }
        mkInvoice.setInvoiceUrl(pdfurl);
        this.setBizYearMonthNull(mkInvoice);
        super._update(ctx, pk, (IObjectValue)mkInvoice);
        IMServerUtil.doMethodWithTransaction(MakeInvoiceControllerBean.class.getName(), "synInvoiceData", new Class[]{Context.class, MakeInvoiceInfo.class}, new Object[]{ctx, mkInvoice}, 3);
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose("make", (IObjectValue)mkInvoice);
    }

    protected MakeInvoiceTypeEnum getMakeInvoiceType(Date invoiceDate, Integer bizYear, Integer bizMonth) {
        if (invoiceDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(invoiceDate);
        int year = Integer.valueOf(format.substring(0, 4));
        int month = Integer.valueOf(format.substring(5, 6));
        if (bizYear != null && bizMonth != null && bizYear != 0 && bizMonth != 0) {
            if (bizYear > year || bizYear == year && bizMonth > month) {
                return MakeInvoiceTypeEnum.PreMakeInvoice;
            }
            if (bizYear < year || bizYear == year && bizMonth < month) {
                return MakeInvoiceTypeEnum.ReMakeInvoice;
            }
            if (bizYear == year && bizMonth == month) {
                return MakeInvoiceTypeEnum.CurrentPeriodSale;
            }
        }
        return null;
    }

    protected void synInvoiceData(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        ctx.put((Object)"disablePermissionForKScript", (Object)true);
        this.addInvoiceBookEntry(ctx, mkInvoice);
        InvoiceInvMgrFactory.getLocalInstance(ctx).updateInvMgr(mkInvoice);
        InvoiceDetailFactory.getLocalInstance(ctx).makeReverse(mkInvoice);
        ctx.remove((Object)"disablePermissionForKScript");
    }

    @Override
    protected Map _addSrcBill(Context ctx, String mkInvoiceIds, String otherBillIds) throws BOSException, EASBizException {
        int i;
        String[] mkidArray = mkInvoiceIds.split(",");
        String[] otherbillIdArray = otherBillIds.split(",");
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        retMap.put("isAdd", true);
        mkidArray = this.checkBeforeAddOrCancelSrcBill(ctx, mkidArray, retMap);
        if (mkidArray.length == 0) {
            return retMap;
        }
        if ((mkidArray = this.reBuildMkArr(ctx, mkidArray, otherbillIdArray)).length == 0) {
            return retMap;
        }
        String srcBillId = otherbillIdArray[0];
        String srcBillBosType = BOSUuid.read((String)srcBillId).getType().toString();
        ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
        MakeInvoiceInfo info = null;
        String logDetail = null;
        String logItem = "FC910EF3".equals(srcBillBosType) ? "im_mkInvoice_addSrcBill" : "im_mkInvoice_addSrcReqBill";
        IObjectPK logPk = null;
        for (i = 0; i < mkidArray.length; ++i) {
            info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkidArray[i]));
            logDetail = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LogDetail", ctx.getLocale(), new Object[]{info.getInvoiceNo(), info.getInvoiceNumber()});
            logPk = LogUtils.beginLog(ctx, "addSrcBill", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, logItem, info.getCompany().getId().toString());
            logPKs.add(logPk);
        }
        for (i = 0; i < mkidArray.length; ++i) {
            for (int j = 0; j < otherbillIdArray.length; ++j) {
                this.traceUpAndDown(ctx, otherbillIdArray[j], mkidArray[i], srcBillBosType, "412A6F98");
            }
        }
        MakeInvoiceControllerBean.saveRelation(ctx, mkidArray, otherbillIdArray, srcBillBosType);
        for (i = 0; i < mkidArray.length; ++i) {
            info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkidArray[i]));
            WriteBackFacadeFactory.getLocalInstance(ctx).dispose("addSrcBill", (IObjectValue)info);
        }
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            String obID2 = null;
            String srcBillTableName = "FC910EF3".equals(srcBillBosType) ? "T_AR_OtherBill" : "T_IM_MakeInvoiceReq";
            String isMakeInvoicedField = "FC910EF3".equals(srcBillBosType) ? "FIsMakeInvoiced" : "FIsMakeInoviced";
            for (String obID2 : Arrays.asList(otherbillIdArray)) {
                stmt.addBatch("IF EXISTS (SELECT 1 FROM T_BOT_Relation where FDESTENTITYID = '412A6F98' and  FSRCOBJECTID = '" + obID2 + "' )UPDATE " + srcBillTableName + " SET " + isMakeInvoicedField + " = 1 where fid='" + obID2 + "'");
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        HashMap<Integer, Integer> yearMap = null;
        HashMap<Integer, Integer> monthMap = null;
        String updateSQL = "FC910EF3".equals(srcBillBosType) ? this.getSelectArSql() : this.getSelectReqSql();
        for (int i2 = 0; i2 < mkidArray.length; ++i2) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)updateSQL, (Object[])new Object[]{mkidArray[i2]});
            try {
                yearMap = new HashMap<Integer, Integer>();
                monthMap = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    yearMap.put(rs.getInt("bizYear"), rs.getInt("bizYear"));
                    monthMap.put(rs.getInt("bizMonth"), rs.getInt("bizMonth"));
                }
                if (yearMap.size() == 1 && monthMap.size() == 1) {
                    info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkidArray[i2]));
                    Integer year = (Integer)yearMap.values().toArray()[0] == 0 ? null : (Integer)yearMap.values().toArray()[0];
                    Integer month = (Integer)monthMap.values().toArray()[0] == 0 ? null : (Integer)monthMap.values().toArray()[0];
                    MakeInvoiceTypeEnum makeInvoiceType = this.getMakeInvoiceType(info.getInvoiceDate(), year, month);
                    Object[] params = new Object[]{year, month, mkidArray[i2]};
                    StringBuffer updateInvoiceSQL = new StringBuffer();
                    updateInvoiceSQL.append("update T_IM_MakeInvoice set FBizYear=?,FBizMonth=? ");
                    if (makeInvoiceType != null) {
                        updateInvoiceSQL.append(",FMakeInvoiceType=? ");
                        params = new Object[]{year, month, makeInvoiceType.getValue(), mkidArray[i2]};
                    }
                    updateInvoiceSQL.append(" where fid=?");
                    DbUtil.execute((Context)ctx, (String)updateInvoiceSQL.toString(), (Object[])params);
                    continue;
                }
                String updateInvoiceSQL = "update T_IM_MakeInvoice set FMakeInvoiceType=null  where fid=? ";
                DbUtil.execute((Context)ctx, (String)updateInvoiceSQL, (Object[])new Object[]{mkidArray[i2]});
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        Iterator it = logPKs.iterator();
        while (it.hasNext()) {
            LogUtils.afterLog(ctx, (IObjectPK)it.next());
        }
        return retMap;
    }

    protected String getSelectReqSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT src.FBizYear as bizYear,src.FBizMonth as bizMonth,src.FAudittime as auditTime").append("\n");
        sql.append(" FROM t_im_makeinvoicereq src").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceRelation relation on src.fid = relation.FBizBillID").append("\n");
        sql.append(" WHERE relation.FInvoiceBillID = ?").append("\n");
        sql.append(" ORDER BY src.fauditTime asc");
        return sql.toString();
    }

    protected String getSelectArSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT src.FYear as bizYear,src.FPERIOD as bizMonth,src.FAuditDate as auditTime").append("\n");
        sql.append(" FROM t_ar_otherbill src").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceRelation relation on src.fid = relation.FBizBillID").append("\n");
        sql.append(" WHERE relation.FInvoiceBillID = ?").append("\n");
        sql.append(" ORDER BY src.fauditDate asc");
        return sql.toString();
    }

    private String[] reBuildMkArr(Context ctx, String[] mkidArray, String[] otherbillIdArray) throws BOSException {
        ArrayList<String> newMkId = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        String mkids = IMUtils.getInStringFromArray(mkidArray);
        String arids = IMUtils.getInStringFromArray(otherbillIdArray);
        sb.append(" SELECT FDESTOBJECTID FROM  T_BOT_Relation ");
        sb.append(" where FDESTOBJECTID in ").append(mkids);
        sb.append(" and FSRCOBJECTID in ").append(arids).append(" group by FDESTOBJECTID ");
        ArrayList<String> idsarr = new ArrayList<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String mkid = rs.getString("FDESTOBJECTID");
                idsarr.add(mkid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < mkidArray.length; ++i) {
            String id = mkidArray[i];
            if (idsarr.contains(id)) continue;
            newMkId.add(id);
        }
        String[] ret = new String[newMkId.size()];
        for (int i = 0; i < newMkId.size(); ++i) {
            ret[i] = newMkId.get(i).toString();
        }
        return ret;
    }

    private String[] checkBeforeAddOrCancelSrcBill(Context ctx, String[] mkIDArr, Map retMap) throws EASBizException, BOSException {
        ArrayList msg = new ArrayList();
        if (retMap.get("errorMsg") != null) {
            msg = (ArrayList)retMap.get("errorMsg");
        }
        ArrayList<String> successID = new ArrayList<String>();
        String selectSQL = "SELECT fid, FSrcSystem,fstatus FROM T_IM_MakeInvoice WHERE FID IN " + IMUtils.getInStringFromArray(mkIDArr);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        try {
            String srcSystem = null;
            String status = null;
            String id = null;
            while (rs.next()) {
                srcSystem = rs.getString("FSrcSystem");
                status = rs.getString("fstatus");
                id = rs.getString("fid");
                if ("2".equals(srcSystem) && !"99".equals(status) && !"4".equals(status)) {
                    msg.add(new IMException(IMException.NOT_SUPPORT_ADDSRCBILL).getMessage());
                    continue;
                }
                successID.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        String[] ret = new String[successID.size()];
        for (int i = 0; i < successID.size(); ++i) {
            ret[i] = successID.get(i).toString();
        }
        retMap.put("errorMsg", msg);
        return ret;
    }

    @Override
    protected Map _cancelSrcBill(Context ctx, String mkInvoiceIds) throws BOSException, EASBizException {
        String[] mkIDParm = mkInvoiceIds.split(",");
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        retMap.put("isAdd", Boolean.valueOf(false));
        String[] mkIDArr = this.checkBeforeCancelSrcBill(ctx, mkIDParm, retMap);
        if (mkIDArr.length == 0) {
            return retMap;
        }
        if ((mkIDArr = this.checkBeforeAddOrCancelSrcBill(ctx, mkIDArr, retMap)).length == 0) {
            return retMap;
        }
        ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
        MakeInvoiceInfo info = null;
        String logDetail = null;
        IObjectPK logPk = null;
        HashSet<String> obIDList = new HashSet<String>();
        for (int i = 0; i < mkIDArr.length; ++i) {
            info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkIDArr[i]));
            logDetail = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LogDetail", ctx.getLocale(), new Object[]{info.getInvoiceNo(), info.getInvoiceNumber()});
            logPk = LogUtils.beginLog(ctx, "cancelSrcBill", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, "im_mkInvoice_cancelSrcBill", info.getCompany().getId().toString());
            logPKs.add(logPk);
            String ids = IMUtils.getInString(mkIDArr[i]);
            String whereSQL = " WHERE (FSRCENTITYID = 'FC910EF3' or  FSRCENTITYID ='AC368D2D' ) and FDESTENTITYID = '412A6F98' and FOPERATORID = 'unknown' and FTYPE = 0 and FDESTOBJECTID in " + ids;
            String selectSQL = "SELECT FSRCOBJECTID FROM T_BOT_Relation " + whereSQL;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            MakeInvoiceInfo mkBillInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkIDArr[i]));
            boolean isDelete = mkBillInfo.getStatus() == InvoiceBillStatus.DELETED;
            try {
                while (rs.next()) {
                    obIDList.add(rs.getString("FSRCOBJECTID"));
                }
                if (CollectionUtil.isEmpty(obIDList)) {
                    ArrayList<String> msg = new ArrayList<String>();
                    msg.add(IMUtils.getIMResource(ctx, "CALCELSRCBILL_OBIDLIST_NULL", new String[0]));
                    retMap.put("errorMsg", msg);
                    return retMap;
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            if (!isDelete) {
                WriteBackFacadeFactory.getLocalInstance(ctx).dispose("cancelSrcBill", (IObjectValue)info);
            }
            String deleteSql = "DELETE FROM T_BOT_Relation " + whereSQL;
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        this.deleteRelation(ctx, mkIDArr);
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            String obID2 = null;
            String srcBillId = (String)obIDList.iterator().next();
            String srcBillBosType = BOSUuid.read((String)srcBillId).getType().toString();
            String srcBillTableName = "FC910EF3".equals(srcBillBosType) ? "T_AR_OtherBill" : "T_IM_MakeInvoiceReq";
            String isMakeInvoicedField = "FC910EF3".equals(srcBillBosType) ? "FIsMakeInvoiced" : "FIsMakeInoviced";
            for (String obID2 : obIDList) {
                stmt.addBatch("IF NOT EXISTS (SELECT 1 FROM T_BOT_Relation where FDESTENTITYID = '412A6F98' and  FSRCOBJECTID = '" + obID2 + "' )UPDATE " + srcBillTableName + " SET " + isMakeInvoicedField + " = 0 where fid='" + obID2 + "'");
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        String updateInvoiceSQL = "update T_IM_MakeInvoice set FBizYear = null,FBizMonth = null, FMakeInvoiceType = null where fid=?";
        ArrayList<String[]> params = new ArrayList<String[]>();
        for (int i = 0; i < mkIDArr.length; ++i) {
            params.add(new String[]{mkIDArr[i]});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateInvoiceSQL, params);
        Iterator it = logPKs.iterator();
        while (it.hasNext()) {
            LogUtils.afterLog(ctx, (IObjectPK)it.next());
        }
        return retMap;
    }

    private String[] checkBeforeCancelSrcBill(Context ctx, String[] mkIDArr, Map retMap) throws BOSException {
        ArrayList<String> msg = new ArrayList<String>();
        try {
            for (int i = 0; i < mkIDArr.length; ++i) {
                MakeInvoiceInfo mkInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkIDArr[i]));
                try {
                    IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(String.valueOf(mkInfo.getCompany().getId()), "im_makeinovice_cancelsrcbill");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    mkIDArr[i] = "";
                    msg.add(IMUtils.getIMResource(ctx, "CANCELSRCBILL_PERM_ERROR", mkInfo.getNumber(), mkInfo.getCompany().getName()));
                    continue;
                }
                if (mkInfo.getStatus() == InvoiceBillStatus.TEMPSTROE || mkInfo.getStatus() == InvoiceBillStatus.SUBMITED || mkInfo.getStatus() == InvoiceBillStatus.AUDITED) {
                    mkIDArr[i] = "";
                    msg.add(IMUtils.getIMResource(ctx, "CALCELSRCBILL_STATUS_ERROR", mkInfo.getNumber()));
                    continue;
                }
                String selectSQL = "SELECT FID,fsrcBosType FROM T_IM_MakeInvoiceRelation WHERE FInvoiceBillID = '" + mkIDArr[i] + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
                if (!rs.next()) {
                    mkIDArr[i] = "";
                    msg.add(IMUtils.getIMResource(ctx, "NO_SOURCEBILL", mkInfo.getNumber()));
                    continue;
                }
                if (!"3D667D4A".equals(rs.getString("fsrcBosType")) && !"B4E229F6".equals(rs.getString("fsrcBosType")) && !"0CADF79B".equals(rs.getString("fsrcBosType"))) continue;
                mkIDArr[i] = "";
                msg.add(IMUtils.getIMResource(ctx, "REQ_SOURCE_BILL", mkInfo.getNumber()));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        retMap.put("errorMsg", msg);
        return mkIDArr;
    }

    private boolean hasBotpRelation(Context ctx, String srcID, String destID, String srcEntityID, String destEntityID) throws BOSException {
        boolean hasRelation = false;
        String operateID = "unknown";
        int type = 0;
        try {
            String selectSQL = " SELECT FID FROM T_BOT_Relation WHERE FSRCENTITYID = '" + srcEntityID + "' and FDESTENTITYID = '" + destEntityID + "' and FOPERATORID = '" + operateID + "' and FTYPE = " + type + " and FDESTOBJECTID ='" + destID + "' and FSRCOBJECTID = '" + srcID + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.next()) {
                hasRelation = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("excute sql error...");
        }
        return hasRelation;
    }

    private void traceUpAndDown(Context ctx, String srcId, String desId, String srcBosType, String desBosType) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(desBosType);
        info.setDestObjectID(desId);
        info.setOperatorID("unknown");
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }

    @Override
    protected Map _getBlueBillInfoByRedID(Context ctx, String redID) throws BOSException, EASBizException {
        SelectorItemCollection redSelector = new SelectorItemCollection();
        redSelector.add(new SelectorItemInfo("redBillId"));
        MakeInvoiceInfo redBillInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(redID), redSelector);
        String blueBillId = redBillInfo.getRedBillId();
        SelectorItemCollection blueSelector = new SelectorItemCollection();
        blueSelector.add(new SelectorItemInfo("invoiceNumber"));
        blueSelector.add(new SelectorItemInfo("invoiceNo"));
        blueSelector.add(new SelectorItemInfo("invoiceType"));
        MakeInvoiceInfo blueBillInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(blueBillId), blueSelector);
        String invoiceNumber = blueBillInfo.getInvoiceNumber();
        String invoiceNo = blueBillInfo.getInvoiceNo();
        String invoiceType = blueBillInfo.getInvoiceType().getAlias();
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("invoiceNumber", invoiceNumber);
        retMap.put("invoiceNo", invoiceNo);
        retMap.put("invoiceType", invoiceType);
        return retMap;
    }

    private void deleteRelation(Context ctx, String[] mkidArray) throws BOSException {
        String idStr = IMUtils.getInStringFromArray(mkidArray);
        String deleteSQL = "delete from T_IM_MakeInvoiceRelation where FInvoiceBillID in" + idStr;
        DbUtil.execute((Context)ctx, (String)deleteSQL);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            MakeInvoiceEntryInfo makeInvoiceEntryInfo = info.getEntries().get(i);
            if (makeInvoiceEntryInfo.getProduceName() != null || makeInvoiceEntryInfo.getEntryName() == null) continue;
            makeInvoiceEntryInfo.setProduceName(makeInvoiceEntryInfo.getEntryName().getName());
        }
        if (info.getBizType() == null) {
            info.setBizType(IMKBizTypeEnum.EAS);
        }
        if (info.getCurrentAccountType() == null) {
            info.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        }
        if (info.getApplicant() == null) {
            info.setApplicant(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (info.getCurrency() == null) {
            info.setCurrency(ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency());
        }
        this.setNewNumber(ctx, info);
        this.setInvoiceNo(ctx, info);
        this.setBizYearMonthNull(info);
        String remark = IMUtils.cutStr(info.getRemark(), 230);
        info.setRemark(remark);
        this.updateSpecificInformationInfo(ctx, (IObjectValue)info);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.setEntryTaxClassName(ctx, pk.toString());
        this.updateInvoicedPartlyRedData(ctx, info);
        return pk;
    }

    private void setEntryTaxClassName(Context ctx, String mkID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" UPDATE t_im_makeinvoiceentry t10 SET (ftaxClassName) = (");
        sb.append(" SELECT distinct t2.FSIMPLENAME  FROM  t_im_makeinvoiceentry t1 left join T_IM_TaxClassificationCode t2 on t1.FTAXCLASSIFICATIONCODE = t2.FMERGECODE ");
        sb.append(" where t1.FMAKEINVOICEID  =  '" + mkID + "' and t1.fid = t10.fid )");
        DBUtil.executeUpdate((Context)ctx, (String)sb.toString(), null);
    }

    @Override
    protected Map _checkBeforeMake(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i).toString();
            MakeInvoiceInfo mkInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            if (mkInvoice == null) {
                result.put(id, IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0]));
                continue;
            }
            try {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_make");
            }
            catch (Exception e) {
                result.put(id, e.getMessage());
                continue;
            }
            if (InvoiceBillStatus.AUDITED.equals((Object)mkInvoice.getStatus())) continue;
            result.put(id, IMUtils.getIMResource(ctx, "AUDITEDMAKE", new String[0]));
        }
        return result;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        this.putBillValues(ctx, mkInvoice);
        this.redInvoiceHandler(ctx, mkInvoice);
        this.doRedBillRemork(ctx, mkInvoice);
        this.setBizYearMonthNull(mkInvoice);
        this.updateSpecificInformationInfo(ctx, (IObjectValue)mkInvoice);
        super._update(ctx, pk, model);
        if (mkInvoice.isIsRedVoice()) {
            this.writeBackRedFields(ctx, mkInvoice, false);
        }
    }

    @Override
    protected Map _checkBeforeCancel(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i).toString();
            MakeInvoiceInfo mkInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            StringBuffer errorMsg = new StringBuffer();
            if (mkInvoice == null) {
                result.put(id, IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0]));
                continue;
            }
            try {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_make");
            }
            catch (Exception e) {
                result.put(id, e.getMessage());
                continue;
            }
            if (!InvoiceBillStatus.MAKED.equals((Object)mkInvoice.getStatus())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "MAKEDCANCEL", new String[0]));
            }
            if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "ElectInvoiceJustRed", new String[0]));
            }
            Calendar now = Calendar.getInstance();
            Calendar invoiceCal = Calendar.getInstance();
            if (mkInvoice.getInvoiceDate() != null) {
                invoiceCal.setTime(mkInvoice.getInvoiceDate());
                if (now.get(2) != invoiceCal.get(2)) {
                    errorMsg.append(IMUtils.getIMResource(ctx, "INVOICEDATEATCURRENTMONTH", new String[0])).append(NEXTLINE);
                }
            }
            if (errorMsg.length() <= 0) continue;
            result.put(id, errorMsg.toString());
        }
        return result;
    }

    @Override
    protected Map _checkBeforeElecMake(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i).toString();
            MakeInvoiceInfo mkInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            StringBuffer errorMsg = new StringBuffer();
            if (mkInvoice == null) {
                result.put(id, IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0]));
                continue;
            }
            try {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(mkInvoice.getCompany().getId().toString(), "im_makeInvoice_make");
            }
            catch (Exception e) {
                result.put(id, e.getMessage());
                continue;
            }
            if (!InvoiceBillStatus.AUDITED.equals((Object)mkInvoice.getStatus())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "AUDITEDMAKE", new String[0]));
            }
            if (errorMsg.length() <= 0) continue;
            result.put(id, errorMsg.toString());
        }
        return result;
    }

    protected void clearRedVoiceNumber(Context ctx, MakeInvoiceInfo info) throws EASBizException, BOSException {
        if (info.getId() == null || !MakeInvoiceFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            return;
        }
        MakeInvoiceInfo systemInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        if (systemInfo.getInvoiceType() != info.getInvoiceType()) {
            info.setRedVoiceNumber(null);
        }
    }

    protected void doRedBillRemork(Context ctx, MakeInvoiceInfo info) {
        if (!info.isIsRedVoice()) {
            return;
        }
        String originalRemark = info.getRemark() == null ? "" : info.getRemark().trim();
        String str = "";
        if ((PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType())) && !StringUtils.isEmpty((String)info.getBlueVoiceNum()) && !StringUtils.isEmpty((String)info.getRedVoiceNumber())) {
            str = IMUtils.getIMResource(ctx, "DIGREDREMARK", info.getBlueVoiceNum(), info.getRedVoiceNumber());
        } else if ((PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) && !StringUtils.isEmpty((String)info.getRedVoiceNumber())) {
            String redReqNumber = info.getRedVoiceNumber();
            str = IMUtils.getIMResource(ctx, "RED_INVOICE_REMORK", new String[0]) + redReqNumber;
        } else if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)info.getInvoiceType())) {
            if (info.getBlueVoiceCode() != null && info.getBlueVoiceNum() != null) {
                str = IMUtils.getIMResource(ctx, "REDREMARK", info.getBlueVoiceCode(), info.getBlueVoiceNum());
            }
            if (info.isIsDiffTax()) {
                str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedDiffTaxRemark", (Locale)ctx.getLocale()) + str;
            }
        }
        if (info.get("redLockStrLength") != null) {
            int redLockStrLength = 0;
            try {
                redLockStrLength = Integer.valueOf(info.get("redLockStrLength").toString());
            }
            catch (Exception e) {
                logger.error((Object)("[getRedLockStrLengthError]" + e.getMessage()), (Throwable)e);
            }
            if (redLockStrLength > 0 && originalRemark.length() >= redLockStrLength) {
                originalRemark = originalRemark.substring(redLockStrLength);
            }
            if (!"".equals(str) && !str.equals(originalRemark)) {
                info.setRemark(str + originalRemark);
            }
        } else if (!"".equals(str) && originalRemark.indexOf(str) == -1) {
            info.setRemark(str + originalRemark);
        }
    }

    @Override
    protected boolean _afterSalerRed(Context ctx, Map param) throws BOSException, EASBizException {
        String remark = IMUtils.getIMResource(ctx, "RED_INVOICE_REMORK", new String[0]);
        String updateSql = " update T_IM_MakeInvoice set FRedVoiceNumber = ? ,FRemark = ? where fid = ?";
        Iterator iterator = param.keySet().iterator();
        Object[][] params = new Object[param.size()][3];
        String remarkStr = null;
        int i = 0;
        while (iterator.hasNext()) {
            String mkId = iterator.next().toString();
            String redReqNumber = param.get(mkId).toString();
            MakeInvoiceInfo info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectStringPK(mkId));
            remarkStr = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType()) ? IMUtils.getIMResource(ctx, "DIGREDREMARK", info.getBlueVoiceNum(), redReqNumber) : remark + redReqNumber;
            params[i][0] = redReqNumber;
            params[i][1] = remarkStr;
            params[i][2] = mkId;
            ++i;
        }
        DBUtil.executeBatch((Context)ctx, (String)updateSql, (Object[][])params);
        return true;
    }

    @Override
    protected IObjectPK _saveNoSetting(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDiffTaxEntry(ctx, model);
        this.setDiffTaxRemark(ctx, model);
        return this.innerSave(ctx, model, true);
    }

    protected void checkDiffTaxEntry(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        if (mkInvoice.isIsDiffTax()) {
            MakeInvoiceEntryCollection entrys = mkInvoice.getEntries();
            int entryCount = entrys.size();
            boolean isOnlyProductEntry = true;
            if (entryCount == 0 || entryCount > 2) {
                isOnlyProductEntry = false;
            } else if (entryCount == 1) {
                if (!RowType.NORMAL_ROW.equals((Object)entrys.get(0).getBillRowType())) {
                    isOnlyProductEntry = false;
                }
            } else if (!(entryCount != 2 || RowType.DISCOUNTED_ROW.equals((Object)entrys.get(0).getBillRowType()) && RowType.DISCOUNT_ROW.equals((Object)entrys.get(1).getBillRowType()))) {
                isOnlyProductEntry = false;
            }
            if (!isOnlyProductEntry) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DiffTaxOnlyOneLine", ctx.getLocale())});
            }
        }
    }

    private void setDiffTaxRemark(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)model;
        if (mkInvoice.isIsDiffTax() && mkInvoice.getEntries().size() > 0) {
            BigDecimal deductAmt = mkInvoice.getEntries().get(0).getDeductAmt();
            deductAmt = deductAmt == null ? new BigDecimal("0.00") : deductAmt.setScale(2);
            String lockRemarkString = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiffTaxRemark", (Object[])new Object[]{deductAmt.toString()});
            String remarkString = mkInvoice.getRemark() == null ? "" : mkInvoice.getRemark();
            String matchedString = "";
            if (!StringUtils.isEmpty((String)remarkString)) {
                Pattern p = Pattern.compile("^(\u5dee\u989d\u5f81\u7a0e\uff1a)[0-9]+\\.[0-9]+\u3002");
                Matcher m = p.matcher(remarkString);
                if (m.find()) {
                    matchedString = m.group();
                }
                int lockLength = matchedString.length();
                String newRemark = remarkString.substring(lockLength);
                newRemark = lockRemarkString + newRemark;
                mkInvoice.setRemark(newRemark);
            } else {
                mkInvoice.setRemark(lockRemarkString);
            }
        }
    }

    @Override
    protected boolean _checkIsPreMakeInvoice(Context ctx, String billId) throws BOSException, EASBizException {
        String selectSQL = "select FBizBillID from t_im_makeinvoicerelation where FSrcBosType='AC368D2D' and finvoicebillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                String bizBillID = rs.getString("fbizbillid");
                MakeInvoiceReqInfo reqInfo = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqInfo((IObjectPK)new ObjectUuidPK(bizBillID));
                if (reqInfo.getSourceBillType() == MakeInvoiceReqBillTypeEnum.SaleOrder) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void addSameRedBillIDLock(Context ctx, String id) throws EASBizException, BOSException {
        StringBuffer lockSQL = new StringBuffer();
        lockSQL.append(" update T_IM_MAKEINVOICE set FID = FID where FRedBillId  in ");
        lockSQL.append(" (SELECT FRedBillId FROM T_IM_MAKEINVOICE");
        lockSQL.append("  WHERE FID = ?)");
        DbUtil.execute((Context)ctx, (String)lockSQL.toString(), (Object[])new Object[]{id});
    }

    protected void writeBackRedFields(Context ctx, MakeInvoiceInfo redMkInfo, boolean isAdd) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)redMkInfo.getRedBillId())) {
            return;
        }
        this.addSameRedBillIDLock(ctx, redMkInfo.getRedBillId());
        HashMap<String, Integer> redSeqMap = new HashMap<String, Integer>();
        HashMap<String, Integer> blueSeqMap = new HashMap<String, Integer>();
        HashMap<String, BigDecimal> priceTaxMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        AbstractMakeInvoiceInfo blue = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)redMkInfo.getRedBillId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        MakeInvoiceCollection coll = this.getMakeInvoiceCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            blue = coll.get(0);
        }
        if (blue != null && (InvoiceSrcSystem.DOWNLOAD.equals((Object)blue.getSrcSystem()) || InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)blue.getSrcSystem()))) {
            return;
        }
        MakeInvoiceCollection redInvoiceColl = this.getRedInvoicesByRed(ctx, redMkInfo.getRedBillId());
        int size = redInvoiceColl.size();
        for (int i = 0; i < size; ++i) {
            MakeInvoiceEntryCollection redEntries = redInvoiceColl.get(i).getEntries();
            int entrySize = redEntries.size();
            for (int j = 0; j < entrySize; ++j) {
                if (!priceTaxMap.containsKey(redEntries.get(j).getSourceBillEntryId())) {
                    priceTaxMap.put(redEntries.get(j).getSourceBillEntryId(), IMUtils.isNullToZero(redEntries.get(j).getPriceTax()));
                    qtyMap.put(redEntries.get(j).getSourceBillEntryId(), IMUtils.isNullToZero(redEntries.get(j).getQuantity()));
                    continue;
                }
                BigDecimal oldPriceTax = (BigDecimal)priceTaxMap.get(redEntries.get(j).getSourceBillEntryId());
                BigDecimal oldQty = (BigDecimal)qtyMap.get(redEntries.get(j).getSourceBillEntryId());
                priceTaxMap.put(redEntries.get(j).getSourceBillEntryId(), oldPriceTax.add(IMUtils.isNullToZero(redEntries.get(j).getPriceTax())));
                qtyMap.put(redEntries.get(j).getSourceBillEntryId(), oldQty.add(IMUtils.isNullToZero(redEntries.get(j).getQuantity())));
            }
        }
        HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> blueQty = new HashMap<String, BigDecimal>();
        MakeInvoiceEntryCollection blueEntries = new MakeInvoiceEntryCollection();
        if (blue != null) {
            blueEntries = blue.getEntries();
        }
        for (int i = 0; i < blueEntries.size(); ++i) {
            MakeInvoiceEntryInfo entry = blueEntries.get(i);
            String key = null;
            blueSeqMap.put(entry.getId().toString(), entry.getSeq());
            key = entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) ? entry.getSourceBillEntryId() : entry.getId().toString();
            if (bluePriceTax.containsKey(key)) {
                bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(IMUtils.isNullToZero(entry.getPriceTax())));
                blueQty.put(key, ((BigDecimal)blueQty.get(key)).add(IMUtils.isNullToZero(entry.getQuantity())));
                continue;
            }
            bluePriceTax.put(key, IMUtils.isNullToZero(entry.getPriceTax()));
            blueQty.put(key, IMUtils.isNullToZero(entry.getQuantity()));
        }
        if (isAdd) {
            MakeInvoiceEntryCollection redEntries = redMkInfo.getEntries();
            for (int i = 0; i < redEntries.size(); ++i) {
                MakeInvoiceEntryInfo entry = redEntries.get(i);
                redSeqMap.put(entry.getSourceBillEntryId(), entry.getSeq());
            }
            this.checkOverRed(ctx, bluePriceTax, blueQty, priceTaxMap, qtyMap, redSeqMap, blueSeqMap, redMkInfo, (MakeInvoiceInfo)blue);
        }
        int size2 = blueEntries.size();
        for (int i = 0; i < size2; ++i) {
            MakeInvoiceEntryInfo blueEntry = blueEntries.get(i);
            if (blueEntry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
            BigDecimal unRedPriceTax = IMUtils.isNullToZero(blueEntry.getUnRedPriceTax());
            BigDecimal unRedQty = IMUtils.isNullToZero(blueEntry.getUnRedQty());
            BigDecimal redPriceTax = IMUtils.isNullToZero(blueEntry.getRedPriceTax());
            BigDecimal redQty = IMUtils.isNullToZero(blueEntry.getRedQty());
            BigDecimal totalPriceTax = unRedPriceTax.add(redPriceTax);
            BigDecimal totalQty = unRedQty.add(redQty);
            BigDecimal nowUnRedPriceTax = totalPriceTax;
            BigDecimal nowRedPriceTax = BigDecimal.ZERO;
            BigDecimal nowUnRedQty = totalQty;
            BigDecimal nowRedQty = BigDecimal.ZERO;
            if (priceTaxMap.containsKey(blueEntry.getId().toString())) {
                BigDecimal priceTax = IMUtils.isNullToZero((BigDecimal)priceTaxMap.get(blueEntry.getId().toString()));
                BigDecimal qty = IMUtils.isNullToZero((BigDecimal)qtyMap.get(blueEntry.getId().toString()));
                nowUnRedPriceTax = totalPriceTax.add(priceTax);
                nowRedPriceTax = priceTax.negate();
                nowUnRedQty = totalQty.add(qty);
                nowRedQty = qty.negate();
            }
            blueEntry.setUnRedPriceTax(nowUnRedPriceTax);
            blueEntry.setRedPriceTax(nowRedPriceTax);
            blueEntry.setUnRedQty(nowUnRedQty);
            blueEntry.setRedQty(nowRedQty);
        }
        if (isAdd && blue != null) {
            blue.setIsRedVoicedBill(true);
        }
        if (blue != null) {
            this._update(ctx, (IObjectPK)new ObjectUuidPK(blue.getId()), (IObjectValue)blue);
        }
    }

    protected void checkOverRed(Context ctx, Map<String, BigDecimal> bluePriceTax, Map<String, BigDecimal> blueQty, Map<String, BigDecimal> priceTaxMap, Map<String, BigDecimal> qtyMap, Map<String, Integer> redSeqMap, Map<String, Integer> blueSeqMap, MakeInvoiceInfo redMkInfo, MakeInvoiceInfo blue) throws IMException {
        StringBuffer totalErrorMsg = new StringBuffer();
        StringBuffer priceTaxOverErrorMsg = new StringBuffer();
        StringBuffer qtyOverErrorMsg = new StringBuffer();
        String blueInvoice = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"BlueInvoice", (Locale)ctx.getLocale());
        String redInvoice = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedInvoice", (Locale)ctx.getLocale());
        String reason = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"MakeInvoiceWriteBackFailed", (Locale)ctx.getLocale());
        String redQtyOver = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedQtyOver", (Locale)ctx.getLocale());
        String redPriceTaxOver = ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedPriceTaxOver", (Locale)ctx.getLocale());
        BigDecimal NEG_ONE = new BigDecimal(-1);
        for (String key : bluePriceTax.keySet()) {
            if (StringUtils.isEmpty((String)key)) continue;
            if (priceTaxMap.containsKey(key) && NEG_ONE.multiply(priceTaxMap.get(key)).compareTo(bluePriceTax.get(key)) > 0) {
                priceTaxOverErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedWriteBackErrorMsg", (Locale)ctx.getLocale(), (Object[])new Object[]{redInvoice, redMkInfo.getNumber(), redSeqMap.get(key), blueInvoice, blue.getNumber(), blueSeqMap.get(key)})).append(";\r\n");
            }
            if (!qtyMap.containsKey(key) || NEG_ONE.multiply(qtyMap.get(key)).compareTo(blueQty.get(key)) <= 0) continue;
            qtyOverErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RedWriteBackErrorMsg", (Locale)ctx.getLocale(), (Object[])new Object[]{redInvoice, redMkInfo.getNumber(), redSeqMap.get(key), blueInvoice, blue.getNumber(), blueSeqMap.get(key)})).append(";\r\n");
        }
        if (priceTaxOverErrorMsg.length() > 0) {
            priceTaxOverErrorMsg.insert(0, redPriceTaxOver + NEXTLINE);
        }
        if (qtyOverErrorMsg.length() > 0) {
            qtyOverErrorMsg.insert(0, redQtyOver + NEXTLINE);
        }
        if (priceTaxOverErrorMsg.length() > 0 || qtyOverErrorMsg.length() > 0) {
            totalErrorMsg.append(reason + NEXTLINE);
            totalErrorMsg.append(priceTaxOverErrorMsg);
            totalErrorMsg.append(qtyOverErrorMsg);
            throw new IMException(IMException.ERRORMSG, new Object[]{totalErrorMsg.toString()});
        }
    }

    protected MakeInvoiceCollection getRedInvoicesByRed(Context ctx, String blueInvID) throws BOSException, EASBizException {
        MakeInvoiceCollection redColl = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("redBillId", (Object)blueInvID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"99", CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.billRowType"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.priceTax"));
        sic.add(new SelectorItemInfo("entries.noTaxAmt"));
        viewInfo.setSelector(sic);
        redColl = this.getMakeInvoiceCollection(ctx, viewInfo);
        return redColl;
    }

    @Override
    protected void _updateWithoutCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setBizYearMonthNull((MakeInvoiceInfo)model);
        super._update(ctx, pk, model);
    }

    @Override
    protected Map _checkCanAddSrcBill(Context ctx, ArrayList idList, String srcBillBosType) throws BOSException, EASBizException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        boolean isBlueInvoice = true;
        HashMap<String, String> invoiceIDNumberMap = new HashMap<String, String>();
        HashSet idset = IMUtils.list2Set(idList);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(MakeInvoiceInfo.getMakeSelector());
        MakeInvoiceCollection mkBills = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(ev);
        BigDecimal firstPriceTax = BigDecimal.ZERO;
        HashSet<CurrentAccountType> acctTypeSet = new HashSet<CurrentAccountType>();
        HashSet<Boolean> isDiffTaxSet = new HashSet<Boolean>();
        int j = mkBills.size();
        for (int i = 0; i < j; ++i) {
            if (mkBills.get(i).getStatus().getValue() != "4") {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "InvoiceNeedMaked", ctx));
                return retMap;
            }
            if (i == 0) {
                firstPriceTax = mkBills.get(i).getPriceTaxTotal();
                if (firstPriceTax.signum() < 0) {
                    isBlueInvoice = false;
                }
            } else if (mkBills.get(i).getPriceTaxTotal().signum() != firstPriceTax.signum()) {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "PriceTax_SigNumNotSame", ctx));
                return retMap;
            }
            isDiffTaxSet.add(mkBills.get(i).isIsDiffTax());
            acctTypeSet.add(mkBills.get(i).getCurrentAccountType());
            invoiceIDNumberMap.put(mkBills.get(i).getId().toString(), mkBills.get(i).getNumber());
        }
        if (acctTypeSet.size() > 1) {
            retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotSameAcctType", ctx));
            return retMap;
        }
        if (isDiffTaxSet.size() >= 2) {
            retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotSameDiffTax", ctx));
            return retMap;
        }
        CurrentAccountType acctType = mkBills.get(0).getCurrentAccountType();
        String firstCustID = "";
        String firstCompanyID = "";
        for (int i = 0; i < mkBills.size(); ++i) {
            MakeInvoiceInfo info = mkBills.get(i);
            String custID = null;
            String companyId = null;
            if (acctType == CurrentAccountType.CUSTOMER) {
                custID = info.getCurrAcctCustomer() != null ? info.getCurrAcctCustomer().getId().toString() : "111111111111111111111111111=";
            }
            if (acctType == CurrentAccountType.SUPPLIER) {
                custID = info.getCurrAcctSupplier() != null ? info.getCurrAcctSupplier().getId().toString() : "111111111111111111111111111=";
            }
            companyId = info.getCompany().getId().toString();
            if (i == 0) {
                firstCustID = custID;
                firstCompanyID = companyId;
                continue;
            }
            if (!firstCustID.equals(custID)) {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotSameCustomerOrCompany", ctx));
                return retMap;
            }
            if (firstCompanyID.equals(companyId)) continue;
            retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotSameCustomerOrCompany", ctx));
            return retMap;
        }
        HashSet<String> uniqueSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("invoiceBillID", (Object)idset, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        MakeInvoiceRelationCollection coll = MakeInvoiceRelationFactory.getLocalInstance(ctx).getMakeInvoiceRelationCollection(view);
        MakeInvoiceRelationInfo info = null;
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (uniqueSet.contains(info.getInvoiceBillID())) continue;
                sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "SrcBillIsAROrReq_AddSrc", ctx.getLocale(), new Object[]{invoiceIDNumberMap.get(info.getInvoiceBillID())})).append(NEXTLINE);
                uniqueSet.add(info.getInvoiceBillID());
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select relation.FSrcBosType as srcBosType,invoice.FID as billID from t_im_makeinvoicerelation relation ");
        sql.append(" inner join t_im_makeinvoice invoice on invoice.FRedBillId = relation.finvoicebillid");
        sql.append(" where invoice.fid in ").append(IMUtils.getInStringFromSet(idset));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            uniqueSet.clear();
            while (rs.next()) {
                String srcBosType = rs.getString("srcBosType");
                String billID = rs.getString("billID");
                if (uniqueSet.contains(billID)) continue;
                if (!srcBillBosType.equals(srcBosType)) {
                    String billAlias = "FC910EF3".equals(srcBosType) ? MakeInvoiceReqBillTypeEnum.OtherReceiveBill.getAlias() : MakeInvoiceReqBillTypeEnum.MakeInvoiceReq.getAlias();
                    sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "blueAndRedAddSrcNOSAME", ctx.getLocale(), new Object[]{invoiceIDNumberMap.get(billID), billAlias})).append(NEXTLINE);
                }
                uniqueSet.add(billID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (sb.length() > 0) {
            retMap.put("errorMsg", sb.toString());
            return retMap;
        }
        retMap.put("idset", idset);
        retMap.put("firstCustID", firstCustID);
        retMap.put("firstCompanyID", firstCompanyID);
        retMap.put("isBlueInvoice", isBlueInvoice);
        retMap.put("isDiffTax", isDiffTaxSet.toArray()[0]);
        return retMap;
    }

    @Override
    protected Map _classifyInvoices(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        ArrayList<String> blueInvoice = new ArrayList<String>();
        ArrayList<String> redInvoice = new ArrayList<String>();
        HashSet idset = IMUtils.list2Set(idList);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(MakeInvoiceInfo.getMakeSelector());
        MakeInvoiceCollection mkBills = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(ev);
        int j = mkBills.size();
        for (int i = 0; i < j; ++i) {
            if (mkBills.get(i).getPriceTaxTotal() == null) continue;
            if (BigDecimal.ZERO.compareTo(mkBills.get(i).getPriceTaxTotal()) < 0) {
                blueInvoice.add(mkBills.get(i).getId().toString());
                continue;
            }
            redInvoice.add(mkBills.get(i).getId().toString());
        }
        HashMap<String, ArrayList<String>> retMap = new HashMap<String, ArrayList<String>>();
        retMap.put("blueInvoice", blueInvoice);
        retMap.put("redInvoice", redInvoice);
        return retMap;
    }

    @Override
    protected Map _checkBeforeAddSrcBill(Context ctx, Set invoiceIDList, Set srcBillIDList) throws BOSException, EASBizException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        BigDecimal invoicePriceTax = BigDecimal.ZERO;
        BigDecimal srcBillPriceTax = BigDecimal.ZERO;
        BigDecimal unInvoicedAmt = BigDecimal.ZERO;
        BigDecimal invoicedAmt = BigDecimal.ZERO;
        BigDecimal absUnInvoicedAmt = BigDecimal.ZERO;
        String srcBillId = (String)srcBillIDList.iterator().next();
        String srcBillBosType = BOSUuid.read((String)srcBillId).getType().toString();
        try {
            String inString = IMUtils.getInStringFromSet(invoiceIDList);
            String selectAmount = " select  sum(FPRICETAXTOTAL) as invoicePriceTax from t_im_makeinvoice where fid in " + inString;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectAmount);
            if (rs.next()) {
                invoicePriceTax = rs.getBigDecimal("invoicePriceTax");
            }
            inString = IMUtils.getInStringFromSet(srcBillIDList);
            selectAmount = "FC910EF3".equals(srcBillBosType) ? "SELECT sum(FAmount) as srcBillPriceTax,sum(FAMOUNT - isnull(FINVOICEDAMT,0)) as unInvoicedAmt,isnull(sum(FINVOICEDAMT),0) as invoicedAmt,abs(sum(FAMOUNT - isnull(FINVOICEDAMT,0))) as absUnInvoicedAmt  FROM t_ar_otherbill where fid in" + inString : "SELECT sum(FPriceIncludingTax) as srcBillPriceTax,sum(FPriceIncludingTax - isnull(FINVOICEDAMT,0)) as unInvoicedAmt,isnull(sum(FINVOICEDAMT),0) as invoicedAmt,abs(sum(FPriceIncludingTax - isnull(FINVOICEDAMT,0))) as absUnInvoicedAmt  FROM T_IM_MakeInvoiceReq where fid in" + inString;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectAmount);
            if (rs.next()) {
                srcBillPriceTax = rs.getBigDecimal("srcBillPriceTax");
                unInvoicedAmt = rs.getBigDecimal("unInvoicedAmt");
                invoicedAmt = rs.getBigDecimal("invoicedAmt");
                absUnInvoicedAmt = rs.getBigDecimal("absUnInvoicedAmt");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (BigDecimal.ZERO.compareTo(invoicePriceTax) < 0) {
            if (invoicePriceTax.compareTo(unInvoicedAmt) > 0) {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "addSrcOverAmt_blueInvoice", ctx));
                return retMap;
            }
        } else if (BigDecimal.ZERO.compareTo(invoicePriceTax) > 0) {
            if (BigDecimal.ZERO.compareTo(srcBillPriceTax) <= 0 && invoicedAmt.compareTo(invoicePriceTax.abs()) < 0) {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "addSrcOverAmt_redInvoiceBlueSrc", ctx));
                return retMap;
            }
            if (BigDecimal.ZERO.compareTo(srcBillPriceTax) > 0 && absUnInvoicedAmt.compareTo(invoicePriceTax.abs()) < 0) {
                retMap.put("errorMsg", IMUtils.getResource("com.kingdee.eas.tm.im.MakeInvoiceResource", "addSrcOverAmt_redInvoiceRedSrc", ctx));
                return retMap;
            }
        }
        return retMap;
    }

    @Override
    protected Map _checkCanCancelSrcBill(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        HashMap<String, String> invoiceToSrcBill = new HashMap<String, String>();
        HashSet<String> srcBillID = new HashSet<String>();
        String inString = IMUtils.getInStringFromList(idList);
        HashMap<String, String> invoiceIDToNumber = new HashMap<String, String>();
        HashMap<String, String> srcBillIDToNumber = new HashMap<String, String>();
        StringBuffer relationSql = new StringBuffer();
        relationSql.append("select  mir.FSRCBOSTYPE as srcBosType,mi.FID as invoiceID,mi.FNumber as invoiceNumber,ob.FID as bizBillID,ob.FNumber as bizBillNumber ").append("\n");
        relationSql.append(" from t_im_makeinvoicerelation mir ").append("\n");
        relationSql.append(" inner join t_im_makeinvoice mi on mi.FID = mir.FINVOICEBILLID ").append("\n");
        relationSql.append(" inner join t_ar_otherbill ob on ob.FID = mir.FBIZBILLID ").append("\n");
        relationSql.append(" where mir.FINVOICEBILLID in " + inString).append("\n");
        relationSql.append(" UNION ALL ").append("\n");
        relationSql.append("select  mir.FSRCBOSTYPE as srcBosType,mi.FID as invoiceID,mi.FNumber as invoiceNumber,ob.FID as bizBillID,ob.FNumber as bizBillNumber ").append("\n");
        relationSql.append(" from t_im_makeinvoicerelation mir ").append("\n");
        relationSql.append(" inner join t_im_makeinvoice mi on mi.FID = mir.FINVOICEBILLID ").append("\n");
        relationSql.append(" inner join T_IM_MakeInvoiceReq ob on ob.FID = mir.FBIZBILLID ").append("\n");
        relationSql.append(" where mir.FINVOICEBILLID in " + inString).append("\n");
        String srcBosType = "";
        String invoiceID = "";
        String invoiceNumber = "";
        String bizBillID = "";
        String bizBillNumber = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)relationSql.toString());
        try {
            while (rs.next()) {
                srcBosType = rs.getString("srcBosType");
                bizBillID = rs.getString("bizBillID");
                bizBillNumber = rs.getString("bizBillNumber");
                invoiceID = rs.getString("invoiceID");
                invoiceNumber = rs.getString("invoiceNumber");
                if ("FC910EF3".equals(srcBosType) || "AC368D2D".equals(srcBosType)) {
                    invoiceToSrcBill.put(invoiceID, bizBillID);
                    srcBillID.add(bizBillID);
                }
                invoiceIDToNumber.put(invoiceID, invoiceNumber);
                srcBillIDToNumber.put(bizBillID, bizBillNumber);
            }
            if (invoiceToSrcBill.size() == 0) {
                return retMap;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        inString = IMUtils.getInStringFromSet(srcBillID);
        HashSet<String> unpassSrcBillID = new HashSet<String>();
        String priceTaxSql = "select mir.FBIZBILLID as bizBillID from t_im_makeinvoice mi  left join t_im_makeinvoicerelation mir on mi.FID = mir.FINVOICEBILLID  where mi.FPRICETAXTOTAL < 0 and mir.FBIZBILLID in " + inString;
        rs = DbUtil.executeQuery((Context)ctx, (String)priceTaxSql);
        try {
            while (rs.next()) {
                bizBillID = rs.getString("bizBillID");
                unpassSrcBillID.add(bizBillID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (unpassSrcBillID.size() > 0) {
            String invoice_id2 = "";
            String bizBill_id = "";
            ArrayList<String> msg = new ArrayList<String>();
            ArrayList<String> unpassInvoiceID = new ArrayList<String>();
            for (String invoice_id2 : invoiceToSrcBill.keySet()) {
                bizBill_id = (String)invoiceToSrcBill.get(invoice_id2);
                if (!unpassSrcBillID.contains(bizBill_id) || unpassInvoiceID.contains(invoice_id2)) continue;
                msg.add(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "srcBillHasRedInvoice", IMUtils.getLocale(), new Object[]{invoiceIDToNumber.get(invoice_id2), srcBillIDToNumber.get(bizBill_id)}));
                unpassInvoiceID.add(invoice_id2);
            }
            retMap.put("errorMsg", msg);
            retMap.put("unpassInvoiceID", unpassInvoiceID);
        }
        return retMap;
    }

    @Override
    protected Map _getAddSrcBillFilter(Context ctx, Map params) throws BOSException, EASBizException {
        String bosType = (String)params.get("bosType");
        FilterInfo filterInfo = null;
        if ("FC910EF3".equals(bosType)) {
            filterInfo = this.getOtherBillFilterInfo(ctx, params);
        } else if ("AC368D2D".equals(bosType)) {
            filterInfo = this.getReqBillFilterInfo(ctx, params);
        }
        HashMap<String, FilterInfo> retValue = new HashMap<String, FilterInfo>();
        retValue.put("filter", filterInfo);
        return retValue;
    }

    private FilterInfo getOtherBillFilterInfo(Context ctx, Map params) throws BOSException {
        boolean isBlueInvoice = Boolean.valueOf(params.get("isBlueInvoice").toString());
        String companyID = (String)params.get("companyID");
        String customerID = (String)params.get("customerID");
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_ar_otherbill where fbillStatus = 3  and FisMakeInvoiceReq = 0 and FisVehicleInvoiceReq = 0");
        if (InvoiceReserveUtils.isUsedCar2ArSupport(ctx)) {
            sql.append(" and FIsUsedCarInvoiceReq = 0 ");
        }
        if (isBlueInvoice) {
            sql.append(" and ((isnull(FAmount,0) - isnull(FInvoicedAmt,0)) > 0 or (isnull(FAmount,0) - isnull(FInvoicedAmt,0)) < 0) ");
        }
        if (!StringUtils.isEmpty((String)customerID) && !"111111111111111111111111111=".equals(customerID)) {
            sql.append(" and fasstActID = '" + customerID + "'");
        }
        if (!StringUtils.isEmpty((String)companyID)) {
            sql.append(" and FCompanyID = '" + companyID + "'");
        } else {
            sql.append(" and FCompanyID = '111111111111111111111111111='");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    private FilterInfo getReqBillFilterInfo(Context ctx, Map params) {
        boolean isBlueInvoice = Boolean.valueOf(params.get("isBlueInvoice").toString());
        boolean isDiffTax = false;
        if (params.get("isDiffTax") != null) {
            isDiffTax = Boolean.valueOf(params.get("isDiffTax").toString());
        }
        String companyID = (String)params.get("companyID");
        String customerID = (String)params.get("customerID");
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_IM_MakeInvoiceReq where fstatus = 2");
        if (isBlueInvoice) {
            sql.append(" and ((isnull(FPriceIncludingTax,0) - isnull(FInvoicedAmt,0)) > 0 or (isnull(FPriceIncludingTax,0)- isnull(FInvoicedAmt,0)) < 0) ");
        }
        if (!StringUtils.isEmpty((String)customerID) && !"111111111111111111111111111=".equals(customerID)) {
            sql.append(" and FAsstActID = '" + customerID + "'");
        }
        if (!StringUtils.isEmpty((String)companyID)) {
            sql.append(" and FCompanyID = '" + companyID + "'");
        } else {
            sql.append(" and FCompanyID = '111111111111111111111111111='");
        }
        if (isDiffTax) {
            sql.append(" and FisDiffTax = 1");
        } else {
            sql.append(" and FisDiffTax = 0");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    protected void updateInvoicedPartlyRedData(Context ctx, MakeInvoiceInfo blueInvoice) throws EASBizException, BOSException {
        MakeInvoiceEntryInfo entry;
        int i;
        if (InvoiceSrcSystem.EXCEL != blueInvoice.getSrcSystem() || blueInvoice.isIsRedVoice() || InvoiceBillStatus.MAKED != blueInvoice.getStatus()) {
            return;
        }
        MakeInvoiceEntryCollection entries = blueInvoice.getEntries();
        HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> blueQty = new HashMap<String, BigDecimal>();
        for (i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            String key = null;
            key = entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) ? entry.getSourceBillEntryId() : entry.getId().toString();
            if (bluePriceTax.containsKey(key)) {
                bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax()));
                blueQty.put(key, ((BigDecimal)blueQty.get(key)).add(entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity()));
                continue;
            }
            bluePriceTax.put(key, entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax());
            blueQty.put(key, entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity());
        }
        for (i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            if (entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
            entry.setUnRedQty((BigDecimal)blueQty.get(entry.getId().toString()));
            entry.setUnRedPriceTax((BigDecimal)bluePriceTax.get(entry.getId().toString()));
            entry.setRedPriceTax(BigDecimal.ZERO);
            entry.setRedQty(BigDecimal.ZERO);
        }
        this._updateWithoutCheck(ctx, (IObjectPK)new ObjectUuidPK(blueInvoice.getId()), (IObjectValue)blueInvoice);
    }

    @Override
    protected Map _batchRed(Context ctx, List billIDs, boolean isRedBlueSourceBill, String rushRedReason) throws BOSException, EASBizException {
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"412A6F98"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int errorCount = 0;
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(billIDs);
            Iterator lt = billIDs.iterator();
            ctx.put((Object)"isBatchRed", (Object)"1");
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
                ++errorCount;
                result.put(id, mutexException.getMessage());
                lt.remove();
            }
            if (billIDs.size() > 0) {
                int i;
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[billIDs.size()];
                BatchExecuteParamsEntry entry = null;
                Class[] paramTypes = new Class[]{IObjectPK.class, Boolean.class, String.class};
                for (int i2 = 0; i2 < billIDs.size(); ++i2) {
                    entry = new BatchExecuteParamsEntry(paramTypes);
                    entry.add(0, (Object)new ObjectUuidPK(billIDs.get(i2).toString()));
                    entry.add(1, (Object)isRedBlueSourceBill);
                    entry.add(2, (Object)rushRedReason);
                    paramEntries[i2] = entry;
                }
                ServiceStateManager.getInstance().enableNextCallServices();
                ServiceStateManager.getInstance().getServiceState().enableServices();
                BatchExecuteResult exeResult = bizCtrl.batchExecute("redSingleInvoice", new Class[]{IObjectPK.class, Boolean.TYPE, String.class}, paramEntries);
                if (exeResult.getBatchResult() == null) {
                    Throwable[] exps = exeResult.getExceptions();
                    for (i = 0; i < exps.length; ++i) {
                        if (exps[i] == null) continue;
                        ++errorCount;
                        result.put(paramEntries[i].get(0).toString(), exps[i].getMessage());
                    }
                } else {
                    BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                    for (i = 0; i < paramEntries.length; ++i) {
                        Object id = paramEntries[i].get(0);
                        ActionResult actionResult = actionResults.getActionResult(id);
                        if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                        result.put(id.toString(), actionResult.getMessage());
                        ++errorCount;
                    }
                }
            }
            StringBuffer errorMsg = new StringBuffer();
            if (errorCount > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(billIDs), CompareType.INCLUDE));
                view.setFilter(filter);
                MakeInvoiceCollection coll = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
                MakeInvoiceInfo info = null;
                HashMap<String, String> numMap = new HashMap<String, String>();
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    numMap.put(info.getId().toString(), info.getNumber());
                }
                for (String id : result.keySet()) {
                    errorMsg.append(numMap.get(id) + ":" + result.get(id).toString() + NEXTLINE);
                }
            }
            result.put("ERROR_COUNT", errorCount);
            result.put("ERRORMSG", errorMsg.toString());
        }
        catch (BaseException e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(billIDs);
            ctx.remove((Object)"isBatchRed");
        }
        return result;
    }

    @Override
    protected void _redSingleInvoice(Context ctx, IObjectPK id, boolean isRedBlueSourceBill, String rushRedReason) throws BOSException, EASBizException {
        MakeInvoiceInfo info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo(id);
        IObjectPK logPk = LogUtils.beginLog(ctx, "_batchRed", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_mkInvoice_red", info.getCompany().getId().toString());
        this.checkBeforeRed(ctx, info);
        String src = info.getSrcSystem().getAlias();
        if (InvoiceSrcSystem.PWYDOWNLOAD.getAlias().equals(src)) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "invoiceSrcError", new String[0])});
        }
        String companyID = info.getCompany().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
        if (codeRuleInfo == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "codeRule_null", new String[0])});
        }
        MakeInvoiceInfo mkInvoice = (MakeInvoiceInfo)this._red(ctx, id.toString());
        mkInvoice.setIsRedBlueSourceBill(isRedBlueSourceBill);
        if (!StringUtils.isEmpty((String)rushRedReason) && RushRedReasonEnum.getEnum(rushRedReason) != null) {
            mkInvoice.setRushRedReason(RushRedReasonEnum.getEnum(rushRedReason));
        } else {
            mkInvoice.put("rushRedReason", null);
        }
        this.save(ctx, (CoreBaseInfo)mkInvoice);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected Map _checkBatchRed(Context ctx, List ids) throws BOSException, EASBizException {
        MakeInvoiceInfo info;
        int i;
        ArrayList<String> errorMsg = new ArrayList<String>();
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> numMap = new HashMap<String, String>();
        int size = ids.size();
        for (i = 0; i < size; ++i) {
            String id = ids.get(i).toString();
            MakeInvoiceInfo mkInvoice = this.getMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            numMap.put(mkInvoice.getId().toString(), mkInvoice.getNumber());
        }
        for (i = 0; i < ids.size(); ++i) {
            try {
                String id = ids.get(i).toString();
                info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(id));
                this.checkBeforeRed(ctx, info);
                String src = info.getSrcSystem().getAlias();
                if (InvoiceSrcSystem.PWYDOWNLOAD.getAlias().equals(src)) {
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "invoiceSrcError", new String[0])});
                }
                String companyID = info.getCompany().getId().toString();
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
                if (codeRuleInfo != null) continue;
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "codeRule_null", new String[0])});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                errorMsg.add(numMap.get(ids.get(i)) + ":" + e.getMessage());
            }
        }
        if (errorMsg.size() > 0) {
            ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
            IObjectPK logPk = null;
            info = null;
            String logDetail = null;
            String logItem = "im_mkInvoice_red";
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(ids.get(i2).toString()));
                logDetail = info.getNumber();
                logPk = LogUtils.beginLog(ctx, "_checkBatchRed", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, logItem, info.getCompany().getId().toString());
                logPKs.add(logPk);
            }
        }
        result.put("errorMsg", errorMsg);
        return result;
    }

    private boolean isRedVoice(MakeInvoiceInfo mkInvoice) {
        boolean isRedVoice = false;
        MakeInvoiceEntryCollection entryCol = mkInvoice.getEntries();
        BigDecimal priceTaxAmtTotal = BigDecimal.ZERO;
        for (int idx = 0; idx < entryCol.size(); ++idx) {
            MakeInvoiceEntryInfo entry = entryCol.get(idx);
            BigDecimal priceTax = entry.getPriceTax();
            priceTaxAmtTotal = priceTaxAmtTotal.add(priceTax != null ? priceTax : BigDecimal.ZERO);
        }
        if (priceTaxAmtTotal.compareTo(BigDecimal.ZERO) < 0) {
            isRedVoice = true;
        }
        return isRedVoice;
    }

    @Override
    protected Map _checkCanAddMakeInvoiceType(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        HashSet successIDs = new HashSet(ids);
        MakeInvoiceCollection mkInvoiceColl = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection("where id in " + IMUtils.getInStringFromSet(new HashSet(ids)));
        if (mkInvoiceColl == null || mkInvoiceColl.size() == 0) {
            retMap.put("detailMsg", IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "MakeInvoiceIsNull", IMUtils.getLocale()));
            return retMap;
        }
        StringBuffer detailMsg = new StringBuffer();
        for (int i = 0; i < mkInvoiceColl.size(); ++i) {
            MakeInvoiceInfo info = mkInvoiceColl.get(i);
            if (!InvoiceBillStatus.MAKED.equals((Object)info.getStatus()) && !InvoiceBillStatus.DELETED.equals((Object)info.getStatus())) {
                detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "InvoiceNeedMakedOrDeleted", IMUtils.getLocale())).append(NEXTLINE);
                successIDs.remove(info.getId().toString());
                break;
            }
            if (info.getBizYear() == 0 && info.getBizMonth() == 0) continue;
            detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BillNotAllowMakeInvType", IMUtils.getLocale())).append(NEXTLINE);
            successIDs.remove(info.getId().toString());
            break;
        }
        retMap.put("detailMsg", detailMsg.toString());
        return retMap;
    }

    @Override
    protected Map _addMakeInvoiceType(Context ctx, List ids, String makeInvoiceType) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
        StringBuffer errorMsg = new StringBuffer();
        int errorCountInCheck = 0;
        try {
            MakeInvoiceInfo info = null;
            String logDetail = null;
            IObjectPK logPk = null;
            for (int i = 0; i < ids.size(); ++i) {
                info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK((String)ids.get(i)));
                logDetail = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_ByNumber", ctx.getLocale(), new Object[]{info.getNumber()});
                logPk = LogUtils.beginLog(ctx, "addMakeInvoiceType", BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, "im_mkInvoice_addMakeInvoiceType", info.getCompany().getId().toString());
                logPKs.add(logPk);
            }
            Map retMap = this.checkBeforeAddMakeInvoiceType(ctx, ids);
            errorMsg.append((String)retMap.get("detailMsg"));
            Set idSet = (Set)retMap.get("successIDs");
            errorCountInCheck = ids.size() - idSet.size();
            if (idSet != null && idSet.size() > 0) {
                StringBuffer sql = new StringBuffer();
                if ("-1".equals(makeInvoiceType)) {
                    makeInvoiceType = null;
                }
                sql.append("update T_IM_MakeInvoice set FMakeInvoiceType = ").append(makeInvoiceType).append(" where fid = ?");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                Iterator iterator = idSet.iterator();
                while (iterator.hasNext()) {
                    params.add(new Object[]{iterator.next()});
                }
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
            }
            result.put("ERROR_COUNT", errorCountInCheck);
            result.put("ERRORMSG", errorMsg.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Iterator it = logPKs.iterator();
        while (it.hasNext()) {
            LogUtils.afterLog(ctx, (IObjectPK)it.next());
        }
        return result;
    }

    private Map checkBeforeAddMakeInvoiceType(Context ctx, List ids) throws BOSException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        StringBuffer detailMsg = new StringBuffer();
        IRowSet rs = null;
        String srcBosType = null;
        try {
            HashSet successIDs = new HashSet(ids);
            MakeInvoiceCollection mkInvoiceColl = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection("where id in " + IMUtils.getInStringFromSet(new HashSet(ids)));
            String sql = "select FBizBillID as bizBillID,FSrcBosType as srcBosType from T_IM_MakeInvoiceRelation where FInvoiceBillID = ?";
            for (int i = 0; i < mkInvoiceColl.size(); ++i) {
                MakeInvoiceInfo info = mkInvoiceColl.get(i);
                HashSet<String> bizBillSet = new HashSet<String>();
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
                while (rs.next()) {
                    srcBosType = rs.getString("srcBosType");
                    String bizBillID = rs.getString("bizBillID");
                    if ("3D667D4A".equals(srcBosType)) continue;
                    bizBillSet.add(bizBillID);
                }
                if ("FC910EF3".equals(srcBosType)) {
                    detailMsg.append(info.getNumber()).append(":");
                    detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BillNotAllowMakeInvType", IMUtils.getLocale())).append(NEXTLINE);
                    successIDs.remove(info.getId().toString());
                    continue;
                }
                if ("AC368D2D".equals(srcBosType)) {
                    MakeInvoiceReqCollection reqColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection("where id in " + IMUtils.getInStringFromSet(bizBillSet));
                    for (int j = 0; j < reqColl.size(); ++j) {
                        MakeInvoiceReqInfo reqInfo = reqColl.get(j);
                        if (reqInfo.getBizYear() == 0 && reqInfo.getBizMonth() == 0) continue;
                        detailMsg.append(info.getNumber()).append(":");
                        detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BillNotAllowMakeInvType", IMUtils.getLocale())).append(NEXTLINE);
                        successIDs.remove(info.getId().toString());
                        srcBosType = "";
                        break;
                    }
                }
                srcBosType = "";
            }
            retMap.put("detailMsg", detailMsg.toString());
            retMap.put("successIDs", successIDs);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected void _batchUpdateEmailAndPhone(Context ctx, List billIds, String recBillEmail, String cellphone) throws BOSException, EASBizException {
        if (billIds.size() == 0) {
            return;
        }
        String sql = "update T_IM_MakeInvoice set FRecBillEmail = {0},FCellphone = {1} where fid IN ({2})";
        TMSqlUtil.executeNotInject((Context)ctx, (String)sql, (Object[])new Object[]{recBillEmail, cellphone, billIds});
    }

    private void checkAmtOver(Context ctx, String billId) throws EASBizException, BOSException {
        boolean isAllowInvoiceOverBizAmt = IMParamUtils.isAllowInvoiceOverBizAmt(ctx);
        if (isAllowInvoiceOverBizAmt) {
            return;
        }
        String sql = " SELECT FBizBillID from T_IM_MakeInvoiceRelation where FInvoiceBillID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        HashSet<String> bizBillIDs = new HashSet<String>();
        try {
            while (rs.next()) {
                bizBillIDs.add(rs.getString("FBizBillID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bizBillIDs.size() == 0) {
            return;
        }
        String bizBosType = BOSUuid.read((String)((String)bizBillIDs.iterator().next())).getType().toString();
        ArrayList<String> supportBosTypes = new ArrayList<String>();
        supportBosTypes.add("FC910EF3");
        supportBosTypes.add("AC368D2D");
        supportBosTypes.add("0CADF79B");
        if (!supportBosTypes.contains(bizBosType)) {
            return;
        }
        StringBuilder invoiceSumSql = new StringBuilder();
        invoiceSumSql.append(" SELECT sum(isnull(FPriceTaxTotal,0)) as FAmtTotal  FROM  T_IM_MakeInvoice ").append("\n");
        invoiceSumSql.append(" WHERE FID in (select FInvoiceBillID from T_IM_MakeInvoiceRelation where FBizBillID in  ({0}))").append("\n");
        invoiceSumSql.append(" AND FStatus <>'99'");
        IRowSet invoiceSumResult = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)invoiceSumSql.toString(), (Object[])new Object[]{bizBillIDs});
        BigDecimal invoiceSumAmt = BigDecimal.ZERO;
        try {
            if (invoiceSumResult.next()) {
                invoiceSumAmt = invoiceSumResult.getBigDecimal("FAmtTotal");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuilder bizSumSql = new StringBuilder();
        if ("FC910EF3".equals(bizBosType)) {
            bizSumSql.append("SELECT sum(isnull(FAmount,0)) as  FAmtTotal FROM T_AR_Otherbill where FID in ({0})");
        } else if ("AC368D2D".equals(bizBosType)) {
            bizSumSql.append("SELECT sum(isnull(FPriceIncludingTax,0)) as FAmtTotal FROM T_IM_MakeInvoiceReq where FID in ({0})");
        } else if ("0CADF79B".equals(bizBosType)) {
            bizSumSql.append("SELECT sum(isnull(FPriceIncludingTax,0)) as  FAmtTotal FROM T_IM_UsedCarInvoiceReq where FID in ({0})");
        }
        IRowSet bizSumResult = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)bizSumSql.toString(), (Object[])new Object[]{bizBillIDs});
        BigDecimal bizSumAmt = BigDecimal.ZERO;
        try {
            if (bizSumResult.next()) {
                bizSumAmt = bizSumResult.getBigDecimal("FAmtTotal");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bizSumAmt.compareTo(invoiceSumAmt) < 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BillAmtOver", IMUtils.getLocale())});
        }
    }

    public static void saveRelation(Context ctx, String[] mkidArray, String[] otherbillIdArray, String srcBillBosType) throws BOSException {
        try {
            String selectSQL = "select FGroupID, FOperateTime from T_IM_MakeInvoiceRelation where FBizBillID = '" + otherbillIdArray[0] + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            String groupID = BOSUuid.create((String)"55555555").toString();
            Timestamp operateTime = new Timestamp(new Date().getTime());
            if (rs.next()) {
                groupID = rs.getString("FGroupID");
                operateTime = rs.getTimestamp("FOperateTime");
            }
            String insertSql = "insert into T_IM_MakeInvoiceRelation(FID, FSrcBosType, FBizBillID, FInvoiceBillID, FAmount, FQty, FGroupID, FOperateTime) values (?, ?, ?, ?, ?, ?, ?, ?)";
            for (int i = 0; i < mkidArray.length; ++i) {
                Object[][] params = new Object[otherbillIdArray.length][8];
                for (int m = 0; m < otherbillIdArray.length; ++m) {
                    params[m][0] = BOSUuid.create((String)"0EBBB5B4").toString();
                    params[m][1] = srcBillBosType;
                    params[m][2] = otherbillIdArray[m];
                    params[m][3] = mkidArray[i];
                    params[m][4] = BigDecimal.ZERO;
                    params[m][5] = BigDecimal.ZERO;
                    params[m][6] = groupID;
                    params[m][7] = operateTime;
                }
                DBUtil.executeBatch((Context)ctx, (String)insertSql, (Object[][])params);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _downloadSIMInvoice(Context ctx, IObjectValue bill, IObjectCollection invoices) throws BOSException, EASBizException {
    }

    @Override
    protected ArrayList _checkIsVouchered(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        HashSet idset = IMUtils.list2Set(ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ArrayList<String> voucheredMsg = new ArrayList<String>();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(MakeInvoiceInfo.getMakeSelector());
        MakeInvoiceCollection mkBills = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(ev);
        for (int j = 0; j < mkBills.size(); ++j) {
            if (!mkBills.get(j).isFiVouchered()) continue;
            voucheredMsg.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"voucheredMsg", (Locale)ctx.getLocale(), (Object[])new String[]{mkBills.get(j).getNumber()}));
        }
        return voucheredMsg;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = info.isEASBizType() ? "com.kingdee.eas.custom.makeInvoiceListPage" : "com.kingdee.eas.tm.imc.SIMMakeInvoiceListPage";
        } else if ("edit".equals(viewType)) {
            uiPk = info.isEASBizType() ? "com.kingdee.eas.custom.makeInvoiceEditPage" : "com.kingdee.eas.tm.imc.SIMMakeInvoiceEditPage";
        }
        return uiPk;
    }

    public void setInvoiceNo(Context ctx, MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if ((PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getInvoiceType())) && !IMUtils.isEmpty(mkInvoice.getInvoiceNo())) {
            mkInvoice.setInvoiceNumber("0");
        }
        if ((PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)mkInvoice.getBlueInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)mkInvoice.getBlueInvoiceType())) && !IMUtils.isEmpty(mkInvoice.getBlueVoiceNum())) {
            mkInvoice.setBlueVoiceCode("0");
        }
    }

    protected void updateSpecificInformationInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        if (info.getSpecificService() == null) {
            info.setSpecificService(SpecificServiceEnum.Normal);
        }
        SpecificInformationInfo specInfo = info.getSpecificInformation();
        if (info.getId() != null && specInfo != null && specInfo.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.NOTEQUALS));
            viewInfo.setFilter(filter);
            MakeInvoiceCollection coll = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(viewInfo);
            HashSet<String> deleteSpecIDSet = new HashSet<String>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                deleteSpecIDSet.add(coll.get(i).getSpecificInformation().getId().toString());
            }
            if (deleteSpecIDSet.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", deleteSpecIDSet, CompareType.INCLUDE));
                SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
            }
        }
        if (specInfo != null) {
            SpecificInformationFactory.getLocalInstance(ctx).save((CoreBaseInfo)specInfo);
        }
    }

    protected void deleteSpecDataByBizBill(Context ctx, MakeInvoiceInfo info) throws BOSException, EASBizException {
        SpecificInformationInfo specInfo = info.getSpecificInformation();
        if (specInfo != null && specInfo.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
            boolean isExistOtherRef = MakeInvoiceFactory.getLocalInstance(ctx).exists(filter);
            if (!isExistOtherRef) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
            }
        }
    }
}

