/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.app.AbstractMakeInvoiceReportFacadeControllerBean;
import com.kingdee.eas.tm.im.basedata.TaxPlateCollection;
import com.kingdee.eas.tm.im.basedata.TaxPlateFactory;
import com.kingdee.eas.tm.im.basedata.TaxPlateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MakeInvoiceReportFacadeControllerBean
extends AbstractMakeInvoiceReportFacadeControllerBean {
    private static final String PARAM_NUMBER = "VATM009";
    private static final String TABLE_FIELD_PREFIX = "FIELD";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceReportFacadeControllerBean");
    private static final String EAS_RESOURCE = "com.kingdee.eas.tm.im.app.MakeInvoceReportResource";
    private static final String[] sumFields = new String[]{"FTAXRATE", "FNOTAXAMT1", "FNOTAXAMT2", "FNOTAXAMT3", "FNOTAXAMT4", "FNOTAXAMT5", "FTAXAMT1", "FTAXAMT2", "FTAXAMT3", "FTAXAMT4", "FTAXAMT5"};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable());
        params.setString("tempTable", tempTable);
        this.insertBillData(ctx, params);
        this.updateMakeInvoice(ctx, params);
        return params;
    }

    private void insertBillData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append(" ").append(" (FTaxRate, FNoTaxAmt1, FNoTaxAmt2, FNoTaxAmt3,FNoTaxAmt4, ").append(" FTaxAmt1, FTaxAmt2,FTaxAmt3,FTaxAmt4) ");
        String selectSQL = this.getSelectDataSQL(ctx, tempTable, params);
        String sql = insertSQL + selectSQL;
        logger.info((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
    }

    private String getSelectDataSQL(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String dateToStr;
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("select (CASE WHEN e.FTaxRate=0 and e.FPreferentialPolicies='DutyFree' THEN 101 WHEN e.FTaxRate=0 and e.FPreferentialPolicies='NoTaxation' THEN 102");
        selectSQL.append(" ELSE isnull(e.FTaxRate,103) END) as FTaxRate,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax>0 and i.FIsDelete=1 THEN e.FNoTaxAmt WHEN e.FpriceTax<0 and i.FIsDelete =1 and e.FBILLROWTYPE=2 THEN e.FNoTaxAmt ELSE 0 END ) as FNoTaxAmt1,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax>0 and i.FSTATUS ='4' THEN e.FNoTaxAmt  WHEN e.FpriceTax<0 and i.FSTATUS ='4' and e.FBILLROWTYPE=2 THEN e.FNoTaxAmt ELSE 0 END ) as FNoTaxAmt2,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax<0 and i.FIsDelete=1 and e.FBILLROWTYPE!=2 THEN e.FNoTaxAmt ELSE 0 END ) as FNoTaxAmt3,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax<0 and i.FSTATUS ='4'  and e.FBILLROWTYPE!=2 THEN e.FNoTaxAmt ELSE 0 END ) as FNoTaxAmt4,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax>0 and i.FIsDelete=1 THEN e.FTaxAmt WHEN e.FpriceTax<0 and i.FIsDelete =1 and e.FBILLROWTYPE=2 THEN e.FTaxAmt ELSE 0 END ) as FTaxAmt1,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax>0 and i.FSTATUS ='4'  THEN e.FTaxAmt WHEN e.FpriceTax<0 and i.FSTATUS ='4' and e.FBILLROWTYPE=2 THEN e.FTaxAmt ELSE 0 END ) as FTaxAmt2,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax<0 and i.FIsDelete=1 and e.FBILLROWTYPE!=2 THEN e.FTaxAmt ELSE 0 END ) as FTaxAmt3,");
        selectSQL.append(" sum(CASE WHEN e.FpriceTax<0 and i.FSTATUS ='4'  and e.FBILLROWTYPE!=2 THEN e.FTaxAmt ELSE 0 END ) as FTaxAmt4");
        selectSQL.append(" from T_IM_MakeInvoiceEntry e inner join  T_IM_MakeInvoice i on i.FID=e.FMakeInvoiceID ");
        selectSQL.append(" INNER JOIN T_IM_InvoiceDetail invoiceDetail on invoiceDetail.FInvoiceCode = i.FInvoiceNumber and invoiceDetail.FInvoiceNo = i.FInvoiceNo ");
        selectSQL.append(this.getQuerySelect(params, ctx, true));
        String dateFromStr = params.getString("startDate");
        if (dateFromStr != null && !"".equals(dateFromStr)) {
            selectSQL.append(" and invoiceDetail.FInvoiceDate >= to_date('").append(dateFromStr).append("')");
        }
        if ((dateToStr = params.getString("endDate")) != null && !"".equals(dateToStr)) {
            dateToStr = dateToStr + " 23:59:59";
            selectSQL.append(" and invoiceDetail.FInvoiceDate <= to_date('").append(dateToStr).append("')");
        }
        selectSQL.append(" group by (CASE WHEN e.FTaxRate=0 and e.FPreferentialPolicies='DutyFree' THEN 101 WHEN e.FTaxRate=0 and e.FPreferentialPolicies='NoTaxation' THEN 102 ");
        selectSQL.append("  ELSE isnull(e.FTaxRate,103) END) order by FTaxRate desc ");
        logger.info((Object)("\u53d6\u6570SQL\uff1a" + selectSQL.toString()));
        return selectSQL.toString();
    }

    private String getQuerySelect(RptParams params, Context ctx, boolean isMakeInvoice) throws EASBizException, BOSException {
        String dateToStr;
        String dateFromStr;
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" where 1 = 1 ");
        Set taxPlateIds = (Set)params.getObject("taxPlateIds");
        if (taxPlateIds != null && !taxPlateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)taxPlateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            TaxPlateCollection taxPlateColl = TaxPlateFactory.getLocalInstance(ctx).getTaxPlateCollection(view);
            String plateNoStr = null;
            HashSet<String> taxNumberSet = new HashSet<String>();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("pwyData.taxNumber");
            int size = taxPlateColl.size();
            for (int i = 0; i < size; ++i) {
                plateNoStr = taxPlateColl.get(i).getPlateNo() + ",";
                TaxPlateInfo info = TaxPlateFactory.getLocalInstance(ctx).getTaxPlateInfo((IObjectPK)new ObjectUuidPK(taxPlateColl.get(i).getId()), selector);
                taxNumberSet.add(info.getPwyData().getTaxNumber());
            }
            if (taxNumberSet.size() != 1) {
                throw new IMException(IMException.MIRPT_CHECK);
            }
            if (!StringUtils.isEmpty(plateNoStr)) {
                selectSQL.append(" and i.FPlateNo in ('").append(plateNoStr.substring(0, plateNoStr.length() - 1)).append("')");
            }
        }
        String invoiceType = params.getString("invoiceType");
        if (isMakeInvoice) {
            invoiceType = invoiceType.replace("0", "1").replace("2", "0").replace("51", "2").replace("61", "3").replace("26", "4").replace("27", "5");
        }
        if (invoiceType != null && !"".equals(invoiceType)) {
            invoiceType = invoiceType.replaceAll(",", "','");
            selectSQL.append(" and i.FInvoiceType in ('").append(invoiceType).append("')");
        }
        if ((dateFromStr = params.getString("startDate")) != null && !"".equals(dateFromStr)) {
            selectSQL.append(" and i.FInvoiceDate >= to_date('").append(dateFromStr).append("')");
        }
        if ((dateToStr = params.getString("endDate")) != null && !"".equals(dateToStr)) {
            dateToStr = dateToStr + " 23:59:59";
            selectSQL.append(" and i.FInvoiceDate <= to_date('").append(dateToStr).append("')");
        }
        return selectSQL.toString();
    }

    private void updateMakeInvoice(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        String taxRate = params.getString("taxRate");
        if (taxRate != null && !"".equals(taxRate)) {
            sql.append(" select (CASE WHEN FTaxRate in (").append(taxRate).append(") THEN FTaxRate ELSE 103 END)");
        } else {
            sql.append(" select ");
        }
        sql.append(" FTaxRate, sum(FNoTaxAmt1) as FNoTaxAmt1, sum(FNoTaxAmt2) as FNoTaxAmt2, ABS(sum(FNoTaxAmt3)) as FNoTaxAmt3,ABS(sum(FNoTaxAmt4)) as FNoTaxAmt4,sum(FNoTaxAmt2-FNoTaxAmt1-FNoTaxAmt3+FNoTaxAmt4) as FNoTaxAmt5,");
        sql.append(" sum(FTaxAmt1) as FTaxAmt1, sum(FTaxAmt2) as FTaxAmt2,ABS(sum(FTaxAmt3)) as FTaxAmt3,ABS(sum(FTaxAmt4)) as FTaxAmt4,sum(FTaxAmt2-FTaxAmt1-FTaxAmt3+FTaxAmt4) as FTaxAmt5");
        sql.append(" from ").append(tempTable);
        if (taxRate != null && !"".equals(taxRate)) {
            sql.append(" group by (CASE WHEN FTaxRate in (").append(taxRate).append(") THEN FTaxRate ELSE 103 END) with rollup order by FTaxRate desc;");
        } else {
            sql.append(" group by FTaxRate  with rollup order by FTaxRate desc;");
        }
        rs = this.executeQuery(sql.toString(), null, ctx);
        ArrayList<Object> taxPlateList = new ArrayList<Object>();
        while (rs.next()) {
            for (int i = 0; i < rs.getColumnCount(); ++i) {
                if (!"FTAXRATE".equals(rs.getColumnName(i).toUpperCase())) continue;
                taxPlateList.add(rs.getObject(i));
            }
        }
        rs.reset();
        if (taxPlateList.size() != 0) {
            String newTempTable = null;
            newTempTable = this.createTempTable(ctx, this.getNewCreateTempTable(taxPlateList));
            params.setString("tempTable", newTempTable);
            this.insertNewBillData(ctx, params, rs);
            this.dropTempTable(tempTable, ctx);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT * ");
        sql.append(" FROM ").append(tempTable);
        rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        sql.setLength(0);
        sql.append(" SELECT * ");
        sql.append(" FROM ").append(tempTable);
        rs = this.executeQuery(sql.toString(), null, ctx);
        pp.setObject("totalset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        sql.setLength(0);
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        pp.setInt("totalCount", totalCount);
        pp.setObject("details", (Object)this.getMakeInvoiceDetail(ctx, params));
        return pp;
    }

    private void insertNewBillData(Context ctx, RptParams params, RptRowSet rs) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer insertSQL = new StringBuffer();
        for (int i = 0; i < sumFields.length; ++i) {
            if ("FTAXRATE".equals(sumFields[i])) continue;
            StringBuffer filedValue = new StringBuffer();
            filedValue.append("'").append(EASResource.getString((String)EAS_RESOURCE, (String)sumFields[i])).append("',");
            while (rs.next()) {
                for (int j = 0; j < rs.getColumnCount(); ++j) {
                    if (!sumFields[i].equals(rs.getColumnName(j))) continue;
                    filedValue.append(rs.getBigDecimal(i) == null ? "0" : rs.getBigDecimal(i).setScale(10, 4).toPlainString()).append(",");
                }
            }
            insertSQL.append("insert into ").append(tempTable).append(" values (").append(filedValue.substring(0, filedValue.length() - 1)).append(");");
            rs.reset();
        }
        this.executeUpdate(ctx, insertSQL.toString(), null);
    }

    private String getCreateTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempMakeInvoiceReportTable(");
        String decimalDefStr = " Decimal(28,10) not null default 0";
        for (int i = 0; i < sumFields.length; ++i) {
            sql.append(sumFields[i]).append(decimalDefStr);
            if (i == sumFields.length - 1) continue;
            sql.append(",");
        }
        sql.append(");");
        return sql.toString();
    }

    private String getNewCreateTempTable(ArrayList taxPlateList) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempNewMakeInvoiceReportTable(");
        String decimalDefStr = " Decimal(28,10) not null default 0";
        sql.append(" item nvarchar(44),");
        for (int i = 0; i < taxPlateList.size(); ++i) {
            if (taxPlateList.get(i) == null) {
                sql.append(TABLE_FIELD_PREFIX).append(decimalDefStr);
            } else {
                BigDecimal columnName = (BigDecimal)taxPlateList.get(i);
                if (columnName.compareTo(new BigDecimal(101)) == 0) {
                    sql.append("DutyFree").append(decimalDefStr);
                } else if (columnName.compareTo(new BigDecimal(102)) == 0) {
                    sql.append("NoTaxation").append(decimalDefStr);
                } else if (columnName.compareTo(new BigDecimal(103)) == 0) {
                    sql.append("other").append(decimalDefStr);
                } else {
                    sql.append(TABLE_FIELD_PREFIX).append(columnName.multiply(new BigDecimal(100)).setScale(0)).append(decimalDefStr);
                }
            }
            if (i == taxPlateList.size() - 1) continue;
            sql.append(",");
        }
        sql.append(");");
        logger.info((Object)("\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }

    public RptRowSet getMakeInvoiceDetail(Context ctx, RptParams params) throws EASBizException, BOSException {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("select sum(CASE WHEN FTotalPriceTax>0 and FStatus='0' THEN 1 ");
        selectSQL.append(" ELSE 0 END) as invoiceQty1,");
        selectSQL.append(" sum(CASE WHEN FTotalPriceTax>=0 and FIsDelete=1 THEN 1 ELSE 0 END ) as invoiceQty2,");
        selectSQL.append(" sum(CASE WHEN FTotalPriceTax<0 and FStatus='0' THEN 1 ELSE 0 END ) as invoiceQty3,");
        selectSQL.append(" sum(CASE WHEN FTotalPriceTax<0 and FIsDelete=1 THEN 1 ELSE 0 END ) as invoiceQty4");
        selectSQL.append(" from T_IM_InvoiceDetail i  ");
        selectSQL.append(this.getQuerySelect(params, ctx, false));
        logger.info((Object)("\u53d6\u6570SQL\uff1a" + selectSQL.toString()));
        return this.executeQuery(selectSQL.toString(), null, ctx);
    }
}

