/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.AreaUnitEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.SpecificInformationEntryInfo;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TransTypeEnum;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceReqspecificdataImport
extends IMBillImportBase {
    private Hashtable firstData = null;
    private static Logger logger = Logger.getLogger(MakeInvoiceReqspecificdataImport.class);
    private static final String resClassName = "com.kingdee.eas.tm.im.SpecificInformationResource";
    private MakeInvoiceReqInfo reqInfo = null;
    private boolean isDig = false;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MakeInvoiceReqFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        ICoreBase iCoreBase = this.getController(ctx);
        try {
            iCoreBase.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.reqInfo = null;
        SpecificInformationInfo specInfo = new SpecificInformationInfo();
        specInfo.setId(BOSUuid.create((String)"5E6919D3"));
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.reqInfo = this.doNumber(lineData, ctx);
                    this.isDig = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)this.reqInfo.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)this.reqInfo.getInvoiceType());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (this.reqInfo == null) {
                    return null;
                }
            }
            try {
                this.transmitSpecificInfo(lineData, ctx, specInfo);
                continue;
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        this.reqInfo.setSpecificInformation(specInfo);
        return this.reqInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MakeInvoiceReqInfo doNumber(Hashtable lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        MakeInvoiceReqInfo reqInfo = null;
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (number != null && number.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", number, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entries.*"));
            sic.add(new SelectorItemInfo("specificInformation.*"));
            sic.add(new SelectorItemInfo("specificInformation.entries.*"));
            view.setSelector(sic);
            MakeInvoiceReqCollection makeInvoiceReqColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
            if (makeInvoiceReqColl.size() > 0) {
                reqInfo = makeInvoiceReqColl.get(0);
                if (!MakeInvoiceReqStatusEnum.TEMPSTROE.equals((Object)reqInfo.getStatus())) {
                    String str = IMUtils.getResource(resClassName, "STATUS_ERROR", ctx);
                    throw new TaskExternalException(str);
                }
                if (!SpecificServiceEnum.Normal.equals((Object)reqInfo.getSpecificService())) return reqInfo;
                String str = IMUtils.getResource(resClassName, "NormalSpec_NOTIMPORT", ctx);
                throw new TaskExternalException(str);
            }
            String str = IMUtils.getResource(resClassName, "RECORD_NOTEXIST", ctx);
            throw new TaskExternalException(str);
        }
        String str = IMUtils.getResource(resClassName, "NUMBER_IS_ISNULL", ctx);
        throw new TaskExternalException(str);
    }

    private void transmitSpecificInfo(Hashtable lineData, Context ctx, SpecificInformationInfo specInfo) throws TaskExternalException, EASBizException, BOSException {
        if (this.reqInfo != null) {
            SpecificServiceEnum specEnum = this.reqInfo.getSpecificService();
            if (SpecificServiceEnum.ConstructionService.equals((Object)specEnum)) {
                HashMap<String, String> specInfoData = new HashMap<String, String>();
                String jzfwfsd = this.getString(lineData, "FSimpleAddress");
                if (this.isDig && StringUtils.isEmpty((String)jzfwfsd)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FSimpleAddress_NOTNULL", ctx));
                }
                specInfoData.put("jzfwfsd", jzfwfsd);
                String jzfwfsdjtdz = this.getString(lineData, "FDetailedAddress");
                if (this.isDig && StringUtils.isEmpty((String)jzfwfsdjtdz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FDetailedAddress_NOTNULL", ctx));
                }
                specInfoData.put("jzfwfsdjtdz", jzfwfsdjtdz);
                String kdsbz = this.getBoolean(ctx, "FIsCrosscity_ERROR", this.getString(lineData, "FIsCrosscity"));
                specInfoData.put("kdsbz", kdsbz);
                String jzxmmc = this.getString(lineData, "FBuildingName");
                if (this.isDig && StringUtils.isEmpty((String)jzxmmc)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FBuildingName_NOTNULL", ctx));
                }
                specInfoData.put("jzxmmc", jzxmmc);
                String tdzzsxmbh = this.getString(lineData, "FLandVatNum");
                specInfoData.put("tdzzsxmbh", tdzzsxmbh);
                specInfo.setSpecInfoData(Kson.getGson().toJson(specInfoData));
            } else if (SpecificServiceEnum.EstateOperate.equals((Object)specEnum)) {
                HashMap<String, String> specInfoData = new HashMap<String, String>();
                String bdcdz = this.getString(lineData, "FSimpleAddress2");
                if (this.isDig && StringUtils.isEmpty((String)bdcdz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FSimpleAddress2_NOTNULL", ctx));
                }
                specInfoData.put("bdcdz", bdcdz);
                String bdcjtdz = this.getString(lineData, "FDetailedAddress2");
                if (this.isDig && StringUtils.isEmpty((String)bdcjtdz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FDetailedAddress2_NOTNULL", ctx));
                }
                specInfoData.put("bdcjtdz", bdcjtdz);
                String kdsbz = this.getBoolean(ctx, "FIsCrosscity_ERROR", this.getString(lineData, "FIsCrosscity2"));
                specInfoData.put("kdsbz", kdsbz);
                String zlqq = this.getDate(ctx, lineData, "FLeaseStartDate2");
                if (this.isDig && StringUtils.isEmpty((String)zlqq)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FLeaseStartDate2_NOTNULL", ctx));
                }
                specInfoData.put("zlqq", zlqq);
                String zlqz = this.getDate(ctx, lineData, "FLeaseEndDate2");
                if (StringUtils.isEmpty((String)zlqz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FLeaseEndDate2_NOTNULL", ctx));
                }
                specInfoData.put("zlqz", zlqz);
                if (!StringUtils.isEmpty((String)zlqq) && !StringUtils.isEmpty((String)zlqz) && zlqq.compareTo(zlqz) > 0) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "DATA_ERROR", ctx));
                }
                String cqzsh = this.getString(lineData, "FPropertyNum2");
                if (this.isDig && StringUtils.isEmpty((String)cqzsh)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FPropertyNum2_NOTNULL", ctx));
                }
                specInfoData.put("cqzsh", cqzsh);
                String dw = this.getAreaUnitString(lineData, ctx, "FAreaUnit2");
                specInfoData.put("dw", dw);
                specInfo.setSpecInfoData(Kson.getGson().toJson(specInfoData));
            } else if (SpecificServiceEnum.EstateSaleService.equals((Object)specEnum)) {
                HashMap<String, String> specInfoData = new HashMap<String, String>();
                String wqhtbabh = this.getString(lineData, "FRealEstateCode3");
                specInfoData.put("wqhtbabh", wqhtbabh);
                String bdcdz = this.getString(lineData, "FSimpleAddress3");
                if (this.isDig && StringUtils.isEmpty((String)bdcdz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FSimpleAddress2_NOTNULL", ctx));
                }
                specInfoData.put("bdcdz", bdcdz);
                String bdcjtdz = this.getString(lineData, "FDetailedAddress3");
                if (this.isDig && StringUtils.isEmpty((String)bdcjtdz)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FDetailedAddress2_NOTNULL", ctx));
                }
                specInfoData.put("bdcjtdz", bdcjtdz);
                String kdsbz = this.getBoolean(ctx, "FIsCrosscity_ERROR", this.getString(lineData, "FIsCrosscity3"));
                specInfoData.put("kdsbz", kdsbz);
                String tdzzsxmbh = this.getString(lineData, "FLandVatNum3");
                specInfoData.put("tdzzsxmbh", tdzzsxmbh);
                String hdjsjg = this.getString(lineData, "FApprovedPrice3");
                specInfoData.put("hdjsjg", this.getBigDeciaml(hdjsjg, 2).toString());
                String sjcjhsje = this.getString(lineData, "FActualDealPrice3");
                specInfoData.put("sjcjhsje", this.getBigDeciaml(sjcjhsje, 2).toString());
                String cqzsh = this.getString(lineData, "FPropertyNum3");
                specInfoData.put("cqzsh", cqzsh);
                String dw = this.getAreaUnitString(lineData, ctx, "FAreaUnit3");
                specInfoData.put("dw", dw);
                specInfo.setSpecInfoData(Kson.getGson().toJson(specInfoData));
            } else if (SpecificServiceEnum.CargoTransportService.equals((Object)specEnum)) {
                SpecificInformationEntryInfo entryInfo = new SpecificInformationEntryInfo();
                entryInfo.setId(BOSUuid.create((String)"506D2A5F"));
                HashMap<String, String> specInfoEntryData = new HashMap<String, String>();
                String ysgjzl = this.getTransTypeString(lineData, ctx);
                specInfoEntryData.put("ysgjzl", ysgjzl);
                String ysgjhp = this.getString(lineData, "FCargoTransNum4");
                if (this.isDig && StringUtils.isEmpty((String)ysgjhp)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FCargoTransNum4_NOTNULL", ctx));
                }
                specInfoEntryData.put("ysgjhp", ysgjhp);
                String qyd = this.getString(lineData, "FDeparture4");
                if (this.isDig && StringUtils.isEmpty((String)qyd)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FDeparture4_NOTNULL", ctx));
                }
                specInfoEntryData.put("qyd", qyd);
                String ddd = this.getString(lineData, "FDestination4");
                if (this.isDig && StringUtils.isEmpty((String)ddd)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FDestination4_NOTNULL", ctx));
                }
                specInfoEntryData.put("ddd", ddd);
                String yshwmc1 = this.getString(lineData, "FCargoName4");
                if (this.isDig && StringUtils.isEmpty((String)yshwmc1)) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "FCargoName4_NOTNULL", ctx));
                }
                specInfoEntryData.put("yshwmc1", yshwmc1);
                entryInfo.setSpecInfoData(Kson.getGson().toJson(specInfoEntryData));
                specInfo.getEntries().add(entryInfo);
            }
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        Hashtable result = new Hashtable();
        try {
            String specServiceType = rs.getString("specificService");
            String specInfoData = rs.getString("specificInformation.SpecInfoData");
            String specInfoEntryData = rs.getString("entries1.SpecInfoData");
            Map specMap = new HashMap();
            this.putTable(result, "FNumber", rs.getString("number"));
            if ("03".equals(specServiceType)) {
                if (!IMUtils.isEmpty(specInfoData)) {
                    specMap = (Map)JSON.parseObject((String)specInfoData, Map.class);
                    this.putTable(result, "FSimpleAddress", specMap.get("jzfwfsd"));
                    this.putTable(result, "FDetailedAddress", specMap.get("jzfwfsdjtdz"));
                    this.putTable(result, "FIsCrosscity", "1".equals(specMap.get("kdsbz")) ? yes : no);
                    this.putTable(result, "FBuildingName", specMap.get("jzxmmc"));
                    this.putTable(result, "FLandVatNum", specMap.get("tdzzsxmbh"));
                }
            } else if ("06".equals(specServiceType)) {
                if (!IMUtils.isEmpty(specInfoData)) {
                    specMap = (Map)JSON.parseObject((String)specInfoData, Map.class);
                    this.putTable(result, "FSimpleAddress2", specMap.get("bdcdz"));
                    this.putTable(result, "FDetailedAddress2", specMap.get("bdcjtdz"));
                    this.putTable(result, "FIsCrosscity2", "1".equals(specMap.get("kdsbz")) ? yes : no);
                    this.putTable(result, "FLeaseStartDate2", specMap.get("zlqq"));
                    this.putTable(result, "FLeaseEndDate2", specMap.get("zlqz"));
                    this.putTable(result, "FPropertyNum2", specMap.get("cqzsh"));
                    this.putTable(result, "FAreaUnit2", (Object)AreaUnitEnum.getEnum((String)specMap.get("dw")));
                }
            } else if ("05".equals(specServiceType)) {
                if (!IMUtils.isEmpty(specInfoData)) {
                    specMap = (Map)JSON.parseObject((String)specInfoData, Map.class);
                    this.putTable(result, "FRealEstateCode3", specMap.get("wqhtbabh"));
                    this.putTable(result, "FSimpleAddress3", specMap.get("bdcdz"));
                    this.putTable(result, "FDetailedAddress3", specMap.get("bdcjtdz"));
                    this.putTable(result, "FIsCrosscity3", "1".equals(specMap.get("kdsbz")) ? yes : no);
                    this.putTable(result, "FLandVatNum3", specMap.get("tdzzsxmbh"));
                    this.putTable(result, "FApprovedPrice3", specMap.get("hdjsjg"));
                    this.putTable(result, "FActualDealPrice3", specMap.get("sjcjhsje"));
                    this.putTable(result, "FPropertyNum3", specMap.get("cqzsh"));
                    this.putTable(result, "FAreaUnit3", (Object)AreaUnitEnum.getEnum((String)specMap.get("dw")));
                }
            } else if ("04".equals(specServiceType) && !IMUtils.isEmpty(specInfoEntryData)) {
                specMap = (Map)JSON.parseObject((String)specInfoEntryData, Map.class);
                this.putTable(result, "FCargoTransType4", specMap.get("ysgjzl"));
                this.putTable(result, "FCargoTransNum4", specMap.get("ysgjhp"));
                this.putTable(result, "FDeparture4", specMap.get("qyd"));
                this.putTable(result, "FDestination4", specMap.get("ddd"));
                this.putTable(result, "FCargoName4", specMap.get("yshwmc1"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getBoolean(Context ctx, String key, String booleanVal) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        String retVal = "0";
        if (!IMUtils.isEmpty(booleanVal)) {
            if (yes.equals(booleanVal) || "TRUE".equalsIgnoreCase(booleanVal) || "T".equalsIgnoreCase(booleanVal) || "1".equals(booleanVal)) {
                retVal = "1";
            } else if (no.equals(booleanVal) || "FALSE".equalsIgnoreCase(booleanVal) || "F".equalsIgnoreCase(booleanVal) || "0".equals(booleanVal)) {
                retVal = "0";
            } else {
                throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
            }
        }
        return retVal;
    }

    private String getDate(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                if (o.toString().length() != 8) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
                }
                o = df.parse(o.toString());
                o = df.format(o);
            }
            catch (ParseException pex) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
            }
        }
        return o.toString();
    }

    private String getAreaUnitString(Hashtable lineData, Context ctx, String fieldName) throws TaskExternalException {
        String dw = this.getString(lineData, fieldName);
        if (this.isDig && StringUtils.isEmpty((String)dw)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "FAreaUnit2_NOTNULL", ctx));
        }
        boolean isExist = false;
        List areas = AreaUnitEnum.getEnumList();
        int size = areas.size();
        for (int i = 0; i < size; ++i) {
            if (!((AreaUnitEnum)((Object)areas.get(i))).getValue().equals(dw)) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "FAreaUnit2_ERROE", ctx));
        }
        return dw;
    }

    protected BigDecimal getBigDeciaml(String value, int precision) throws TaskExternalException {
        BigDecimal val = new BigDecimal("0");
        String valStr = value.toString().trim();
        valStr = valStr.replaceAll("[\uff0c,]", "");
        String reg = "(^-?\\d+(\\.\\d+)?$)";
        if (value != null && valStr.length() > 0 && valStr.matches(reg)) {
            val = new BigDecimal(valStr);
            val = val.setScale(precision, 4);
        }
        return val;
    }

    private String getTransTypeString(Hashtable lineData, Context ctx) throws TaskExternalException {
        String ysgjzl = this.getString(lineData, "FCargoTransType4");
        if (this.isDig && StringUtils.isEmpty((String)ysgjzl)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "FCargoTransType4_NOTNULL", ctx));
        }
        if (TransTypeEnum.Railway.getAlias().equals(ysgjzl) || TransTypeEnum.Railway.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Railway.getAlias();
        } else if (TransTypeEnum.Road.getAlias().equals(ysgjzl) || TransTypeEnum.Road.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Road.getAlias();
        } else if (TransTypeEnum.Water.getAlias().equals(ysgjzl) || TransTypeEnum.Water.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Water.getAlias();
        } else if (TransTypeEnum.Air.getAlias().equals(ysgjzl) || TransTypeEnum.Air.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Air.getAlias();
        } else if (TransTypeEnum.Pipeline.getAlias().equals(ysgjzl) || TransTypeEnum.Pipeline.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Pipeline.getAlias();
        } else if (TransTypeEnum.Other.getAlias().equals(ysgjzl) || TransTypeEnum.Other.getValue().equals(ysgjzl)) {
            ysgjzl = TransTypeEnum.Other.getAlias();
        } else {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "FCargoTransType4_ERROR", ctx));
        }
        return ysgjzl;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.MKInvReqSpecificInformationQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        if (this.getContextParameter().get("isConverParams") != null && "true".equals(this.getContextParameter().get("isConverParams"))) {
            Hashtable temp = firstData;
            firstData = currentData;
            currentData = temp;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }
}

