/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.AbstractMakeVolumnInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeVolumnInvoiceFacadeControllerBean
extends AbstractMakeVolumnInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeVolumnInvoiceFacadeControllerBean");
    private static final String RES_RESOURCE_NAME = "com.kingdee.eas.tm.im.MakeVolumnInvoiceResource";

    @Override
    protected ArrayList _checkBeforeInvoice(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        String errorMsg;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        MakeInvoiceCollection makeInvoiceColl = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(ev);
        HashSet<String> companyIDs = new HashSet<String>();
        HashSet<String> invoiceTypes = new HashSet<String>();
        HashSet<Boolean> isPurchasedInvoices = new HashSet<Boolean>();
        MakeInvoiceInfo mkInfo = null;
        for (int i = 0; i < makeInvoiceColl.size(); ++i) {
            mkInfo = makeInvoiceColl.get(i);
            invoiceTypes.add(mkInfo.getInvoiceType().getValue());
            isPurchasedInvoices.add(mkInfo.isIsPurchaseInvoice());
            companyIDs.add(mkInfo.getCompany().getId().toString());
        }
        HashSet<Integer> goldenTaxControls = new HashSet<Integer>();
        for (String companyID : companyIDs) {
            Map paramMap = IMUtils.getParam(ctx, companyID, new String[]{"VATM015"});
            int goldenTaxControl = IMUtils.getIntegerValue((String)paramMap.get("VATM015"));
            goldenTaxControls.add(goldenTaxControl);
        }
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (invoiceTypes.size() > 1 || !invoiceTypes.contains("0")) {
            errorMsg = IMUtils.getString(RES_RESOURCE_NAME, "MSG_CHECKFAILURE_INVOICETYPE", ctx.getLocale());
            errorMsgs.add(errorMsg);
        }
        if (isPurchasedInvoices.size() > 1) {
            errorMsg = IMUtils.getString(RES_RESOURCE_NAME, "MSG_CHECKFAILURE_ISPURCHASEFLAG", ctx.getLocale());
            errorMsgs.add(errorMsg);
        }
        if (goldenTaxControls.size() > 1 || !goldenTaxControls.contains(0)) {
            errorMsg = IMUtils.getString(RES_RESOURCE_NAME, "MSG_CHECKFAILURE_GOLENTAXCONTROL", ctx.getLocale());
            errorMsgs.add(errorMsg);
        }
        return errorMsgs;
    }
}

