/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.tm.im.app.AbstractManualMatchFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMDBUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManualMatchFacadeControllerBean
extends AbstractManualMatchFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.ManualMatchFacadeControllerBean");

    @Override
    protected Map _takeBillData(Context ctx, String takeDataSQL) throws BOSException, EASBizException {
        HashMap<String, IRowSet> data = new HashMap<String, IRowSet>();
        IRowSet rowSet = IMDBUtils.executeQuery(ctx, takeDataSQL);
        data.put("rowSet", rowSet);
        return data;
    }

    @Override
    protected void _updateRelationsData(Context ctx, List relationList) throws BOSException, EASBizException {
        String selectSql = "select * from t_tmim_relations where fbillid = ? and fbillentryid = ? and FInvoiceNumber = ?";
        String insertSql = "insert into t_tmim_relations(fbillid, fbillentryid, finvoicenumber) values(?, ?, ?)";
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        try {
            for (int i = 0; i < relationList.size(); ++i) {
                Object[] selectParams;
                IRowSet rs;
                Map relation = (Map)relationList.get(i);
                String billId = relation.get("billId").toString();
                String entryId = relation.get("entryId").toString();
                String invoiceNumber = relation.get("invoiceNumber").toString();
                if (invoiceNumber != null && billId != null) {
                    this.checkRelationData(ctx, billId, invoiceNumber);
                }
                if ((rs = DBUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])(selectParams = new Object[]{billId, entryId, invoiceNumber}))).next()) continue;
                Object[] insertParams = new Object[]{billId, entryId, invoiceNumber};
                insertParamList.add(insertParams);
            }
            if (insertParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)insertSql, (Object[][])((Object[][])insertParamList.toArray((T[])new Object[insertParamList.size()][3])));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void checkRelationData(Context ctx, String billId, String invoiceNumber) throws BOSException {
        try {
            String selectSql = "select fbillid from t_tmim_relations where finvoicenumber = ?";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{invoiceNumber});
            if (rs.next()) {
                String bBOSType;
                String bid = rs.getString("fbillid");
                String aBOSType = BOSUuid.read((String)billId).getType().toString();
                if (!aBOSType.equalsIgnoreCase(bBOSType = BOSUuid.read((String)bid).getType().toString())) {
                    throw new BOSException(IMUtils.getIMResource(ctx, "RELATION_ERROR", new String[0]));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }
}

