/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwySettingCollection;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.PwySettingStatusEnum;
import com.kingdee.eas.tm.im.app.AbstractPwySettingControllerBean;
import com.kingdee.eas.tm.im.common.cache.IMThreadLocalCache;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.MetaDataUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.Enum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.internal.util.jna.ISVNSecurityLibrary;

public class PwySettingControllerBean
extends AbstractPwySettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.PwySettingControllerBean");
    private static final String SPLIT = "_";

    @Override
    protected IObjectValue _getCollectionByCompany(Context ctx, String companyId, OPTypeEnum opType, String invoiceId, IObjectValue defaultSetting) throws BOSException, EASBizException {
        return this._getPwySetting(ctx, companyId, opType, invoiceId, defaultSetting);
    }

    @Override
    protected IObjectValue _getPwySetting(Context ctx, String companyId, OPTypeEnum opType, String invoiceId, IObjectValue object) throws BOSException, EASBizException {
        Object enableCache = ctx.get((Object)"CTX_ENABLE_THREADLOCAL_CACHE");
        boolean enableThreadLocalCache = false;
        if (enableCache != null) {
            enableThreadLocalCache = Boolean.parseBoolean(enableCache.toString());
        }
        PwySettingInfo resultInfo = null;
        ArrayList<PwySettingInfo> pwyCompanyFitList = new ArrayList<PwySettingInfo>();
        HashMap pwyCompanyBillMap = new HashMap();
        HashMap pwyCompanyBillFieldMap = new HashMap();
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        filter.appendFilterItem("company.id", (Object)companyId);
        filter.appendFilterItem("opType", (Object)opType.getValue());
        filter.appendFilterItem("status", (Object)0);
        CoreBaseCollection coll = PwySettingFactory.getLocalInstance(ctx).getCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        if (opType.equals((Object)OPTypeEnum.MakeInvoice)) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String key;
                PwySettingInfo info = (PwySettingInfo)coll.get(i);
                if (info.getBillBosType() == null) {
                    pwyCompanyFitList.add(info);
                    continue;
                }
                if (info.getBillBosType() != null && info.getMatchField() == null) {
                    key = info.getBillBosType();
                    this.putToMap(key, pwyCompanyBillMap, info);
                    continue;
                }
                if (info.getBillBosType() == null || info.getMatchField() == null) continue;
                key = info.getBillBosType() + SPLIT + info.getMatchField();
                this.putToMap(key, pwyCompanyBillFieldMap, info);
            }
            if (pwyCompanyBillMap.isEmpty() && pwyCompanyBillFieldMap.isEmpty()) {
                resultInfo = (PwySettingInfo)pwyCompanyFitList.get(0);
            } else {
                List<Object> pwyCompanyBillFitList = new ArrayList();
                List<Object> pwyCompanyBillFieldFitList = new ArrayList();
                HashSet<String> bizbillids = new HashSet<String>();
                String srcBosType = null;
                String bizbillid = null;
                String fgroupid = null;
                String fcombinid = null;
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT fsrcbostype,fbizbillid,fgroupid,fcombinid ");
                sql.append("\n FROM t_im_makeinvoicerelation relation ");
                sql.append("\n WHERE relation.finvoicebillid = '").append(invoiceId).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (rs.next()) {
                        srcBosType = rs.getString("fsrcbostype");
                        bizbillid = rs.getString("fbizbillid");
                        fgroupid = rs.getString("fgroupid");
                        fcombinid = rs.getString("fcombinid");
                        bizbillids.add(bizbillid);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (srcBosType != null) {
                    String cacheKey = companyId + SPLIT + srcBosType + SPLIT + fcombinid;
                    if (enableThreadLocalCache && (resultInfo = IMThreadLocalCache.getPwySettingCacheMap().get(cacheKey)) != null) {
                        return resultInfo;
                    }
                    pwyCompanyBillFitList = this.getFitBillList(pwyCompanyBillMap, srcBosType);
                    pwyCompanyBillFieldFitList = this.getFitBillFieldList(ctx, pwyCompanyBillFieldMap, srcBosType, bizbillids);
                    if (pwyCompanyBillFieldFitList.size() > 0) {
                        resultInfo = (PwySettingInfo)pwyCompanyBillFieldFitList.get(0);
                    } else if (pwyCompanyBillFitList.size() > 0) {
                        resultInfo = (PwySettingInfo)pwyCompanyBillFitList.get(0);
                    }
                    if (enableThreadLocalCache && resultInfo != null) {
                        IMThreadLocalCache.getPwySettingCacheMap().put(cacheKey, resultInfo);
                    }
                }
                if (resultInfo == null) {
                    if (invoiceId != null) {
                        srcBosType = BOSUuid.read((String)invoiceId).getType().toString();
                        pwyCompanyBillFitList = this.getFitBillList(pwyCompanyBillMap, srcBosType);
                        ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBosType));
                        EntityViewInfo view1 = new EntityViewInfo();
                        FilterInfo filter1 = new FilterInfo();
                        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceId, CompareType.EQUALS));
                        view1.setFilter(filter1);
                        CoreBaseCollection invoices = icoreBase.getCollection(view1);
                        if (invoices != null && invoices.size() > 0) {
                            pwyCompanyBillFieldFitList = this.getFitInvoiceBillField(ctx, pwyCompanyBillFieldMap, srcBosType, invoices.getObject(0));
                        }
                    }
                    if (pwyCompanyBillFieldFitList.size() > 0) {
                        resultInfo = (PwySettingInfo)pwyCompanyBillFieldFitList.get(0);
                    } else if (pwyCompanyBillFitList.size() > 0) {
                        resultInfo = (PwySettingInfo)pwyCompanyBillFitList.get(0);
                    } else if (pwyCompanyFitList.size() > 0) {
                        resultInfo = (PwySettingInfo)pwyCompanyFitList.get(0);
                    }
                }
            }
        } else if (opType.equals((Object)OPTypeEnum.RecInvoice)) {
            resultInfo = (PwySettingInfo)coll.get(0);
        } else if (opType.equals((Object)OPTypeEnum.TaxDraft)) {
            resultInfo = (PwySettingInfo)coll.get(0);
        }
        return resultInfo;
    }

    protected String getMatchFieldValue(Object value) {
        if (null == value) {
            return "";
        }
        String strValue = null;
        if (value instanceof Enum) {
            Object enumValue = IMUtils.getEnumValue((Enum)value);
            strValue = enumValue.toString();
        } else if (value instanceof Boolean) {
            Boolean boolValue = Boolean.parseBoolean(value.toString());
            strValue = boolValue != false ? "1" : "0";
        } else if (value instanceof ISVNSecurityLibrary.TimeStamp) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            strValue = formatter.format(value);
        } else if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            strValue = formatter.format(value);
        } else {
            strValue = value instanceof CoreBaseInfo ? ((CoreBaseInfo)value).getId().toString() : value.toString();
        }
        return strValue;
    }

    private List<PwySettingInfo> getFitBillList(Map map, String srcBosType) {
        ArrayList<PwySettingInfo> list = new ArrayList<PwySettingInfo>();
        block0: for (String key : map.keySet()) {
            List value = (List)map.get(key);
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                PwySettingInfo info = (PwySettingInfo)value.get(i);
                if (!srcBosType.equals(info.getBillBosType())) continue;
                list.add(info);
                continue block0;
            }
        }
        return list;
    }

    private List<PwySettingInfo> getFitBillFieldList(Context ctx, Map map, String srcBosType, Set<String> bizbillids) throws EASBizException, BOSException {
        ArrayList<PwySettingInfo> list = new ArrayList<PwySettingInfo>();
        int billSize = bizbillids.size();
        for (String key : map.keySet()) {
            if (!srcBosType.equals(key.split(SPLIT)[0])) continue;
            List value = (List)map.get(key);
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                PwySettingInfo info = (PwySettingInfo)value.get(i);
                CoreBaseCollection coll = this.getBillCollectionByID(ctx, bizbillids, info);
                if (coll == null || coll.size() != billSize) continue;
                list.add(info);
            }
        }
        return list;
    }

    private List<PwySettingInfo> getFitInvoiceBillField(Context ctx, Map map, String billBosType, IObjectValue invoice) throws EASBizException, BOSException {
        ArrayList<PwySettingInfo> list = new ArrayList<PwySettingInfo>();
        String fieldValue = null;
        for (String key : map.keySet()) {
            if (!billBosType.equals(key.split(SPLIT)[0])) continue;
            List value = (List)map.get(key);
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                PwySettingInfo info = (PwySettingInfo)value.get(i);
                fieldValue = this.getMatchFieldValue(invoice.get(info.getMatchField()));
                String matchFieldValue = info.getMatchFieldValue();
                if (!StringUtils.isEmpty((String)matchFieldValue) && matchFieldValue.equals(fieldValue)) {
                    list.add(info);
                    continue;
                }
                if (!StringUtils.isEmpty((String)matchFieldValue) || !StringUtils.isEmpty((String)fieldValue)) continue;
                list.add(info);
            }
        }
        return list;
    }

    private CoreBaseCollection getBillCollectionByID(Context ctx, Set<String> billIDs, PwySettingInfo info) throws BOSException, EASBizException {
        if (CollectionUtil.isEmpty(billIDs)) {
            return null;
        }
        PropertyInfo property = MetaDataUtil.getEntityProperty(ctx, info.getBillBosType(), info.getMatchField());
        Object propertyValue = null;
        String type = property.getString("dataType");
        SimpleDateFormat formatter = null;
        if (type != null && info.getMatchFieldValue() != null) {
            if (type.equalsIgnoreCase(DataType.DATE.getName())) {
                formatter = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    propertyValue = formatter.parse(info.getMatchFieldValue());
                }
                catch (ParseException e) {
                    throw new BOSException("date format error!");
                }
            } else if (type.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || type.equalsIgnoreCase(DataType.TIME.getName())) {
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    propertyValue = formatter.parse(info.getMatchFieldValue());
                }
                catch (ParseException e) {
                    throw new BOSException("date format error!");
                }
            } else {
                propertyValue = info.getMatchFieldValue();
            }
        } else {
            propertyValue = info.getMatchFieldValue();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIDs, CompareType.INCLUDE));
        if (info.getMatchField() != null) {
            filter.getFilterItems().add(new FilterItemInfo(info.getMatchField(), propertyValue));
        }
        viewInfo.setFilter(filter);
        ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)info.getBillBosType()));
        return icoreBase.getCollection(viewInfo);
    }

    private void putToMap(String key, Map map, PwySettingInfo info) {
        ArrayList<PwySettingInfo> list = null;
        list = (ArrayList<PwySettingInfo>)map.get(key);
        if (list == null) {
            list = new ArrayList<PwySettingInfo>();
        }
        list.add(info);
        map.put(key, list);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company.id");
        sic.add("company.number");
        sic.add("company.name");
        sic.add("clientId");
        sic.add("clientSecret");
        sic.add("httpAddress");
        sic.add("secretKey");
        sic.add("billName");
        sic.add("billBosType");
        sic.add("matchField");
        sic.add("matchFieldValue");
        sic.add("status");
        sic.add("opType");
        sic.add("caPassword");
        sic.add("bankAccount");
        sic.add("addressPhone");
        sic.add("pwyeetxt");
        sic.add("drawertxt");
        sic.add("checkertxt");
        sic.add("confirmPassword");
        sic.add("fpdkType");
        sic.add(new SelectorItemInfo("drawer.id"));
        sic.add(new SelectorItemInfo("drawer.number"));
        sic.add(new SelectorItemInfo("drawer.name"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("payee.id"));
        sic.add(new SelectorItemInfo("payee.number"));
        sic.add(new SelectorItemInfo("payee.name"));
        return sic;
    }

    @Override
    protected String _getAddressByUnitId(Context ctx, String companyId) throws BOSException {
        StringBuffer getId = new StringBuffer();
        String address = "";
        getId.append("select FHttpAddress from T_IM_PwySetting where fcompanyid = '").append(companyId + "'");
        IRowSet querySet = DbUtil.executeQuery((Context)ctx, (String)getId.toString());
        try {
            if (querySet.next()) {
                address = querySet.getString("FHttpAddress");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return address;
    }

    @Override
    protected ArrayList _active(Context ctx, Set ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setSelector(this.getSelector());
        view.setFilter(filter);
        PwySettingCollection coll = PwySettingFactory.getLocalInstance(ctx).getPwySettingCollection(view);
        PwySettingInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement updateSql = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSql = conn.prepareStatement("update T_IM_PwySetting set FStatus = 0 where FID = ? ");
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                IObjectPK logPk = LogUtils.beginLog(ctx, "active", BOSObjectType.create((String)"5FFAC545"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getLogInfo(), "im_pwySetting_active", info.getCompany().getId().toString());
                if (!PwySettingStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
                    errors.add(IMUtils.getIMResource(ctx, "CANNOT_ACTIVE", new String[0]));
                    continue;
                }
                try {
                    this.checkUnique(ctx, info);
                }
                catch (IMException e) {
                    errors.add(e.getMessage());
                    continue;
                }
                updateSql.setString(1, info.getId().toString());
                updateSql.execute();
                LogUtils.afterLog(ctx, logPk);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateSql);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateSql);
        SQLUtils.cleanup((Connection)conn);
        return errors;
    }

    @Override
    protected ArrayList _inActive(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setSelector(this.getSelector());
        view.setFilter(filter);
        PwySettingCollection coll = PwySettingFactory.getLocalInstance(ctx).getPwySettingCollection(view);
        PwySettingInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IObjectPK logPk = LogUtils.beginLog(ctx, "unactive", BOSObjectType.create((String)"5FFAC545"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getLogInfo(), "im_pwySetting_unactive", info.getCompany().getId().toString());
            if (!PwySettingStatusEnum.USING.equals((Object)info.getStatus())) {
                errors.add(IMUtils.getIMResource(ctx, "CANNOT_INACTIVE", new String[0]));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            LogUtils.afterLog(ctx, logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_IM_PwySetting set FStatus = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null && !this._exists(ctx, pk)) {
            logger.info((Object)("pwySetting not exists " + pk));
            return;
        }
        PwySettingInfo info = PwySettingFactory.getLocalInstance(ctx).getPwySettingInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    public void checkBeforeDelete(Context ctx, PwySettingInfo info) throws BOSException, EASBizException {
        if (PwySettingStatusEnum.USING.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CANNOTREMOVE", (Locale)ctx.getOriginLocale())});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PwySettingInfo pwySetting = (PwySettingInfo)model;
        IMUtils.trimHeadTextFields((PropertyContainer)pwySetting);
        this.checkBeforeSubmit(ctx, pwySetting);
        return super._submit(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PwySettingInfo pwySetting = null;
        pwySetting = model == null ? PwySettingFactory.getLocalInstance(ctx).getPwySettingInfo(pk) : (PwySettingInfo)model;
        IMUtils.trimHeadTextFields((PropertyContainer)pwySetting);
        this.checkBeforeSubmit(ctx, pwySetting);
        super._submit(ctx, pk, model);
    }

    private void checkBeforeSubmit(Context ctx, PwySettingInfo pwySetting) throws IMException, BOSException {
        StringBuffer errorMsg = new StringBuffer();
        if (pwySetting.getCompany() == null) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"COMPANY", (Locale)ctx.getOriginLocale()));
        }
        if (pwySetting.getHttpAddress() == null) {
            pwySetting.setHttpAddress("");
        }
        if (!(OPTypeEnum.TaxDraft.equals((Object)pwySetting.getOpType()) || !pwySetting.getHttpAddress().isEmpty() || OPTypeEnum.RecInvoice.equals((Object)pwySetting.getOpType()) && pwySetting.isFpdkType())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"HTTPADDRESS", (Locale)ctx.getOriginLocale()));
        }
        if (pwySetting.getClientId().isEmpty()) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CLIENTID", (Locale)ctx.getOriginLocale()));
        }
        if (pwySetting.getClientSecret().isEmpty()) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CLIENTSECRET", (Locale)ctx.getOriginLocale()));
        }
        if (StringUtils.isEmpty((String)pwySetting.getSecretKey())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"SECRETKEY", (Locale)ctx.getOriginLocale()));
        }
        if (errorMsg.length() > 0) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"NOTNULL"));
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.substring(1)});
        }
    }

    private void checkUnique(Context ctx, PwySettingInfo info) throws IMException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        boolean mi = OPTypeEnum.MakeInvoice.equals((Object)info.getOpType());
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("opType", (Object)info.getOpType().getValue()));
        if (mi) {
            filter.getFilterItems().add(new FilterItemInfo("billName", (Object)info.getBillName()));
            filter.getFilterItems().add(new FilterItemInfo("matchField", (Object)info.getMatchField()));
            filter.getFilterItems().add(new FilterItemInfo("matchFieldValue", (Object)info.getMatchFieldValue()));
        }
        view.setFilter(filter);
        PwySettingCollection collection = PwySettingFactory.getLocalInstance(ctx).getPwySettingCollection(view);
        if (collection != null && collection.size() > 0) {
            if (mi) {
                throw new IMException(IMException.PWYMI_MUST_UNIQUE);
            }
            throw new IMException(IMException.PWYRI_MUST_UNIQUE);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkUnique(ctx, (PwySettingInfo)model);
        return super._addnew(ctx, model);
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        String permItem = IMUtils.getPermissionItem(ctx, queryPK);
        return this._getAuthOrgsByType(ctx, orgType, permItem);
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, String permItem) throws BOSException, EASBizException {
        OrgUnitCollection unitColl = IMFacadeFactory.getLocalInstance(ctx).getAuthOrgsByType(orgType, permItem);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < unitColl.size(); ++i) {
            idSet.add(unitColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgUnitRelationCollection unitRelationColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        idSet = new HashSet();
        OrgUnitCollection relationColl = new OrgUnitCollection();
        for (int i = 0; i < unitRelationColl.size(); ++i) {
            OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
            orgUnitInfo.setId(BOSUuid.read((String)unitRelationColl.get(i).getFromUnit().getId().toString()));
            relationColl.add(orgUnitInfo);
        }
        unitColl.addCollection(relationColl);
        return unitColl;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("*"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getLogInfo();
    }

    @Override
    protected Map _getTaxNoSumResult(Context ctx, Set companyIds) throws BOSException, EASBizException {
        TaxNoSumResult sumRet;
        HashMap<String, TaxNoSumResult> result = new HashMap<String, TaxNoSumResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        view.setFilter(filter);
        PwySettingCollection pwySettingColl = this.getPwySettingCollection(ctx, view);
        CompanyOrgUnitInfo curOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap<String, String> companyMap = new HashMap<String, String>();
        String taxNo = null;
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            taxNo = company.getTaxNumber();
            if (!StringUtils.isEmpty((String)taxNo)) {
                taxNo = taxNo.trim();
            }
            companyMap.put(company.getId().toString(), taxNo);
            if (result.containsKey(taxNo)) {
                sumRet = (TaxNoSumResult)result.get(taxNo);
            } else {
                sumRet = new TaxNoSumResult(taxNo);
                sumRet.setDefaultCompany(company);
                result.put(taxNo, sumRet);
            }
            if (curOrg.equals((Object)company)) {
                sumRet.setDefaultCompany(curOrg);
            }
            sumRet.getCompanyMap().put(company.getId().toString(), company);
        }
        for (int i = 0; i < pwySettingColl.size(); ++i) {
            PwySettingInfo setting = pwySettingColl.get(i);
            taxNo = (String)companyMap.get(setting.getCompany().getId().toString());
            sumRet = (TaxNoSumResult)result.get(taxNo);
            sumRet.getPwySettingList().add(setting);
            if (!sumRet.getDefaultCompany().getId().toString().equals(setting.getCompany().getId().toString())) continue;
            sumRet.setDefaultPwySetting(setting);
        }
        return result;
    }
}

