/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.GenerateInvoiceAction;
import com.kingdee.eas.tm.im.InvoiceActionFactory;
import com.kingdee.eas.tm.im.InvoiceActionInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxSepInvoiceRelationFactory;
import com.kingdee.eas.tm.im.TaxSepInvoiceRelationInfo;
import com.kingdee.eas.tm.im.TaxSeparationCollection;
import com.kingdee.eas.tm.im.TaxSeparationEntryCollection;
import com.kingdee.eas.tm.im.TaxSeparationEntryFactory;
import com.kingdee.eas.tm.im.TaxSeparationEntryInfo;
import com.kingdee.eas.tm.im.TaxSeparationException;
import com.kingdee.eas.tm.im.TaxSeparationFactory;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import com.kingdee.eas.tm.im.TaxSeparationParamInfo;
import com.kingdee.eas.tm.im.TaxSeparationSchemeFactory;
import com.kingdee.eas.tm.im.TaxSeparationSchemeInfo;
import com.kingdee.eas.tm.im.TaxSeparationStatusEnum;
import com.kingdee.eas.tm.im.app.AbstractTaxSeparationControllerBean;
import com.kingdee.eas.tm.im.param.TaxIntegrationFacade;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;

public class TaxSeparationControllerBean
extends AbstractTaxSeparationControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.TaxSeparationControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxSeparationInfo taxSepInfo = (TaxSeparationInfo)model;
        TaxIntegrationFacade integration = new TaxIntegrationFacade();
        integration.notifyDataImportSaveReady(ctx, taxSepInfo);
        this.checkInfoValid(ctx, taxSepInfo);
        if (!taxSepInfo.isIsTaxSeparation()) {
            this.doTaxSeparation(ctx, taxSepInfo);
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)taxSepInfo);
        integration.notifyDataImportSaveSuccessed(ctx, taxSepInfo);
        return pk;
    }

    private void doTaxSeparation(Context ctx, TaxSeparationInfo taxSepInfo) throws EASBizException, BOSException {
        TaxSeparationEntryCollection entry = taxSepInfo.getEntries();
        BigDecimal totalIncludingTax = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalExculdingTax = BigDecimal.ZERO;
        for (int i = 0; i < entry.size(); ++i) {
            TaxSeparationEntryInfo entryInfo = entry.get(i);
            if (entryInfo.getProductCode() == null) {
                throw new TaxSeparationException(TaxSeparationException.PRODECT_CODE_ERROR, new Object[]{taxSepInfo.getSourceBillNumber()});
            }
            if (entryInfo.getMeasureUnit() == null) {
                throw new TaxSeparationException(TaxSeparationException.UNIT_ERROR, new Object[]{taxSepInfo.getSourceBillNumber()});
            }
            if (entryInfo.getPriceIncludingTax() == null) {
                throw new TaxSeparationException(TaxSeparationException.PRICEINCLUDINGTAX_ERROR, new Object[]{taxSepInfo.getSourceBillNumber()});
            }
            if (entryInfo.getQuantity() == null) {
                throw new TaxSeparationException(TaxSeparationException.QUANTITY_ERROR, new Object[]{taxSepInfo.getSourceBillNumber()});
            }
            ProductCodeInfo productCode = entryInfo.getProductCode();
            productCode = ProductCodeFactory.getLocalInstance(ctx).getProductCodeInfo((IObjectPK)new ObjectUuidPK(productCode.getId().toString()));
            if (!productCode.isIsLeaf()) {
                throw new TaxSeparationException(TaxSeparationException.PRODUCT_CODE_IS_NOT_LEAF, new Object[]{taxSepInfo.getSourceBillNumber()});
            }
            BigDecimal priceIncludingTax = entryInfo.getPriceIncludingTax();
            BigDecimal taxRate = entryInfo.getTaxRate() == null ? productCode.getTaxRate() : entryInfo.getTaxRate();
            entryInfo.setTaxRate(taxRate);
            BigDecimal priceExcludingTax = priceIncludingTax.divide(taxRate.add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
            BigDecimal tax = priceIncludingTax.subtract(priceExcludingTax);
            entryInfo.setTax(tax);
            entryInfo.setPriceExcludingTax(priceExcludingTax);
            totalTax = totalTax.add(tax);
            totalIncludingTax = totalIncludingTax.add(priceIncludingTax);
            totalExculdingTax = totalExculdingTax.add(priceExcludingTax);
            if (entryInfo.getPrice() != null) continue;
            BigDecimal price = priceIncludingTax.divide(entryInfo.getQuantity(), 2, RoundingMode.HALF_UP);
            entryInfo.setPrice(price);
        }
        taxSepInfo.setTax(totalTax);
        taxSepInfo.setPriceIncludingTax(totalIncludingTax);
        taxSepInfo.setPriceExcludingTax(totalExculdingTax);
    }

    private void checkInfoValid(Context ctx, TaxSeparationInfo taxSepInfo) throws EASBizException, BOSException {
        if (taxSepInfo.getBizDate() == null) {
            throw new TaxSeparationException(TaxSeparationException.BIZDATE_ERROR);
        }
        if (taxSepInfo.getAsstActType() == null) {
            throw new TaxSeparationException(TaxSeparationException.ASSTTYPE_ERROR);
        }
        if (taxSepInfo.getCompany() == null) {
            throw new TaxSeparationException(TaxSeparationException.COMPANY_ERROR);
        }
        TaxSeparationEntryCollection entry = taxSepInfo.getEntries();
        if (entry == null || entry.size() == 0) {
            throw new TaxSeparationException(TaxSeparationException.ENTRY_ERROR);
        }
        if (taxSepInfo.getNumber() == null) {
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)taxSepInfo, taxSepInfo.getCompany().getId().toString());
            if (number == null) {
                throw new TaxSeparationException(TaxSeparationException.NUMBER_ERROR);
            }
            taxSepInfo.setNumber(number);
        }
        if (taxSepInfo.getSourceBillNumber() != null && taxSepInfo.getSourceBillNumber().length() > 800) {
            taxSepInfo.setSourceBillNumber(taxSepInfo.getSourceBillNumber().substring(0, 800));
        }
        if (taxSepInfo.getStatus() == null) {
            taxSepInfo.setStatus(TaxSeparationStatusEnum.untreated);
        }
    }

    private CustomerTaxInfo getCustomerTax(Context ctx, String customerid, String customerName, String sourceNumber, Map customerTaxMap, StringBuffer errorMsg) throws SQLException, BOSException {
        CustomerTaxInfo cusTaxInfo = null;
        if (customerTaxMap.get(customerid) != null) {
            cusTaxInfo = (CustomerTaxInfo)customerTaxMap.get(customerid);
            return cusTaxInfo;
        }
        EntityViewInfo cusView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("taxpayerType"));
        sic.add(new SelectorItemInfo("billToCompanyName"));
        sic.add(new SelectorItemInfo("payInvoiceType"));
        sic.add(new SelectorItemInfo("compantTFN"));
        sic.add(new SelectorItemInfo("address"));
        sic.add(new SelectorItemInfo("telephone"));
        sic.add(new SelectorItemInfo("bankAccount"));
        sic.add(new SelectorItemInfo("defaultBillToCompany"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerid));
        filter.getFilterItems().add(new FilterItemInfo("defaultBillToCompany", (Object)1));
        cusView.setFilter(filter);
        cusView.setSelector(sic);
        CoreBaseCollection custaxColl = CustomerTaxFactory.getLocalInstance((Context)ctx).getCollection(cusView);
        if (custaxColl == null || custaxColl.size() == 0) {
            return null;
        }
        cusTaxInfo = (CustomerTaxInfo)custaxColl.get(0);
        customerTaxMap.put(customerid, custaxColl.get(0));
        return cusTaxInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("entries.specification"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.tax"));
        sic.add(new SelectorItemInfo("entries.priceExcludingTax"));
        sic.add(new SelectorItemInfo("entries.priceIncludingTax"));
        sic.add(new SelectorItemInfo("entries.discountRate"));
        sic.add(new SelectorItemInfo("entries.discountAmount"));
        sic.add(new SelectorItemInfo("productCode.id"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo("priceExcludingTax"));
        sic.add(new SelectorItemInfo("priceIncludingTax"));
        return sic;
    }

    private String getTaxSeparateQueryPKID() {
        return "com.kingdee.eas.tm.im.app.TaxSeparationQuery";
    }

    @Override
    protected Map _getSeparationCount(Context ctx, String companyId) throws BOSException, EASBizException {
        HashMap<String, Integer> billCount = new HashMap<String, Integer>();
        try {
            String idStr = this.splitCompanyId(companyId);
            String sql = "select count(FStatus) count FROM T_IM_TaxSeparation where fcompanyId in ('" + idStr + "') and FStatus = '" + 0 + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt("count");
            }
            billCount.put(TaxSeparationStatusEnum.untreated.toString(), count);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billCount;
    }

    private String splitCompanyId(String companyId) {
        StringBuffer sb = new StringBuffer();
        String[] companys = companyId.split(",");
        for (int i = 0; i < companys.length; ++i) {
            sb.append("','").append(companys[i]);
        }
        return sb.substring(3);
    }

    @Override
    protected void _deleteByMakeInvoice(Context ctx, String invoiceId) throws BOSException, EASBizException {
        String deleteSumSql = "delete from T_IM_TaxSeparation where fid in ( select FSUMTAXSEPID from T_IM_TaxSeparationInvoice where FTAXSEPID is not null and FINVOICEID = ?)";
        Object[] param = new Object[]{invoiceId};
        DbUtil.execute((Context)ctx, (String)deleteSumSql, (Object[])param);
        String deleteSumEntrySql = "delete from T_IM_TaxSeparationEntry where fbillid in( select FSUMTAXSEPID from T_IM_TaxSeparationInvoice where FTAXSEPID is not null and FINVOICEID = ?)";
        DbUtil.execute((Context)ctx, (String)deleteSumEntrySql, (Object[])param);
        String updateStatusSql = "update T_IM_TaxSeparation set fstatus = 0 where fid in ( select FTAXSEPID from T_IM_TaxSeparationInvoice where FTAXSEPID is not null and FINVOICEID = ?)";
        DbUtil.execute((Context)ctx, (String)updateStatusSql, (Object[])param);
        updateStatusSql = "update T_IM_TaxSeparation set fstatus = 0 where fid in ( select FSUMTAXSEPID from T_IM_TaxSeparationInvoice where FTAXSEPID is  null and FINVOICEID = ?)";
        DbUtil.execute((Context)ctx, (String)updateStatusSql, (Object[])param);
        String deleteTaxSeparationInvoiceSql = "delete from T_IM_TaxSeparationInvoice where FINVOICEID =?";
        DbUtil.execute((Context)ctx, (String)deleteTaxSeparationInvoiceSql, (Object[])param);
    }

    @Override
    protected void _taxPriceSeparateNew(Context ctx, TaxSeparationParamInfo taxSeparationParam) throws BOSException, EASBizException {
        TaxSeparationSchemeInfo scheme = this.getTaxSeparationScheme(ctx);
        IRowSet rs = this.getTaxSeparationInfoByIds(ctx, taxSeparationParam.getFilter());
        StringBuffer errorMsg = new StringBuffer();
        try {
            this.generateMakeInvoice(ctx, rs, scheme, errorMsg, taxSeparationParam);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (errorMsg.length() > 0) {
            throw new TaxSeparationException(TaxSeparationException.TAX_SEPARATE_ERROR, new Object[]{errorMsg.toString()});
        }
    }

    private IRowSet getTaxSeparationInfoByIds(Context ctx, FilterInfo filterItme) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        filter.mergeFilter(filterItme, "and");
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection sic = this.getSelector();
        view.setSelector(sic);
        view.setSorter(sorter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(this.getTaxSeparateQueryPKID()));
        exec.setObjectView(view);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private void generateMakeInvoice(Context ctx, IRowSet rs, TaxSeparationSchemeInfo scheme, StringBuffer errorMsg, TaxSeparationParamInfo taxSeparationParam) throws BOSException, SQLException, EASBizException, ParserException {
        HashSet<Map<String, List<TaxSepInvoiceRelationInfo>>> paramSet = new HashSet<Map<String, List<TaxSepInvoiceRelationInfo>>>();
        Map<String, List<TaxSepInvoiceRelationInfo>> actionMap = null;
        HashMap customerTaxMap = new HashMap();
        if (scheme.isIsSum()) {
            int type = scheme.getSumType().getValue();
            HashMap tmpMap = new HashMap();
            while (rs.next()) {
                if (this.customerIsNull(ctx, rs, customerTaxMap, errorMsg)) continue;
                String companyId = rs.getString("company.id");
                String sourceSys = rs.getString("sourceSys");
                String headkey = null;
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (3 == type) {
                    headkey = companyId + "ALL";
                } else if (0 == type) {
                    Date bizDate = rs.getDate("bizDate");
                    headkey = companyId + sdf.format(bizDate);
                } else if (2 == type) {
                    calendar.setTime(rs.getDate("bizDate"));
                    headkey = companyId + calendar.get(2);
                } else if (1 == type) {
                    calendar.setTime(rs.getDate("bizDate"));
                    headkey = companyId + calendar.get(3);
                }
                if (sourceSys != null) {
                    headkey = headkey + sourceSys;
                }
                List<String> idList = null;
                if (tmpMap.get(headkey) == null) {
                    idList = new ArrayList();
                    tmpMap.put(headkey, idList);
                } else {
                    idList = (List)tmpMap.get(headkey);
                }
                idList.add(rs.getString("id"));
            }
            Set keySet = tmpMap.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                List idList = (List)tmpMap.get(iterator.next());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bill.id", new HashSet(idList), CompareType.INCLUDE));
                actionMap = this.getActionMap(ctx, filter, scheme, customerTaxMap);
                paramSet.add(actionMap);
            }
        } else {
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                if (this.customerIsNull(ctx, rs, customerTaxMap, errorMsg)) continue;
                String id = rs.getString("id");
                idList.add(id);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill.id", new HashSet(idList), CompareType.INCLUDE));
            actionMap = this.getActionMap(ctx, filter, scheme, customerTaxMap);
            paramSet.add(actionMap);
        }
        this.generateInvoice(ctx, paramSet, scheme, errorMsg);
    }

    private Map<String, List<TaxSepInvoiceRelationInfo>> getActionMap(Context ctx, FilterInfo filter, TaxSeparationSchemeInfo scheme, Map customerTaxMap) throws BOSException {
        HashMap<String, List<TaxSepInvoiceRelationInfo>> actionMap = new HashMap<String, List<TaxSepInvoiceRelationInfo>>();
        String key = null;
        ArrayList<TaxSepInvoiceRelationInfo> actionList = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(this.getEntryTaxSelector());
        ev.setFilter(filter);
        TaxSeparationEntryCollection taxSepEntryColl = TaxSeparationEntryFactory.getLocalInstance(ctx).getTaxSeparationEntryCollection(ev);
        for (int i = 0; i < taxSepEntryColl.size(); ++i) {
            TaxSeparationEntryInfo taxSepEntryInfo = taxSepEntryColl.get(i);
            String customerID = taxSepEntryInfo.getBill().getCustomer().getId().toString();
            key = "_" + taxSepEntryInfo.getTaxRate() + "_" + taxSepEntryInfo.getBill().getCustomer().getId();
            if (!scheme.isIsSum()) {
                key = key + "_" + taxSepEntryInfo.getBill().getId();
            }
            TaxSepInvoiceRelationInfo taxInvoiceRelationInfo = new TaxSepInvoiceRelationInfo();
            taxSepEntryInfo.setType(this.getTypeStr(taxSepEntryInfo, scheme));
            BigDecimal invoiceQuantity = taxSepEntryInfo.getQuantity();
            taxSepEntryInfo.setInvoiceQuantity(invoiceQuantity);
            taxInvoiceRelationInfo.setQuantity(invoiceQuantity);
            taxInvoiceRelationInfo.setTaxSepEntry(taxSepEntryInfo);
            if (scheme.isIsInTax()) {
                BigDecimal priceIncludingTax = taxSepEntryInfo.getPriceIncludingTax();
                taxInvoiceRelationInfo.setAmount(priceIncludingTax);
            } else {
                BigDecimal priceExcludingTax = taxSepEntryInfo.getPriceExcludingTax();
                taxInvoiceRelationInfo.setAmount(priceExcludingTax);
            }
            if (customerTaxMap.get(customerID) != null) {
                CustomerTaxInfo customerTax = (CustomerTaxInfo)customerTaxMap.get(customerID);
                if (customerTax.getBigDecimal("maxValue") != null) {
                    BigDecimal maxValue = customerTax.getBigDecimal("maxValue");
                    taxInvoiceRelationInfo.setCustomerID(customerID);
                    taxInvoiceRelationInfo.setMaxValue(maxValue);
                }
                if (customerTax.get("isTakeModel") != null) {
                    taxInvoiceRelationInfo.setTakeModel(customerTax.getBoolean("isTakeModel"));
                }
            }
            if (actionMap.containsKey(key)) {
                ((List)actionMap.get(key)).add(taxInvoiceRelationInfo);
                continue;
            }
            actionList = new ArrayList<TaxSepInvoiceRelationInfo>();
            actionList.add(taxInvoiceRelationInfo);
            actionMap.put(key, actionList);
        }
        return actionMap;
    }

    private void generateInvoice(Context ctx, Set<Map<String, List<TaxSepInvoiceRelationInfo>>> paramSet, TaxSeparationSchemeInfo scheme, StringBuffer errorMsg) throws EASBizException, BOSException, SQLException {
        GenerateInvoiceAction action = null;
        for (Map<String, List<TaxSepInvoiceRelationInfo>> actionMap : paramSet) {
            Set<String> keySet = actionMap.keySet();
            Iterator<String> keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                List<TaxSepInvoiceRelationInfo> actionList = actionMap.get(keyIterator.next());
                action = new GenerateInvoiceAction(actionList);
                String companyId = actionList.get(0).getTaxSepEntry().getBill().getCompany().getId().toString();
                int maxLineNo = this.getMaxLineNo(ctx, companyId);
                BigDecimal maxAmt = this.getMaxAmt(ctx, companyId);
                int pricePrecision = this.getPricePrecision(ctx, companyId);
                action.setMaxLine(maxLineNo);
                action.setisList(scheme.isIsList());
                action.setisInTax(scheme.isIsInTax());
                if (actionList.get(0).getMaxValue() != null) {
                    action.setMaxAmount(actionList.get(0).getMaxValue());
                } else {
                    action.setMaxAmount(maxAmt);
                }
                action.setPricePrecision(pricePrecision);
                action.action();
                this.afterAction(ctx, action, errorMsg);
            }
        }
    }

    private void afterAction(Context ctx, GenerateInvoiceAction action, StringBuffer errorMsg) throws BOSException, EASBizException, SQLException {
        List<TaxSeparationEntryInfo> taxSepEntryList = action.getTaxSepEntryList();
        this.reverseTaxSep(ctx, taxSepEntryList);
        List<TaxSepInvoiceRelationInfo> invoiceRelationList = action.getInvoiceRelationList();
        this.saveTaxInvoiceRelation(ctx, invoiceRelationList);
        List<MakeInvoiceInfo> invoiceList = action.getInvoiceList();
        this.saveMakeInvoice(ctx, invoiceList, errorMsg);
        this.addBotpRelation(ctx, invoiceRelationList);
    }

    private void addBotpRelation(Context ctx, List<TaxSepInvoiceRelationInfo> invoiceRelationList) throws BOSException {
        HashMap<String, String> botpRelationMap = new HashMap<String, String>();
        for (TaxSepInvoiceRelationInfo taxSepInvoiceRelation : invoiceRelationList) {
            String invoiceId = taxSepInvoiceRelation.getInvoiceEntry().getMakeInvoice().getId().toString();
            String taxSepId = taxSepInvoiceRelation.getTaxSepEntry().getBill().getId().toString();
            String key = taxSepId.concat(invoiceId);
            if (botpRelationMap.containsKey(key)) continue;
            BOTRelationInfo botRelation = new BOTRelationInfo();
            botRelation.setSrcEntityID(taxSepInvoiceRelation.getTaxSepEntry().getBill().getBOSType().toString());
            botRelation.setDestEntityID(taxSepInvoiceRelation.getInvoiceEntry().getMakeInvoice().getBOSType().toString());
            botRelation.setSrcObjectID(taxSepId);
            botRelation.setDestObjectID(invoiceId);
            botRelation.setDate(new java.util.Date());
            botRelation.setOperatorID(ContextUtil.getCurrentUserInfo((Context)ctx).toString());
            botRelation.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(botRelation);
            botpRelationMap.put(key, "OK");
        }
    }

    private void reverseTaxSep(Context ctx, List<TaxSeparationEntryInfo> taxSepEntryList) throws BOSException, EASBizException {
        HashSet<String> taxSepIdList = new HashSet<String>();
        for (TaxSeparationEntryInfo taxSepEntry : taxSepEntryList) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("invoiceAmout"));
            selector.add(new SelectorItemInfo("invoiceQuantity"));
            TaxSeparationEntryFactory.getLocalInstance(ctx).updatePartial(taxSepEntry, selector);
            taxSepIdList.add(taxSepEntry.getBill().getId().toString());
        }
        if (taxSepIdList.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("invoiceTotalAmount"));
            sic.add(new SelectorItemInfo("status"));
            sic.add(new SelectorItemInfo("entries.invoiceAmout"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", taxSepIdList, CompareType.INCLUDE));
            view.setFilter(filter);
            TaxSeparationCollection coll = TaxSeparationFactory.getLocalInstance(ctx).getTaxSeparationCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                TaxSeparationInfo taxSepInfo = coll.get(i);
                BigDecimal invoiceTotalAmount = this.getTotalAmount(taxSepInfo.getEntries());
                taxSepInfo.setInvoiceTotalAmount(invoiceTotalAmount);
                taxSepInfo.setStatus(TaxSeparationStatusEnum.treated);
                TaxSeparationFactory.getLocalInstance(ctx).updatePartial(taxSepInfo, sic);
            }
        }
    }

    private BigDecimal getTotalAmount(TaxSeparationEntryCollection entries) {
        BigDecimal totalAmount = new BigDecimal("0");
        for (int i = 0; i < entries.size(); ++i) {
            TaxSeparationEntryInfo entryInfo = entries.get(i);
            BigDecimal invoiceAmout = entryInfo.getInvoiceAmout() == null ? new BigDecimal("0") : entryInfo.getInvoiceAmout();
            totalAmount = totalAmount.add(invoiceAmout);
        }
        return totalAmount;
    }

    private void saveMakeInvoice(Context ctx, List<MakeInvoiceInfo> invoiceList, StringBuffer errorMsg) throws BOSException, SQLException, EASBizException {
        for (MakeInvoiceInfo makeInvoice : invoiceList) {
            this.beforeSubmit(ctx, makeInvoice, errorMsg);
            MakeInvoiceFactory.getLocalInstance(ctx).submit((CoreBaseInfo)makeInvoice);
        }
    }

    private void beforeSubmit(Context ctx, MakeInvoiceInfo makeInvoice, StringBuffer errorMsg) throws BOSException, SQLException {
        HashMap customerTaxMap;
        String customerName;
        String customerid;
        CustomerTaxInfo customerTax;
        makeInvoice.setApplicant(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (makeInvoice.getCurrAcctCustomer() != null && makeInvoice.getCurrAcctCustomer().getId().toString() != null && (customerTax = this.getCustomerTax(ctx, customerid = makeInvoice.getCurrAcctCustomer().getId().toString(), customerName = makeInvoice.getCurrAcctCustomer().getName(), null, customerTaxMap = new HashMap(), errorMsg)) != null) {
            makeInvoice.setInvoiceType(customerTax.getPayInvoiceType());
            makeInvoice.setCurrentAccountType(CurrentAccountType.CUSTOMER);
            makeInvoice.setReceiveCompany(customerTax.getBillToCompanyName());
            makeInvoice.setTaxNumber(customerTax.getCompantTFN());
            makeInvoice.setAddress(customerTax.getAddress());
            makeInvoice.setTel(customerTax.getTelephone());
            if (customerTax.getBank() != null) {
                makeInvoice.setBankName(customerTax.getBank().getName());
            }
            makeInvoice.setBankAccount(customerTax.getBankAccount());
        }
    }

    private void saveTaxInvoiceRelation(Context ctx, List<TaxSepInvoiceRelationInfo> invoiceRelationList) throws BOSException {
        InvoiceActionInfo invoiceAction = this.getCurrentAction(ctx);
        for (TaxSepInvoiceRelationInfo relation : invoiceRelationList) {
            relation.setAction(invoiceAction);
            TaxSepInvoiceRelationFactory.getLocalInstance(ctx).addnew(relation);
        }
    }

    private InvoiceActionInfo getCurrentAction(Context ctx) throws BOSException {
        InvoiceActionInfo invoiceAction = new InvoiceActionInfo();
        InvoiceActionFactory.getLocalInstance(ctx).addnew(invoiceAction);
        return invoiceAction;
    }

    private SelectorItemCollection getEntryTaxSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("productCode.id"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("specification"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("quantity"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("priceExcludingTax"));
        sic.add(new SelectorItemInfo("priceIncludingTax"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("bill.company.id"));
        sic.add(new SelectorItemInfo("bill.currency.id"));
        sic.add(new SelectorItemInfo("bill.customer.id"));
        sic.add(new SelectorItemInfo("bill.customer.name"));
        sic.add(new SelectorItemInfo("bill.sourcebillnumber"));
        sic.add(new SelectorItemInfo("bill.bizDate"));
        return sic;
    }

    private String getTypeStr(TaxSeparationEntryInfo entryInfo, TaxSeparationSchemeInfo scheme) {
        String discountRate;
        String type = scheme.getSumRule().getValue();
        String dim = null;
        String entryNameId = entryInfo.getProductCode() == null || entryInfo.getProductCode().getId().toString() == null ? "null" : entryInfo.getProductCode().getId().toString();
        String specs = entryInfo.getSpecification() == null ? "" : entryInfo.getSpecification();
        String measureUnitId = entryInfo.getMeasureUnit().getId().toString() == null ? "" : entryInfo.getMeasureUnit().getId().toString();
        String price = entryInfo.getPrice().toString() == null ? "null" : entryInfo.getPrice().toString();
        String string = discountRate = entryInfo.getDiscountRate() == null ? "0" : entryInfo.getDiscountRate().toString();
        dim = scheme.isIsSum() ? ("1".equals(type) ? this.concat(entryNameId, specs, measureUnitId) : ("2".equals(type) ? this.concat(entryNameId, specs, measureUnitId, price) : ("3".equals(type) ? this.concat(entryNameId, specs, measureUnitId, price, discountRate) : UUID.randomUUID().toString()))) : UUID.randomUUID().toString();
        return dim;
    }

    private String concat(String ... str) {
        String PREFIX = "_";
        StringBuffer sb = new StringBuffer();
        if (str.length > 0) {
            int len = str.length;
            for (int idx = 0; idx < len; ++idx) {
                sb.append(str[idx] == null ? "" : str[idx]);
                if (idx >= len - 1) continue;
                sb.append(PREFIX);
            }
        }
        return sb.toString();
    }

    private boolean customerIsNull(Context ctx, IRowSet rs, Map customerTaxMap, StringBuffer errorMsg) throws SQLException, BOSException {
        String sourceNumber;
        String customerName;
        boolean IsCustomerNull = false;
        String customerid = rs.getString("customer.id");
        CustomerTaxInfo customerTax = this.getCustomerTax(ctx, customerid, customerName = rs.getString("CUSTOMER.NAME"), sourceNumber = rs.getString("SOURCEBILLNUMBER"), customerTaxMap, errorMsg);
        if (customerTax == null) {
            IsCustomerNull = true;
        }
        return IsCustomerNull;
    }

    private BigDecimal getMaxAmt(Context ctx, String companyId) throws EASBizException, BOSException {
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM002"});
    }

    private int getMaxLineNo(Context ctx, String companyId) throws EASBizException, BOSException {
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM005"}).intValue();
    }

    private int getPricePrecision(Context ctx, String companyId) throws EASBizException, BOSException {
        return IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM001"}).intValue();
    }

    @Override
    protected IObjectValue _generateInvoice(Context ctx, String filterItems) throws BOSException, EASBizException {
        try {
            TaxSeparationSchemeInfo scheme = this.getTaxSeparationScheme(ctx);
            StringBuffer errorMsg = new StringBuffer();
            FilterInfo filter = new FilterInfo(filterItems);
            IRowSet rs = this.getTaxSeparationInfoByIds(ctx, filter);
            this.generateMakeInvoice(ctx, rs, scheme, errorMsg, null);
            if (errorMsg.length() > 0) {
                throw new TaxSeparationException(TaxSeparationException.TAX_SEPARATE_ERROR, new Object[]{errorMsg.toString()});
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private TaxSeparationSchemeInfo getTaxSeparationScheme(Context ctx) throws BOSException, TaxSeparationException {
        CoreBaseCollection coll = TaxSeparationSchemeFactory.getLocalInstance(ctx).getCollection();
        TaxSeparationSchemeInfo scheme = null;
        if (coll.size() <= 0) {
            throw new TaxSeparationException(TaxSeparationException.SCHEME_ERROR);
        }
        scheme = (TaxSeparationSchemeInfo)coll.get(0);
        return scheme;
    }

    @Override
    protected List _importBills(Context ctx, IObjectCollection taxSeparationCollection) throws BOSException, EASBizException {
        IObjectPK[] pks = this._saveBatchData(ctx, taxSeparationCollection);
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>(Arrays.asList(pks));
        return list;
    }
}

