/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceRelationCollection;
import com.kingdee.eas.tm.im.MakeInvoiceRelationEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceRelationFactory;
import com.kingdee.eas.tm.im.MakeInvoiceRelationInfo;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceBillTypeEnum;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceCollection;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceException;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceFactory;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.AbstractUsedCarMakeInvoiceControllerBean;
import com.kingdee.eas.tm.im.app.util.IMCodeRuleHelper;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.basedata.SalerEnterpriseType;
import com.kingdee.eas.tm.im.common.InvoiceTypeEnum;
import com.kingdee.eas.tm.im.common.writeback.WriteBackFacadeFactory;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.OrgUtils;
import com.kingdee.eas.tm.im.util.UsedCarMakeInvoiceFilterFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UsedCarMakeInvoiceControllerBean
extends AbstractUsedCarMakeInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.UsedCarMakeInvoiceControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = (UsedCarMakeInvoiceInfo)model;
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        } else {
            info.setId(BOSUuid.create((String)"03DDCDAF"));
        }
        if (info.getSrcSystem() == null) {
            info.setSrcSystem(InvoiceSrcSystem.MANUAL);
        }
        this.doNumber(ctx, info);
        this.redInvoiceHandler(ctx, info);
        this.doRedBillRemork(ctx, info);
        this.checkBeforeSave(ctx, info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        this.extendsBlueRelationData(ctx, info);
        this.matchPwySettingInfo(ctx, info);
        this.matchSalerInfo(ctx, info);
        this.checkLength(ctx, (IObjectValue)info, new String[]{"salerName", "salerTaxNo", "salerAddress", "salerPhone"});
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        return pk;
    }

    private void checkStatusEqualsInDB(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, IMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        view.setSelector(sic);
        UsedCarMakeInvoiceCollection reqInfos = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceCollection(view);
        if (reqInfos.size() == 1 && reqInfos.get(0).getStatus() != null && !reqInfos.get(0).getStatus().equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + " : " + IMUtils.getIMResource(ctx, "BillStatusChange", new String[0])});
        }
    }

    @Override
    protected IObjectPK _saveWithoutBusiness(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = (UsedCarMakeInvoiceInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)"03DDCDAF"));
        }
        if (info.getSrcSystem() == null) {
            info.setSrcSystem(InvoiceSrcSystem.MANUAL);
        }
        this.doNumber(ctx, info);
        this.checkBeforeSave(ctx, info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        return pk;
    }

    protected void doNumber(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNewNumber(ctx, (IObjectValue)info, info.getCompany().getId().toString(), null);
            info.setNumber(number);
        }
        if (info.getNumber() != null) {
            info.setNumber(info.getNumber().trim());
        }
    }

    protected void redInvoiceHandler(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException, EASBizException {
        if (invoice.getPriceTaxTotal() != null && invoice.getPriceTaxTotal().compareTo(BigDecimal.ZERO) < 0) {
            String bosType;
            String redBillID;
            String blueBillID;
            invoice.setIsRedVoice(true);
            UsedCarMakeInvoiceInfo blueInvoice = null;
            if (InvoiceSrcSystem.REDINVOICE.equals((Object)invoice.getSrcSystem())) {
                blueInvoice = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoice.getRedBillId()));
            } else {
                String blueVoiceNum = invoice.getBlueVoiceNum();
                if (blueVoiceNum != null && !blueVoiceNum.isEmpty()) {
                    String blueVoiceCode = invoice.getBlueVoiceCode();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)blueVoiceNum, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)blueVoiceCode, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)false, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(this.getSelectors());
                    UsedCarMakeInvoiceCollection invoiceCol = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceCollection(view);
                    if (invoiceCol.size() > 0) {
                        blueInvoice = invoiceCol.get(0);
                    }
                }
            }
            if (blueInvoice != null && !this.hasBotpRelation(ctx, blueBillID = blueInvoice.getId().toString(), redBillID = invoice.getId().toString(), bosType = invoice.getBOSType().toString(), bosType)) {
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_IM_UsedCarMakeInvoice set fisredvoicedbill = 1 where fid = '");
                sql.append(blueBillID);
                sql.append("' ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                this.traceUpAndDown(ctx, blueBillID, redBillID, bosType, bosType);
            }
        } else {
            invoice.setIsRedVoice(false);
            invoice.setIsRedBlueSourceBill(false);
            invoice.setBlueVoiceCode(null);
            invoice.setBlueVoiceNum(null);
            invoice.setRedVoiceNumber(null);
        }
    }

    protected void doRedBillRemork(Context ctx, UsedCarMakeInvoiceInfo info) {
        if (info.isIsRedVoice() && info.getBlueVoiceCode() != null && info.getBlueVoiceNum() != null) {
            String str = IMUtils.getIMResource(ctx, "REDREMARK", info.getBlueVoiceCode(), info.getBlueVoiceNum());
            info.setRemark(str);
        }
    }

    protected void extendsBlueRelationData(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException, EASBizException {
        if (!invoice.isIsRedVoice()) {
            return;
        }
        if (!invoice.isIsRedBlueSourceBill()) {
            this.delBlueRelationData(ctx, invoice);
        } else {
            this.addBlueRelationData(ctx, invoice);
        }
    }

    protected void addBlueRelationData(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException, EASBizException {
        String billId = invoice.getId().toString();
        String selectSQL = "select * from t_im_makeinvoicerelation where finvoicebillid = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        try {
            if (rs.next()) {
                return;
            }
            this.doBillRelation(ctx, invoice);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void doBillRelation(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException, EASBizException {
        int i;
        String invoiceId = invoice.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoicebillid", (Object)invoice.getRedBillId(), CompareType.EQUALS));
        view.setFilter(filter);
        MakeInvoiceRelationCollection relationColl = MakeInvoiceRelationFactory.getLocalInstance(ctx).getMakeInvoiceRelationCollection(view);
        MakeInvoiceRelationInfo relationInfo = null;
        CoreBaseCollection relations = new CoreBaseCollection();
        MakeInvoiceRelationEntryInfo relationEntryInfo = null;
        Iterator it = relationColl.iterator();
        while (it.hasNext()) {
            relationInfo = (MakeInvoiceRelationInfo)it.next();
            relationInfo.setId(null);
            relationInfo.setInvoiceBillID(invoiceId);
            int size = relationInfo.getEntries().size();
            for (i = 0; i < size; ++i) {
                relationEntryInfo = relationInfo.getEntries().get(i);
                relationEntryInfo.setId(null);
                relationEntryInfo.setDestObjectID(invoiceId);
            }
            relations.add((CoreBaseInfo)relationInfo);
        }
        if (relations.size() > 0) {
            MakeInvoiceRelationFactory.getLocalInstance(ctx).addnewBatchData(relations);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)invoice.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)invoice.getRedBillId(), CompareType.EQUALS));
        view.setFilter(filter);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (collection != null && collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                BOTRelationInfo relation = collection.get(i);
                if (relation.getRelationEntries() != null) {
                    for (int j = 0; j < relation.getRelationEntries().size(); ++j) {
                        relation.getRelationEntries().get(j).setId(null);
                    }
                }
                relation.setId(null);
                relation.setDestObjectID(invoice.getId().toString());
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(relation);
            }
        }
    }

    protected void delBlueRelationData(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException {
        String billId = invoice.getId().toString();
        String selectSQL = "select FSrcBosType from t_im_makeinvoicerelation where finvoicebillid = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        try {
            if (rs.next()) {
                String srcBosType = rs.getString("FSrcBosType");
                String delRelationSql = "delete from t_im_makeinvoicerelation where finvoicebillid  = '" + billId + "'";
                DbUtil.execute((Context)ctx, (String)delRelationSql);
                String delRelationEntrySql = "delete from t_im_makeinvoicerelationEntry where FDestObjectID  = '" + billId + "'";
                DbUtil.execute((Context)ctx, (String)delRelationEntrySql);
                String delBotRelationSql = "delete from T_BOT_RELATION where FDESTOBJECTID = '" + billId + "' and FSRCENTITYID ='" + srcBosType + "'";
                DbUtil.execute((Context)ctx, (String)delBotRelationSql);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkBeforeSave(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        String[] fields = new String[]{"company", "number", "bizDate"};
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, fields, null);
        this.checkLength(ctx, (IObjectValue)info, null);
        if (InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus()) || InvoiceBillStatus.AUDITED.equals((Object)info.getStatus()) || InvoiceBillStatus.MAKED.equals((Object)info.getStatus()) || InvoiceBillStatus.DELETED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_SAVE_STATUS_ERROR", ctx.getLocale(), new Object[]{info.getStatus().getAlias(ctx.getLocale())})});
        }
        super._checkNumberDup(ctx, null, (IObjectValue)info);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = (UsedCarMakeInvoiceInfo)model;
        if (model == null) {
            info = this.getUsedCarMakeInvoiceInfo(ctx, pk, this.getSelectors());
        }
        this.submit(ctx, (CoreBaseInfo)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = (UsedCarMakeInvoiceInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)"03DDCDAF"));
        }
        this.doNumber(ctx, info);
        this.clearTrimInfo(ctx, info);
        this.checkBeforeSubmit(ctx, info);
        this.redInvoiceHandler(ctx, info);
        this.doRedBillRemork(ctx, info);
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        }
        info.setStatus(InvoiceBillStatus.SUBMITED);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.extendsBlueRelationData(ctx, info);
        this.matchPwySettingInfo(ctx, info);
        this.matchSalerInfo(ctx, info);
        this.checkSalerInfo(ctx, info);
        this.checkBySalerEnterpriseType(ctx, info);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        return pk;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            return super.submit(ctx, model);
        }
        catch (MissMatchParticipantException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"HAVENO_MULTIAPPROVE_ASSIGNMENT", (Locale)ctx.getLocale())});
        }
        catch (MatchAssignmentException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_WFMatch", (Locale)ctx.getLocale())});
        }
        catch (AlreadyInProcessQueueException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)ctx.getLocale())});
        }
    }

    protected void checkSalerInfo(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        String[] emptyFields = new String[]{"salerName", "salerTaxNo"};
        String salerNameAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.UsedCarInvoiceResource", (String)"SALERNAME", (Locale)ctx.getLocale());
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        fieldAlias.put("salerName", salerNameAlias);
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, fieldAlias);
        this.checkLength(ctx, (IObjectValue)info, new String[]{"salerName", "salerTaxNo", "salerAddress", "salerPhone"});
    }

    protected void checkBySalerEnterpriseType(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        if (SalerEnterpriseType.BusinessUnit == info.getSalerEnterpriseType()) {
            String[] businessEmptyFields = new String[]{"businessUnitName", "businessUnitTaxNo", "businessUnitAddress", "businessUnitPhone", "businessUnitBankAccount"};
            IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, businessEmptyFields, null, "BUSINESSUNITERROR");
            this.checkLength(ctx, (IObjectValue)info, businessEmptyFields);
        } else if (SalerEnterpriseType.SecondHandCarMarket == info.getSalerEnterpriseType()) {
            String[] emptyFields = new String[]{"usedCarMarketName", "usedCarMarketTaxNo", "usedCarMarketAddress", "usedCarMarketPhone", "usedCarMarketBankAccount"};
            IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, null);
            this.checkLength(ctx, (IObjectValue)info, emptyFields);
        }
    }

    protected void matchSalerInfo(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        String taxNo;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), sic);
        if (info.getSalerName() == null) {
            info.setSalerName(company.getRegisteredCode());
        }
        if (!StringUtils.isEmpty((String)(taxNo = company.getTaxNumber()))) {
            taxNo = taxNo.trim();
        }
        if (StringUtils.isEmpty((String)info.getSalerTaxNo())) {
            info.setSalerTaxNo(taxNo);
        }
        if (StringUtils.isEmpty((String)info.getSalerAddress())) {
            info.setSalerAddress(company.getTaxAddress());
        }
        if (StringUtils.isEmpty((String)info.getSalerPhone())) {
            info.setSalerPhone(company.getContactPhone());
        }
        if (SalerEnterpriseType.BusinessUnit == info.getSalerEnterpriseType()) {
            if (StringUtils.isEmpty((String)info.getBusinessUnitName())) {
                info.setBusinessUnitName(company.getRegisteredCode());
            }
            if (StringUtils.isEmpty((String)info.getBusinessUnitTaxNo())) {
                info.setBusinessUnitTaxNo(taxNo);
            }
            if (StringUtils.isEmpty((String)info.getBusinessUnitAddress())) {
                info.setBusinessUnitAddress(company.getTaxAddress());
            }
            if (StringUtils.isEmpty((String)info.getBusinessUnitPhone())) {
                info.setBusinessUnitPhone(company.getContactPhone());
            }
            if (StringUtils.isEmpty((String)info.getBusinessUnitBankAccount())) {
                String bankName = null;
                if (company.getBank() != null) {
                    bankName = company.getBank().getName();
                }
                info.setBusinessUnitBankAccount(this.getStringValue(bankName) + this.getStringValue(company.getBankAccount()));
            }
            info.setUsedCarMarketName(null);
            info.setUsedCarMarketTaxNo(null);
            info.setUsedCarMarketAddress(null);
            info.setUsedCarMarketPhone(null);
            info.setUsedCarMarketBankAccount(null);
        } else if (SalerEnterpriseType.SecondHandCarMarket == info.getSalerEnterpriseType()) {
            if (StringUtils.isEmpty((String)info.getUsedCarMarketName())) {
                info.setUsedCarMarketName(company.getRegisteredCode());
            }
            if (StringUtils.isEmpty((String)info.getUsedCarMarketTaxNo())) {
                info.setUsedCarMarketTaxNo(taxNo);
            }
            if (StringUtils.isEmpty((String)info.getUsedCarMarketAddress())) {
                info.setUsedCarMarketAddress(company.getTaxAddress());
            }
            if (StringUtils.isEmpty((String)info.getUsedCarMarketPhone())) {
                info.setUsedCarMarketPhone(company.getContactPhone());
            }
            if (StringUtils.isEmpty((String)info.getUsedCarMarketBankAccount())) {
                String bankName = null;
                if (company.getBank() != null) {
                    bankName = company.getBank().getName();
                }
                info.setUsedCarMarketBankAccount(this.getStringValue(bankName) + this.getStringValue(company.getBankAccount()));
            }
            info.setBusinessUnitName(null);
            info.setBusinessUnitTaxNo(null);
            info.setBusinessUnitAddress(null);
            info.setBusinessUnitPhone(null);
            info.setBusinessUnitBankAccount(null);
        }
    }

    protected void matchPwySettingInfo(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        OPTypeEnum opType = OPTypeEnum.MakeInvoice;
        String invoiceId = info.getId().toString();
        PwySettingInfo settingInfo = PwySettingFactory.getLocalInstance(ctx).getCollectionByCompany(companyId, opType, invoiceId, null);
        if (settingInfo != null) {
            String[] addressPhone;
            if (StringUtils.isEmpty((String)info.getDrawertxt())) {
                info.setDrawertxt(settingInfo.getDrawertxt());
            }
            if (!StringUtils.isEmpty((String)settingInfo.getAddressPhone()) && (addressPhone = settingInfo.getAddressPhone().split("\\s+")).length > 1 && StringUtils.isEmpty((String)info.getSalerAddress()) && StringUtils.isEmpty((String)info.getSalerPhone())) {
                info.setSalerAddress(addressPhone[0]);
                info.setSalerPhone(addressPhone[1]);
            }
            if (SalerEnterpriseType.BusinessUnit == info.getSalerEnterpriseType() && !StringUtils.isEmpty((String)settingInfo.getAddressPhone())) {
                addressPhone = settingInfo.getAddressPhone().split("\\s+");
                if (addressPhone.length > 1 && StringUtils.isEmpty((String)info.getBusinessUnitAddress()) && StringUtils.isEmpty((String)info.getBusinessUnitPhone())) {
                    info.setBusinessUnitAddress(addressPhone[0]);
                    info.setBusinessUnitPhone(addressPhone[1]);
                }
                if (StringUtils.isEmpty((String)info.getBusinessUnitBankAccount())) {
                    info.setBusinessUnitBankAccount(settingInfo.getBankAccount());
                }
            } else if (SalerEnterpriseType.SecondHandCarMarket == info.getSalerEnterpriseType() && !StringUtils.isEmpty((String)settingInfo.getAddressPhone())) {
                addressPhone = settingInfo.getAddressPhone().split("\\s+");
                if (addressPhone.length > 1 && StringUtils.isEmpty((String)info.getUsedCarMarketAddress()) && StringUtils.isEmpty((String)info.getUsedCarMarketPhone())) {
                    info.setUsedCarMarketAddress(addressPhone[0]);
                    info.setUsedCarMarketPhone(addressPhone[1]);
                }
                if (StringUtils.isEmpty((String)info.getUsedCarMarketBankAccount())) {
                    info.setUsedCarMarketBankAccount(settingInfo.getBankAccount());
                }
            }
        }
    }

    protected void checkBeforeSubmit(Context ctx, UsedCarMakeInvoiceInfo info) throws EASBizException, BOSException {
        if (!InvoiceBillStatus.TEMPSTROE.equals((Object)info.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_SUBMIT_STATUS_ERROR", ctx.getLocale())});
        }
        super._checkNumberDup(ctx, null, (IObjectValue)info);
        String buyerNameAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.UsedCarInvoiceResource", (String)"BUYERNAME", (Locale)ctx.getLocale());
        String buyerCardNoAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.UsedCarInvoiceResource", (String)"BUYERCARDNO", (Locale)ctx.getLocale());
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        fieldAlias.put("buyerName", buyerNameAlias);
        fieldAlias.put("buyerCardNo", buyerCardNoAlias);
        if (SalerEnterpriseType.BusinessUnit == info.getSalerEnterpriseType()) {
            String[] emptyFields = new String[]{"company", "number", "bizDate", "status", "invoiceType", "currentAccountType", "srcSystem", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "salerEnterpriseType", "licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "priceTaxTotal", "taxClassificationCode"};
            IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, fieldAlias);
        } else if (SalerEnterpriseType.SecondHandCarMarket == info.getSalerEnterpriseType()) {
            String[] emptyFields = new String[]{"company", "number", "bizDate", "status", "invoiceType", "currentAccountType", "srcSystem", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "salerEnterpriseType", "licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "priceTaxTotal", "taxClassificationCode"};
            IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, fieldAlias);
        }
        this.checkLength(ctx, (IObjectValue)info, null);
    }

    protected void checkLength(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] lengthFields = new String[]{"number", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "blueVoiceCode", "blueVoiceNum", "salerName", "salerTaxNo", "salerAddress", "salerPhone", "invoiceNumber", "invoiceNo", "licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "businessUnitName", "businessUnitTaxNo", "businessUnitAddress", "businessUnitAddress", "businessUnitBankAccount", "usedCarMarketName", "usedCarMarketTaxNo", "usedCarMarketAddress", "usedCarMarketAddress", "usedCarMarketBankAccount", "remark", "drawertxt"};
        String[] checkFields = fields == null ? lengthFields : fields;
        IMServerUtil.checkLengthFields(ctx, info, checkFields);
    }

    protected void clearTrimInfo(Context ctx, UsedCarMakeInvoiceInfo info) {
        String[] fields = new String[]{"number", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "blueVoiceCode", "blueVoiceNum", "salerName", "salerTaxNo", "salerAddress", "salerPhone", "invoiceNumber", "invoiceNo", "licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "businessUnitName", "businessUnitTaxNo", "businessUnitAddress", "businessUnitAddress", "businessUnitBankAccount", "usedCarMarketName", "usedCarMarketTaxNo", "usedCarMarketAddress", "usedCarMarketAddress", "usedCarMarketBankAccount", "remark", "drawertxt"};
        IMServerUtil.clearTrimInfo((IObjectValue)info, fields);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = this.getUsedCarMakeInvoiceInfo(ctx, pk, this.getSelectors());
        this.checkBeforeDelete(ctx, info);
        this.beforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    protected void checkBeforeDelete(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, EASBizException {
        boolean isModify = false;
        if (InvoiceSrcSystem.EXCEL.equals((Object)info.getSrcSystem()) || InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)info.getSrcSystem())) {
            if (!info.getCreateTime().equals(info.getLastUpdateTime())) {
                isModify = true;
            }
            if (!InvoiceBillStatus.TEMPSTROE.equals((Object)info.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus()) && isModify) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
            }
        } else if (!(InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)info.getSrcSystem()) || InvoiceBillStatus.TEMPSTROE.equals((Object)info.getStatus()) || InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus()))) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
        }
    }

    protected void beforeDelete(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException {
        try {
            String billId = invoice.getId().toString();
            String selectSQL = "select FSrcEntryID FROM t_im_makeinvoicerelationentry where FDestObjectID in" + IMUtils.getInStringFromArray(new String[]{billId});
            HashSet<String> idSet = new HashSet<String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            while (rs.next()) {
                String bizBillID = rs.getString("FSrcEntryID");
                idSet.add(bizBillID);
            }
            if (invoice.isIsRedVoice()) {
                String selectSQL2 = "select fsrcobjectid from T_BOT_Relation where fdestobjectid in" + IMUtils.getInStringFromArray(new String[]{billId});
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)selectSQL2);
                while (rs2.next()) {
                    idSet.add(rs2.getString("fsrcobjectid"));
                }
            }
            if (idSet != null && idSet.size() > 0) {
                String upSQL;
                Iterator iterator = idSet.iterator();
                ArrayList<Object[]> miIds = new ArrayList<Object[]>();
                ArrayList<Object[]> mqIds = new ArrayList<Object[]>();
                while (iterator.hasNext()) {
                    String srcBillID = (String)iterator.next();
                    if (StringUtils.isEmpty((String)srcBillID)) continue;
                    String srcBillBosType = BOSUuid.read((String)srcBillID).getType().toString();
                    if ("03DDCDAF".equals(srcBillBosType)) {
                        miIds.add(new Object[]{srcBillID});
                    }
                    if (!"60F3A997".equals(srcBillBosType)) continue;
                    mqIds.add(new Object[]{srcBillID});
                }
                if (!miIds.isEmpty()) {
                    upSQL = "update T_IM_UsedCarMakeInvoice set fisredvoicedbill = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, miIds);
                }
                if (!mqIds.isEmpty()) {
                    upSQL = "update T_IM_UsedCarInvoiceReqEntry set FIsMakeInoviced = 0 where fid = ? ";
                    DbUtil.executeBatch((Context)ctx, (String)upSQL, mqIds);
                }
            }
            String deleSQL = "delete from t_bot_relation where fdestentityid = ? and fdestobjectid = ?";
            DbUtil.execute((Context)ctx, (String)deleSQL, (Object[])new Object[]{"03DDCDAF", billId});
            String deleteRelaSQL = "delete from T_IM_MakeInvoiceRelation where FInvoiceBillID in" + IMUtils.getInStringFromArray(new String[]{billId});
            DbUtil.execute((Context)ctx, (String)deleteRelaSQL);
            String deleteRelaEntrySQL = "delete from T_IM_MakeInvoiceRelationEntry where FDestObjectID in" + IMUtils.getInStringFromArray(new String[]{billId});
            DbUtil.execute((Context)ctx, (String)deleteRelaEntrySQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = this.getUsedCarMakeInvoiceInfo(ctx, pk, this.getSelectors());
        this.checkBeforeAudit(ctx, info);
        info.setStatus(InvoiceBillStatus.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void checkBeforeAudit(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, EASBizException {
        if (!InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_AUDIT_STATUS_ERROR", ctx.getLocale())});
        }
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<String> fields = new ArrayList<String>();
        if (info.isIsRedVoice()) {
            fields.add("blueVoiceCode");
            fields.add("blueVoiceNum");
        }
        if (fields.size() > 0) {
            String[] fieldArr = new String[fields.size()];
            fields.toArray(fieldArr);
            IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, fieldArr, null);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = this.getUsedCarMakeInvoiceInfo(ctx, pk, this.getSelectors());
        this.checkBeforeUnAudit(ctx, info);
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setStatus(InvoiceBillStatus.TEMPSTROE);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void checkBeforeUnAudit(Context ctx, UsedCarMakeInvoiceInfo info) throws BOSException, EASBizException {
        if (!InvoiceBillStatus.AUDITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_UNAUDIT_STATUS_ERROR", ctx.getLocale())});
        }
        if (info.isFiVouchered()) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "HasVoucher_NotUnAudit", ctx.getLocale())});
        }
    }

    @Override
    protected IObjectValue _red(Context ctx, String invoiceId) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo invoice = this.getUsedCarMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(invoiceId), this.getSelectors());
        this.checkBeforeRed(ctx, invoice);
        invoice.setPriceTaxTotal(invoice.getPriceTaxTotal().negate());
        invoice.setRedBillId(invoiceId);
        invoice.setId(BOSUuid.create((String)"03DDCDAF"));
        invoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        invoice.setBizDate(Calendar.getInstance().getTime());
        invoice.setBlueVoiceCode(invoice.getInvoiceNumber());
        invoice.setBlueVoiceNum(invoice.getInvoiceNo());
        invoice.setInvoiceNo(null);
        invoice.setInvoiceNumber(null);
        invoice.setInvoiceDate(null);
        invoice.setSrcSystem(InvoiceSrcSystem.REDINVOICE);
        invoice.setSourceBillType(UsedCarMakeInvoiceBillTypeEnum.UsedCarMakeInvoice);
        invoice.setSourceBillNumber(invoice.getNumber());
        invoice.setSourceBillId(null);
        invoice.setSourceBillEntryId(null);
        invoice.setIsPrint(false);
        invoice.setIsDelete(false);
        invoice.setDeleteUser(null);
        invoice.setDeleteDate(null);
        invoice.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp time = new Timestamp(new Date().getTime());
        invoice.setCreateTime(time);
        invoice.setAuditTime(null);
        invoice.setAuditor(null);
        invoice.setLastUpdateTime(null);
        invoice.setLastUpdateUser(null);
        invoice.setFiVouchered(false);
        invoice.setVoucher(null);
        invoice.setVoucherType(null);
        invoice.setIsRedVoice(true);
        invoice.setIsRedVoicedBill(false);
        invoice.setIsRedBlueSourceBill(true);
        invoice.setDrawertxt(null);
        invoice.setPayeetxt(null);
        invoice.setChecktxt(null);
        invoice.setSnapShotUrl(null);
        invoice.setInvoiceUrl(null);
        invoice.setPlateNo(null);
        invoice.setExtensionNo(null);
        invoice.setMachineNo(null);
        invoice.setCheckCode(null);
        String redNumber = "red_" + invoice.getNumber();
        String strCompanyID = invoice.getCompany() != null && invoice.getCompany().getId() != null ? invoice.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)invoice, strCompanyID);
        if (ruleInfo != null) {
            redNumber = this.getNewNumber(ctx, (IObjectValue)invoice, strCompanyID, null);
        }
        invoice.setNumber(redNumber);
        return invoice;
    }

    @Override
    protected void _checkBeforeRed(Context ctx, String invoiceId) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo invoice = this.getUsedCarMakeInvoiceInfo(ctx, (IObjectPK)new ObjectUuidPK(invoiceId), this.getSelectors());
        this.checkBeforeRed(ctx, invoice);
    }

    protected void checkBeforeRed(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException, EASBizException {
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), "im_usedCarMakeInvoice_red");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        StringBuffer errorMsg = new StringBuffer();
        if (!InvoiceBillStatus.MAKED.equals((Object)invoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "MAKEDRED", new String[0])).append(";\r\n");
        }
        if (invoice.isIsRedVoicedBill()) {
            errorMsg.append(IMUtils.getIMResource(ctx, "REDED", new String[0])).append(";\r\n");
        }
        if (invoice.isIsRedVoice()) {
            errorMsg.append(IMUtils.getIMResource(ctx, "REDINVOICE_RED", new String[0])).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    @Override
    protected void _checkBeforeCopy(Context ctx, String invoiceId) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        if (InvoiceSrcSystem.SYSTEM.equals((Object)info.getSrcSystem()) || InvoiceSrcSystem.REDINVOICE.equals((Object)info.getSrcSystem()) || InvoiceSrcSystem.DOWNLOAD.equals((Object)info.getSrcSystem())) {
            throw new UsedCarMakeInvoiceException(UsedCarMakeInvoiceException.CANT_COPY_BILL, new Object[]{info.getSrcSystem().getAlias()});
        }
        CompanyOrgUnitInfo orgInfo = info.getCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()), this.getPermissionItem(null));
    }

    @Override
    protected void _afterMakeInvoice(Context ctx, String invoiceId, Map params) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        String invoiceNum = (String)params.get("invoiceNum");
        String invoiceNo = (String)params.get("invoiceNo");
        String card_no = (String)params.get("card_no");
        String subid = (String)params.get("subid");
        info.setInvoiceNumber(invoiceNum);
        info.setInvoiceNo(invoiceNo);
        info.setStatus(InvoiceBillStatus.MAKED);
        info.setInvoiceDate(new Date());
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (StringUtils.isEmpty((String)info.getDrawertxt())) {
            info.setDrawertxt(user.getName());
        }
        info.setPlateNo(card_no);
        info.setExtensionNo(subid);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose("make", (IObjectValue)info);
    }

    @Override
    protected void _afterPrintInvoice(Context ctx, String invoiceId, Map params) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        info.setIsPrint(true);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    @Override
    protected void _afterCancelInvoice(Context ctx, String invoiceId, Map params) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        info.setIsDelete(true);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setDeleteUser(user);
        info.setDeleteDate(new Date());
        info.setStatus(InvoiceBillStatus.DELETED);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        this.redInvoiceCancel(ctx, info);
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose("cancel", (IObjectValue)info);
    }

    protected void redInvoiceCancel(Context ctx, UsedCarMakeInvoiceInfo invoice) throws BOSException {
        if (!invoice.isIsRedVoice()) {
            return;
        }
        String blueBillId = invoice.getRedBillId();
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_UsedCarMakeInvoice set FIsRedVoicedBill = 0 where fid = '" + blueBillId + "'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _redInvoice(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo invoice = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billId));
        Map map = this._checkBeforeRedInvoice(ctx, billId, params);
        UsedCarMakeInvoiceInfo blueInvoice = (UsedCarMakeInvoiceInfo)map.get("blueInvoice");
        if (blueInvoice != null) {
            for (String field : new String[]{"company", "currentAccountType", "currAcctCustomer", "currAcctSupplier", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "productCode", "licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "priceTaxTotal", "taxClassificationCode"}) {
                invoice.put(field, blueInvoice.get(field));
            }
            invoice.setPriceTaxTotal(invoice.getPriceTaxTotal().negate());
            invoice.setRedBillId(blueInvoice.getId().toString());
            invoice.setSourceBillType(UsedCarMakeInvoiceBillTypeEnum.UsedCarMakeInvoice);
            invoice.setSourceBillNumber(blueInvoice.getNumber());
        }
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        if (!StringUtils.isEmpty((String)invoiceCode)) {
            invoice.setBlueVoiceCode(invoiceCode);
        }
        if (!StringUtils.isEmpty((String)invoiceNumber)) {
            invoice.setBlueVoiceNum(invoiceNumber);
        }
        this.redInvoiceHandler(ctx, invoice);
        this.doRedBillRemork(ctx, invoice);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(invoice.getId().toString()), (IObjectValue)invoice);
    }

    @Override
    protected Map _checkBeforeRedInvoice(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo invoice = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billId));
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), "im_usedCarMakeInvoice_redInvoice");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        UsedCarMakeInvoiceInfo blueInvoice = this.getBlueInvoice(ctx, invoiceCode, invoiceNumber);
        if (blueInvoice != null) {
            StringBuffer errorMsg = new StringBuffer();
            if (!InvoiceBillStatus.MAKED.equals((Object)blueInvoice.getStatus())) {
                errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_BLUE_INV_STATUS_ERROR", ctx.getLocale())).append(";\r\n");
            }
            if (blueInvoice.isIsRedVoicedBill()) {
                errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_BLUDINV_HASRED", ctx.getLocale())).append(";\r\n");
            }
            if (blueInvoice.isIsRedVoice()) {
                errorMsg.append(IMUtils.getIMResource(ctx, "REDINVOICE_RED", new String[0])).append(";\r\n");
            }
            if (errorMsg.length() > 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
            }
        }
        HashMap<String, UsedCarMakeInvoiceInfo> retValue = new HashMap<String, UsedCarMakeInvoiceInfo>();
        retValue.put("blueInvoice", blueInvoice);
        return retValue;
    }

    protected UsedCarMakeInvoiceInfo getBlueInvoice(Context ctx, String invoiceCode, String invoiceNumber) throws BOSException {
        UsedCarMakeInvoiceInfo blueInvoice = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceCode, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        UsedCarMakeInvoiceCollection invoiceCol = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceCollection(view);
        if (invoiceCol.size() > 0) {
            blueInvoice = invoiceCol.get(0);
        }
        return blueInvoice;
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, String mainOrgUnitId, Map otherInformation) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = new UsedCarMakeInvoiceInfo();
        info.setCompany((CompanyOrgUnitInfo)OrgUtils.getDefaultMainBizOrg(ctx, mainOrgUnitId, OrgType.Company, null));
        Timestamp serverDate = IMUtils.getCurrentTime();
        info.setBizDate(serverDate);
        info.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        info.setStatus(InvoiceBillStatus.TEMPSTROE);
        info.setInvoiceType(InvoiceTypeEnum.USEDCARINVOICE);
        info.setSalerEnterpriseType(SalerEnterpriseType.BusinessUnit);
        info.setIsDelete(false);
        info.setIsRedVoice(false);
        info.setIsRedVoicedBill(false);
        info.setIsPrint(false);
        info.setFiVouchered(false);
        info.setSrcSystem(InvoiceSrcSystem.MANUAL);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCreateTime(serverDate);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        IMCodeRuleHelper codeHelper = new IMCodeRuleHelper();
        codeHelper.genNewBillNumber(ctx, (IObjectValue)info, (OrgUnitInfo)info.getCompany(), UsedCarMakeInvoiceFactory.getLocalInstance(ctx));
        String mainOrgId = info.getCompany().getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)info, mainOrgId);
        info.put("ruleStatus", ruleStatus);
        return info;
    }

    @Override
    protected Map _getInitData(Context ctx, String companyid, String status, Map otherInformation) throws BOSException, EASBizException {
        HashMap<String, String> cache = super._getInitData(ctx, companyid, status, otherInformation);
        if (cache == null) {
            cache = new HashMap<String, String>();
        }
        UsedCarMakeInvoiceInfo billInfo = (UsedCarMakeInvoiceInfo)otherInformation.get("objectValue");
        String companyId = billInfo.getCompany().getId().toString();
        String customerId = billInfo.getCurrAcctCustomer() != null ? billInfo.getCurrAcctCustomer().getId().toString() : null;
        UsedCarMakeInvoiceFilterFactory filterFactory = UsedCarMakeInvoiceFilterFactory.getInstance();
        cache.put("companyFilter", filterFactory.getCompanyFilter(this.getPermissionItem(status)).toString());
        cache.put("customerFilter", filterFactory.getCustomerFilter(companyId).toString());
        cache.put("supplierFilter", filterFactory.getSupplierFilter(companyId).toString());
        cache.put("buyerNameFilter", filterFactory.getBuyerNameFilter(companyId, customerId).toString());
        cache.put("productCodeFilter", filterFactory.getProductCodeFilter(companyId, customerId).toString());
        cache.put("taxClassificationCodeFilter", filterFactory.getTaxClassificationCodeFilter().toString());
        return cache;
    }

    private String getStringValue(String value) {
        return IMUtils.isEmpty(value) ? "" : value;
    }

    @Override
    protected String getEntityTblName() {
        return "T_IM_UsedCarMakeInvoice";
    }

    @Override
    protected String getVoucherLogItem() {
        return null;
    }

    public SelectorItemCollection getSelectors() {
        return IMSelectorFactory.getUsedCarMakeInvoiceSelectors();
    }

    protected String getPermissionItem(String status) {
        return "im_usedCarMakeInvoice_new";
    }

    @Override
    protected void _checkBeforeEdit(Context ctx, String invoiceId) throws BOSException, EASBizException {
        UsedCarMakeInvoiceInfo info = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        if (info.getStatus() != null && !InvoiceBillStatus.TEMPSTROE.equals((Object)info.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"CANNOTEDIT", (Locale)ctx.getLocale())});
        }
    }
}

