/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IVehicleMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceCollection;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceFactory;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.AbstractVehicleMakeInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VehicleMakeInvoiceFacadeControllerBean
extends AbstractVehicleMakeInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.VehicleMakeInvoiceFacadeControllerBean");

    @Override
    protected ArrayList _buildMakePwyParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            String mkBillID = ids.get(i).toString();
            VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkBillID), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
            PwyServiceType serviceType = invoice.isIsRedVoice() ? PwyServiceType.OPR_INV_VEHICLE_RED_MAKE : PwyServiceType.OPR_INV_VEHICLE_MAKE;
            IObjectPK logPK = null;
            String billID = invoice.getId().toString();
            try {
                String logItemName = "im_vehicleinvoice_make";
                String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
                String logDetail = invoice.getNumber();
                logPK = LogUtils.beginLog(ctx, actionName, invoice.getBOSType(), (IObjectPK)new ObjectUuidPK(billID), logDetail, logItemName, invoice.getCompany().getId().toString());
                VehicleMakeInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforeMake(invoice.getId().toString());
            }
            catch (EASBizException e) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("error", "exception");
                resultMap.put("exception", invoice.getNumber() + ":" + e.getMessage());
                resultMap.put("billId", invoice.getId().toString());
                resultMap.put("number", invoice.getNumber());
                retList.add(resultMap);
                continue;
            }
            PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            invokeParam.setLogPK(logPK.toString());
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    @Override
    protected ArrayList _buildCancelPwyParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            String mkBillID = ids.get(i).toString();
            VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkBillID), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
            IObjectPK logPK = null;
            String billID = invoice.getId().toString();
            try {
                String logItemName = "im_vehicleinvoice_cancel";
                String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
                String logDetail = invoice.getNumber();
                logPK = LogUtils.beginLog(ctx, actionName, invoice.getBOSType(), (IObjectPK)new ObjectUuidPK(billID), logDetail, logItemName, invoice.getCompany().getId().toString());
                VehicleMakeInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforeCancel(invoice.getId().toString());
            }
            catch (EASBizException e) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("error", "exception");
                resultMap.put("exception", invoice.getNumber() + ":" + e.getMessage());
                resultMap.put("billId", invoice.getId().toString());
                resultMap.put("number", invoice.getNumber());
                retList.add(resultMap);
                continue;
            }
            PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_VEHICLE_CANCEL, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            invokeParam.setLogPK(logPK.toString());
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    @Override
    protected ArrayList _buildPrintPwyParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem, boolean isRePrint) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            String mkBillID = ids.get(i).toString();
            VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkBillID), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
            IObjectPK logPK = null;
            String billID = invoice.getId().toString();
            try {
                String logItemName = isRePrint ? "im_vehicleinvoice_reprint" : "im_vehicleinvoice_printinvoice";
                String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
                String logDetail = invoice.getNumber();
                logPK = LogUtils.beginLog(ctx, actionName, invoice.getBOSType(), (IObjectPK)new ObjectUuidPK(billID), logDetail, logItemName, invoice.getCompany().getId().toString());
                VehicleMakeInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrint(invoice.getId().toString(), isRePrint);
            }
            catch (EASBizException e) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("error", "exception");
                resultMap.put("exception", invoice.getNumber() + ":" + e.getMessage());
                resultMap.put("billId", invoice.getId().toString());
                resultMap.put("number", invoice.getNumber());
                retList.add(resultMap);
                continue;
            }
            PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_VEHICLE_PRINT, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            invokeParam.setLogPK(logPK.toString());
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    @Override
    protected void _checkBeforeMake(Context ctx, String invoiceId) throws BOSException, EASBizException {
        VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), "im_vehicleinvoice_make");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        StringBuffer errorMsg = new StringBuffer();
        if (!InvoiceBillStatus.AUDITED.equals((Object)invoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "AUDITEDMAKE", new String[0]));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    @Override
    protected void _checkBeforePrint(Context ctx, String invoiceId, boolean isRePrint) throws BOSException, EASBizException {
        String permItemName = isRePrint ? "im_vehicleinvoice_reprint" : "im_vehicleinvoice_printinvoice";
        VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), permItemName);
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected Map _checkBeforePrint(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList orderIds = new ArrayList();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (idSet.size() > 0) {
            ArrayList<String> billIds = new ArrayList<String>();
            for (String billid : idSet) {
                billIds.add(billid);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            VehicleMakeInvoiceInfo info = null;
            HashSet<String> companyids = new HashSet<String>();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
            ev.setFilter(filter);
            ev.setSelector(sic);
            VehicleMakeInvoiceCollection coll = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceCollection(ev);
            if (coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    info = coll.get(i);
                    companyids.add(info.getCompany().getId().toString());
                }
            }
            IMFacadeFactory.getLocalInstance(ctx).checkBatchPermission(new ArrayList(companyids), "im_vehicleinvoice_printinvoice");
            if (!this.isAllPrint(ctx, idSet, true)) {
                errorMsg = errorMsg + IMUtils.getIMResource(ctx, "INVOICE_ISNOT_ALLPRINT", new String[0]);
            }
            if (!"".equals(errorMsg = errorMsg + this.isSeqPrint(ctx, idSet, false, false, orderIds))) {
                retMap.put("errorMsg", errorMsg);
            } else {
                String successMsg = this.getSuccessMessage(ctx, idSet);
                retMap.put("successMsg", successMsg);
                retMap.put("orderIds", orderIds);
            }
        }
        return retMap;
    }

    private boolean isAllPrint(Context ctx, Set idSet, boolean isPrint) throws BOSException {
        IVehicleMakeInvoice iMkInvoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isPrint", (Object)isPrint, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        VehicleMakeInvoiceCollection mkInvoiceCol = iMkInvoice.getVehicleMakeInvoiceCollection(view);
        return mkInvoiceCol.size() == 0;
    }

    private String isSeqPrint(Context ctx, Set idSet, boolean isPrintList, boolean isRePrint, ArrayList orderIds) throws BOSException {
        IVehicleMakeInvoice iMkInvoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        VehicleMakeInvoiceCollection mkInvoiceCol = iMkInvoice.getVehicleMakeInvoiceCollection(view);
        int size = mkInvoiceCol.size();
        VehicleMakeInvoiceInfo invoice0 = mkInvoiceCol.get(0);
        if (size == 0 || invoice0 == null || invoice0.getInvoiceNumber() == null) {
            return IMUtils.getIMResource(ctx, "INVOICENUMBER_HAVENULLVALUE", new String[0]);
        }
        if (!isPrintList) {
            String invoiceNumber0 = invoice0.getInvoiceNumber();
            for (int idx = 1; idx < size; ++idx) {
                if (invoiceNumber0.equals(mkInvoiceCol.get(idx).getInvoiceNumber())) continue;
                return IMUtils.getIMResource(ctx, "NOT_SUPPORT_MULTINUMBERPRINT", new String[0]);
            }
        }
        for (int i = 0; i < mkInvoiceCol.size(); ++i) {
            orderIds.add(mkInvoiceCol.get(i).getId().toString());
        }
        if (!isPrintList) {
            String invoiceNoStart = invoice0.getInvoiceNo();
            String invoiceNoEnd = mkInvoiceCol.get(size - 1).getInvoiceNo();
            if (invoiceNoStart == null || invoiceNoEnd == null) {
                return IMUtils.getIMResource(ctx, "INVOICENO_HAVENULLVALUE", new String[0]);
            }
            long noStart = Long.parseLong(invoiceNoStart);
            long noEnd = Long.parseLong(invoiceNoEnd);
            long noDiff = noEnd - noStart;
            if (noDiff != (long)(size - 1)) {
                String retValue = IMUtils.getIMResource(ctx, "INVOICE_ISNOT_SEQPRINT", new String[0]);
                if (isRePrint) {
                    retValue = IMUtils.getIMResource(ctx, "INVOICE_ISNOTSEQ_CANNOTREPRINT", new String[0]);
                }
                return retValue;
            }
        }
        return "";
    }

    private String getSuccessMessage(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("invoiceType"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        VehicleMakeInvoiceCollection mkInvoiceCol = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceCollection(view);
        VehicleMakeInvoiceInfo invoice0 = mkInvoiceCol.get(0);
        String successMsg = "";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICETYPE", new String[0]) + "\uff1a" + (Object)((Object)invoice0.getInvoiceType()) + "\n";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICENUMBER", new String[0]) + "\uff1a" + invoice0.getInvoiceNumber() + "\n";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICENO", new String[0]) + "\uff1a" + invoice0.getInvoiceNo();
        return successMsg;
    }

    @Override
    protected Map _checkBeforeRePrint(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList orderIds = new ArrayList();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (idSet.size() > 0) {
            if (!this.isAllPrint(ctx, idSet, false)) {
                errorMsg = errorMsg + IMUtils.getIMResource(ctx, "HAVE_INVOICE_NOTPRINT", new String[0]);
            }
            if (!"".equals(errorMsg = errorMsg + this.isSeqPrint(ctx, idSet, false, true, orderIds))) {
                retMap.put("errorMsg", errorMsg);
            } else {
                String successMsg = this.getSuccessMessage(ctx, idSet);
                retMap.put("successMsg", successMsg);
                retMap.put("orderIds", orderIds);
            }
        }
        return retMap;
    }

    @Override
    protected void _checkBeforeCancel(Context ctx, String invoiceId) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        VehicleMakeInvoiceInfo invoice = VehicleMakeInvoiceFactory.getLocalInstance(ctx).getVehicleMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceId), IMSelectorFactory.getVehicleMakeInvoiceSelectors());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), "im_vehicleinvoice_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.MAKED.equals((Object)invoice.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "MAKEDCANCEL", new String[0])).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }
}

