/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.incomeinvoice.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.app.incomeinvoice.action.IAction;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.ActionResult;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;

public abstract class BaseAction
implements IAction {
    protected IObjectPK logPK = null;
    protected Context ctx = null;

    public BaseAction(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public ActionResult execute(IncomeInvoiceActionTypeEnum actionType, ActionParam params) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public ActionResult executeBatch(IncomeInvoiceActionTypeEnum actionType, ActionParam params) throws EASBizException, BOSException {
        return null;
    }

    protected void beginLog(IRowSet rs, String logItemName) throws SQLException {
        String FId = rs.getString("FId");
        String FCompanyID = rs.getString("FCompanyID");
        String FInvoiceNumber = rs.getString("FInvoiceNumber");
        String FInvoiceCode = rs.getString("FInvoiceCode");
        String instanceDetail = this.getResource("instanceDeatil", new Object[]{FInvoiceCode, FInvoiceNumber});
        this.logPK = LogUtils.beginLog(this.ctx, this.getResource(logItemName), BOSObjectType.create((String)this.getBillBosType()), (IObjectPK)new ObjectUuidPK(FId), instanceDetail, logItemName, FCompanyID);
    }

    protected IObjectPK[] beginLog(Set billIds, String logItemName, boolean isComplete, String detailDesc) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
        view.setFilter(filter);
        ObjectUuidPK[] logPKs = null;
        IncomeInvoiceCollection invColl = IncomeInvoiceFactory.getLocalInstance(this.ctx).getIncomeInvoiceCollection(view);
        IncomeInvoiceInfo invoiceInfo = null;
        if (invColl != null && invColl.size() > 0) {
            logPKs = new ObjectUuidPK[invColl.size()];
            int size = invColl.size();
            for (int i = 0; i < size; ++i) {
                invoiceInfo = invColl.get(i);
                String instanceDetail = this.getResource("instanceDeatil", new Object[]{invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNumber()});
                if (detailDesc != null) {
                    instanceDetail = instanceDetail + detailDesc;
                }
                IObjectPK logPK = LogUtils.beginLog(this.ctx, this.getResource(logItemName), BOSObjectType.create((String)this.getBillBosType()), (IObjectPK)new ObjectUuidPK(invoiceInfo.getId().toString()), instanceDetail, logItemName, invoiceInfo.getCompany().getId().toString());
                if (isComplete) {
                    this.afterLog(logPK);
                }
                logPKs[i] = logPK;
            }
        }
        return logPKs;
    }

    protected void afterLog(IObjectPK logPKs) {
        if (logPKs != null) {
            LogUtils.afterLog(this.ctx, logPKs);
        }
    }

    protected void afterLog() {
        if (this.logPK != null) {
            LogUtils.afterLog(this.ctx, this.logPK);
        }
    }

    protected String getBillBosType() {
        return "1343913D";
    }

    protected String getResource(String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)key, (Locale)this.ctx.getLocale(), (Object[])params);
    }

    protected String getResource(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)key, (Locale)this.ctx.getLocale());
    }

    protected String getQueryInvoiceSQL(ActionParam params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT invoice.FId,invoice.FInvoiceNumber,invoice.FInvoiceCode,invoice.FInvoiceType,invoice.FIsAccept,invoice.FIsReceive,");
        sql.append(" invoice.FStatus,invoice.FAuthenticateStatus,invoice.FAuthenticateType,invoice.FFiVouchered,invoice.FCompanyID,invoice.FTmInvoiceType,invoice.FBizBIllTypeID, ");
        sql.append(" abs.FCheckState,abs.FCheckType,invoice.FIsPurchaseSyn ");
        sql.append(" FROM t_im_IncomeInvoice invoice");
        sql.append(" Left JOIN T_TM_CheckAbs abs on abs.fid = invoice.FCheckAbsID");
        sql.append(this.getQueryInvoiceWhereSQLNew(params));
        return sql.toString();
    }

    protected String getQueryInvoiceWhereSQLNew(ActionParam params) {
        StringBuffer sql = new StringBuffer();
        if (params.getInvoiceId() != null) {
            sql.append(" where invoice.FId = '").append(params.getInvoiceId()).append("'");
        } else {
            sql.append(" where invoice.FInvoiceNumber = '").append(params.getInvoiceNumber()).append("' and invoice.FInvoiceCode ='").append(params.getInvoiceCode()).append("' ");
        }
        return sql.toString();
    }

    protected String getQueryInvoiceWhereSQL(ActionParam params) {
        StringBuffer sql = new StringBuffer();
        if (params.getInvoiceId() != null) {
            sql.append(" where FId = '").append(params.getInvoiceId()).append("'");
        } else {
            sql.append(" where FInvoiceNumber = '").append(params.getInvoiceNumber()).append("' and invoice.FInvoiceCode ='").append(params.getInvoiceCode()).append("' ");
        }
        return sql.toString();
    }

    protected String getQueryInvoiceEntryWhereSQL(ActionParam params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" where FIncomeInvoiceID = '").append(params.getInvoiceId()).append("'");
        return sql.toString();
    }

    protected String getCompanyListSQL(ActionParam params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT company.FId as CompanyId,company.FAccountPeriodID as PeriodId FROM T_ORG_COMPANY company");
        sql.append(" INNER JOIN t_im_incomeinvoice  invoice ON company.fid = invoice.fcompanyid");
        sql.append(" WHERE invoice.FID in (").append(CollectionUtil.convertSet2String(params.getIds(), ",", true)).append(")");
        sql.append(" GROUP BY company.FId,company.FAccountPeriodID");
        return sql.toString();
    }
}

