/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.incomeinvoice.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.ExchInvStrategy;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceException;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.app.incomeinvoice.action.BaseAction;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.ActionResult;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExchangeInvoiceAction
extends BaseAction {
    public ExchangeInvoiceAction(Context ctx) {
        super(ctx);
    }

    @Override
    public ActionResult execute(IncomeInvoiceActionTypeEnum actionType, ActionParam params) throws EASBizException, BOSException {
        ActionResult result = new ActionResult();
        if (IncomeInvoiceActionTypeEnum.SAME.equals((Object)actionType)) {
            result = this.same(params);
        } else if (IncomeInvoiceActionTypeEnum.REVERSE.equals((Object)actionType)) {
            result = this.reverse(params);
        }
        return result;
    }

    private ActionResult same(ActionParam params) throws EASBizException, BOSException {
        return null;
    }

    private ActionResult reverse(ActionParam params) throws EASBizException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQueryInvoiceSQL(params));
        try {
            ArrayList<String> ids;
            if (rs.next()) {
                String FId = rs.getString("FId");
                String FCompanyID = rs.getString("FCompanyID");
                PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission(this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(FCompanyID), "im_incomeInvoice_cancelexchange");
                this.beginLog(rs, "im_incomeInvoice_cancelexchange");
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FDestObjectID from T_BOT_Relation WHERE FDESTENTITYID ='1343913D' AND FSRCENTITYID='1343913D' AND FOperatorID='exchangeInvoice' AND FSRCOBJECTID = '").append(FId).append("'");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString("FDestObjectID"));
                }
                if (ids.isEmpty()) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.UNEXCHANGEINVOICEERROR);
                }
            } else {
                throw new IncomeInvoiceException(IncomeInvoiceException.NOTEXISTINVOICEERROR);
            }
            HashMap<String, Serializable> param = new HashMap<String, Serializable>();
            param.put("idList", ids);
            param.put("isExchange", Boolean.valueOf(false));
            IncomeInvoiceFacadeFactory.getLocalInstance(this.ctx).checkExchange(param);
            this.buildParamsAndUpdate(ids, params);
            this.afterLog();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void buildParamsAndUpdate(List ids, ActionParam actionParams) throws BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ctx", this.ctx);
        params.put("isExchange", false);
        params.put("srcId", actionParams.getInvoiceId());
        params.put("srcCode", actionParams.getInvoiceCode());
        params.put("srcNum", actionParams.getInvoiceNumber());
        try {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" Select FID,FInvoiceCode,FInvoiceNumber From T_IM_IncomeInvoice ");
            sql.append(" Where FID in ").append(IMUtils.getInStringFromList(ids));
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            ArrayList<String> destIdList = new ArrayList<String>();
            ArrayList<String> destCodeList = new ArrayList<String>();
            ArrayList<String> destNumList = new ArrayList<String>();
            while (rs.next()) {
                destIdList.add(rs.getString("FID"));
                destCodeList.add(rs.getString("FInvoiceCode"));
                destNumList.add(rs.getString("FInvoiceNumber"));
            }
            params.put("destIdList", destIdList);
            params.put("destCodes", destCodeList.toArray(new String[destCodeList.size()]));
            params.put("destNums", destNumList.toArray(new String[destNumList.size()]));
            ExchInvStrategy strategy = new ExchInvStrategy(params);
            strategy.doExchange();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

