/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.plugin.IInvoicePlugin;
import com.kingdee.eas.tm.im.app.plugin.ISplitLimitAmtPlugin;
import com.kingdee.eas.tm.im.app.plugin.IUnitConvertPlugin;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginContext;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginUtil;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoicePluginService {
    private static Logger logger = Logger.getLogger((String)"InvoicePluginService");
    private Map<String, IInvoicePlugin> pluginCache = new HashMap<String, IInvoicePlugin>();
    private InvoicePluginContext pluginContext = null;

    public InvoicePluginService(Context ctx, InvoiceReqInfo invoiceReq) {
        this.pluginContext = new InvoicePluginContext(ctx, invoiceReq);
    }

    public boolean isSupportPlugin() {
        return InvoicePluginUtil.isSupportPlugin(this.pluginContext.getInvoiceReq());
    }

    public InvoiceParamConfigInfo getInvoiceParamConfig(String companyID) throws BOSException {
        if (!this.isSupportPlugin()) {
            return null;
        }
        return this.pluginContext.getInvoiceParam(companyID);
    }

    public void unitConvert(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryInfo entry, BillReqInfo billReq, BillEntryReqInfo entryReq) throws BOSException, EASBizException {
        if (!this.isSupportPlugin()) {
            return;
        }
        String defaultPluginName = "com.kingdee.eas.tm.im.app.plugin.impl.UnitConvertPlugin";
        IUnitConvertPlugin unitConvertPlugin = (IUnitConvertPlugin)this.getInvoicePlugin(this.pluginContext.getCtx(), "412A6F98", IUnitConvertPlugin.class, defaultPluginName);
        unitConvertPlugin.setPluginContext(this.pluginContext);
        unitConvertPlugin.unitConvert(makeInvoice, entry, billReq, entryReq);
    }

    public void splitLimitAmtEntry(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryCollection oldEntrys, MakeInvoiceEntryCollection newEntrs, MakeInvoiceEntryInfo oldEntry, MakeInvoiceEntryInfo entry) throws EASBizException, BOSException {
        if (!this.isSupportPlugin()) {
            return;
        }
        String defaultPluginName = "com.kingdee.eas.tm.im.app.plugin.impl.SplitLimitAmtPlugin";
        ISplitLimitAmtPlugin splitLimitAmtPlugin = (ISplitLimitAmtPlugin)this.getInvoicePlugin(this.pluginContext.getCtx(), "412A6F98", ISplitLimitAmtPlugin.class, defaultPluginName);
        splitLimitAmtPlugin.setPluginContext(this.pluginContext);
        splitLimitAmtPlugin.splitLimitAmtEntry(makeInvoice, oldEntrys, newEntrs, oldEntry, entry);
    }

    private IInvoicePlugin getInvoicePlugin(Context ctx, String bosType, Class inf, String defaultPluginName) throws BOSException, EASBizException {
        String key = bosType + "_" + inf.getName();
        IInvoicePlugin invoicePlugin = this.pluginCache.get(key);
        if (invoicePlugin == null) {
            String pluginName = defaultPluginName;
            try {
                String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, (Class)inf);
                if (checkers != null && checkers.length > 0) {
                    pluginName = checkers[0];
                }
            }
            catch (EASDBException e) {
                throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
            }
            try {
                invoicePlugin = (IInvoicePlugin)Class.forName(pluginName).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            this.pluginCache.put(key, invoicePlugin);
        }
        return invoicePlugin;
    }

    public InvoicePluginContext getPluginContext() {
        return this.pluginContext;
    }

    public void setPluginContext(InvoicePluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }
}

