/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.app.util.IMServiceCache;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvoicePluginUtil {
    public static Set<String> getMaterialIDs(InvoiceReqInfo invoiceReq) {
        List<BillReqInfo> bills = invoiceReq.getBills();
        BillReqInfo billReqInfo = null;
        List<BillEntryReqInfo> entrys = null;
        BillEntryReqInfo entry2 = null;
        HashSet<String> materialIDs = new HashSet<String>();
        int size = bills.size();
        for (int i = 0; i < size; ++i) {
            billReqInfo = bills.get(i);
            entrys = billReqInfo.getEntrys();
            for (BillEntryReqInfo entry2 : entrys) {
                if (StringUtils.isEmpty((String)entry2.getMaterialID())) continue;
                materialIDs.add(entry2.getMaterialID());
            }
        }
        return materialIDs;
    }

    public static boolean isSupportPlugin(InvoiceReqInfo invoiceReq) {
        String srcSystem = invoiceReq.getSrcSystem();
        return IMConstant.SRCTYPE_FI_AR.equals(srcSystem) || IMConstant.SRCTYPE_IM_INVOICEREQ.equals(srcSystem);
    }

    public static Map<String, MultiMeasureUnitInfo> betchFetchMutiMeasureUnit(Context ctx, Set<String> materialIDs) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hashMap;
        HashMap<String, MultiMeasureUnitInfo> mutiMeasureUnitCache = new HashMap<String, MultiMeasureUnitInfo>();
        if (materialIDs.size() == 0) {
            return mutiMeasureUnitCache;
        }
        String materialIDStr = null;
        String materialIDTbl = null;
        IRowSet rs = null;
        try {
            if (materialIDs.size() > 1000) {
                materialIDTbl = IMUtils.getIdTempTable(ctx, "MaterialIDsTemp", new ArrayList<String>(materialIDs));
                materialIDStr = "select fid from " + materialIDTbl;
            } else {
                materialIDStr = CollectionUtil.convertSet2String(materialIDs, ",", true);
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID,FSeq,FMaterialID,FMeasureUnitID,FQtyPrecision,FBaseConvsRate,FConversionRate,FIsBasicUnit").append("\n");
            sql.append(" FROM T_BD_MultiMeasureUnit").append("\n");
            sql.append(" WHERE FMaterialID  in (").append(materialIDStr).append(")").append("\n");
            sql.append(" ORDER by FSeq asc").append("\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            MultiMeasureUnitInfo multiMeasureUnitInfo = null;
            String materialID = null;
            String measureUnitID = null;
            String key = null;
            MaterialInfo materialInfo = null;
            MeasureUnitInfo measureUnitInfo = null;
            boolean isBasicUnit = false;
            while (rs.next()) {
                materialID = rs.getString("FMaterialID");
                measureUnitID = rs.getString("FMeasureUnitID");
                multiMeasureUnitInfo = new MultiMeasureUnitInfo();
                multiMeasureUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                multiMeasureUnitInfo.setSeq(rs.getInt("FSeq"));
                multiMeasureUnitInfo.setQtyPrecision(rs.getInt("FQtyPrecision"));
                multiMeasureUnitInfo.setBaseConvsRate(rs.getBigDecimal("FBaseConvsRate"));
                multiMeasureUnitInfo.setConversionRate(rs.getBigDecimal("FConversionRate"));
                materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
                multiMeasureUnitInfo.setMaterial(materialInfo);
                measureUnitInfo = new MeasureUnitInfo();
                measureUnitInfo.setId(BOSUuid.read((String)rs.getString("FMeasureUnitID")));
                multiMeasureUnitInfo.setMeasureUnit(measureUnitInfo);
                key = materialID + "_" + measureUnitID;
                mutiMeasureUnitCache.put(key, multiMeasureUnitInfo);
                isBasicUnit = rs.getBoolean("FIsBasicUnit");
                if (!isBasicUnit) continue;
                mutiMeasureUnitCache.put(materialID, multiMeasureUnitInfo);
            }
            hashMap = mutiMeasureUnitCache;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(materialIDTbl)) {
                    TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(materialIDTbl);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)materialIDTbl)) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(materialIDTbl);
        }
        return hashMap;
    }

    public static SelectorItemCollection getEntryMeasureUnitSelector(Context ctx, String bosType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        PropertyCollection entityProperties = entity.getEntityProperties();
        EntityObjectInfo entry = null;
        PropertyInfo property = null;
        int size = entityProperties.size();
        for (int i = 0; i < size; ++i) {
            property = entityProperties.get(i);
            boolean isEntry = SCMMDUtil.isEntryProperty((EntityObjectInfo)entity, (PropertyInfo)property);
            if (!isEntry) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            entry = relation.getSupplierObject();
            break;
        }
        if (entry == null) {
            return sic;
        }
        PropertyInfo entryProperty = (PropertyInfo)property.clone();
        PropertyCollection entryProperties = entry.getEntityProperties();
        EntityObjectInfo linkEntity = null;
        int size2 = entryProperties.size();
        for (int i = 0; i < size2; ++i) {
            property = entryProperties.get(i);
            if (!(property instanceof LinkPropertyInfo) || !InvoicePluginUtil.isMeasureUnit(linkEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject())) continue;
            sic.add(entryProperty.getName() + "." + property.getName() + ".id");
            sic.add(entryProperty.getName() + "." + property.getName() + ".name");
        }
        return sic;
    }

    public static boolean isMeasureUnit(EntityObjectInfo linkEntity) {
        if (linkEntity == null) {
            return false;
        }
        String measureUnitBosType = "5B825C57";
        boolean isMeasureUnit = measureUnitBosType.equals(linkEntity.getType().toString()) || linkEntity.getBaseEntity() != null && measureUnitBosType.equals(linkEntity.getBaseEntity().getType().toString()) || linkEntity.getBaseEntity().getBaseEntity() != null && measureUnitBosType.equals(linkEntity.getBaseEntity().getBaseEntity().getType().toString());
        return isMeasureUnit;
    }
}

