/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.app.handler.user.AbstractUserHandler;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.app.BizFromCQCloudInfo;
import com.kingdee.eas.tm.im.app.ReturnCQPurCloudInfo;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.IMConvertUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class BizFromCQPurCloudService
extends AbstractUserHandler {
    private static Logger logger = Logger.getLogger(BizFromCQPurCloudService.class);
    private Map<String, String> companyMap = new HashMap<String, String>();
    private Map<String, String> supplierMap = new HashMap<String, String>();
    private Set<String> supplierNumberSet = new HashSet<String>();
    private Map<String, String> invoiceSupplierMap = new HashMap<String, String>();

    public Object handleOriginal(Context ctx, Object data) throws Exception {
        this.writeLog("@@@@BizFromCQPurCloudService.handleOriginal()");
        Object returnData = null;
        if (data == null) {
            ReturnCQPurCloudInfo errorReturn = new ReturnCQPurCloudInfo("004", IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "CQPurCloud_DataIsNull", ctx));
            HashMap<String, ReturnCQPurCloudInfo> msgMap = new HashMap<String, ReturnCQPurCloudInfo>();
            msgMap.put("data", errorReturn);
            JSONObject json = JSONObject.fromObject(msgMap);
            returnData = json.toString();
            return returnData;
        }
        try {
            returnData = this.handleReceive(ctx, data);
            if (null == returnData) {
                this.writeLog("[BizFromCQPurCloudService.handleOriginal]:returnData is null");
                returnData = "";
            } else {
                this.writeLog("[BizFromCQPurCloudService.handleOriginal]returnData:" + returnData.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)("[BizFromCQPurCloudService.handleOriginal]Exception:" + e.getMessage()), (Throwable)e);
            ReturnCQPurCloudInfo errorReturn = new ReturnCQPurCloudInfo("003", e.toString());
            HashMap<String, ReturnCQPurCloudInfo> msgMap = new HashMap<String, ReturnCQPurCloudInfo>();
            msgMap.put("data", errorReturn);
            JSONObject json = JSONObject.fromObject(msgMap);
            returnData = json.toString();
        }
        return returnData;
    }

    public boolean isEndWithOriginal() {
        return true;
    }

    public Object handleReceive(Context ctx, Object data) throws Exception {
        HashMap<String, ReturnCQPurCloudInfo> msgMap = new HashMap<String, ReturnCQPurCloudInfo>();
        Map<String, String> incomeInvoiceMap = new HashMap();
        Map parseMap = new HashMap();
        parseMap = this.parseJsonData(ctx, data);
        String action = (String)parseMap.get("action");
        incomeInvoiceMap = (Map)parseMap.get("incomeInvoiceMap");
        if (StringUtils.isEmpty((String)action) || incomeInvoiceMap.size() == 0) {
            String totalMsg = IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "actionOrInvoiceIsNull", ctx);
            ReturnCQPurCloudInfo returnInfo = new ReturnCQPurCloudInfo("004", totalMsg);
            msgMap.put("data", returnInfo);
            JSONObject json = JSONObject.fromObject(msgMap);
            return json.toString();
        }
        Set companyNumberSet = (Set)parseMap.get("companyNumberSet");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        int j = companyColl.size();
        for (int i = 0; i < j; ++i) {
            this.companyMap.put(companyColl.get(i).getNumber(), companyColl.get(i).getId().toString());
        }
        ReturnCQPurCloudInfo returnInfo = new ReturnCQPurCloudInfo();
        List<BizFromCQCloudInfo> detailData = new ArrayList<BizFromCQCloudInfo>();
        Map retMap = new HashMap();
        if ("receive".equals(action)) {
            retMap = this.doReceiveInvoice(ctx, incomeInvoiceMap);
            if (retMap.get("isPartlySuccess") != null && Boolean.parseBoolean(retMap.get("isPartlySuccess").toString())) {
                returnInfo.setTotalErrorCode("001");
            } else {
                returnInfo.setTotalErrorCode("000");
            }
        } else if ("unreceive".equals(action)) {
            retMap = this.doUnReceiveInvoice(ctx, incomeInvoiceMap);
            if (retMap.get("unReceiveSuccess") != null && Boolean.parseBoolean(retMap.get("unReceiveSuccess").toString())) {
                returnInfo.setTotalErrorCode("000");
            } else {
                returnInfo.setTotalErrorCode("001");
            }
        } else if ("cancel".equals(action)) {
            retMap = this.doCancelInvoice(ctx, incomeInvoiceMap);
        }
        if (retMap != null && retMap.get("retList") != null) {
            detailData = (List)retMap.get("retList");
        }
        returnInfo.setDetailData(detailData);
        msgMap.put("data", returnInfo);
        JSONObject json = JSONObject.fromObject(msgMap);
        return json.toString();
    }

    private Map parseJsonData(Context ctx, Object data) throws BOSException {
        Map receiveMap = IMConvertUtils.convertJsonToMap(ctx, data);
        Map returnData = (Map)receiveMap.get("data");
        HashSet<String> companyNumberSet = new HashSet<String>();
        String action = "";
        HashMap<String, String> incomeInvoiceMap = new HashMap<String, String>();
        if (returnData.get("action") != null) {
            action = (String)returnData.get("action");
        }
        if (!StringUtils.isEmpty((String)action)) {
            List invoiceList = (List)returnData.get("invoices");
            Map invoiceCodeNoMap = null;
            String invoiceCode = "";
            String invoiceNo = "";
            String companyNumber = "";
            String supplierNumber = "";
            int j = invoiceList.size();
            for (int i = 0; i < j; ++i) {
                invoiceCodeNoMap = (Map)invoiceList.get(i);
                if (invoiceCodeNoMap == null) continue;
                invoiceCode = (String)invoiceCodeNoMap.get("invoiceCode");
                invoiceNo = (String)invoiceCodeNoMap.get("invoiceNo");
                companyNumber = (String)invoiceCodeNoMap.get("companyNumber");
                supplierNumber = (String)invoiceCodeNoMap.get("supplierNumber");
                if (!(StringUtils.isEmpty((String)invoiceCode) || StringUtils.isEmpty((String)invoiceNo) || StringUtils.isEmpty((String)companyNumber))) {
                    incomeInvoiceMap.put(invoiceCode + "_" + invoiceNo, companyNumber);
                    companyNumberSet.add(companyNumber);
                }
                if (StringUtils.isEmpty((String)invoiceCode) || StringUtils.isEmpty((String)invoiceNo) || StringUtils.isEmpty((String)supplierNumber)) continue;
                this.invoiceSupplierMap.put(invoiceCode + "_" + invoiceNo, supplierNumber);
                this.supplierNumberSet.add(supplierNumber);
            }
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("action", action);
        retMap.put("incomeInvoiceMap", incomeInvoiceMap);
        retMap.put("companyNumberSet", companyNumberSet);
        return retMap;
    }

    private Map doReceiveInvoice(Context ctx, Map<String, String> incomeInvoiceMap) throws BOSException {
        BizFromCQCloudInfo retInfo;
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        ArrayList<BizFromCQCloudInfo> retList = new ArrayList<BizFromCQCloudInfo>();
        boolean isPartlySuccess = false;
        int successCount = 0;
        int failCount = 0;
        Map systemNotExists = new HashMap();
        Map unMatchedInvoice = new HashMap();
        Map matchedInvoice = new HashMap();
        Set unMatchedIDSet = new HashSet();
        Map classifyMap = new HashMap();
        classifyMap = this.classifyInvoice(ctx, incomeInvoiceMap);
        systemNotExists = (Map)classifyMap.get("systemNotExists");
        unMatchedInvoice = (Map)classifyMap.get("unMatchedInvoice");
        matchedInvoice = (Map)classifyMap.get("matchedInvoice");
        unMatchedIDSet = (Set)classifyMap.get("unMatchedIDSet");
        this.getSupplierID(ctx);
        Iterator iterator = null;
        String key = "";
        String[] splitKey = null;
        Map downloadMap = new HashMap();
        BizFromCQCloudInfo detailInfo = null;
        if (systemNotExists.size() > 0) {
            iterator = systemNotExists.keySet().iterator();
            while (iterator.hasNext()) {
                retInfo = new BizFromCQCloudInfo();
                key = "";
                splitKey = null;
                key = ((String)iterator.next()).toString();
                splitKey = key.split("_");
                try {
                    downloadMap = this.downLoadInvoice(ctx, key, incomeInvoiceMap.get(key), "receive");
                    if (downloadMap.size() <= 0) continue;
                    detailInfo = (BizFromCQCloudInfo)downloadMap.get("retDetailInfo");
                    retList.add(detailInfo);
                    if (Boolean.parseBoolean(downloadMap.get("isSuccess").toString())) {
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                }
                catch (Exception e) {
                    if (splitKey == null || splitKey.length <= 1) continue;
                    retInfo = new BizFromCQCloudInfo();
                    retInfo.setInvoiceCode(splitKey[0]);
                    retInfo.setInvoiceNo(splitKey[1]);
                    retInfo.setErrorCode("003");
                    retInfo.setErrorMsg(IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DownLoadInvoiceError", ctx));
                    retList.add(retInfo);
                    ++failCount;
                }
            }
        }
        if (unMatchedInvoice.size() > 0) {
            iterator = unMatchedInvoice.keySet().iterator();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            try {
                StringBuffer selectSql = new StringBuffer();
                selectSql.append("update T_IM_IncomeInvoice set FISPURCHASESYN = 1,FISACCEPT = 1 ");
                if (user != null) {
                    selectSql.append(",FAcceptUserID = '" + user.getId().toString() + "'");
                }
                selectSql.append(",FAcceptInvoiceDate = GETDATE() ");
                String whereSql = " where FID in " + IMUtils.getInStringFromSet(unMatchedIDSet);
                selectSql.append(whereSql);
                DbUtil.execute((Context)ctx, (String)selectSql.toString());
                this.updateSupplierInfo(ctx);
                while (iterator.hasNext()) {
                    key = "";
                    splitKey = null;
                    key = ((String)iterator.next()).toString();
                    splitKey = key.split("_");
                    if (splitKey == null || splitKey.length <= 1) continue;
                    retInfo = new BizFromCQCloudInfo();
                    retInfo.setInvoiceCode(splitKey[0]);
                    retInfo.setInvoiceNo(splitKey[1]);
                    retInfo.setErrorCode("000");
                    retInfo.setErrorMsg(IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "EASHasInvoice_updateFlag", ctx));
                    retList.add(retInfo);
                    ++successCount;
                }
            }
            catch (Exception e) {
                while (iterator.hasNext()) {
                    key = "";
                    splitKey = null;
                    key = ((String)iterator.next()).toString();
                    splitKey = key.split("_");
                    if (splitKey == null || splitKey.length <= 1) continue;
                    retInfo = new BizFromCQCloudInfo();
                    retInfo.setInvoiceCode(splitKey[0]);
                    retInfo.setInvoiceNo(splitKey[1]);
                    retInfo.setErrorCode("003");
                    retInfo.setErrorMsg(e.toString());
                    retList.add(retInfo);
                    ++failCount;
                }
            }
        }
        if (matchedInvoice.size() > 0) {
            iterator = matchedInvoice.keySet().iterator();
            while (iterator.hasNext()) {
                key = "";
                splitKey = null;
                key = ((String)iterator.next()).toString();
                splitKey = key.split("_");
                if (splitKey == null || splitKey.length <= 1) continue;
                retInfo = new BizFromCQCloudInfo();
                retInfo.setInvoiceCode(splitKey[0]);
                retInfo.setInvoiceNo(splitKey[1]);
                retInfo.setErrorCode("005");
                retInfo.setErrorMsg(IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "matchedInvoice_receiveFail", ctx));
                retList.add(retInfo);
                ++failCount;
            }
        }
        if (failCount > 0) {
            isPartlySuccess = true;
        }
        retMap.put("retList", retList);
        retMap.put("isPartlySuccess", Boolean.valueOf(isPartlySuccess));
        return retMap;
    }

    private Map doUnReceiveInvoice(Context ctx, Map<String, String> incomeInvoiceMap) throws BOSException {
        boolean unReceiveSuccess;
        ArrayList<BizFromCQCloudInfo> retList;
        HashMap<String, Serializable> retMap;
        block9: {
            retMap = new HashMap<String, Serializable>();
            retList = new ArrayList<BizFromCQCloudInfo>();
            unReceiveSuccess = true;
            Map classifyMap = new HashMap();
            classifyMap = this.classifyInvoice(ctx, incomeInvoiceMap);
            Map matchedInvoice = new HashMap();
            Set unMatchedIDSet = new HashSet();
            Map unMatchedInvoice = new HashMap();
            matchedInvoice = (Map)classifyMap.get("matchedInvoice");
            unMatchedIDSet = (Set)classifyMap.get("unMatchedIDSet");
            unMatchedInvoice = (Map)classifyMap.get("unMatchedInvoice");
            Iterator iterator = null;
            String key = null;
            String[] splitKey = null;
            try {
                BizFromCQCloudInfo retInfo;
                if (unMatchedIDSet.size() > 0) {
                    String sql = "update T_IM_IncomeInvoice set FISPURCHASESYN = 0 where FID in " + IMUtils.getInStringFromSet(unMatchedIDSet);
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                if (unMatchedInvoice.size() > 0) {
                    iterator = unMatchedInvoice.keySet().iterator();
                    while (iterator.hasNext()) {
                        key = ((String)iterator.next()).toString();
                        splitKey = key.split("_");
                        if (splitKey == null || splitKey.length <= 1) continue;
                        retInfo = new BizFromCQCloudInfo();
                        retInfo.setInvoiceCode(splitKey[0]);
                        retInfo.setInvoiceNo(splitKey[1]);
                        retInfo.setErrorCode("000");
                        retList.add(retInfo);
                    }
                }
                if (matchedInvoice.size() <= 0) break block9;
                unReceiveSuccess = false;
                iterator = matchedInvoice.keySet().iterator();
                while (iterator.hasNext()) {
                    key = ((String)iterator.next()).toString();
                    splitKey = key.split("_");
                    if (splitKey == null || splitKey.length <= 1) continue;
                    retInfo = new BizFromCQCloudInfo();
                    retInfo.setInvoiceCode(splitKey[0]);
                    retInfo.setInvoiceNo(splitKey[1]);
                    retInfo.setErrorCode("005");
                    retInfo.setErrorMsg(IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "invoiceHasGenAP", ctx));
                    retList.add(retInfo);
                }
            }
            catch (Exception e) {
                BizFromCQCloudInfo retInfo;
                unReceiveSuccess = false;
                if (matchedInvoice.size() > 0) {
                    iterator = matchedInvoice.keySet().iterator();
                    while (iterator.hasNext()) {
                        key = ((String)iterator.next()).toString();
                        splitKey = key.split("_");
                        if (splitKey == null || splitKey.length <= 1) continue;
                        retInfo = new BizFromCQCloudInfo();
                        retInfo.setInvoiceCode(splitKey[0]);
                        retInfo.setInvoiceNo(splitKey[1]);
                        retInfo.setErrorCode("003");
                        retInfo.setErrorMsg(e.toString());
                        retList.add(retInfo);
                    }
                }
                if (unMatchedInvoice.size() <= 0) break block9;
                iterator = unMatchedInvoice.keySet().iterator();
                while (iterator.hasNext()) {
                    key = ((String)iterator.next()).toString();
                    splitKey = key.split("_");
                    if (splitKey == null || splitKey.length <= 1) continue;
                    retInfo = new BizFromCQCloudInfo();
                    retInfo.setInvoiceCode(splitKey[0]);
                    retInfo.setInvoiceNo(splitKey[1]);
                    retInfo.setErrorCode("003");
                    retInfo.setErrorMsg(e.toString());
                    retList.add(retInfo);
                }
            }
        }
        retMap.put("retList", retList);
        retMap.put("unReceiveSuccess", Boolean.valueOf(unReceiveSuccess));
        return retMap;
    }

    private Map doCancelInvoice(Context ctx, Map<String, String> incomeInvoiceMap) {
        return null;
    }

    private Map classifyInvoice(Context ctx, Map<String, String> incomeInvoiceMap) throws BOSException {
        HashMap<String, String> systemNotExists = new HashMap<String, String>();
        HashMap<String, String> unMatchedInvoice = new HashMap<String, String>();
        HashMap<String, String> matchedInvoice = new HashMap<String, String>();
        HashSet unMatchedIDSet = new HashSet();
        HashSet<String> matchedIDSet = new HashSet<String>();
        HashSet<String> invoiceNoSet = new HashSet<String>();
        String[] invoiceCodeNo = null;
        Iterator<String> iter = incomeInvoiceMap.keySet().iterator();
        String key = "";
        while (iter.hasNext()) {
            key = "";
            invoiceCodeNo = null;
            key = iter.next().toString();
            invoiceCodeNo = key.split("_");
            if (invoiceCodeNo == null || invoiceCodeNo.length <= 1) continue;
            invoiceNoSet.add(invoiceCodeNo[1]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceCode"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("bizBillType.billBosType"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", invoiceNoSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IncomeInvoiceCollection invoiceColl = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(viewInfo);
        HashMap<String, String> systemInvoiceCodeNo = new HashMap<String, String>();
        HashMap<String, String> systemInvoiceID = new HashMap<String, String>();
        if (invoiceColl.size() == 0) {
            systemNotExists.putAll(incomeInvoiceMap);
        } else {
            IncomeInvoiceInfo info = null;
            String bizBillType = "";
            int j = invoiceColl.size();
            for (int i = 0; i < j; ++i) {
                bizBillType = "";
                info = invoiceColl.get(i);
                bizBillType = info.getBizBillType() == null ? "" : info.getBizBillType().getBillBosType();
                systemInvoiceCodeNo.put(info.getInvoiceCode() + "_" + info.getInvoiceNumber(), bizBillType);
                systemInvoiceID.put(info.getInvoiceCode() + "_" + info.getInvoiceNumber(), info.getId().toString());
            }
            iter = incomeInvoiceMap.keySet().iterator();
            while (iter.hasNext()) {
                key = "";
                key = iter.next().toString();
                if (systemInvoiceCodeNo.containsKey(key)) {
                    if ("48DA3A71".equals(systemInvoiceCodeNo.get(key))) {
                        matchedInvoice.put(key, incomeInvoiceMap.get(key));
                        matchedIDSet.add(incomeInvoiceMap.get(key));
                        continue;
                    }
                    unMatchedInvoice.put(key, incomeInvoiceMap.get(key));
                    unMatchedIDSet.add(systemInvoiceID.get(key));
                    continue;
                }
                systemNotExists.put(key, incomeInvoiceMap.get(key));
            }
        }
        HashMap<String, Cloneable> retMap = new HashMap<String, Cloneable>();
        retMap.put("systemNotExists", systemNotExists);
        retMap.put("unMatchedInvoice", unMatchedInvoice);
        retMap.put("matchedInvoice", matchedInvoice);
        retMap.put("unMatchedIDSet", unMatchedIDSet);
        retMap.put("matchedIDSet", matchedIDSet);
        return retMap;
    }

    protected Map downLoadInvoice(Context ctx, String invoiceCodeNo, String companyNumber, String action) throws EASBizException, BOSException {
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        List paramList = this.buildPwyParam(ctx, invoiceCodeNo, companyNumber);
        String[] invoiceSplit = invoiceCodeNo.split("_");
        if (paramList.isEmpty()) {
            BizFromCQCloudInfo retDetailInfo = new BizFromCQCloudInfo("005", IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "EAS_buildParamFailed", ctx), invoiceSplit[0], invoiceSplit[1]);
            retMap.put("retDetailInfo", retDetailInfo);
            retMap.put("isSuccess", Boolean.valueOf(false));
            return retMap;
        }
        List list = PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
        PwyInvokeParam invokeParam = null;
        Map invokeActionMap = null;
        for (int i = 0; i < list.size(); ++i) {
            BizFromCQCloudInfo retDetailInfo;
            invokeParam = (PwyInvokeParam)list.get(i);
            if (invokeParam.isError()) {
                retDetailInfo = new BizFromCQCloudInfo("002", invokeParam.getExceptionMsg(), invoiceSplit[0], invoiceSplit[1]);
                retMap.put("retDetailInfo", retDetailInfo);
                retMap.put("isSuccess", Boolean.valueOf(false));
                continue;
            }
            IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                retDetailInfo = new BizFromCQCloudInfo("002", pwyService.getInvokeParam().getDescription(), invoiceSplit[0], invoiceSplit[1]);
                retMap.put("retDetailInfo", retDetailInfo);
                retMap.put("isSuccess", Boolean.valueOf(false));
                continue;
            }
            invokeActionMap = pwyService.getInvokeParam().getInvokeActionMap();
            if (invokeActionMap.get("invoiceDataIsNull") != null) {
                retDetailInfo = new BizFromCQCloudInfo("002", IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DownLoadInvoiceError", ctx), invoiceSplit[0], invoiceSplit[1]);
                retMap.put("retDetailInfo", retDetailInfo);
                retMap.put("isSuccess", Boolean.valueOf(false));
                continue;
            }
            retDetailInfo = new BizFromCQCloudInfo("000", IMUtils.getResource("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceDownSuccess", ctx), invoiceSplit[0], invoiceSplit[1]);
            retMap.put("retDetailInfo", retDetailInfo);
            retMap.put("isSuccess", Boolean.valueOf(true));
        }
        return retMap;
    }

    protected List buildPwyParam(Context ctx, String invoiceCodeNo, String companyNumber) throws EASBizException, BOSException {
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        ArrayList bodyList = new ArrayList();
        PwyServiceType msgType = PwyServiceType.OPR_POOL_WEB_DOWNLOAD_CODENO;
        String[] splitCodeNo = null;
        splitCodeNo = invoiceCodeNo.split("_");
        String invoiceCode = "";
        String invoiceNo = "";
        if (splitCodeNo != null && splitCodeNo.length > 1) {
            invoiceCode = splitCodeNo[0];
            invoiceNo = splitCodeNo[1];
        }
        if (!(StringUtils.isEmpty((String)invoiceCode) || StringUtils.isEmpty((String)invoiceNo) || StringUtils.isEmpty((String)companyNumber))) {
            HashMap<String, String> webDownloadCodeNoParams = new HashMap<String, String>();
            webDownloadCodeNoParams.put("invoiceCode", invoiceCode);
            webDownloadCodeNoParams.put("invoiceNo", invoiceNo);
            bodyList.add(webDownloadCodeNoParams);
            String companyID = this.companyMap.get(companyNumber);
            HashSet<String> companyIDs = new HashSet<String>();
            if (StringUtils.isEmpty((String)companyID)) {
                companyIDs.add("111111111111111111111111111=");
            } else {
                companyIDs.add(companyID);
            }
            PwyActionParam actionParam = null;
            Map resultMap = PwySettingFactory.getLocalInstance(ctx).getTaxNoSumResult(companyIDs);
            for (String taxNo : resultMap.keySet()) {
                for (HashMap hashMap : bodyList) {
                    HashMap tempParam = new HashMap();
                    tempParam.put("sumRet", resultMap.get(taxNo));
                    CompanyOrgUnitInfo company = ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany();
                    if (!StringUtils.isEmpty((String)company.getTaxNumber())) {
                        hashMap.put("buyerTaxNo", company.getTaxNumber().trim());
                    }
                    tempParam.put("pwyData", hashMap);
                    tempParam.put("isCQPurCloudReceive", true);
                    String supplierNumber = null;
                    if (this.invoiceSupplierMap.containsKey(invoiceCodeNo) && this.supplierMap.containsKey(supplierNumber = this.invoiceSupplierMap.get(invoiceCodeNo))) {
                        tempParam.put("supplierID", this.supplierMap.get(supplierNumber));
                    }
                    actionParam = new PwyActionParam(msgType, TransSrcSystemEnum.easgui, company.getId().toString(), tempParam);
                    paramList.add(actionParam);
                }
            }
        }
        this.writeLog(((Object)paramList).toString());
        return paramList;
    }

    protected void getSupplierID(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", this.supplierNumberSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        SupplierCollection coll = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(evi);
        if (coll != null && coll.size() > 0) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                this.supplierMap.put(coll.get(i).getNumber(), coll.get(i).getId().toString());
            }
        }
    }

    protected void updateSupplierInfo(Context ctx) {
        String updateSql = "update t_im_incomeinvoice set FCurrAcctSupplierID = ? where FInvoiceCode = ? and FInvoiceNumber = ?";
        ArrayList<Object[]> batchUpdateParamList = new ArrayList<Object[]>();
        String[] split = null;
        Iterator<String> it = this.invoiceSupplierMap.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = it.next().toString();
            split = key.split("_");
            Object[] paramValue = new Object[3];
            if (this.supplierMap.get(this.invoiceSupplierMap.get(key)) == null) continue;
            paramValue[0] = this.supplierMap.get(this.invoiceSupplierMap.get(key));
            paramValue[1] = split[0];
            paramValue[2] = split[1];
            batchUpdateParamList.add(paramValue);
        }
        if (batchUpdateParamList.size() > 0) {
            try {
                DbUtil.executeBatch((Context)ctx, (String)updateSql, batchUpdateParamList);
            }
            catch (BOSException e) {
                logger.error((Object)("[updateSupplierError]:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void writeLog(String log) {
        logger.error((Object)log);
    }
}

