/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.constant.PoolSyncConstant;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncPwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PoolSync4OtherBillService {
    public static TMTraceLogger logger = TMLoggerFactory.getTraceLogger((String)"PoolSync4OtherBillService");

    public void saveAndUpdateInvoiceStatus(Map params, ArrayList<String> fidArray) throws Exception {
        this.saveInvoiceStatus(params, fidArray);
        Boolean isSubmit = params.get("isSubmit") == null ? false : (Boolean)params.get("isSubmit");
        if (isSubmit.booleanValue()) {
            this.updateInvoiceStatus(params, "30");
        }
    }

    public void saveInvoiceStatus(Map params, ArrayList<String> fidArray) throws Exception {
        block3: {
            Context ctx = (Context)params.get("ctx");
            String companyId = (String)params.get("companyId");
            String billId = (String)params.get("billId");
            String bizBillNumber = (String)params.get("bizBillNumber");
            Boolean isSubmit = params.get("isSubmit") == null ? false : (Boolean)params.get("isSubmit");
            Boolean isIntegratedByPWY = params.get("isIntegratedByPWY") == null ? false : (Boolean)params.get("isIntegratedByPWY");
            String bizBillType = (String)params.get("bizBillType");
            if (MatchConstant.TYPEID_PAYREQUESTBILL.equals(bizBillType)) {
                return;
            }
            try {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.putAll(params);
                paramMap.put("fidArray", fidArray);
                paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.OTHERBILL);
                paramMap.remove("ctx");
                PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_SAVE_INVOICE_STATUS);
                actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
                actionParam.setBillId(billId);
                actionParam.setBillNumber(bizBillNumber);
                actionParam.setOrgId(companyId);
                actionParam.setParams(paramMap);
                this.baseInvoiceCall(ctx, actionParam, isIntegratedByPWY);
            }
            catch (Exception e) {
                logger.error((Object)("saveInvoiceStatus error,e=" + e));
                if (!isIntegratedByPWY.booleanValue() || !isSubmit.booleanValue()) break block3;
                throw e;
            }
        }
    }

    public void updateInvoiceStatus(Map params, String expenseStatus) throws Exception {
        block3: {
            Context ctx = (Context)params.get("ctx");
            String companyId = (String)params.get("companyId");
            String billId = (String)params.get("billId");
            String bizBillNumber = (String)params.get("bizBillNumber");
            Boolean isIntegratedByPWY = params.get("isIntegratedByPWY") == null ? false : (Boolean)params.get("isIntegratedByPWY");
            String bizBillType = (String)params.get("bizBillType");
            if (MatchConstant.TYPEID_PAYREQUESTBILL.equals(bizBillType)) {
                return;
            }
            try {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.putAll(params);
                paramMap.put("expenseStatus", expenseStatus);
                paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.OTHERBILL);
                paramMap.remove("ctx");
                PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_UPATE_INVOICE_STATUS);
                actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
                actionParam.setBillId(billId);
                actionParam.setBillNumber(bizBillNumber);
                actionParam.setOrgId(companyId);
                actionParam.setParams(paramMap);
                this.baseInvoiceCall(ctx, actionParam, isIntegratedByPWY);
            }
            catch (Exception e) {
                logger.error((Object)("updateInvoiceStatus error,e=" + e + ",isIntegratedByPWY=" + isIntegratedByPWY));
                if (!isIntegratedByPWY.booleanValue()) break block3;
                throw e;
            }
        }
    }

    public void deleteInvoiceStatus(Map params) throws Exception {
        block4: {
            Context ctx = (Context)params.get("ctx");
            String companyId = (String)params.get("companyId");
            String billId = (String)params.get("billId");
            String bizBillNumber = (String)params.get("bizBillNumber");
            String bizBillType = (String)params.get("bizBillType");
            Boolean isIntegratedByPWY = params.get("isIntegratedByPWY") == null ? false : (Boolean)params.get("isIntegratedByPWY");
            if (MatchConstant.TYPEID_PAYREQUESTBILL.equals(bizBillType)) {
                return;
            }
            if (params.get("isSubmit") != null) {
                return;
            }
            try {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.putAll(params);
                paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.OTHERBILL);
                paramMap.remove("ctx");
                PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_DEL_INVOICE_STATUS);
                actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
                actionParam.setBillId(billId);
                actionParam.setBillNumber(bizBillNumber);
                actionParam.setOrgId(companyId);
                actionParam.setParams(paramMap);
                this.baseInvoiceCall(ctx, actionParam, isIntegratedByPWY);
            }
            catch (Exception e) {
                logger.error((Object)("deleteInvoiceStatus error,e=" + e));
                if (!isIntegratedByPWY.booleanValue()) break block4;
                throw e;
            }
        }
    }

    public void updateVoucherInfo(Map params) throws Exception {
        List data = (List)params.get("data");
        Context ctx = (Context)params.get("ctx");
        if (data.size() == 0) {
            return;
        }
        Map param = null;
        String billId = null;
        String operation = null;
        ArrayList<Map> updateDataList = new ArrayList<Map>();
        ArrayList<Map> deleteDataList = new ArrayList<Map>();
        HashSet<String> updateIdSet = new HashSet<String>();
        HashSet<String> deleteIdSet = new HashSet<String>();
        HashSet<String> voucherIdSet = new HashSet<String>();
        String voucherId = null;
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            param = (Map)data.get(i);
            billId = (String)param.get("billId");
            voucherId = (String)param.get("voucherId");
            operation = (String)param.get("operation");
            if ("update".equals(operation)) {
                updateDataList.add(param);
                updateIdSet.add(billId);
                voucherIdSet.add(voucherId);
                continue;
            }
            if (!"delete".equals(operation)) continue;
            deleteDataList.add(param);
            deleteIdSet.add(billId);
        }
        if (updateDataList.size() > 0) {
            params.put("dataList", updateDataList);
            params.put("billIdSet", updateIdSet);
            this.deleteVoucherInfo(ctx, params);
            params.put("dataList", updateDataList);
            params.put("billIdSet", updateIdSet);
            params.put("voucherIdSet", voucherIdSet);
            this.saveVoucherInfo(ctx, params);
        }
        if (deleteDataList.size() > 0) {
            params.put("dataList", deleteDataList);
            params.put("billIdSet", deleteIdSet);
            this.deleteVoucherInfo(ctx, params);
        }
    }

    protected void saveVoucherInfo(Context ctx, Map params) throws Exception {
        List dataList = (List)params.get("dataList");
        Set billIdSet = (Set)params.get("billIdSet");
        Set voucherIdSet = (Set)params.get("voucherIdSet");
        Map<String, OtherBillInfo> billMap = this.getBillMap(ctx, billIdSet);
        List invoiceList = PoolSyncUtil.getInvoiceList(ctx, billIdSet);
        Map invoiceObject = null;
        String serialNo = null;
        String bizBillId = null;
        String voucherId = null;
        String voucherNumber = null;
        VoucherInfo voucherInfo = null;
        HashMap serialNoMap = new HashMap();
        HashMap<String, VoucherInfo> invoiceVoucherMap = new HashMap<String, VoucherInfo>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            invoiceObject = (Map)invoiceList.get(i);
            serialNo = (String)invoiceObject.get("FSERIALNO");
            bizBillId = (String)invoiceObject.get("FBIZBILLID");
            voucherId = (String)invoiceObject.get("FVOUCHERID");
            voucherNumber = (String)invoiceObject.get("FVOUCHERNUMBER");
            if (!serialNoMap.containsKey(bizBillId)) {
                serialNoMap.put(bizBillId, new ArrayList());
            }
            ((List)serialNoMap.get(bizBillId)).add(serialNo);
            if (invoiceVoucherMap.containsKey(bizBillId)) continue;
            voucherInfo = new VoucherInfo();
            voucherInfo.setId(BOSUuid.read((String)voucherId));
            voucherInfo.setNumber(voucherNumber);
            invoiceVoucherMap.put(bizBillId, voucherInfo);
        }
        Map<String, VoucherInfo> voucherMap = this.getVoucherMap(ctx, voucherIdSet);
        String bizBillNumber = null;
        String companyId = null;
        OtherBillInfo objectValue = null;
        HashMap<String, Object> paramMap = null;
        PwyActionParam actionParam = null;
        String billId = null;
        Map data = null;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            data = (Map)dataList.get(i);
            billId = (String)data.get("billId");
            voucherId = (String)data.get("voucherId");
            objectValue = billMap.get(billId);
            voucherInfo = voucherMap.get(voucherId);
            if (objectValue == null || voucherInfo == null) continue;
            if (invoiceVoucherMap.get(billId) != null) {
                voucherInfo.setNumber(((VoucherInfo)invoiceVoucherMap.get(billId)).getNumber());
            }
            bizBillNumber = objectValue.getNumber();
            companyId = objectValue.getCompany().getId().toString();
            paramMap = new HashMap<String, Object>();
            ArrayList<String> expenseIdArray = new ArrayList<String>();
            expenseIdArray.add(billId);
            paramMap.put("expenseIdArray", expenseIdArray);
            paramMap.put("voucherInfo", PoolSyncPwyHelper.getVoucherInfoMap(voucherInfo));
            paramMap.put("serialNoArray", serialNoMap.get(billId));
            paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.OTHERBILL);
            actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_SAVE_VOUCHER);
            actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
            actionParam.setBillId(billId);
            actionParam.setBillNumber(bizBillNumber);
            actionParam.setOrgId(companyId);
            actionParam.setParams(paramMap);
            PoolSyncUtil.poolAsyncCall(ctx, actionParam);
        }
    }

    protected void deleteVoucherInfo(Context ctx, Map params) throws Exception {
        List dataList = (List)params.get("dataList");
        Set billIdSet = (Set)params.get("billIdSet");
        Map<String, OtherBillInfo> billMap = this.getBillMap(ctx, billIdSet);
        List invoiceList = (List)params.get("oldInvoiceList");
        Map invoiceObject = null;
        String bizBillId = null;
        String voucherId = null;
        String voucherNumber = null;
        VoucherInfo voucherInfo = null;
        HashMap<String, VoucherInfo> invoiceVoucherMap = new HashMap<String, VoucherInfo>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            invoiceObject = (Map)invoiceList.get(i);
            bizBillId = (String)invoiceObject.get("FBIZBILLID");
            voucherId = (String)invoiceObject.get("FVOUCHERID");
            voucherNumber = (String)invoiceObject.get("FVOUCHERNUMBER");
            if (StringUtils.isEmpty((String)voucherId) || invoiceVoucherMap.containsKey(bizBillId)) continue;
            voucherInfo = new VoucherInfo();
            voucherInfo.setId(BOSUuid.read((String)voucherId));
            voucherInfo.setNumber(voucherNumber);
            invoiceVoucherMap.put(bizBillId, voucherInfo);
        }
        HashMap<String, Object> paramMap = null;
        PwyActionParam actionParam = null;
        String bizBillNumber = null;
        String companyId = null;
        OtherBillInfo objectValue = null;
        String billId = null;
        Map data = null;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            data = (Map)dataList.get(i);
            billId = (String)data.get("billId");
            voucherInfo = (VoucherInfo)invoiceVoucherMap.get(billId);
            objectValue = billMap.get(billId);
            if (voucherInfo == null || objectValue == null) continue;
            bizBillNumber = objectValue.getNumber();
            companyId = objectValue.getCompany().getId().toString();
            paramMap = new HashMap<String, Object>();
            ArrayList<String> expenseIdArray = new ArrayList<String>();
            expenseIdArray.add(billId);
            paramMap.put("expenseIdArray", expenseIdArray);
            paramMap.put("voucherId", voucherInfo.getId().toString());
            paramMap.put("voucherNumber", voucherInfo.getNumber());
            paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.OTHERBILL);
            actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_DEL_VOUCHER);
            actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
            actionParam.setBillId(billId);
            actionParam.setBillNumber(bizBillNumber);
            actionParam.setOrgId(companyId);
            actionParam.setParams(paramMap);
            PoolSyncUtil.poolAsyncCall(ctx, actionParam);
        }
    }

    protected Map<String, OtherBillInfo> getBillMap(Context ctx, Set<String> billIdSet) throws BOSException {
        IObjectCollection billCollection = PoolSyncUtil.getBillCollection(ctx, billIdSet, this.getBillSelectors());
        HashMap<String, OtherBillInfo> billMap = new HashMap<String, OtherBillInfo>();
        OtherBillInfo objectValue = null;
        for (int i = 0; i < billCollection.size(); ++i) {
            objectValue = (OtherBillInfo)billCollection.getObject(i);
            billMap.put(objectValue.getId().toString(), objectValue);
        }
        return billMap;
    }

    protected Map<String, VoucherInfo> getVoucherMap(Context ctx, Set<String> voucherIdSet) throws BOSException {
        VoucherCollection voucherCollection = PoolSyncUtil.getVoucherCollection(ctx, voucherIdSet);
        HashMap<String, VoucherInfo> voucherMap = new HashMap<String, VoucherInfo>();
        VoucherInfo voucherInfo = null;
        for (int i = 0; i < voucherCollection.size(); ++i) {
            voucherInfo = voucherCollection.get(i);
            voucherMap.put(voucherInfo.getId().toString(), voucherInfo);
        }
        return voucherMap;
    }

    protected SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    public void baseInvoiceCall(Context ctx, PwyActionParam actionParam, Boolean isIntegratedByPWY) throws Exception {
        PoolSyncUtil.poolSyncCall(ctx, actionParam);
    }
}

